/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.HibernateMappingGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.DefaultValue;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Notnulldefault;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.SchemaMigration;
import jp.jasminesoft.util.RandomString;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitdbImportXslGenerator
extends SourceGenerator {
    private static Logger logger = LogManager.getLogger(InitdbImportXslGenerator.class);
    private static Map<String, String> defaultValueMap = null;
    int parentcnt = -1;

    public InitdbImportXslGenerator(Project project) {
        super(project);
        Object[] notnulldefaults;
        if (defaultValueMap != null) {
            return;
        }
        defaultValueMap = new HashMap<String, String>();
        Database database = AppSchemaUtil.getDatabase(project.getEnvironment());
        SchemaMigration schemaMigration = database.getSchemaMigration();
        if (schemaMigration != null && ArrayUtils.isNotEmpty((Object[])(notnulldefaults = schemaMigration.getNotnulldefault()))) {
            for (Object notnulldefault : notnulldefaults) {
                String type = ((Notnulldefault)notnulldefault).getType();
                String content = ((Notnulldefault)notnulldefault).getContent();
                if ("string".equals(type)) {
                    defaultValueMap.put("String", content);
                    continue;
                }
                if ("byte".equals(type)) {
                    defaultValueMap.put("Byte", content);
                    continue;
                }
                if ("short".equals(type)) {
                    defaultValueMap.put("Short", content);
                    continue;
                }
                if ("int".equals(type)) {
                    defaultValueMap.put("Int", content);
                    continue;
                }
                if ("long".equals(type)) {
                    defaultValueMap.put("Long", content);
                    continue;
                }
                if ("float".equals(type)) {
                    defaultValueMap.put("Float", content);
                    continue;
                }
                if ("double".equals(type)) {
                    defaultValueMap.put("Double", content);
                    continue;
                }
                if ("date".equals(type)) {
                    defaultValueMap.put("Date", content);
                    continue;
                }
                if ("time".equals(type)) {
                    defaultValueMap.put("Time", content);
                    continue;
                }
                if (!"datetime".equals(type)) continue;
                defaultValueMap.put("DateTime", content);
            }
        }
        CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();
        defaultValueMap.put("Byte", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Byte"), (String)defaultValueMap.get("Byte")));
        defaultValueMap.put("Short", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Short"), (String)defaultValueMap.get("Short")));
        defaultValueMap.put("Int", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Int"), (String)defaultValueMap.get("Int")));
        defaultValueMap.put("Long", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Long"), (String)defaultValueMap.get("Long")));
        defaultValueMap.put("Float", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Float"), (String)defaultValueMap.get("Float")));
        defaultValueMap.put("Double", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Double"), (String)defaultValueMap.get("Double")));
        defaultValueMap.put("String", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.String"), (String)defaultValueMap.get("String")));
        defaultValueMap.put("Date", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Date"), (String)defaultValueMap.get("Date")));
        defaultValueMap.put("Time", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Time"), (String)defaultValueMap.get("Time")));
        defaultValueMap.put("DateTime", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.DateTime"), (String)defaultValueMap.get("DateTime")));
        defaultValueMap.put("Zipcode", StringUtils.defaultIfBlank((String)compatibilityManager.getStringValue("jp.jasminesoft.jfc.gen.InitdbImportXslGenerator.defaultvalue.Zipcode"), (String)"100-0000"));
    }

    @Override
    public String getFileSuffix() {
        return ".xsl";
    }

    public String getFilename() {
        return "initdb";
    }

    public String getSubpackageName() {
        return "conf" + File.separator + "importxsl";
    }

    protected String getTemplateMatch(Modelitem modelitem) {
        return modelitem.getName();
    }

    @Override
    public void process() {
        String subpackagename = this.getSubpackageName();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return;
        }
        for (int i = 0; i < ipc.length; ++i) {
            String content;
            String type;
            String filename;
            String storage;
            int storagetype;
            Model model;
            if (!(ipc[i] instanceof Model) || !AppSchemaUtil.isGenerateInitLoader(model = (Model)ipc[i]) || (storagetype = AppSchemaUtil.getStorageType(storage = model.getStorage())) == 3 || (filename = model.getId()) == null || (type = model.getType()) == null) continue;
            if ("store".equals(type)) {
                content = this.processStoreModel(model);
            } else {
                if (!"master".equals(type)) continue;
                content = this.processMasterModel(model);
            }
            if (content == null) continue;
            content = content + this.getGeneratorClassName();
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public String processStoreModel(Model model) {
        StringBuilder buf = new StringBuilder();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        buf.append("<?xml version=\"1.0\" encoding=\"" + enc + "\"?>");
        buf.append(CR);
        buf.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">");
        buf.append(CR);
        buf.append("<xsl:output method=\"xml\"/>");
        buf.append(CR);
        buf.append(CR);
        if (this.isJuserModel(model)) {
            buf.append("<xsl:param name=\"versionXmlFilePath\"/>" + CR);
            buf.append("<xsl:variable name=\"jprincipalDoc\" select=\"document('jprincipal.xml')\"/>" + CR);
            buf.append("<xsl:variable name=\"enableJprincipalDoc\"" + CR);
            buf.append("    select=\"count($jprincipalDoc//source) &gt; 0 and" + CR);
            buf.append("            count($jprincipalDoc//initdata) &gt; 0\"/>" + CR);
            buf.append(CR);
        }
        String rootelemname = model.getId();
        this.createTemplateHasChild(buf, model, rootelemname, "/*", null);
        IModelChoice[] imc = model.getContent();
        if (imc != null && imc.length > 0) {
            for (int i = 0; i < imc.length; ++i) {
                Modelitem modelitem;
                if (!(imc[i] instanceof Modelitem) || "model".equals((modelitem = (Modelitem)imc[i]).getSrcgen())) continue;
                String elemname = AppSchemaUtil.getChildPart(modelitem.getName());
                boolean isHasChildFlag = modelitem.getHasChild();
                if (isHasChildFlag) {
                    String template_match = this.getTemplateMatch(modelitem);
                    this.createTemplateHasChild(buf, model, elemname, template_match, template_match);
                    continue;
                }
                Relation rel = AppSchemaUtil.getRelation(modelitem);
                if (rel != null) {
                    Model rmodel;
                    PrimaryKey[] r_pkeys;
                    Relation rel0;
                    boolean isRelRef_moreRelation = false;
                    if (rel.getType().equals("ref") && (rel0 = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.project, model, modelitem)) != null) {
                        rel = rel0;
                        isRelRef_moreRelation = true;
                    }
                    if ((r_pkeys = AppSchemaUtil.getPrimaryKey(rmodel = (Model)rel.getIdrefAsIRNode())) != null && r_pkeys.length > 1) {
                        String elemname0;
                        String r_pkey_name;
                        if (rel.getType().equals("ref") && rel.getRefstoretype().equals("thismodel")) {
                            if (!isRelRef_moreRelation) {
                                this.processStoreModel_single(model, modelitem, elemname, null, buf);
                                continue;
                            }
                            for (PrimaryKey r_pkey : r_pkeys) {
                                r_pkey_name = r_pkey.getName();
                                elemname0 = elemname + "_" + r_pkey_name;
                                this.processStoreModel_single(model, modelitem, elemname0, elemname0, buf);
                            }
                            continue;
                        }
                        if (!"check".equals(rel.getType())) {
                            for (PrimaryKey r_pkey : r_pkeys) {
                                r_pkey_name = r_pkey.getName();
                                elemname0 = elemname + "_" + r_pkey_name;
                                this.processStoreModel_single(model, modelitem, elemname0, elemname0, buf);
                            }
                            continue;
                        }
                        this.processStoreModel_checkbox(model, modelitem, elemname, buf);
                        continue;
                    }
                    this.processStoreModel_single(model, modelitem, elemname, null, buf);
                    continue;
                }
                this.processStoreModel_single(model, modelitem, elemname, null, buf);
            }
        }
        buf.append("</xsl:stylesheet>");
        buf.append(CR);
        return buf.toString();
    }

    private boolean isJuserModel(Model model) {
        return model.getId().equals("juser");
    }

    private void processStoreModel_single(Model model, Modelitem modelitem, String elemname, String templatename, StringBuilder buf) {
        if (this.isJuserModel(model)) {
            this.processStoreModel_single4juser(model, modelitem, elemname, templatename, buf);
        } else {
            this.processStoreModel_single_normal(model, modelitem, elemname, templatename, buf);
        }
    }

    private void processStoreModel_single_normal(Model model, Modelitem modelitem, String elemname, String templatename, StringBuilder buf) {
        String reffullelemname;
        Modelitem refmitem;
        String fullelemname = modelitem.getName();
        String mitemFooter = model.getRealFilenameRefModelitemFooter();
        templatename = templatename == null ? this.getTemplateMatch(modelitem) : templatename;
        buf.append("<xsl:template match=\"");
        buf.append(templatename);
        buf.append("\">");
        buf.append(CR);
        buf.append("  <" + elemname + ">");
        buf.append(CR);
        if (mitemFooter != null && mitemFooter.length() > 0 && fullelemname.endsWith(mitemFooter)) {
            buf.append(this.appendConvertCodeForUploadDir(""));
        }
        buf.append("    <xsl:value-of select=\".\"/>");
        buf.append(CR);
        buf.append("  </" + elemname + ">");
        buf.append(CR);
        if (mitemFooter != null && mitemFooter.length() > 0 && (refmitem = AppSchemaUtil.getModelitem(reffullelemname = fullelemname + mitemFooter, model)) != null) {
            int ri = reffullelemname.lastIndexOf(47);
            String refelemname = ri >= 0 ? reffullelemname.substring(ri + 1) : reffullelemname;
            buf.append("  <xsl:if test=\"count(../" + refelemname + ") = 0\">");
            buf.append(CR);
            buf.append("    <" + refelemname + ">");
            buf.append(CR);
            buf.append(this.appendConvertCodeForUploadDir("    "));
            buf.append("      <xsl:value-of select=\".\"/>");
            buf.append(CR);
            buf.append("    </" + refelemname + ">");
            buf.append(CR);
            buf.append("  </xsl:if>");
            buf.append(CR);
        }
        buf.append("</xsl:template>");
        buf.append(CR);
        buf.append(CR);
    }

    private void processStoreModel_single4juser(Model model, Modelitem modelitem, String elemname, String templatename, StringBuilder buf) {
        if (this.isSkipModelitem(modelitem, model)) {
            return;
        }
        if (!elemname.equals("jprincipalId")) {
            this.processStoreModel_single_normal(model, modelitem, elemname, templatename, buf);
            return;
        }
        buf.append("<xsl:template match=\"jprincipalId[not($enableJprincipalDoc)]\">" + CR);
        buf.append("  <jprincipalId>" + CR);
        buf.append("    <xsl:value-of select=\"text()\"/>" + CR);
        buf.append("  </jprincipalId>" + CR);
        buf.append("</xsl:template>" + CR);
        buf.append(CR);
        buf.append("<xsl:template match=\"jprincipalId[$enableJprincipalDoc]\">" + CR);
        buf.append("  <xsl:variable name=\"source_id\" select=\"text()\"/>" + CR);
        buf.append("  <xsl:variable name=\"source_name\" select=\"$jprincipalDoc//source/jprincipal[@id=$source_id]/*[local-name()='name' or local-name()='principalId']/text()\"/>" + CR);
        buf.append("  <xsl:variable name=\"initdata_jprincipal\" select=\"$jprincipalDoc//initdata/jprincipal[principalId/text()=$source_name]\"/>" + CR);
        buf.append(CR);
        buf.append("  <xsl:if test=\"count($initdata_jprincipal) &gt; 0\">" + CR);
        buf.append("    <jprincipalId>" + CR);
        buf.append("      <xsl:value-of select=\"$initdata_jprincipal/@id\"/>" + CR);
        buf.append("    </jprincipalId>" + CR);
        buf.append("  </xsl:if>" + CR);
        buf.append("</xsl:template>" + CR);
        buf.append(CR);
        buf.append("<xsl:template match=\"preferenceItem\">" + CR);
        buf.append("  <preferenceItem>" + CR);
        buf.append("    <xsl:attribute name=\"key\">" + CR);
        buf.append("      <xsl:value-of select=\"@key\"/>" + CR);
        buf.append("    </xsl:attribute>" + CR);
        buf.append("    <xsl:value-of select=\".\"/>" + CR);
        buf.append("  </preferenceItem>" + CR);
        buf.append("</xsl:template>" + CR);
        buf.append(CR);
    }

    private void processStoreModel_checkbox(Model model, Modelitem modelitem, String elemname, StringBuilder buf) {
        String templatename = this.getTemplateMatch(modelitem);
        buf.append("<xsl:template match=\"");
        buf.append(templatename);
        buf.append("\">");
        buf.append(CR);
        buf.append("  <xsl:copy-of select=\".\"/>");
        buf.append(CR);
        buf.append("</xsl:template>");
        buf.append(CR);
        buf.append(CR);
    }

    private void createTemplateHasChild(StringBuilder buf, Model model, String parentoutputelemname, String template_match, String parentelemname) {
        buf.append("<xsl:template match=\"" + template_match + "\">");
        buf.append(CR);
        if (this.isJuserModel(model)) {
            buf.append("  <xsl:variable name=\"version\">" + CR);
            buf.append("    <xsl:if test=\"string-length($versionXmlFilePath) &gt; 0\">" + CR);
            buf.append("      <xsl:value-of select=\"document($versionXmlFilePath)/jfc_root/jfc_version\"/>" + CR);
            buf.append("    </xsl:if>" + CR);
            buf.append("  </xsl:variable>" + CR);
        }
        buf.append("  <" + parentoutputelemname + ">");
        buf.append(CR);
        IModelChoice[] imc = model.getContent();
        if (imc != null && imc.length > 0) {
            String storage = model.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            if (storagetype == 5 && parentelemname != null && !parentelemname.equals("")) {
                this.createContainerPrimaryKey(buf, model, parentoutputelemname);
            }
            for (int i = 0; i < imc.length; ++i) {
                String elemname;
                Modelitem modelitem;
                if (!(imc[i] instanceof Modelitem) || this.isSkipModelitem(modelitem = (Modelitem)imc[i], model)) continue;
                String fullelemname = this.getTemplateMatch(modelitem);
                if (parentelemname == null || parentelemname.equals("")) {
                    if (fullelemname.indexOf(47) >= 0) continue;
                    elemname = fullelemname;
                } else {
                    String head = parentelemname + "/";
                    if (!fullelemname.startsWith(head) || (elemname = fullelemname.substring(head.length())).indexOf(47) >= 0) continue;
                }
                Relation rel = AppSchemaUtil.getRelation(modelitem);
                if (rel != null) {
                    Model rmodel;
                    PrimaryKey[] r_pkeys;
                    Relation rel0;
                    boolean isRelRef_moreRelation = false;
                    if (rel.getType().equals("ref") && (rel0 = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.project, model, modelitem)) != null) {
                        rel = rel0;
                        isRelRef_moreRelation = true;
                    }
                    if ((r_pkeys = AppSchemaUtil.getPrimaryKey(rmodel = (Model)rel.getIdrefAsIRNode())) != null && r_pkeys.length > 1) {
                        String elemname0;
                        String r_pkey_name;
                        if (rel.getType().equals("ref") && rel.getRefstoretype().equals("thismodel")) {
                            if (!isRelRef_moreRelation) {
                                this.createTemplateHasChild_single(model, modelitem, elemname, buf);
                                continue;
                            }
                            for (PrimaryKey r_pkey : r_pkeys) {
                                r_pkey_name = r_pkey.getName();
                                elemname0 = elemname + "_" + r_pkey_name;
                                this.createTemplateHasChild_single(model, modelitem, elemname0, buf);
                            }
                            continue;
                        }
                        if ("check".equals(rel.getType())) continue;
                        for (PrimaryKey r_pkey : r_pkeys) {
                            r_pkey_name = r_pkey.getName();
                            elemname0 = elemname + "_" + r_pkey_name;
                            this.createTemplateHasChild_single(model, modelitem, elemname0, buf);
                        }
                        continue;
                    }
                    this.createTemplateHasChild_single(model, modelitem, elemname, buf);
                    continue;
                }
                this.createTemplateHasChild_single(model, modelitem, elemname, buf);
            }
        } else {
            buf.append("    ");
            buf.append("<xsl:copy-of select=\"@*\"/>\n");
            buf.append(CR);
            buf.append("    ");
            buf.append("<xsl:copy-of select=\"*\"/>\n");
            buf.append(CR);
        }
        if (this.isJuserModel(model)) {
            buf.append("    ");
            buf.append("<xsl:apply-templates select=\"preferenceItem\"/>" + CR);
        }
        buf.append("  </" + parentoutputelemname + ">");
        buf.append(CR);
        buf.append("</xsl:template>");
        buf.append(CR);
        buf.append(CR);
    }

    private boolean isSkipModelitem(Modelitem modelitem, Model model) {
        if (!this.isJuserModel(model)) {
            return false;
        }
        if ("compulsoryChange".equals(modelitem.getName())) {
            return true;
        }
        return "model".equals(modelitem.getSrcgen());
    }

    private void createTemplateHasChild_single(Model model, Modelitem modelitem, String elemname, StringBuilder buf) {
        if (this.isJuserModel(model)) {
            this.createTemplateHasChild_single4juser(model, modelitem, elemname, buf);
        } else {
            this.createTemplateHasChild_single_normal(model, modelitem, elemname, buf);
        }
    }

    private void createTemplateHasChild_single_normal(Model model, Modelitem modelitem, String elemname, StringBuilder buf) {
        boolean isPrimaryKey = this.getPrimaryKey(model, modelitem) != null;
        boolean isMustFlag = HibernateMappingGenerator.isMust(model, modelitem) || isPrimaryKey;
        boolean isMultipleFlag = this.isMultipleFlag(modelitem);
        boolean isHasChildFlag = modelitem.getHasChild();
        boolean isMasterModelFromR6 = false;
        String initialDataSaveDir = model.getInitialDataSaveDir();
        if (initialDataSaveDir != null && initialDataSaveDir.endsWith(".initialdata")) {
            isMasterModelFromR6 = true;
        }
        if (!isHasChildFlag && isMustFlag) {
            buf.append("    ");
            buf.append("<xsl:choose>");
            buf.append(CR);
            if (isMasterModelFromR6) {
                buf.append("    ").append("<xsl:when test=\"name() = 'master'\">").append(CR);
                buf.append("      ").append("<id><xsl:value-of select=\"@id\"/></id>").append(CR);
                buf.append("      ").append("<content><xsl:value-of select=\".\"/></content>").append(CR);
                buf.append("      ").append("<priority><xsl:value-of select=\"@priority\"/></priority>").append(CR);
                buf.append("      ").append("<valid><xsl:value-of select=\"@valid\"/></valid>").append(CR);
                buf.append("    ").append("</xsl:when>").append(CR);
            }
            buf.append("    ");
            buf.append("<xsl:when test=\"" + elemname + "\">");
            buf.append(CR);
            buf.append("      ");
            buf.append("<xsl:apply-templates select=\"");
            buf.append(elemname);
            if (!isMultipleFlag) {
                buf.append("[1]");
            }
            buf.append("\"/>");
            buf.append(CR);
            buf.append("    ");
            buf.append("</xsl:when>");
            buf.append(CR);
            buf.append("    ");
            buf.append("<xsl:otherwise>");
            buf.append(CR);
            this.createDefaultElement(buf, model, modelitem, elemname, "      ");
            buf.append("    ");
            buf.append("</xsl:otherwise>");
            buf.append(CR);
            buf.append("    ");
            buf.append("</xsl:choose>");
            buf.append(CR);
            buf.append(CR);
        } else {
            buf.append("    ");
            buf.append("<xsl:apply-templates select=\"");
            buf.append(elemname);
            if (!isMultipleFlag) {
                buf.append("[1]");
            }
            buf.append("\"/>");
            buf.append(CR);
            buf.append(CR);
        }
    }

    private void createTemplateHasChild_single4juser(Model model, Modelitem modelitem, String elemname, StringBuilder buf) {
        if ("userid".equals(elemname) || "passwd".equals(elemname)) {
            Modelitem n_modelitem = new Modelitem(modelitem);
            n_modelitem.setMust(false);
            this.createTemplateHasChild_single_normal(model, n_modelitem, elemname, buf);
        } else if ("level".equals(elemname)) {
            Modelitem n_modelitem = new Modelitem(modelitem);
            n_modelitem.setMust(true);
            this.createTemplateHasChild_single_normal(model, n_modelitem, elemname, buf);
        } else if ("jprincipalId".equals(elemname)) {
            buf.append("    ");
            buf.append("<xsl:if test=\"string-length($version) = 0 and not(jprincipalId[text() = '0' or text() = '2'])\">" + CR);
            buf.append("      ");
            buf.append("<jprincipalId>0</jprincipalId>" + CR);
            buf.append("    ");
            buf.append("</xsl:if>" + CR);
            buf.append("    ");
            buf.append("<xsl:apply-templates select=\"jprincipalId\"/>" + CR);
            buf.append(CR);
        } else {
            this.createTemplateHasChild_single_normal(model, modelitem, elemname, buf);
        }
    }

    private void createContainerPrimaryKey(StringBuilder buf, Model model, String parentoutputelemname) {
        StringBuilder buf1 = new StringBuilder();
        buf1.append(CR);
        buf1.append("      ");
        buf1.append("<xsl:value-of select=\"position()-1\"/>");
        buf1.append(CR);
        buf1.append("    ");
        this.createContainerPrimaryKey(buf, model, parentoutputelemname, "    ", buf1.toString());
    }

    private void createContainerPrimaryKey(StringBuilder buf, Model model, String parentoutputelemname, String basetab, String jshidvalue) {
        String elemname;
        IModelChoice[] imc = model.getContent();
        for (int i = 0; i < imc.length; ++i) {
            boolean isPrimaryKey;
            Modelitem modelitem;
            if (!(imc[i] instanceof Modelitem) || "model".equals((modelitem = (Modelitem)imc[i]).getSrcgen())) continue;
            boolean bl = isPrimaryKey = this.getPrimaryKey(model, modelitem) != null;
            if (!isPrimaryKey) continue;
            elemname = modelitem.getName();
            buf.append(basetab);
            buf.append("<xsl:choose>");
            buf.append(CR);
            buf.append(basetab);
            buf.append("<xsl:when test=\"/*/" + elemname + "\">");
            buf.append(CR);
            buf.append(basetab + "  ");
            buf.append("<xsl:apply-templates select=\"/*/");
            buf.append(elemname);
            buf.append("[1]");
            buf.append("\"/>");
            buf.append(CR);
            buf.append(basetab);
            buf.append("</xsl:when>");
            buf.append(CR);
            buf.append(basetab);
            buf.append("<xsl:otherwise>");
            buf.append(CR);
            this.createDefaultElement(buf, model, modelitem, null, basetab + "  ");
            buf.append(basetab);
            buf.append("</xsl:otherwise>");
            buf.append(CR);
            buf.append(basetab);
            buf.append("</xsl:choose>");
            buf.append(CR);
            buf.append(CR);
        }
        elemname = parentoutputelemname + "jshid";
        buf.append(basetab);
        buf.append("<");
        buf.append(elemname);
        buf.append(">");
        buf.append(jshidvalue);
        buf.append("</");
        buf.append(elemname);
        buf.append(">");
        buf.append(CR);
        buf.append(CR);
    }

    private void createDefaultElement(StringBuilder buf, Model model, Modelitem modelitem, String realelemname, String basetab) {
        String sizeStr;
        String fullelemname = modelitem.getName();
        int li = fullelemname.lastIndexOf(47);
        String elemname = li >= 0 ? fullelemname.substring(li + 1) : fullelemname;
        PrimaryKey primaryKey = this.getPrimaryKey(model, modelitem);
        boolean isMultipleFlag = this.isMultipleFlag(modelitem);
        boolean isHasChildFlag = modelitem.getHasChild();
        int num = 1;
        if (isMultipleFlag && StringUtils.isNumeric((String)(sizeStr = modelitem.getDefaultSize()))) {
            num = StringUtil.intValue((String)sizeStr);
        }
        for (int i = 0; i < num; ++i) {
            if (isHasChildFlag) {
                buf.append(basetab);
                buf.append("<" + elemname + ">");
                buf.append(CR);
                this.createContainerPrimaryKey(buf, model, elemname, basetab + "  ", Integer.toString(i));
                this.parentcnt = i;
                this.createDefaultChildElement(buf, model, fullelemname, basetab + "  ");
                buf.append(basetab);
                buf.append("</" + elemname + ">");
                buf.append(CR);
                continue;
            }
            String ret = this.createDefaultValue(model, modelitem, realelemname, primaryKey);
            buf.append(basetab);
            buf.append("<" + elemname + ">");
            buf.append(ret);
            buf.append("</" + elemname + ">");
            buf.append(CR);
        }
        if (isHasChildFlag) {
            this.parentcnt = -1;
        }
    }

    private String createDefaultValue(Model model, Modelitem modelitem, String elemname, PrimaryKey primaryKey) {
        return InitdbImportXslGenerator.createDefaultValue(model, modelitem, elemname, primaryKey, this.parentcnt, this.project);
    }

    public static String createDefaultValue(Model model, Modelitem modelitem, PrimaryKey primaryKey, int parentcnt, Project project) {
        return InitdbImportXslGenerator.createDefaultValue(model, modelitem, null, primaryKey, parentcnt, project);
    }

    public static String createDefaultValue(Model model, Modelitem modelitem, String elemname, PrimaryKey primaryKey, int parentcnt, Project project) {
        String v;
        boolean autokey;
        if (primaryKey != null) {
            String type = AppSchemaUtil.getPkeyType(model, primaryKey.getName(), primaryKey.getType(), project);
            boolean autoid = primaryKey.getAutoid();
            if (type != null && "int".equals(type) && autoid && primaryKey.getUseseq() != null) {
                return "-1";
            }
        }
        if ((autokey = modelitem.getAutokey()) && parentcnt >= 0) {
            return Integer.toString(parentcnt);
        }
        DefaultValue insert_dv = null;
        DefaultValue init_dv = null;
        IModelChoice[] imc = model.getContent();
        if (imc != null && imc.length > 0) {
            for (int i = 0; i < imc.length; ++i) {
                DefaultValue dv;
                if (!(imc[i] instanceof DefaultValue) || (dv = (DefaultValue)imc[i]).getType().equals("operation") || dv.getType().equals("javacode") || !modelitem.getName().equals(dv.getName())) continue;
                if (dv.getAction() == null || "insert".equals(dv.getAction())) {
                    insert_dv = dv;
                    continue;
                }
                if (!"init".equals(dv.getAction())) continue;
                init_dv = dv;
            }
        }
        if (insert_dv != null && (v = InitdbImportXslGenerator.getDefaultValue(insert_dv)) != null) {
            return v;
        }
        if (init_dv != null && (v = InitdbImportXslGenerator.getDefaultValue(init_dv)) != null) {
            return v;
        }
        String type = AppSchemaUtil.getModelitemType(project, model.getId(), modelitem, "roleid");
        String mitemname = AppSchemaUtil.getChildPart(modelitem.getName());
        if ("storeref".equals(modelitem.getType()) && elemname != null && elemname.startsWith(mitemname) && elemname.length() > mitemname.length()) {
            String postfix = elemname.substring(mitemname.length() + 1);
            Relation _relation = AppSchemaUtil.getRelation(modelitem);
            Model _rmodel = (Model)_relation.getIdrefAsIRNode();
            PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKey(_rmodel);
            int count = 0;
            if (_relation.getType().equals("ref")) {
                if (r_pkeys != null && r_pkeys.length > 1) {
                    for (PrimaryKey r_pkey : r_pkeys) {
                        if (!r_pkey.getName().equals(postfix)) continue;
                        Modelitem mitem_r_pkey = AppSchemaUtil.getModelitem(r_pkey.getName(), _rmodel);
                        if (mitem_r_pkey != null) {
                            type = AppSchemaUtil.getModelitemType(project, _rmodel.getId(), mitem_r_pkey, "roleid");
                        }
                        break;
                    }
                } else {
                    Modelitem mitem_r_pkey = AppSchemaUtil.getModelitem(r_pkeys[0].getName(), _rmodel);
                    type = AppSchemaUtil.getModelitemType(project, _rmodel.getId(), mitem_r_pkey, "roleid");
                }
            } else if (r_pkeys != null && r_pkeys.length > 1) {
                for (PrimaryKey r_pkey : r_pkeys) {
                    if (r_pkey.getName().equals(postfix)) break;
                    ++count;
                }
                String[] tokens = StringUtil.split((String)type, (String)PrimaryKeyUtils.PKEY_SEPARATOR());
                if (count < tokens.length) {
                    type = tokens[count];
                } else {
                    logger.warn("Complex key mismatch. model=" + model.getId() + ",type=" + type + ",modelitem=" + modelitem + ",r_pkeys=" + Arrays.asList(r_pkeys));
                }
            }
        }
        if (AppSchemaUtil.isZipCode(project, modelitem, model)) {
            type = "zipcode";
        }
        if ("string".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("String") : null, (String)"Undefined");
        }
        if ("int".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("Int") : null, (String)"0");
        }
        if ("date".equals(type)) {
            return StringUtils.defaultIfEmpty((String)(defaultValueMap != null ? defaultValueMap.get("Date") : null), (String)InitdbImportXslGenerator.getNowDate(0));
        }
        if ("time".equals(type)) {
            return StringUtils.defaultIfEmpty((String)(defaultValueMap != null ? defaultValueMap.get("Time") : null), (String)InitdbImportXslGenerator.getNowTime(0));
        }
        if ("dateTime".equals(type)) {
            return StringUtils.defaultIfEmpty((String)(defaultValueMap != null ? defaultValueMap.get("DateTime") : null), (String)InitdbImportXslGenerator.getNowTimestamp(0));
        }
        if ("long".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("Long") : null, (String)"0");
        }
        if ("float".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("Float") : null, (String)"0");
        }
        if ("double".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("Double") : null, (String)"0");
        }
        if ("zipcode".equals(type)) {
            return defaultValueMap != null ? defaultValueMap.get("Zipcode") : "100-0000";
        }
        if ("byte".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("Byte") : null, (String)"0");
        }
        if ("short".equals(type)) {
            return StringUtils.defaultIfEmpty(defaultValueMap != null ? defaultValueMap.get("Short") : null, (String)"0");
        }
        return "0";
    }

    private static String getDefaultValue(DefaultValue dv) {
        String type = dv.getType();
        String content = dv.getContent();
        if ("null".equals(content = StringUtils.removeEnd((String)content, (String)",targetdate"))) {
            return null;
        }
        if ("date".equals(type)) {
            if ("now".equals(content)) {
                return InitdbImportXslGenerator.getNowDate(0);
            }
            if (content.startsWith("now")) {
                String rest = content.substring("now".length());
                if (rest.startsWith("+")) {
                    rest = rest.substring(1);
                }
                int amount = StringUtil.intValue((String)rest);
                return InitdbImportXslGenerator.getNowDate(amount);
            }
        } else if ("time".equals(type)) {
            if ("now".equals(content)) {
                return InitdbImportXslGenerator.getNowTime(0);
            }
            if (content.startsWith("now")) {
                String rest = content.substring("now".length());
                if (rest.startsWith("+")) {
                    rest = rest.substring(1);
                }
                int amount = StringUtil.intValue((String)rest);
                return InitdbImportXslGenerator.getNowTime(amount);
            }
        } else if ("dateTime".equals(type)) {
            if ("now".equals(content)) {
                return InitdbImportXslGenerator.getNowTimestamp(0);
            }
            if (content.startsWith("now")) {
                String rest = content.substring("now".length());
                if (rest.startsWith("+")) {
                    rest = rest.substring(1);
                }
                int amount = StringUtil.intValue((String)rest);
                return InitdbImportXslGenerator.getNowTimestamp(amount);
            }
        } else if ("userid".equals(type)) {
            if (content == null || content.equals("")) {
                return "Unknown userid";
            }
        } else {
            if ("sum".equals(type)) {
                return null;
            }
            if ("random:string".equals(type)) {
                int len = StringUtil.intValue((String)content);
                if (len == 0) {
                    len = 8;
                }
                return RandomString.createRandomString((int)len);
            }
            if (!"zipcode".equals(type) && ("string".equals(type) ? content == null || InitdbImportXslGenerator.isSpecialExpression(content) : !(!"byte".equals(type) && !"short".equals(type) && !"int".equals(type) && !"float".equals(type) && !"double".equals(type) && !"long".equals(type) || content != null && !InitdbImportXslGenerator.isSpecialExpression(content)))) {
                return null;
            }
        }
        return content;
    }

    private static boolean isSpecialExpression(String content) {
        return (content = content.trim().toUpperCase()).startsWith("REQUEST(") && content.endsWith(")") || content.startsWith("ATTRIBUTE(") && content.endsWith(")") || content.startsWith("SESSION(") && content.endsWith(")") || content.startsWith("PAGEMAP(") && content.endsWith(")") || content.startsWith("APPMAP(") && content.endsWith(")");
    }

    private static String getNowDate(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(6, amount);
        return new Date(cal.getTimeInMillis()).toString();
    }

    private static String getNowTime(int amount) {
        Calendar cal = Calendar.getInstance();
        Calendar calgmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calgmt.set(1, 1970);
        calgmt.set(6, 1);
        calgmt.set(11, cal.get(11));
        calgmt.set(12, cal.get(12));
        calgmt.set(13, cal.get(13) + amount);
        calgmt.set(14, cal.get(14));
        return new Time(calgmt.getTimeInMillis()).toString();
    }

    private static String getNowTimestamp(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, amount);
        return new Timestamp(cal.getTimeInMillis()).toString();
    }

    private void createDefaultChildElement(StringBuilder buf, Model model, String parentelemname, String basetab) {
        IModelChoice[] imc = model.getContent();
        if (imc == null) {
            return;
        }
        for (int i = 0; i < imc.length; ++i) {
            String head;
            if (!(imc[i] instanceof Modelitem)) continue;
            Modelitem modelitem = (Modelitem)imc[i];
            String elemname = modelitem.getName();
            if (parentelemname == null || parentelemname.equals("") ? elemname.indexOf(47) >= 0 : !elemname.startsWith(head = parentelemname + "/")) continue;
            this.createDefaultElement(buf, model, modelitem, null, basetab);
        }
    }

    private boolean isMultipleFlag(Modelitem modelitem) {
        return modelitem.getMultiple() || AppSchemaUtil.isCheckRelation(modelitem);
    }

    private PrimaryKey getPrimaryKey(Model model, Modelitem modelitem) {
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        return this.getPrimaryKey(modelitem.getName(), pkeys);
    }

    private PrimaryKey getPrimaryKey(String postname, PrimaryKey[] pkeys) {
        if (postname == null || postname.length() == 0 || pkeys == null || pkeys.length == 0) {
            return null;
        }
        for (int i = 0; i < pkeys.length; ++i) {
            if (!postname.equals(pkeys[i].getName())) continue;
            return pkeys[i];
        }
        return null;
    }

    public String processMasterModel(Model model) {
        StringBuilder buf = new StringBuilder();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        String rootelemname = "master";
        buf.append("<?xml version=\"1.0\" encoding=\"" + enc + "\"?> \n");
        buf.append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n");
        buf.append("<xsl:output method=\"xml\"/>\n");
        buf.append("\n");
        buf.append("<xsl:template match=\"/*\">\n");
        buf.append("  <" + rootelemname + ">\n");
        buf.append("    <xsl:attribute name=\"id\">\n");
        buf.append("      <xsl:value-of select=\"@id\"/>\n");
        buf.append("    </xsl:attribute>\n");
        buf.append("\n");
        buf.append("    <xsl:if test=\"@priority\">\n");
        buf.append("      <xsl:attribute name=\"priority\">\n");
        buf.append("        <xsl:value-of select=\"@priority\"/>\n");
        buf.append("      </xsl:attribute>\n");
        buf.append("    </xsl:if>\n");
        buf.append("\n");
        buf.append("    <xsl:if test=\"@valid\">\n");
        buf.append("      <xsl:attribute name=\"valid\">\n");
        buf.append("        <xsl:value-of select=\"@valid\"/>\n");
        buf.append("      </xsl:attribute>\n");
        buf.append("    </xsl:if>\n");
        buf.append("\n");
        buf.append("    <xsl:value-of select=\".\"/>\n");
        buf.append("  </" + rootelemname + ">\n");
        buf.append("</xsl:template>\n");
        buf.append("\n");
        buf.append("</xsl:stylesheet>\n");
        return buf.toString();
    }

    protected String appendConvertCodeForUploadDir(String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append(basetab);
        sb.append("    <xsl:choose>");
        sb.append(CR);
        sb.append(basetab);
        sb.append("      <xsl:when test=\"starts-with(., '..\\upload_dir')\">");
        sb.append(CR);
        sb.append(basetab);
        sb.append("        <xsl:text>..\\</xsl:text>");
        sb.append(CR);
        sb.append(basetab);
        sb.append("      </xsl:when>");
        sb.append(CR);
        sb.append(basetab);
        sb.append("      <xsl:when test=\"starts-with(., '../upload_dir')\">");
        sb.append(CR);
        sb.append(basetab);
        sb.append("        <xsl:text>../</xsl:text>");
        sb.append(CR);
        sb.append(basetab);
        sb.append("      </xsl:when>");
        sb.append(CR);
        sb.append(basetab);
        sb.append("    </xsl:choose>");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<!-- genclassname:" + this.getClass().getName() + " -->" + CR;
        }
        return "";
    }
}

