/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.DbTypeManager;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.VariableValidator_database;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.ConnectionInterface;
import jp.jasminesoft.jfc.gen.appschema.ConnectionInterfaceParam;
import jp.jasminesoft.jfc.gen.appschema.Database;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.HibernateParameterModelitem;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.QuartzJDBCJobstore;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang.StringUtils;

public class InitdbXmlGenerator
extends ConfigGenerator {
    private String quoteid = "";
    private String quotewhere = "";
    private String quoteidinwhere = "";
    private String dbtype = "hsqldb";
    private int max_index_length;
    private String encoding;
    private Database database;
    private HashSet<String> indexNameSet;
    private CompatibilityManager compatibilityManager = CompatibilityManager.getInstance();

    public InitdbXmlGenerator(String tmplatefilename, Project project) {
        super(tmplatefilename, project);
        this.indexNameSet = new HashSet();
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "initdb";
    }

    @Override
    public String getSubpackageName() {
        return "conf";
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return "";
        }
        Environment env = this.project.getEnvironment();
        if (env != null) {
            this.database = AppSchemaUtil.getDatabase(env);
            if (this.database != null) {
                this.quoteid = WebStringEncodeUtilities.replaceCharEntity((String)this.database.getQuoteid());
                this.quotewhere = WebStringEncodeUtilities.replaceCharEntity((String)this.database.getQuotewhere());
                this.quoteidinwhere = WebStringEncodeUtilities.replaceCharEntity((String)this.database.getQuoteidinwhere());
                this.dbtype = DbTypeManager.getType(env);
            }
        }
        this.encoding = DbTypeManager.getDatabaseCharEncoding(env);
        this.max_index_length = DbTypeManager.getMaxIndexNameLength(env);
        this.addContentDatabase(tplman, this.database);
        tplman.addContent("datasource_param", this.createDatasourceParam());
        tplman.addContent("connection_interface", this.createConnectionInterface());
        tplman.addContent("QuartzJDBCJobstoreDef", this.createQuartzJDBCJobstoreDef(this.database));
        tplman.addContent("SpringBatchDDL", this.createSpringBatchDDL(this.database));
        Map<String, StringBuilder> contentMap = this.createContentsMap(ipc);
        this.addContentMap(tplman, contentMap);
        return tplman.getResult();
    }

    private Map<String, StringBuilder> createContentsMap(IProjectChoice[] ipc) {
        HashMap<String, StringBuilder> contentMap = new HashMap<String, StringBuilder>();
        contentMap.put("dropseq", new StringBuilder());
        contentMap.put("createseq", new StringBuilder());
        contentMap.put("dropindex", new StringBuilder());
        contentMap.put("createindex", new StringBuilder());
        contentMap.put("store", new StringBuilder());
        contentMap.put("master", new StringBuilder());
        boolean isCreateSequenceTable = false;
        for (int i = 0; i < ipc.length; ++i) {
            if (!(ipc[i] instanceof Model)) continue;
            Model model = (Model)ipc[i];
            this.addTask(model, contentMap);
            String type = model.getType();
            int seqtype = DbTypeManager.getSequenceStorageType(this.project.getEnvironment(), model);
            if (!"store".equals(type) && !"master".equals(type) || seqtype != 2) continue;
            isCreateSequenceTable = true;
        }
        if (isCreateSequenceTable) {
            contentMap.put("createtable", this.createSequenceTableStatement());
        } else {
            contentMap.put("createtable", this.createSequenceTableStatement_denyAll());
        }
        return contentMap;
    }

    /*
     * WARNING - void declaration
     */
    protected void addTask(Model model, Map<String, StringBuilder> contentMap) {
        String _quoteid;
        String modelId;
        StringBuilder sb;
        block52: {
            Action[] actions;
            String type = model.getType();
            if (type == null || !"store".equals(type) && !"master".equals(type)) {
                return;
            }
            if (!AppSchemaUtil.isGenerateInitLoader(model)) {
                return;
            }
            String id = model.getId();
            if (id == null) {
                return;
            }
            String group = model.getGroup();
            group = group == null ? "data" : group;
            group = WebStringEncodeUtilities.replaceCharEntity((String)group);
            String storage = model.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            if (storagetype == 3) {
                return;
            }
            String tablename_raw = WebStringEncodeUtilities.replaceCharEntity((String)TablenameGenerator.createInitdbXmlTableName(model));
            String tablename_4db = model.getTablename();
            if (StringUtils.isBlank((String)tablename_4db)) {
                tablename_4db = tablename_raw;
            }
            sb = contentMap.get(type);
            sb.append("  ");
            sb.append("<directory group=\"");
            sb.append(group);
            sb.append(" ");
            sb.append(AppSchemaUtil.getStorageString(storage));
            sb.append("\" ");
            sb.append("tablename=\"");
            sb.append(tablename_raw);
            sb.append("\"");
            if (storagetype == 0) {
                if ("master".equals(type)) {
                    String filename = this.database.getMasterDDL();
                    if (StringUtils.isBlank((String)filename)) {
                        filename = "master_" + this.database.getType() + ".ddl";
                    }
                    sb.append(" storage=\"jdbc_master\"");
                    sb.append(" createddlfilename=\"createddl/").append(filename).append("\"");
                    sb.append(" dropddlfilename=\"dropddl/master.ddl\"");
                    sb.append(" replaceddl=\"true\"");
                }
            } else if (storagetype != -1) {
                sb.append(" storage=\"");
                sb.append(AppSchemaUtil.getStorageString(storagetype));
                sb.append("\"");
                if (storagetype == 5) {
                    sb.append(" createddlfilename=\"createddl/");
                    sb.append(tablename_raw);
                    sb.append(".ddl\"");
                    sb.append(" dropddlfilename=\"dropddl/");
                    sb.append(tablename_raw);
                    sb.append(".ddl\"");
                }
            } else {
                this.logger.error("Unknown storage " + storage + " in " + type + " model " + id);
            }
            sb.append(" importxslfilename=\"importxsl/");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)id));
            sb.append(".xsl\"");
            sb.append(" convertimportxslfilename=\"convertimportxsl/");
            sb.append(WebStringEncodeUtilities.replaceCharEntity((String)id));
            sb.append(".xsl\"");
            if ("jfcreminder".equals(id)) {
                sb.append(" denycommand=\"import export\"");
            }
            sb.append(">");
            sb.append("init/" + WebStringEncodeUtilities.replaceCharEntity((String)id));
            sb.append("</directory>");
            sb.append(CR);
            String seq_quoteid = this.quoteid;
            int seqtype = DbTypeManager.getSequenceStorageType(this.project.getEnvironment(), model);
            if (seqtype == 1) {
                PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
                if (pkeys == null) {
                    return;
                }
                for (int i = 0; i < pkeys.length; ++i) {
                    String seq = pkeys[i].getUseseq();
                    int start = pkeys[i].getStart();
                    if (seq == null || seq.length() == 0) continue;
                    seq = WebStringEncodeUtilities.replaceCharEntity((String)seq);
                    sb = contentMap.get("dropseq");
                    sb.append("  ");
                    sb.append("<sql  group=\"drop_seq ");
                    sb.append(seq);
                    sb.append("\"");
                    sb.append(CR);
                    sb.append("        ");
                    sb.append("acceptcommand=\"sql sql-drop-before\" ");
                    sb.append("denycommand=\"all\"");
                    sb.append(CR);
                    sb.append("        ");
                    sb.append("tablename=\"" + tablename_4db + "\">");
                    sb.append(CR);
                    String dropSequenceDDL = this.database.getDropSequenceDDL();
                    dropSequenceDDL = StringUtil.replaceAll((String)dropSequenceDDL, (String)"$SEQNAME", (String)seq);
                    dropSequenceDDL = StringUtil.replaceAll((String)dropSequenceDDL, (String)"$QUOTEID", (String)seq_quoteid);
                    sb.append("    ");
                    sb.append(dropSequenceDDL);
                    sb.append(CR);
                    sb.append("  ");
                    sb.append("</sql>");
                    sb.append(CR);
                    sb.append(CR);
                    sb = contentMap.get("createseq");
                    sb.append("  ");
                    sb.append("<sequence  group=\"create_seq ");
                    sb.append(seq);
                    sb.append("\"");
                    sb.append(CR);
                    sb.append("        ");
                    sb.append("acceptcommand=\"sequence sequence-create-after\" ");
                    sb.append("denycommand=\"all\"");
                    sb.append(CR);
                    sb.append("        ");
                    sb.append("tablename=\"" + tablename_4db + "\" ");
                    String pkeType = AppSchemaUtil.getPkeyType(model, pkeys[i].getName(), pkeys[i].getType(), this.project);
                    Number minvalue = null;
                    Number maxvalue = null;
                    if ("byte".equals(pkeType)) {
                        minvalue = (byte)-128;
                        maxvalue = (byte)127;
                    } else if ("short".equals(pkeType)) {
                        minvalue = (short)Short.MIN_VALUE;
                        maxvalue = (short)Short.MAX_VALUE;
                    } else if ("int".equals(pkeType)) {
                        minvalue = Integer.MIN_VALUE;
                        maxvalue = Integer.MAX_VALUE;
                    } else if ("long".equals(pkeType) || "string".equals(pkeType)) {
                        minvalue = Long.MIN_VALUE;
                        maxvalue = Long.MAX_VALUE;
                    }
                    sb.append(CR);
                    sb.append("        ");
                    sb.append("seqname=\"" + seq + "\" ");
                    sb.append("cache=\"1\" ");
                    sb.append("start=\"" + start + "\"");
                    if (minvalue != null && maxvalue != null) {
                        sb.append(CR);
                        sb.append("        ");
                        sb.append("minvalue=\"" + minvalue + "\" ");
                        sb.append("maxvalue=\"" + maxvalue + "\" ");
                        sb.append("cycle=\"true\"");
                    }
                    sb.append(">");
                    String createSequenceDDL = this.database.getCreateSequenceDDL();
                    createSequenceDDL = StringUtil.replaceAll((String)createSequenceDDL, (String)"$SEQNAME", (String)seq);
                    createSequenceDDL = StringUtil.replaceAll((String)createSequenceDDL, (String)"$QUOTEID", (String)this.quoteid);
                    createSequenceDDL = minvalue != null ? StringUtil.replaceAll((String)createSequenceDDL, (String)"$MINVALUE", (String)("MINVALUE " + String.valueOf(minvalue) + " ")) : StringUtil.replaceAll((String)createSequenceDDL, (String)"$MINVALUE", (String)"");
                    createSequenceDDL = maxvalue != null ? StringUtil.replaceAll((String)createSequenceDDL, (String)"$MAXVALUE", (String)("MAXVALUE " + String.valueOf(maxvalue) + " ")) : StringUtil.replaceAll((String)createSequenceDDL, (String)"$MAXVALUE", (String)"");
                    sb.append(createSequenceDDL);
                    sb.append("</sequence>").append(CR);
                }
            }
            modelId = model.getId();
            LinkedHashMap<Object, String> targetIndexItemMap = new LinkedHashMap<Object, String>();
            for (Action action : actions = AppSchemaUtil.getActionsByModelIdAndType(this.project, modelId, "showList")) {
                Condition[] conditions;
                Conditionlist conditionlist = AppSchemaUtil.getConditionlist(action);
                if (conditionlist == null || (conditions = AppSchemaUtil.getAllInnerCondition(conditionlist)) == null || conditions.length == 0) continue;
                PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(model);
                for (Condition condition : conditions) {
                    void var27_38;
                    String cond;
                    Modelitem mitem;
                    if (!condition.getUseindex()) continue;
                    String string = condition.getName();
                    boolean isPrimaryKey = false;
                    for (PrimaryKey pkey : pkeys) {
                        if (!pkey.getName().equals(string)) continue;
                        isPrimaryKey = true;
                        break;
                    }
                    if (isPrimaryKey && pkeys.length == 1 || (mitem = AppSchemaUtil.getModelitem(string, model)) == null || mitem.getTransient() || mitem.getUniqueKey() != null || "LIKE".equals(cond = condition.getCond()) && StringUtils.isBlank((String)mitem.getDualinputmethod()) || mitem.getAutokey()) continue;
                    if (JavaSourceGenerator.isStringType(mitem.getType())) {
                        boolean isTextarea = false;
                        Action[] _actions = AppSchemaUtil.getActionsByModelIdAndType(this.project, modelId, "show");
                        if (_actions != null) {
                            block4: for (Action _action : _actions) {
                                Presentation[] _presentations = AppSchemaUtil.getPresentation(this.project, _action);
                                if (_presentations == null) continue;
                                for (Presentation _presentation : _presentations) {
                                    Displayitem ditem = AppSchemaUtil.getDisplayitem(string, _presentation);
                                    if (ditem == null || !ditem.getType().equals("textarea") && !ditem.getType().equals("rtextarea")) continue;
                                    isTextarea = true;
                                    break block4;
                                }
                            }
                        }
                        if (isTextarea) continue;
                    }
                    Relation relation = null;
                    if ("masterref".equals(mitem.getType()) && (relation = AppSchemaUtil.getRelationTypeExceptRef(mitem)) != null && relation.getType().equals("check")) {
                        relation = null;
                        continue;
                    }
                    if ("storeref".equals(mitem.getType())) {
                        relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
                        if (relation != null && relation.getType().equals("check")) {
                            relation = null;
                            continue;
                        }
                        if (relation == null && (relation = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null) {
                            if ((relation = AppSchemaUtil.getRelatedLastRelation(relation)).getType().equals("check")) {
                                relation = null;
                                continue;
                            }
                            Modelitem nmitem = AppSchemaUtil.getRelatedLastModelitem(relation);
                            if (nmitem == null) {
                                this.logger.debug("nmitem is null. modelId=" + modelId + " mitem=" + mitem + " relation=" + relation);
                            }
                            if (nmitem != null && this.checkRdbdatatype(nmitem)) continue;
                        }
                    }
                    if (this.checkRdbdatatype(mitem)) continue;
                    String key = "jp.jasminesoft.jfc.gen.HibernateMappingGenerator.tablename.separator";
                    key = key + "." + modelId;
                    String tablenameSeparator = this.compatibilityManager.getStringValue(key);
                    String _tablename = tablename_4db;
                    if (mitem.getMultiple()) {
                        HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(mitem);
                        _tablename = hp != null ? hp.getListTablename() : tablename_4db + "$" + mitem.getRdbcolumnname();
                    } else if (AppSchemaUtil.hasChildPart(string)) {
                        String pname = AppSchemaUtil.getParentPart(string);
                        String cname = AppSchemaUtil.getChildPart(string);
                        Modelitem pmitem = AppSchemaUtil.getModelitem(pname, model);
                        HibernateParameterModelitem hp = AppSchemaUtil.getHibernateParameterModelitem(pmitem);
                        _tablename = hp != null ? hp.getListTablename() : tablename_4db + "$" + pmitem.getRdbcolumnname();
                        String string2 = cname;
                    }
                    if (StringUtils.isNotBlank((String)tablenameSeparator)) {
                        _tablename = _tablename.replace("$", tablenameSeparator);
                    }
                    targetIndexItemMap.put(var27_38, _tablename);
                }
            }
            if ("jfcworkstate".equals(modelId)) {
                targetIndexItemMap.put("modelpkey", tablename_4db);
                targetIndexItemMap.put("wait_layerid", tablename_4db);
                targetIndexItemMap.put("event", tablename_4db);
            }
            String string = _quoteid = model.getUseQuoteid() ? this.quoteid : "";
            if (targetIndexItemMap.size() <= 0) break block52;
            for (Map.Entry value : targetIndexItemMap.entrySet()) {
                String rdbcolumnname;
                String _indexname;
                String _tablename;
                block53: {
                    Model rmodel;
                    PrimaryKey[] primaryKeyArray;
                    Relation relation;
                    Modelitem mitem;
                    String _name;
                    block54: {
                        _name = (String)value.getKey();
                        _tablename = (String)value.getValue();
                        _indexname = this.createIndexName(model, tablename_4db, _name);
                        mitem = AppSchemaUtil.getModelitem(_name, model);
                        if (mitem.getGeneration()) continue;
                        rdbcolumnname = mitem.getRdbcolumnname();
                        if (StringUtils.isBlank((String)rdbcolumnname)) {
                            rdbcolumnname = _name;
                        }
                        if (!"storeref".equals(mitem.getType())) break block53;
                        relation = AppSchemaUtil.getRelationTypeExceptRef(mitem);
                        if (relation == null || "check".equals(relation.getType())) break block54;
                        Model rmodel2 = (Model)relation.getIdrefAsIRNode();
                        PrimaryKey[] r_pkeys2 = AppSchemaUtil.getPrimaryKey(rmodel2);
                        if (r_pkeys2 != null && r_pkeys2.length > 1) {
                            for (PrimaryKey r_pkey : r_pkeys2) {
                                this.createIndexSQL(contentMap, group, tablename_raw, _tablename, this.createIndexName(model, tablename_4db, _name + "_" + r_pkey.getName()), _name + "_" + r_pkey.getName(), _quoteid);
                            }
                            continue;
                        }
                        break block53;
                    }
                    relation = AppSchemaUtil.getRelationTypeIsRef(mitem);
                    if (relation == null) break block53;
                    if (relation.getRefstoretype().equals("refmodel")) continue;
                    Modelitem r_mitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, modelId, mitem);
                    relation = AppSchemaUtil.getRelationTypeExceptRef(r_mitem);
                    if (relation != null && !"check".equals(relation.getType()) && (primaryKeyArray = AppSchemaUtil.getPrimaryKey(rmodel = (Model)relation.getIdrefAsIRNode())) != null && primaryKeyArray.length > 1) {
                        for (PrimaryKey r_pkey : primaryKeyArray) {
                            this.createIndexSQL(contentMap, group, tablename_raw, _tablename, this.createIndexName(model, tablename_4db, _name + "_" + r_pkey.getName()), _name + "_" + r_pkey.getName(), _quoteid);
                        }
                    }
                    break block53;
                    continue;
                }
                this.createIndexSQL(contentMap, group, tablename_raw, _tablename, _indexname, rdbcolumnname, _quoteid);
            }
        }
        if ("jfcworkstate".equals(modelId)) {
            String createIndexDDL;
            String indexname = "jfcidx_jfcwokrstate_complex";
            String tablename = "jfcworkstate";
            String dropIndexDDL = this.database.getJfcworkstateDropIndexDDL();
            if (StringUtils.isNotBlank((String)dropIndexDDL)) {
                assert ("jfcidx_jfcwokrstate_complex".length() <= this.max_index_length) : "indexname jfcidx_jfcwokrstate_complex is over max_index_lenght\u3000" + this.max_index_length;
                sb.append("  ").append("<sql group=\"drop_index data\"").append(CR);
                sb.append("        ").append("acceptcommand=\"sql sql-drop-before\" denycommand=\"all\"").append(CR);
                sb.append("        ").append("tablename=\"jfcworkstate\">").append(CR);
                dropIndexDDL = StringUtil.replaceAll((String)dropIndexDDL, (String)"$INDEXNAME", (String)"jfcidx_jfcwokrstate_complex");
                dropIndexDDL = StringUtil.replaceAll((String)dropIndexDDL, (String)"$QUOTEID", (String)_quoteid);
                dropIndexDDL = StringUtil.replaceAll((String)dropIndexDDL, (String)"$TABLENAME", (String)"jfcworkstate");
                sb.append("    ");
                sb.append(dropIndexDDL);
                sb.append(CR);
                sb.append("  ");
                sb.append("</sql>");
                sb.append(CR);
                sb.append(CR);
            }
            if (StringUtils.isNotBlank((String)(createIndexDDL = this.database.getJfcworkstateCreateIndexDDL()))) {
                sb.append("  ").append("<sql group=\"create_index data\"").append(CR);
                sb.append("        ").append("acceptcommand=\"sql sql-create-after\" denycommand=\"all\"").append(CR);
                sb.append("        ").append("tablename=\"jfcworkstate\">").append(CR);
                createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$INDEXNAME", (String)"jfcidx_jfcwokrstate_complex");
                createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$QUOTEID", (String)_quoteid);
                createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$TABLENAME", (String)"jfcworkstate");
                sb.append("    ");
                sb.append(createIndexDDL);
                sb.append(CR);
                sb.append("  ");
                sb.append("</sql>");
                sb.append(CR);
                sb.append(CR);
            }
        }
    }

    private boolean checkRdbdatatype(Modelitem mitem) {
        String rdbdatatype = mitem.getRdbdatatype();
        return this.database.getType().toLowerCase().startsWith("mysql") && rdbdatatype != null && rdbdatatype.equalsIgnoreCase("text");
    }

    private void createIndexSQL(Map<String, StringBuilder> contentMap, String group, String tablename_raw, String _tablename, String _indexname, String rdbcolumnname, String _quoteid) {
        StringBuilder sb = contentMap.get("dropindex");
        String dropIndexDDL = this.database.getDropIndexDDL();
        if (StringUtils.isNotBlank((String)dropIndexDDL)) {
            this.appendDropIndexDDL(group, tablename_raw, _tablename, _indexname, _quoteid, sb, dropIndexDDL);
        }
        sb = contentMap.get("createindex");
        this.appendCreateIndexDDL(group, tablename_raw, _tablename, _indexname, rdbcolumnname, _quoteid, sb);
    }

    private void appendDropIndexDDL(String group, String tablename_raw, String _tablename, String _indexname, String _quoteid, StringBuilder sb, String dropIndexDDL) {
        sb.append("  ");
        sb.append("<sql group=\"drop_index ");
        sb.append(group);
        sb.append("\"");
        sb.append(CR);
        sb.append("        ");
        sb.append("acceptcommand=\"sql sql-drop-before\" ");
        sb.append("denycommand=\"all\"");
        sb.append(CR);
        sb.append("        ");
        sb.append("tablename=\"");
        sb.append(tablename_raw);
        sb.append("\">");
        sb.append(CR);
        sb.append("    ");
        dropIndexDDL = StringUtil.replaceAll((String)dropIndexDDL, (String)"$QUOTEID", (String)_quoteid);
        dropIndexDDL = StringUtil.replaceAll((String)dropIndexDDL, (String)"$TABLENAME", (String)_tablename);
        dropIndexDDL = StringUtil.replaceAll((String)dropIndexDDL, (String)"$INDEXNAME", (String)_indexname);
        sb.append(dropIndexDDL);
        sb.append(CR);
        sb.append("  ");
        sb.append("</sql>");
        sb.append(CR);
        sb.append(CR);
    }

    private void appendCreateIndexDDL(String group, String tablename_raw, String _tablename, String _indexname, String rdbcolumnname, String _quoteid, StringBuilder sb) {
        sb.append("  ");
        sb.append("<sql group=\"create_index ");
        sb.append(group);
        sb.append("\"");
        sb.append(CR);
        sb.append("        ");
        sb.append("acceptcommand=\"sql sql-create-after\" ");
        sb.append("denycommand=\"all\"");
        sb.append(CR);
        sb.append("        ");
        sb.append("tablename=\"");
        sb.append(tablename_raw);
        sb.append("\">");
        sb.append(CR);
        String createIndexDDL = this.database.getCreateIndexDDL();
        createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$INDEXNAME", (String)_indexname);
        createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$QUOTEID", (String)_quoteid);
        createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$TABLENAME", (String)_tablename);
        createIndexDDL = StringUtil.replaceAll((String)createIndexDDL, (String)"$COLUMNNAME", (String)rdbcolumnname);
        sb.append("    ");
        sb.append(createIndexDDL);
        sb.append(CR);
        sb.append("  ");
        sb.append("</sql>");
        sb.append(CR);
        sb.append(CR);
    }

    private String createIndexName(Model model, String tablename, String name) {
        boolean isQuote = VariableValidator_database.isQuote(model, this.database);
        return VariableValidator_database.createUniqueName("jfcidx_" + tablename + "_" + name, "", this.max_index_length, this.encoding, isQuote, this.indexNameSet, null, null);
    }

    protected StringBuilder createSequenceTableStatement_denyAll() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<!-- define only. for export directory information -->");
        sb.append(CR);
        sb.append("  ");
        sb.append("<directory tablename=\"seq\" denycommand=\"all\">");
        sb.append("init/seq</directory>");
        sb.append(CR);
        return sb;
    }

    protected StringBuilder createSequenceTableStatement() {
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append("<directory tablename=\"seq\" group=\"jdbc\" storage=\"hibernate\" createddlfilename=\"createddl/seq.ddl\" dropddlfilename=\"dropddl/seq.ddl\">");
        sb.append("init/seq</directory>");
        sb.append(CR);
        return sb;
    }

    protected void addContentDatabase(FileTemplateManager tplman, Database db) {
        String driver = "org.hsqldb.jdbcDriver";
        String url = "jdbc:hsqldb:jfcappdb";
        String user = "sa";
        String pwd = "";
        boolean jdbc2flag = true;
        if (db != null) {
            driver = db.getDriver();
            url = db.getUrl();
            user = db.getUser();
            pwd = db.getPassword();
            jdbc2flag = db.getJdbc2();
        }
        tplman.addContent("dbtype", WebStringEncodeUtilities.replaceCharEntity((String)this.dbtype));
        tplman.addContent("driver", WebStringEncodeUtilities.replaceCharEntity((String)driver));
        tplman.addContent("url", WebStringEncodeUtilities.replaceCharEntity((String)url));
        tplman.addContent("user", WebStringEncodeUtilities.replaceCharEntity((String)user));
        tplman.addContent("password", WebStringEncodeUtilities.replaceCharEntity((String)pwd));
        tplman.addContent("quoteid", this.quoteid);
        tplman.addContent("quotewhere", this.quotewhere);
        tplman.addContent("quoteidinwhere", this.quoteidinwhere);
        tplman.addContent("jdbc2", Boolean.toString(jdbc2flag));
        tplman.addContent("maxTablenameLength", Integer.toString(db.getMaxTablenameLength()));
        tplman.addContent("maxIndexnameLength", Integer.toString(db.getMaxIndexnameLength()));
        tplman.addContent("maxColumnnameLength", Integer.toString(db.getMaxColumnnameLength()));
        tplman.addContent("maxLengthStringDataType", db.getMaxLengthStringDataType());
        tplman.addContent("characterLargeObjectDataType", db.getCharacterLargeObjectDataType());
        tplman.addContent("supportTimeDataType", Boolean.toString(db.getSupportTimeDataType()));
        tplman.addContent("searchStringEscapeInLike", db.getSearchStringEscapeInLike());
        if (StringUtils.isNotBlank((String)db.getSpringBatchDDL())) {
            tplman.addContent("springBatchDDL", "springBatchDDL=\"" + db.getSpringBatchDDL() + "\"");
        } else {
            tplman.addContent("springBatchDDL", "");
        }
        if (StringUtils.isNotBlank((String)db.getValidationQuery())) {
            tplman.addContent("validationQuery", "validationQuery=\"" + db.getValidationQuery() + "\"");
        } else {
            tplman.addContent("validationQuery", "");
        }
        if (StringUtils.isNotBlank((String)db.getSequenceDML())) {
            tplman.addContent("sequenceDML", "sequenceDML=\"" + db.getSequenceDML() + "\"");
        } else {
            tplman.addContent("sequenceDML", "");
        }
    }

    protected String createDatasourceParam() {
        StringBuilder sb = new StringBuilder();
        String[][] datasource_parameter = new String[][]{{"maxWait", "500"}, {"defaultAutoCommit", "false"}};
        for (int i = 0; i < datasource_parameter.length; ++i) {
            String key = datasource_parameter[i][0];
            key = WebStringEncodeUtilities.replaceCharEntity((String)key);
            String content = datasource_parameter[i][1];
            content = WebStringEncodeUtilities.replaceCharEntity((String)content);
            sb.append("    ");
            sb.append("<datasource_param key=\"" + key + "\">");
            sb.append(content);
            sb.append("</datasource_param>");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String createConnectionInterface() {
        StringBuilder sb = new StringBuilder();
        Environment env = this.project.getEnvironment();
        ConnectionInterface conintcfg = AppSchemaUtil.getConnectionInterface(env);
        if (conintcfg != null) {
            String factory = conintcfg.getFactory();
            factory = WebStringEncodeUtilities.replaceCharEntity((String)factory);
            sb.append("  ");
            sb.append("<connection_interface factory=\"" + factory + "\" autocommitcount=\"1\">");
            sb.append(CR);
            for (ConnectionInterfaceParam param : conintcfg.getConnectionInterfaceParam()) {
                String key = param.getKey();
                key = WebStringEncodeUtilities.replaceCharEntity((String)key);
                String content = param.getContent();
                content = WebStringEncodeUtilities.replaceCharEntity((String)content);
                sb.append("    ");
                sb.append("<connection_interface_param key=\"" + key + "\">");
                sb.append(content);
                sb.append("</connection_interface_param>");
                sb.append(CR);
            }
            sb.append("  ");
            sb.append("</connection_interface>");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String createQuartzJDBCJobstoreDef(Database database) {
        StringBuilder sb = new StringBuilder();
        QuartzJDBCJobstore qjj = database.getQuartzJDBCJobstore();
        if (qjj != null) {
            sb.append("  ");
            sb.append("<!-- Quartz JDBC Jobstore -->");
            sb.append(CR);
            sb.append(this.craeteQuartzJDBCJobstoreDef(qjj));
        }
        return sb.toString();
    }

    protected void addContentMap(FileTemplateManager tplman, Map<String, StringBuilder> contentMap) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb0 = contentMap.get("dropseq");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- drop sequence -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("dropseq", sb.toString());
        sb = new StringBuilder();
        sb0 = contentMap.get("createseq");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- create sequence -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("createseq", sb.toString());
        sb = new StringBuilder();
        sb0 = contentMap.get("createtable");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- create sequnce table -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("createtable", sb.toString());
        sb = new StringBuilder();
        sb0 = contentMap.get("dropindex");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- drop index -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("dropindex", sb.toString());
        sb = new StringBuilder();
        sb0 = contentMap.get("createindex");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- create index -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("createindex", sb.toString());
        sb = new StringBuilder();
        sb0 = contentMap.get("master");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- create master table -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("master", sb.toString());
        sb = new StringBuilder();
        sb0 = contentMap.get("store");
        if (sb0 != null && sb0.length() > 0) {
            sb.append("  ");
            sb.append("<!-- create data table -->");
            sb.append(CR);
            sb.append(sb0.toString());
            sb.append(CR);
        }
        tplman.addContent("store", sb.toString());
    }

    protected String createSpringBatchDDL(Database database) {
        StringBuilder sb = new StringBuilder();
        String batchddlfilename = database.getSpringBatchDDL();
        if (StringUtils.isNotBlank((String)batchddlfilename)) {
            sb.append("  ");
            sb.append("<directory group=\"data hibernate\" storage=\"hibernate\" ");
            sb.append("createddlfilename=\"createddl/").append(batchddlfilename).append("\" ");
            sb.append("dropddlfilename=\"dropddl/").append(batchddlfilename).append("\" />");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }

    private Object craeteQuartzJDBCJobstoreDef(QuartzJDBCJobstore qjj) {
        String[] sql = new String[]{"<sql group=\"jfc_data\"", "    acceptcommand=\"sql sql-create-after\" denycommand=\"all\" acceptenvtype=\"commandline\"", "    tablename=\"jfcjobschedule\" file=\"createddl/" + qjj.getDdl() + "\">", "</sql>", "<sql group=\"jfc_data\"", "    acceptcommand=\"sql sql-drop-before\" denycommand=\"all\" acceptenvtype=\"commandline\"", "    tablename=\"jfcjobschedule\" file=\"dropddl/" + qjj.getDdl() + "\">", "</sql>"};
        StringBuilder sb = new StringBuilder();
        for (String s : sql) {
            sb.append("  ");
            sb.append(s);
            sb.append(CR);
        }
        sb.append(CR);
        return sb.toString();
    }
}

