/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JspSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;

public class JFCAppResourceGenerator
extends SourceGenerator {
    public static final String ENCODE = "UTF8";
    public static final String DICTIONARY = "template" + File.separator + "dic.txt";
    private static Map<String, String> dic = new HashMap<String, String>();
    private String basedir;
    public static boolean isFullBuild = false;
    private static LangSupport[] supportLang;
    private static LangSupport defaultLang;

    public JFCAppResourceGenerator(Project project, String basedir) {
        super(project);
        this.basedir = basedir;
        Environment env = project.getEnvironment();
        JFCAppResourceGenerator.putCommon("__jfc_common.dojo_webpage_dir", env.getDojoWebpageDir());
        this.loadPreviousResource();
    }

    private void loadPreviousResource() {
        for (LangSupport sup : supportLang) {
            this.loadPreviousResource0(sup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPreviousResource0(LangSupport sup) {
        BufferedReader reader = null;
        String filename = this.basedir + File.separator + this.getSubpackageName() + File.separator + sup.filename + this.getFileSuffix();
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODE));
            String line = null;
            while ((line = reader.readLine()) != null) {
                JFCAppResourceGenerator.setResourceMap(line, sup);
            }
        }
        catch (IOException e) {
            System.out.println("ERROR, " + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadResourceInfo(LangSupport sup) {
        BufferedReader in = null;
        String resourcePathTemplate = "work" + File.separator + "template_html" + File.separator + "webpage" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "$FILENAME$.properties." + ENCODE;
        String resourcePath = resourcePathTemplate.replace("$FILENAME$", sup.filename);
        if (!new File(resourcePath).exists()) {
            String shortname;
            resourcePath = null;
            if (sup.filename.indexOf("_") > 0 && !new File(resourcePath = resourcePathTemplate.replace("$FILENAME$", shortname = sup.filename.substring(0, sup.filename.lastIndexOf("_")))).exists()) {
                resourcePath = null;
            }
            if (resourcePath == null && !new File(resourcePath = "template" + File.separator + sup.filename + ".properties." + ENCODE).exists() && sup.filename.indexOf("_") > 0) {
                shortname = sup.filename.substring(0, sup.filename.lastIndexOf("_"));
                resourcePath = "template" + File.separator + shortname + ".properties." + ENCODE;
            }
        }
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(resourcePath), ENCODE));
            String line = null;
            while ((line = in.readLine()) != null) {
                JFCAppResourceGenerator.setResourceMap(line, sup);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        isFullBuild = false;
        String defaultLanguageStr = JFCUtils.getLocaleString();
        LangSupport supBase = new LangSupport(defaultLanguageStr);
        LangSupport supEn = new LangSupport("en");
        for (LangSupport sup : supportLang = new LangSupport[]{supBase, supEn}) {
            JFCAppResourceGenerator.loadResourceInfo(sup);
        }
        defaultLang = supBase;
        BufferedReader reader = null;
        try {
            File dictionary = new File(DICTIONARY);
            if (!dictionary.exists()) {
                System.err.println("File read error," + dictionary.getAbsolutePath());
                return;
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dictionary), ENCODE));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                int ptr = line.indexOf(",");
                if (ptr < 0) {
                    System.out.println("ERROR line:" + line);
                    continue;
                }
                String key = line.substring(0, ptr);
                String value = line.substring(ptr + 1);
                dic.put(key, value);
            }
        }
        catch (IOException e) {
            System.out.println("ERROR, " + e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void setResourceMap(String line, LangSupport sup) {
        if (line == null || line.length() == 0) {
            return;
        }
        if (line.charAt(0) == '#') {
            return;
        }
        int ptr = line.indexOf("=");
        if (ptr < 0) {
            return;
        }
        String key = line.substring(0, ptr);
        String value = line.substring(ptr + 1);
        key = StringUtil.replaceAll((String)key, (String)"\\", (String)"");
        sup.rmap.put(key, value);
        Set<String> keySet = sup.rvmap.get(value);
        if (keySet == null) {
            keySet = new TreeSet<String>();
            sup.rvmap.put(value, keySet);
        }
        keySet.add(key);
    }

    @Override
    public String getEncoding() {
        return ENCODE;
    }

    @Override
    public String getFileSuffix() {
        return ".properties." + this.getEncoding();
    }

    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public void process() {
        for (LangSupport sup : supportLang) {
            String content = this.process0(sup);
            String filename = sup.filename;
            String subpackagename = this.getSubpackageName();
            if (content == null) continue;
            content = this.getGeneratorClassName() + content;
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public String process0(LangSupport sup) {
        StringBuilder sb = new StringBuilder();
        sb.append("#" + CR);
        sb.append("# JFC Application Resource" + CR);
        sb.append("#" + CR);
        for (String key : sup.rmap.keySet()) {
            String value = sup.rmap.get(key);
            if (key == null || value == null) continue;
            key = this.encodeKey(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append(CR);
        }
        return sb.toString();
    }

    private String encodeKey(String key) {
        return StringUtil.replaceAll((String)key, (String)":", (String)"\\:");
    }

    public static void put(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        for (LangSupport sup : supportLang) {
            if (sup.rkey.contains(key)) break;
            String nvalue = JFCAppResourceGenerator.processedValue(sup, key, value);
            if (nvalue == null) continue;
            String oldvalue = sup.rmap.get(key);
            if (!nvalue.equals(oldvalue)) {
                sup.rmap.put(key, nvalue);
            }
            sup.rkey.add(key);
        }
    }

    private static String processedValue(LangSupport sup, String key, String value) {
        if (StringUtils.isEmpty((String)value)) {
            value = "";
        }
        if (!JFCAppResourceGenerator.defaultLang.lang.equals(sup.lang)) {
            if (!sup.rkey.contains(key)) {
                if (!JFCAppResourceGenerator.isAsciiPrintable(value)) {
                    boolean hasSharpId = value.endsWith("#id");
                    String nvalue = JFCAppResourceGenerator.translateUsingDefaultDictionaly(sup, key, value);
                    if (!value.equals(nvalue)) {
                        value = nvalue;
                    } else if (!(key.startsWith("__jfc_system") || key.startsWith("__jfc_master") && key.indexOf(".content") > 0)) {
                        value = null;
                        String[] tokens = StringUtil.split((String)key, (String)".");
                        if (tokens != null && tokens.length > 0) {
                            value = tokens[tokens.length - 1];
                            if (tokens.length - 2 >= 0) {
                                try {
                                    int tmp = Integer.parseInt(value);
                                    if (tmp >= 0) {
                                        value = tokens[tokens.length - 2] + "." + tokens[tokens.length - 1];
                                    }
                                }
                                catch (NumberFormatException tmp) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (value == null) {
                        value = key;
                    }
                    if (value != null) {
                        value = SourceGenerator.capFirst(value);
                        if (hasSharpId) {
                            value = value + "#id";
                        }
                    }
                }
            } else {
                if ((value = JFCAppResourceGenerator.translateUsingDefaultDictionaly(sup, key, value)) == null) {
                    value = key;
                }
                if (value != null) {
                    value = SourceGenerator.capFirst(value);
                }
            }
        }
        value = StringUtil.replaceAll((String)value, (String)"\r\n", (String)"\\r");
        value = StringUtil.replaceAll((String)value, (String)"\n", (String)"\\r");
        if (key.indexOf(".tooltip.") > 0 || key.endsWith(".tooltip")) {
            value = StringUtil.replaceAll((String)value, (String)"<br>", (String)"\\r");
            value = StringUtil.replaceAll((String)value, (String)"<br/>", (String)"\\r");
        }
        if (sup.lang.equals("en")) {
            if (key.endsWith("jshparam")) {
                if (value.endsWith("1jshparam")) {
                    value = value.substring(0, value.length() - "1jshparam".length()) + " (begin)";
                } else if (value.endsWith("2jshparam")) {
                    value = value.substring(0, value.length() - "2jshparam".length()) + " (end)";
                }
            } else if (key.startsWith("__jfc_system")) {
                int ptr = value.lastIndexOf(" ");
                if (ptr > 0) {
                    String pre = value.substring(0, ptr);
                    String post = value.substring(ptr + 1);
                    String n_post = value = JFCAppResourceGenerator.translateUsingDefaultDictionaly(sup, key, post);
                    value = pre + " " + n_post;
                }
            } else if (!(key.startsWith("__jfc_system") || key.indexOf(".pagetitle.") <= 0 && key.indexOf(".title.") <= 0)) {
                if (value.endsWith(".2")) {
                    value = value.substring(0, value.indexOf(".2"));
                }
            } else if (key.startsWith("__jfc_link.")) {
                if (value.equals("JFCPrintScreen")) {
                    value = "Print Screen";
                } else if (value.equals("OriginalDoImmediatly")) {
                    value = "Run now";
                } else if (value.equals("DeleteAll")) {
                    value = "Delete all";
                } else if (value.indexOf(".") > 0) {
                    value = value.substring(0, value.indexOf("."));
                }
            } else {
                value = JFCAppResourceGenerator.convertProperWord("__jfc_menu.", key, value);
                value = JFCAppResourceGenerator.convertProperWord("__jfc_pankuzu.", key, value);
            }
        }
        return value;
    }

    private static String convertProperWord(String prefix, String key, String value) {
        if (key.startsWith(prefix)) {
            String keypart;
            if (value.toLowerCase().startsWith("jfcmenu.")) {
                value = SourceGenerator.capFirst(value.substring("jfcmenu.".length()));
            }
            if ((keypart = key.substring(prefix.length())).toLowerCase().equals(value.toLowerCase())) {
                if (value.startsWith("ShowList")) {
                    value = "ShowList " + SourceGenerator.capFirst(value.substring("ShowList".length()));
                } else if (value.startsWith("Insert")) {
                    value = "Insert " + SourceGenerator.capFirst(value.substring("Insert".length()));
                } else if (value.startsWith("Download")) {
                    value = "Download " + SourceGenerator.capFirst(value.substring("Download".length()));
                } else if (value.startsWith("UpdateList")) {
                    value = "UpdateList " + SourceGenerator.capFirst(value.substring("UpdateList".length()));
                } else if (value.startsWith("UploadUpdate")) {
                    value = "Upload " + SourceGenerator.capFirst(value.substring("UploadUpdate".length()));
                } else if (value.startsWith("Show")) {
                    value = "Show " + SourceGenerator.capFirst(value.substring("Show".length()));
                }
                if (value.endsWith("Calendarview")) {
                    value = value.substring(0, value.length() - "Calendarview".length()) + " Calendarview";
                }
            }
        }
        return value;
    }

    private static String translateUsingDefaultDictionaly(LangSupport sup, String key, String value) {
        String n_value = dic.get(value);
        if (StringUtils.isNotBlank((String)n_value)) {
            value = n_value;
        } else {
            String rkey = null;
            Set<String> rKeySet = JFCAppResourceGenerator.defaultLang.rvmap.get(value);
            if (rKeySet != null) {
                for (String s : rKeySet) {
                    if (!s.equals(key)) continue;
                    rkey = s;
                    break;
                }
            }
            if (rkey != null && StringUtils.isNotBlank((String)(n_value = sup.rmap.get(rkey)))) {
                value = n_value;
            }
        }
        return value;
    }

    public String translateUsingDefaultDictionaly(String value) {
        String n_value = dic.get(value);
        if (StringUtils.isNotBlank((String)n_value)) {
            return n_value;
        }
        return value;
    }

    private static boolean isAsciiPrintable(String s) {
        boolean ret = true;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (CharUtils.isAsciiPrintable((char)ch)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private static void putCommon(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            return;
        }
        for (LangSupport sup : supportLang) {
            if (sup.rkey.contains(key)) continue;
            sup.rmap.put(key, value);
            sup.rkey.add(key);
        }
    }

    public static String createLinkResourceKey(String type, String name, String forward, String action, String content, JspSourceGenerator jspgen) {
        StringBuilder sb = new StringBuilder("__jfc_link");
        if (forward != null && forward.length() > 0) {
            if (forward.endsWith(".do")) {
                forward = forward.substring(0, forward.length() - 3);
            }
            sb.append(".");
            sb.append(forward);
        } else {
            String pidref;
            Presentation p = jspgen.getPresentation();
            if (p != null && (pidref = p.getIdref()) != null && pidref.length() > 0) {
                sb.append(".");
                sb.append(pidref);
            }
        }
        sb.append(".");
        sb.append(type);
        if ("button".equals(type)) {
            if (action != null && action.length() > 0) {
                sb.append(".");
                sb.append(action);
            } else if (name != null && name.length() > 0) {
                String __name = null;
                __name = name.startsWith("btn") ? name.substring("btn".length()) : name;
                sb.append(".");
                sb.append(__name);
            } else {
                sb.append("._undefined");
            }
        }
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createPankuzuResourceKey(String type, String content) {
        StringBuilder sb = new StringBuilder("__jfc_pankuzu");
        sb.append(".");
        sb.append(type);
        if (content != null && content.endsWith("Jshparam")) {
            content = content.substring(0, content.length() - "Jshparam".length());
        }
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createMessageResourceKey(String type, String content, JspSourceGenerator jspgen) {
        String pidref;
        StringBuilder sb = new StringBuilder("__jfc_msg");
        Presentation p = jspgen.getPresentation();
        if (p != null && (pidref = p.getIdref()) != null && pidref.length() > 0) {
            sb.append(".");
            sb.append(pidref);
        }
        sb.append(".");
        sb.append(type);
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createTitleResourceKey(String type, String content, JspSourceGenerator jspgen) {
        if (content.startsWith("__jfc_common.")) {
            return content;
        }
        String rkey = JFCAppResourceGenerator.getKeyExceptCommon(content);
        if (rkey == null || rkey != null && ("title".equals(type) || "pagetitle".equals(type))) {
            IRNode node;
            Presentation presentation;
            String id = null;
            String name = type;
            Action action = jspgen.getAction();
            if (action == null && (presentation = jspgen.getPresentation()) != null && (node = presentation.getIdrefAsIRNode()) != null && node instanceof Action) {
                action = (Action)node;
            }
            if (action != null) {
                String atype;
                IRNode node2 = action.getIdrefAsIRNode();
                if (node2 != null && node2 instanceof Model) {
                    Model smodel = AppSchemaUtil.getStoreModel((Model)node2);
                    if (smodel != null) {
                        id = smodel.getId();
                    } else {
                        Model model = (Model)node2;
                        id = model.getId();
                    }
                }
                if ((atype = action.getType()).endsWith("-master")) {
                    atype = "master";
                }
                if ("copy".equals(atype)) {
                    int copyActionCount = 0;
                    Action[] _actions = AppSchemaUtil.getActionByModelId(jspgen.project, id);
                    if (_actions != null) {
                        for (Action _action : _actions) {
                            if (!_action.getType().equals("copy")) continue;
                            ++copyActionCount;
                        }
                    }
                    if (copyActionCount > 1 && (atype = action.getId()).length() > "copy".length() + id.length()) {
                        atype = "copy" + atype.substring("copy".length() + id.length());
                    }
                }
                name = name + "." + atype;
            }
            if (id == null) {
                id = "__jfc_system";
            }
            rkey = JFCAppResourceGenerator.createModelResourceKey(id, name, content);
            JFCAppResourceGenerator.put(rkey, content);
        }
        return rkey;
    }

    public static String createModelResourceKey(String id, String name, String content) {
        String rkey;
        if (name.startsWith("__jfc_common") && (rkey = JFCAppResourceGenerator.getCommonKey(content)) != null) {
            return rkey;
        }
        if (name != null) {
            name = StringUtil.replaceAll((String)name, (String)"/", (String)".");
        }
        StringBuilder sb = new StringBuilder();
        if (id != null) {
            sb.append(id);
        } else {
            sb.append("_unknown_model");
        }
        sb.append(".");
        sb.append(name);
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createValueResourceKey(String id, String name, String content) {
        return JFCAppResourceGenerator.createModelResourceKey(id, name, content);
    }

    public static String createMenuTitleResourceKey(String content) {
        return JFCAppResourceGenerator.checkUniqueRKey("__jfc_menutitle", content);
    }

    public static String createMenuDescriptionResourceKey(String name, String content) {
        StringBuilder sb = new StringBuilder("__jfc_menu");
        sb.append(".");
        sb.append(name);
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createMenuTooltipResourceKey(String content) {
        return JFCAppResourceGenerator.checkUniqueRKey("__jfc_menutooltip", content);
    }

    public static String createHelperResourceKey(String methodType, String modelId, String itemName, String content) {
        StringBuilder sb = new StringBuilder("__jfc_helper");
        sb.append(".");
        sb.append(methodType);
        sb.append(".");
        sb.append(modelId);
        sb.append(".");
        sb.append(itemName);
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createTablenameResourceKey(String name, String content) {
        StringBuilder sb = new StringBuilder("__jfc_tablename");
        sb.append(".");
        sb.append(name);
        return JFCAppResourceGenerator.checkUniqueRKey(sb.toString(), content);
    }

    public static String createMasterValidResourceKey(String content, String id) {
        return JFCAppResourceGenerator.checkUniqueRKey("__jfc_master." + id + ".valid", content);
    }

    public static String createMasterContentResourceKey(String content, String id) {
        return JFCAppResourceGenerator.checkUniqueRKey("__jfc_master." + id + ".content", content);
    }

    public static String checkUniqueRKey(String rkey, String content) {
        return JFCAppResourceGenerator.checkUniqueRKey0(rkey, JFCAppResourceGenerator.processedValue(defaultLang, rkey, content));
    }

    private static String checkUniqueRKey0(String rkey, String content) {
        if (!JFCAppResourceGenerator.defaultLang.rkey.contains(rkey) && !JFCAppResourceGenerator.defaultLang.rkey.contains(JFCAppResourceGenerator.getNextResourceKey(rkey))) {
            return rkey;
        }
        String value = JFCAppResourceGenerator.defaultLang.rmap.get(rkey);
        if (value != null && value.equals(content)) {
            return rkey;
        }
        String n_rkey = null;
        int i = 0;
        while (JFCAppResourceGenerator.defaultLang.rkey.contains(n_rkey = i == 0 ? rkey : JFCAppResourceGenerator.getNextResourceKey(n_rkey))) {
            value = JFCAppResourceGenerator.defaultLang.rmap.get(n_rkey);
            if (value != null && value.equals(content)) {
                return n_rkey;
            }
            ++i;
        }
        return JFCAppResourceGenerator.checkUniqueRKey0(n_rkey, content);
    }

    private static String getNextResourceKey(String rkey) {
        String n_rkey = null;
        String token = StringUtil.lastToken((String)rkey, (String)".");
        try {
            int c = Integer.parseInt(token);
            n_rkey = rkey.substring(0, rkey.length() - token.length());
            n_rkey = n_rkey + ++c;
        }
        catch (NumberFormatException e) {
            n_rkey = rkey + ".2";
        }
        return n_rkey;
    }

    public static String getCommonKey(String content) {
        String ret = null;
        Object key = null;
        String value2 = null;
        block0: for (String value2 : JFCAppResourceGenerator.defaultLang.rvmap.keySet()) {
            Set<String> rKeySet;
            if (value2 == null || !value2.equals(content) || (rKeySet = JFCAppResourceGenerator.defaultLang.rvmap.get(value2)) == null) continue;
            for (String s : rKeySet) {
                if (!s.startsWith("__jfc_common")) continue;
                ret = s;
                continue block0;
            }
        }
        return ret;
    }

    public static String getKeyExceptCommon(String content) {
        String ret = null;
        String key2 = null;
        String value = null;
        for (String key2 : JFCAppResourceGenerator.defaultLang.rmap.keySet()) {
            if (key2.startsWith("__jfc_common") || (value = JFCAppResourceGenerator.defaultLang.rmap.get(key2)) == null || !value.equals(content)) continue;
            ret = key2;
            break;
        }
        return ret;
    }

    public static String getKeyFromValue(String value) {
        Set<String> rKeySet = JFCAppResourceGenerator.defaultLang.rvmap.get(value);
        if (rKeySet != null) {
            return rKeySet.iterator().next();
        }
        return null;
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "# genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }

    static {
        JFCAppResourceGenerator.reset();
    }

    static class LangSupport {
        String lang;
        Set<String> rkey = new HashSet<String>();
        Map<String, String> rmap = new TreeMap<String, String>();
        Map<String, Set<String>> rvmap = new TreeMap<String, Set<String>>();
        String filename;

        LangSupport(String lang) {
            this.lang = lang;
            this.filename = "jfcapp_" + lang;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LangSupport) {
                LangSupport target = (LangSupport)obj;
                if (this.lang.equals(target.lang)) {
                    return true;
                }
            }
            return false;
        }
    }
}

