/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.HashSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.Cluster;
import jp.jasminesoft.jfc.gen.appschema.ClusterMachine;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang.StringUtils;

public class JFCClusterPropertiesGenerator
extends ConfigGenerator {
    public JFCClusterPropertiesGenerator(Project project) {
        super(project);
    }

    @Override
    public String getEncoding() {
        return "UTF8";
    }

    @Override
    public String getFileSuffix() {
        return ".properties." + this.getEncoding();
    }

    @Override
    public String getFilename() {
        return "jfccluster";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        Environment env = this.project.getEnvironment();
        Cluster cluster = AppSchemaUtil.getCluster(env);
        if (cluster == null) {
            return "";
        }
        sb.append("# " + this.rman.getValue("JFCClusterPropertiesGenerator.comment.use_cluster"));
        sb.append(CR);
        sb.append("use_cluster=" + cluster.getUseCluster());
        sb.append(CR);
        sb.append(CR);
        sb.append("# " + this.rman.getValue("JFCClusterPropertiesGenerator.comment.retry"));
        sb.append(CR);
        sb.append("connect.retry=" + cluster.getConnectRetry());
        sb.append(CR);
        sb.append(CR);
        sb.append("# " + this.rman.getValue("JFCClusterPropertiesGenerator.comment.sleeptime"));
        sb.append(CR);
        sb.append("connect.sleeptime=" + cluster.getConnectSleeptime());
        sb.append(CR);
        sb.append(CR);
        ClusterMachine[] machines = cluster.getClusterMachine();
        if (machines == null || machines.length == 0) {
            this.logger.error(this.rman.getValue("JFCClusterPropertiesGenerator.error.nothing_cluster_machine"));
            return "";
        }
        HashSet<String> machinenameSet = new HashSet<String>();
        HashSet jmxUrlSet = new HashSet();
        boolean existThismachine = false;
        sb.append("### " + this.rman.getValue("JFCClusterPropertiesGenerator.comment.serverlist"));
        sb.append(CR);
        for (int i = 0; i < machines.length; ++i) {
            int cnt = i + 1;
            ClusterMachine machine = machines[i];
            if (machinenameSet.contains(machine.getMachinename())) {
                Object[] oa = new Object[]{machine.getMachinename()};
                this.logger.error(this.rman.getValue("JFCClusterPropertiesGenerator.error.duplicate_machinename", oa));
                return "";
            }
            machinenameSet.add(machine.getMachinename());
            if (StringUtils.isBlank((String)machine.getIpaddr())) {
                Object[] oa = new Object[]{machine.getMachinename()};
                this.logger.error(this.rman.getValue("JFCClusterPropertiesGenerator.error.no_ipaddr", oa));
                return "";
            }
            if (machine.getThismachine()) {
                if (existThismachine) {
                    this.logger.error(this.rman.getValue("JFCClusterPropertiesGenerator.error.duplicate_thismachine"));
                    return "";
                }
                existThismachine = true;
            }
            sb.append("# " + this.rman.getValue("JFCClusterPropertiesGenerator.comment.server") + cnt);
            sb.append(CR);
            sb.append("cluster_list.machinename." + cnt + "=" + machine.getMachinename());
            sb.append(CR);
            sb.append("cluster_list.ipaddr." + cnt + "=" + machine.getIpaddr());
            sb.append(CR);
            if (machine.checkJmxPort()) {
                sb.append("cluster_list.jmx_port." + cnt + "=" + machine.getJmxPort());
                sb.append(CR);
            }
            if (machine.checkRmiPort()) {
                sb.append("cluster_list.rmi_port." + cnt + "=" + machine.getRmiPort());
                sb.append(CR);
            }
            sb.append("cluster_list.thismachine." + cnt + "=" + machine.getThismachine());
            sb.append(CR);
            sb.append(CR);
        }
        if (!existThismachine) {
            this.logger.error(this.rman.getValue("JFCClusterPropertiesGenerator.error.nothing_thismachine"));
            return "";
        }
        return sb.toString();
    }
}

