/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IJobChoice;
import jp.jasminesoft.jfc.gen.appschema.Job;
import jp.jasminesoft.jfc.gen.appschema.Jobdesc;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class JobInstanceGenerator
extends SourceGenerator {
    private Job job = null;

    public JobInstanceGenerator(Job job, Project project) {
        super(project);
        this.job = job;
    }

    @Override
    public void process() {
        IJobChoice[] ijcs;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(StringUtil.CR);
        sb.append("<jfcjob>");
        sb.append("<name>");
        sb.append(this.job.getName());
        sb.append("</name>");
        String memo = this.job.getMemo();
        if (StringUtils.isBlank((String)memo)) {
            memo = this.job.getName();
        }
        sb.append("<memo>");
        sb.append(memo);
        sb.append("</memo>");
        if (StringUtils.isNotBlank((String)this.job.getClassname())) {
            sb.append("<classname>");
            sb.append(this.job.getClassname());
            sb.append("</classname>");
        }
        if ((ijcs = this.job.getContent()) != null) {
            for (IJobChoice ijc : ijcs) {
                Jobdesc jobdesc;
                if (!(ijc instanceof Jobdesc) || !StringUtils.isNotBlank((String)(jobdesc = (Jobdesc)ijc).getContent())) continue;
                sb.append("<description>");
                sb.append(jobdesc.getContent());
                sb.append("</description>");
            }
        }
        if (StringUtils.isBlank((String)this.job.getClassname())) {
            sb.append("<valid>false</valid>");
        }
        if (StringUtils.isNotBlank((String)this.job.getModel())) {
            sb.append("<targetmodels>");
            sb.append(this.job.getModel());
            sb.append("</targetmodels>");
        }
        sb.append("</jfcjob>");
        sb.append(StringUtil.CR);
        String content = sb.toString();
        String filename = this.job.getName();
        String subpackagename = "init.jfcjob";
        if (content != null) {
            this.createSource(content, filename, subpackagename, false);
        }
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }
}

