/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator_buttonControl4Displayitem;
import jp.jasminesoft.jfc.gen.HelperGenerator_buttonControl4enable;
import jp.jasminesoft.jfc.gen.HelperGenerator_buttonControl4show;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaScriptManagerFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspLayoutManager;
import jp.jasminesoft.jfc.gen.JspLayoutManagerFactory;
import jp.jasminesoft.jfc.gen.JspSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Css;
import jp.jasminesoft.jfc.gen.appschema.Csslist;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang.StringUtils;

public abstract class JspGenerator
extends JspSourceGenerator {
    protected boolean isTilesFlag;
    protected boolean isMobileLayout = false;
    protected boolean isSubwindow = false;
    protected boolean isLogonForm = false;

    public JspGenerator(Project project, Action action, Presentation presentation) {
        this(project, action, presentation, null);
    }

    public JspGenerator(Project project, Action action, Presentation presentation, String fid) {
        super(project, action, presentation);
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (fid != null) {
            this.fid = fid;
        } else {
            String filename = presentation.getFilename();
            if (filename != null && filename.length() > 0) {
                this.fid = filename;
            } else if (action != null) {
                this.fid = action.getId();
            } else {
                this.fid = "";
                this.logger.error(this.rman.getValue("jsp.filename.null", presentation.getIdref()));
            }
        }
        Layout layout = presentation.getLayout();
        if (layout != null) {
            String layouttype = layout.getType();
            if (StringUtils.isNotBlank((String)layouttype)) {
                if (layouttype.startsWith("tiles:")) {
                    this.isTilesFlag = true;
                }
                if ("mobile".equals(layouttype)) {
                    this.isMobileLayout = true;
                }
            }
            if (layouttype != null && layouttype.startsWith("tiles:")) {
                this.isTilesFlag = true;
            }
        }
        this.isSubwindow = action != null ? action.getSubwindow() : false;
    }

    @Override
    public String getFilename() {
        StringBuilder filename = new StringBuilder(JspGenerator.convertJspFilename(this.fid));
        if (this.isMobileLayout) {
            filename.append("Mobile");
        }
        return filename.toString();
    }

    @Override
    public boolean isTiles() {
        return this.isTilesFlag;
    }

    public boolean outputCheckLogonTag() {
        return true;
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        String cnt_header1 = this.gHeader1();
        String cnt_header2 = this.gHeader2();
        String cnt_header3 = this.gHeader3();
        String cnt_body = this.gBody();
        if (!this.isMobileLayout) {
            sb.append(cnt_header1);
            sb.append(cnt_header2);
            sb.append(cnt_header3);
        }
        sb.append(cnt_body);
        return sb.toString();
    }

    protected String gHeader1() {
        String locale;
        String errorpage;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("<%--").append(CR).append(" $").append("Id:").append("$").append(CR).append("--%>").append(CR).append(CR);
        }
        sb.append("<%@ page pageEncoding=\"").append(this.getEncoding()).append("\"");
        String[] importlist = this.getImportList();
        if (importlist != null && importlist.length > 0) {
            sb.append(CR);
            sb.append("    import=\"");
            for (int i = 0; i < importlist.length; ++i) {
                sb.append(importlist[i]);
                if (i + 1 >= importlist.length) continue;
                sb.append(",");
            }
            sb.append("\"");
        }
        if (StringUtils.isNotBlank((String)(errorpage = this.presentation.getErrorpage()))) {
            sb.append(" errorPage=\"").append(errorpage).append("\"");
        }
        sb.append(" %>").append(CR);
        if (this.isRedirectJspFlag) {
            return sb.toString();
        }
        if (this.isMobile()) {
            sb.append("<c:set var=\"isMobile\" value=\"<%= BaseController.isMobile(request) %>\"/>");
        }
        if (this.presentation.getCheckLogon() && this.outputCheckLogonTag()) {
            sb.append("<jfc:ifLogon not=\"true\">").append(CR).append("<c:redirect url=\"/system/iflogonerror.jsp\"/>").append(CR).append("</jfc:ifLogon>").append(CR);
        }
        if (StringUtils.isNotBlank((String)(locale = this.presentation.getLocale()))) {
            sb.append("<fmt:setLocale value=\"<%= jp.jasminesoft.jfc.JFCUtils.getLocaleStringByAcceptLanguage(request.getHeader(\"accept-language\"), \"").append(locale).append("\") %>\" scope=\"session\"/>").append(CR);
        } else {
            Layout layout = this.presentation.getLayout();
            if (StringUtils.startsWith((String)this.fid, (String)"searchList") || "standard".equals(layout.getType())) {
                sb.append("<fmt:setLocale value=\"${sessionScope.__jfc_locale}\" scope=\"request\"/>").append(CR);
            }
        }
        sb.append("<fmt:setBundle basename=\"jfcapp\"/>").append(CR);
        String cssfilename = this.presentation.getCss();
        if (cssfilename != null && cssfilename.length() > 0) {
            sb.append("<c:set var=\"").append("__jfc_cssfilename").append("\" scope=\"session\"").append(" value=\"").append(cssfilename).append("\"/>").append(CR);
        }
        return sb.toString();
    }

    protected String gHeader2() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>").append(CR);
        return sb.toString();
    }

    protected String gHeader3() {
        if ("logon".equals(this.fid) || "logoff".equals(this.fid)) {
            this.isLogonForm = true;
        }
        Layout layout = this.presentation.getLayout();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(CR);
        sb.append("<head>").append(CR);
        sb.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">").append(CR);
        sb.append("<meta charset=\"utf-8\">").append(CR);
        if (this.isRedirectJspFlag) {
            return sb.toString();
        }
        sb.append("<link rel=\"icon\" href=\"favicon.ico\" type=\"image/vnd.microsoft.icon\">").append(CR);
        sb.append("<link rel=\"shortcut icon\" href=\"favicon.ico\" type=\"image/vnd.microsoft.icon\">").append(CR);
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/normalize.css?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\">").append(CR);
        if (this.isLogonForm) {
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/");
            sb.append(this.presentation.getCss()).append(".css");
            sb.append("?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>");
            sb.append("\">").append(CR);
        } else {
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            sb.append("<fmt:message key='__jfc_common.dojo_webpage_dir'/>/dijit/themes/${sessionScope.");
            sb.append("__jfc_cssfilename");
            sb.append("}/${sessionScope.");
            sb.append("__jfc_cssfilename");
            sb.append("}.css\">").append(CR);
        }
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/common.css?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\">").append(CR);
        if (!this.isLogonForm) {
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/<c:out value='${sessionScope.__jfc_fontsizefilename}'/>.css?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\">").append(CR);
            sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/<c:out value='${sessionScope.__jfc_cssfilename}'/>.css?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\">").append(CR);
        } else {
            sb.append("<link rel=\"apple-touch-icon\" href=\"wagby-touch-icon.png\">").append(CR);
        }
        sb.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"css/mycommon.css?<c:out value='${applicationScope.__jfc_buildTimestamp}'/>\">").append(CR);
        if (this.isSubwindow) {
            sb.append(this.gStyleSheetRef());
        }
        if (StringUtils.startsWith((String)this.fid, (String)"searchList") || "standard".equals(layout.getType()) && !this.action.getSubwindow()) {
            String mid;
            String string = mid = this.action != null ? this.action.getIdref() : null;
            if (mid != null) {
                String filename = "searchList" + SourceGenerator.capFirst(mid) + "_stylesheet.jsp";
                sb.append("<jsp:include page=\"").append(filename).append("\" flush=\"true\"/>").append(CR);
            }
        }
        sb.append("<style type=\"text/css\">");
        sb.append(CR);
        sb.append("<!--");
        sb.append(CR);
        sb.append("body { padding: 0 5px; overflow: auto; }");
        sb.append(CR);
        sb.append("${__jfc_csscontent}");
        sb.append(CR);
        sb.append("-->");
        sb.append(CR);
        sb.append("</style>");
        sb.append(CR);
        sb.append("<style type=\"text/css\">");
        sb.append(CR);
        sb.append("  v\\:*{");
        sb.append(CR);
        sb.append("     behavior:url(#default#VML);");
        sb.append(CR);
        sb.append("  }");
        sb.append(CR);
        sb.append("</style>");
        sb.append(CR);
        if (this.isLogonForm || StringUtils.startsWith((String)this.fid, (String)"searchList") || "standard".equals(layout.getType())) {
            sb.append("<script type=\"text/javascript\" src=\"<fmt:message key='__jfc_common.dojo_webpage_dir'/>/dojo/dojo.js\" data-dojo-config=\"async: true, parseOnLoad: false, paths:{'apphome':'../..'}, locale: '<c:out value='${sessionScope.__jfc_browserLocale}'/>'\"></script>").append(CR);
            sb.append("<script type=\"text/javascript\" src=\"system/common.js\"></script>").append(CR);
            sb.append("<script type=\"text/javascript\" src=\"system/jquery.min.js\"></script>").append(CR);
        }
        String cnt_javascript = this.gJavaScriptTag();
        if (!this.isRedirectJspFlag && cnt_javascript != null) {
            sb.append(cnt_javascript);
        }
        String escapedTitle = this.getEscapedTitle();
        String rkey = JFCAppResourceGenerator.createTitleResourceKey("title", escapedTitle, this);
        sb.append("<!-- begin title -->").append(CR);
        Csslist csslist = this.presentation.getCsslist();
        if (csslist != null) {
            Css[] css_ary;
            for (Css css : css_ary = csslist.getCss()) {
                String cssfilename = css.getContent();
                String media = css.getMedia();
                sb.append("<link href=\"").append(cssfilename).append("?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>").append("\" rel=\"stylesheet\" type=\"text/css\"");
                if (StringUtils.isNotBlank((String)media)) {
                    sb.append(" media=\"").append(media).append("\"");
                }
                sb.append("/>").append(CR);
            }
        }
        sb.append("<title>").append("<fmt:message key=\"").append(rkey).append("\"/>").append("</title>").append(CR).append("<!-- end title -->").append(CR).append("</head>").append(CR);
        return sb.toString();
    }

    protected String gBody() {
        StringBuilder sb = new StringBuilder();
        if (!this.isMobileLayout) {
            sb.append("<body class=\"${sessionScope.").append("__jfc_cssfilename").append("}\"");
            if ("logon".equals(this.fid) || "logoff".equals(this.fid)) {
                sb.append(" onload=\"init()\"");
            }
            sb.append(">").append(CR);
        }
        sb.append(this.gBody0());
        sb.append(this.gBody1());
        if (!this.isMobileLayout) {
            sb.append("<br>").append(CR);
            if (!this.isLogonForm && !this.isRedirectJspFlag) {
                sb.append("<script type=\"text/javascript\">").append(CR);
                sb.append("  require([\"dojo/parser\", \"dojo/dom-style\", \"dojo/ready\", \"dojo/i18n!apphome/nls/common\"], function(parser, domStyle, ready, res) {").append(CR);
                sb.append("    window.browser_locale = \"<c:out value='${sessionScope.__jfc_browserLocale}'/>\";").append(CR);
                sb.append("    window.res = res;").append(CR);
                sb.append("    parser.parse();").append(CR);
                sb.append("    ready(function() {").append(CR);
                if (StringUtils.startsWith((String)this.fid, (String)"searchList")) {
                    sb.append("      domStyle.set(\"bodyarea\", \"visibility\", \"visible\");").append(CR);
                }
                sb.append("      for (i in Initializer.initList) {").append(CR);
                sb.append("        (Initializer.initList[i])();").append(CR);
                sb.append("      }").append(CR);
                sb.append("      for (i in Initializer.finList) {").append(CR);
                sb.append("        (Initializer.finList[i])();").append(CR);
                sb.append("      }").append(CR);
                sb.append("    });").append(CR);
                sb.append("  });").append(CR);
                sb.append("</script>").append(CR);
            }
            sb.append("</body>").append(CR);
            sb.append("</html>");
        } else {
            this.jsman = JavaScriptManagerFactory.getInstance(this.project, this.presentation, this.action);
            String jsFilename = this.jsman.getFilename() + this.jsman.getFileSuffix();
            sb.append("<script type=\"text/javascript\" src=\"").append(this.action.getIdref()).append("/").append(jsFilename).append("?<c:out value='${applicationScope.__jfc_releaseTimestamp}'/>\" charset=\"UTF-8\"></script>").append(CR);
            sb.append("<script type=\"text/javascript\">").append(CR);
            sb.append("require(['dojo/ready'], function(ready) {").append(CR);
            sb.append("ready(function() {").append(CR);
            sb.append("try {").append(CR);
            sb.append("create").append(JspGenerator.capFirst(this.action.getIdref())).append("ShowListGrid();").append(CR);
            sb.append("} catch(e) {").append(CR);
            sb.append("console.log(e);").append(CR);
            sb.append("}").append(CR);
            sb.append("});").append(CR);
            sb.append("});").append(CR);
            sb.append("</script>").append(CR);
        }
        return sb.toString();
    }

    protected String gBody0() {
        StringBuilder sb = new StringBuilder();
        Layout layout = this.presentation.getLayout();
        if (layout == null) {
            return sb.toString();
        }
        JspLayoutManager lman = JspLayoutManagerFactory.create(layout, this);
        if (lman == null) {
            return "";
        }
        lman.setPagetitle(this.presentation.getDescription());
        String _body = lman.process();
        String _head = lman.getPreparedContent();
        if (_head != null && _head.length() > 0) {
            sb.append(_head);
            sb.append(CR);
        }
        if (_body != null && _body.length() > 0) {
            sb.append(_body);
        }
        return sb.toString();
    }

    protected String gBody1() {
        return "";
    }

    protected String getXsltPrefix() {
        return this.getActionType();
    }

    public static String getMethodName4ButtonControlAddCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String addbuttonshowcondition = ditem.getAddbuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(addbuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "addbuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlRemoveCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String removebuttonshowcondition = ditem.getRemovebuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(removebuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "removebuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlMoveCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String movebuttonshowcondition = ditem.getMovebuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(movebuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "movebuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlInsertCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String insertbuttonshowcondition = ditem.getInsertbuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(insertbuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "insertbuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlAddButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String addbuttonlabel = ditem.getAddbuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(addbuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "addbuttonlabel");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlRemoveButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String removebuttonlabel = ditem.getRemovebuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(removebuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "removebuttonlabel");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlInsertButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String insertbuttonlabel = ditem.getInsertbuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(insertbuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "insertbuttonlabel");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlClearButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String clearbuttonlabel = ditem.getClearbuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(clearbuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "clearbuttonlabel");
        }
        return methodname;
    }

    public static String parsePlaceHolder4ShowButtonControl(Link link, Model pmodel, Presentation presentation) {
        Model smodel = AppSchemaUtil.getStoreModel(pmodel);
        String showcondition = link.getShowcondition();
        String methodName = null;
        if (StringUtils.isNotBlank((String)showcondition)) {
            if (JspGenerator.isUseEL_Expression(showcondition)) {
                return showcondition;
            }
        } else {
            return null;
        }
        methodName = "buttonControl_show";
        StringBuilder sb = new StringBuilder();
        sb.append("${jfc:").append(methodName).append("(pageContext.request,");
        sb.append("'");
        sb.append(smodel.getId());
        sb.append("'");
        sb.append(",");
        sb.append("'");
        sb.append(pmodel.getId());
        sb.append("'");
        sb.append(",");
        sb.append("'");
        sb.append(HelperGenerator_buttonControl4show.createLinkIdWithControlPattern(link, presentation));
        sb.append("'");
        sb.append(")");
        sb.append("==true}");
        return sb.toString();
    }

    public static String parsePlaceHolder4EnableButtonControl(Link link, Model pmodel, Presentation presentation) {
        Model smodel = AppSchemaUtil.getStoreModel(pmodel);
        String enablecondition = link.getEnablecondition();
        String methodName = null;
        if (StringUtils.isNotBlank((String)enablecondition)) {
            if (JspGenerator.isUseEL_Expression(enablecondition)) {
                return enablecondition;
            }
        } else {
            return null;
        }
        methodName = "buttonControl_enable";
        StringBuilder sb = new StringBuilder();
        sb.append("${jfc:").append(methodName).append("(pageContext.request,");
        sb.append("'");
        sb.append(smodel.getId());
        sb.append("'");
        sb.append(",");
        sb.append("'");
        sb.append(pmodel.getId());
        sb.append("'");
        sb.append(",");
        sb.append("'");
        sb.append(HelperGenerator_buttonControl4enable.createLinkIdWithControlPattern(link, presentation));
        sb.append("'");
        sb.append(")");
        sb.append("==true}");
        return sb.toString();
    }

    public static boolean isUseEL_Expression(String s) {
        if ((s = s.trim()).startsWith("${") && s.endsWith("}")) {
            return true;
        }
        return s.startsWith("TEXTSEARCH_");
    }

    protected void gWizardHiddenPageAttribute(String basetab, StringBuilder sb) {
        sb.append(basetab);
        sb.append("<%");
        sb.append(CR);
        sb.append(basetab + "  ");
        sb.append("if ((String)request.getAttribute(\"");
        sb.append("__jfc_keyname");
        sb.append("\") != null) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("String _key = (String)request.getAttribute(\"");
        sb.append("__jfc_keyname");
        sb.append("\");");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("Integer _page = (Integer)request.getAttribute(_key);");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("if (_page != null) {");
        sb.append(CR);
        sb.append(basetab);
        sb.append("%>");
        sb.append(CR);
        sb.append(basetab + "  ");
        sb.append("<input type=\"hidden\" name=\"<%= _key %>\" value=\"<%= _page %>\">");
        sb.append(CR);
        sb.append(basetab);
        sb.append("<%");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(basetab);
        sb.append("%>");
        sb.append(CR);
    }

    public static boolean isValidShowcondition(String condition) {
        if (StringUtils.isBlank((String)condition)) {
            return false;
        }
        return !"true".equalsIgnoreCase(condition) && !"\u25cb".equals(condition);
    }

    public static boolean needsCheckCondiiton(String condition) {
        return StringUtils.isNotBlank((String)condition) && !"false".equals(condition.toLowerCase());
    }

    public static boolean isIncludeELExpr(String str) {
        return JavaSourceGenerator.isUseExpression(str);
    }

    public String getPlaceholder(String id, Displayitem ditem, String type) {
        String placeholder = ditem.getPlaceholder();
        if (StringUtils.isBlank((String)placeholder)) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        key.append(ditem.getName()).append(".placeholder");
        if (StringUtils.isNotBlank((String)type)) {
            key.append(".").append(type);
        }
        String rkey = JFCAppResourceGenerator.createValueResourceKey(id, key.toString(), placeholder);
        JFCAppResourceGenerator.put(rkey, placeholder);
        StringBuilder sb = new StringBuilder();
        sb.append(" placeholder=\"").append("<fmt:message key='").append(rkey).append("'/>\"");
        return sb.toString();
    }

    protected static enum ParsePlaceHolderMode {
        Show,
        ShowList;

    }
}

