/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JspGenerator;
import jp.jasminesoft.jfc.gen.JspPanelContentBase;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Printall;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;

public class JspGenerator_printAll
extends JspGenerator {
    private Link link;

    public JspGenerator_printAll(Project project, Action action, Presentation presentation, String fid, Link link) {
        super(project, action, presentation, fid);
        this.link = link;
    }

    @Override
    protected String getActionType() {
        return null;
    }

    @Override
    public String getFilename() {
        return this.fid;
    }

    @Override
    public boolean isTiles() {
        return false;
    }

    @Override
    public boolean outputCheckLogonTag() {
        return false;
    }

    @Override
    protected String[] getImportList() {
        String[] ss = new String[]{"java.util.*"};
        return ss;
    }

    @Override
    public String process0() {
        String idref;
        String errorpage;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("<%--");
            sb.append(CR);
            sb.append(" $Id:$");
            sb.append(CR);
            sb.append("--%>");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        sb.append("<%@ page pageEncoding=\"");
        sb.append(this.getEncoding());
        sb.append("\"");
        String[] importlist = this.getImportList();
        if (importlist != null) {
            sb.append(CR);
            sb.append("    import=\"");
            for (int i = 0; i < importlist.length; ++i) {
                sb.append(importlist[i]);
                if (i + 1 >= importlist.length) continue;
                sb.append(",");
            }
            sb.append("\"");
        }
        if ((errorpage = this.presentation.getErrorpage()) != null && errorpage.length() > 0) {
            sb.append(" errorPage=\"" + errorpage + "\"");
        }
        sb.append(" %>");
        sb.append(CR);
        sb.append("<%");
        sb.append(CR);
        this.gSetChoiceMap(sb);
        sb.append(CR);
        Printall printall = AppSchemaUtil.getPrintall(this.action);
        this.gSetOutputMethodMap(sb, printall);
        sb.append("%>");
        sb.append(CR);
        sb.append(CR);
        String default_output_method = printall == null ? "zip" : printall.getDefaultOutputMethod();
        if (default_output_method != null) {
            sb.append("<c:set var=\"default_output_method\" scope=\"request\">");
            sb.append(default_output_method);
            sb.append("</c:set>");
            sb.append(CR);
        }
        if ((idref = this.getIdref()) == null) {
            return sb.toString();
        }
        sb.append("<c:set var=\"formname\" scope=\"request\">");
        sb.append(JspPanelContentBase.createActionId(this.getAction(), idref));
        sb.append("</c:set>");
        sb.append(CR);
        sb.append("<c:import url=\"../system/selectPrintAll.jsp\"/>");
        sb.append(CR);
        return sb.toString();
    }

    private void gSetChoiceMap(StringBuilder sb) {
        sb.append("  ");
        sb.append("Map<String,String> choice_map = new LinkedHashMap<String, String>();");
        sb.append(CR);
        sb.append("  ");
        sb.append("Map<String,String> choice_type_map = new LinkedHashMap<String, String>();");
        sb.append(CR);
        Action showAction = AppSchemaUtil.getActionByModelIdAndType(this.project, this.action.getIdref(), "show");
        Print[] prints = AppSchemaUtil.getPrint(showAction);
        Presentation[] showPresentations = AppSchemaUtil.getPresentation(this.project, showAction);
        Link[] links = showPresentations != null && showPresentations.length > 0 ? AppSchemaUtil.findLink(showPresentations[0]) : new Link[]{};
        block0: for (Print print : prints) {
            String paction = print.getAction();
            for (Link link : links) {
                String label;
                String rkey;
                if (!"action".equals(link.getType()) || !paction.equals(link.getAction())) continue;
                String key = link.getAction();
                int ptr = key.indexOf("_");
                if (ptr > 0) {
                    key = key.substring(ptr + 1);
                }
                if ((rkey = JFCAppResourceGenerator.getCommonKey(label = link.getLabel())) == null) {
                    rkey = JFCAppResourceGenerator.createLinkResourceKey(key, null, null, link.getAction(), label, this);
                    JFCAppResourceGenerator.put(rkey, label);
                }
                Printlayout printlayout = null;
                IRNode node = print.getIdrefAsIRNode();
                if (node != null && node instanceof Printlayout) {
                    printlayout = (Printlayout)node;
                }
                if (printlayout == null) continue;
                sb.append("  ");
                sb.append("choice_map.put(\"");
                sb.append(key);
                sb.append("\", \"");
                sb.append(rkey);
                sb.append("\");");
                sb.append(CR);
                sb.append("  ");
                sb.append("choice_type_map.put(\"");
                sb.append(key);
                sb.append("\", \"");
                sb.append(printlayout.getType());
                sb.append("\");");
                sb.append(CR);
                continue block0;
            }
        }
        sb.append("  ");
        sb.append("request.setAttribute(\"choice_map\", choice_map);");
        sb.append(CR);
        sb.append("  ");
        sb.append("request.setAttribute(\"choice_type_map\", choice_type_map);");
        sb.append(CR);
    }

    private void gSetOutputMethodMap(StringBuilder sb, Printall printall) {
        sb.append("  ");
        sb.append("Map<String,String> output_method_map = new LinkedHashMap<String, String>();");
        sb.append(CR);
        if (AppSchemaUtil.isEnablePrintallOutputMethodZip(printall)) {
            sb.append("  ");
            sb.append("output_method_map.put(\"zip\", \"zip\");");
            sb.append(CR);
        }
        if (AppSchemaUtil.isEnablePrintallOutputMethodSheet(printall)) {
            sb.append("  ");
            sb.append("output_method_map.put(\"sheet\", \"sheet\");");
            sb.append(CR);
        }
        if (AppSchemaUtil.isEnablePrintallOutputMethodPdf(printall)) {
            sb.append("  ");
            sb.append("output_method_map.put(\"pdf\", \"pdf\");");
            sb.append(CR);
        }
        if (AppSchemaUtil.isEnablePrintallOutputMethodRtf(printall)) {
            sb.append("  ");
            sb.append("output_method_map.put(\"rtf\", \"rtf\");");
            sb.append(CR);
        }
        sb.append("  ");
        sb.append("request.setAttribute(\"output_method_map\", output_method_map);");
        sb.append(CR);
    }

    private String getIdref() {
        if (this.link == null) {
            return null;
        }
        IRNode parentnode = this.link.rGetParentRNode();
        if (parentnode == null) {
            return null;
        }
        String idref = null;
        if (parentnode instanceof Displaymodel) {
            Displaymodel dmodel = (Displaymodel)parentnode;
            idref = dmodel.getIdref();
        } else if (parentnode instanceof Displaymodelgroup) {
            Displaymodelgroup dmodel = (Displaymodelgroup)parentnode;
            idref = dmodel.getIdref();
        }
        return idref;
    }
}

