/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JspTaglibManager
implements ISourceVariable {
    private static JspTaglibManager _instance = new JspTaglibManager();
    private ResourceManager rman;
    private Map tmap;
    protected Logger logger = LogManager.getLogger((String)JspTaglibManager.class.getName());

    private JspTaglibManager() {
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.tmap = new HashMap();
    }

    public static JspTaglibManager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTaglibDefinition(Presentation presentation) {
        if (presentation == null) {
            return "";
        }
        Layout layout = presentation.getLayout();
        if (layout == null) {
            return "";
        }
        String type = layout.getType();
        String cnt = (String)this.tmap.get(type);
        if (cnt != null && cnt.length() > 0) {
            return cnt;
        }
        StringBuilder sb = new StringBuilder();
        String basefile = this.getTemplateBasefile(type);
        if (basefile != null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(basefile), "UTF-8"));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith("<%@ taglib")) continue;
                    sb.append(line + CR);
                }
            }
            catch (IOException e) {
                this.logger.warn(this.rman.getValue("file.read.error", basefile));
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        cnt = sb.toString();
        this.tmap.put(type, cnt);
        return cnt;
    }

    public String getTemplateBasefile(String type) {
        String filename = null;
        if (type != null && type.startsWith("tiles:")) {
            String layoutname = type.substring("tiles:".length());
            filename = "template" + File.separator + "base_" + layoutname + ".jsp";
        } else {
            filename = "template" + File.separator + "taglib.jsp";
        }
        return filename;
    }
}

