/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.SpringApplicationContextContainer;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Datalock;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class LockObjectCreatorGenerator
extends JavaSourceGenerator {
    private static final int SEPARAET_LINE_NUM = 72;
    public static final String SUB_PACKAGE_NAME = "app";
    private static final String STOREDATA_VARNAME = "_sdata";
    private static Map<String, Object> beanIdMap = new TreeMap<String, Object>();
    private Model smodel = null;
    private List<Datalock> datalocks;
    private TreeSet<String> nameset;
    private Set<String> modelNameSkipResolvForeignKey;
    protected String[] defaultImportStatement = new String[]{"java.sql.*", "java.text.SimpleDateFormat", "java.util.HashMap", "java.util.LinkedHashSet", "jp.jasminesoft.jfc.*", "jp.jasminesoft.util.*", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager"};

    public static void addLockManagerInApplicationContext(Project project, boolean is_cluster) {
        List<String> list;
        String s;
        String appctxid = "LockManager";
        String classname = "jp.jasminesoft.jfc.LockMultipleManagerImpl";
        ApplicationContextBean bean = new ApplicationContextBean(appctxid, classname, null, true);
        if (beanIdMap.size() > 0) {
            bean.addPropertyMap("lockObjectCreatorMap", beanIdMap);
        }
        bean.addProperty("lockSingleManager", new ApplicationContextBean.ReferenceElement("LockSingleManager"));
        bean.setAopScopedProxy(true);
        bean.setAopScopedProxytargetClass(false);
        if (AppSchemaUtil.isCluster(project) && is_cluster) {
            bean.setLazyInit(true);
        }
        SpringApplicationContextContainer.addApplicationContextBean(bean);
        appctxid = "LockSingleManager";
        classname = AppSchemaUtil.isCluster(project) && is_cluster ? "jp.jasminesoft.jfc.LockManagerClusterImpl" : (AppSchemaUtil.isDblockmanager(project) ? "jp.jasminesoft.jfc.LockManagerDbImpl" : (StringUtils.isNotBlank((String)(s = CompatibilityManager.getInstance().getStringValue("jp.jasminesoft.jfc.gen.LockObjectCreatorGenerator.StandardType"))) && "v2".equals(s) ? "jp.jasminesoft.jfc.LockManagerImpl2" : "jp.jasminesoft.jfc.LockManagerImpl"));
        bean = new ApplicationContextBean(appctxid, classname, null, true);
        if (AppSchemaUtil.isCluster(project) && is_cluster) {
            bean.setLazyInit(true);
        }
        if (CollectionUtils.isNotEmpty(list = AppSchemaUtil.getDisabledPessimisticLockModelIds(project))) {
            bean.addProperty("disabledModelIds", StringUtils.join(list, (String)","));
        }
        SpringApplicationContextContainer.addApplicationContextBean(bean);
    }

    public LockObjectCreatorGenerator(Project project, Model smodel) {
        super(project);
        this.smodel = smodel;
        this.datalocks = AppSchemaUtil.getDatalock(smodel);
        this.nameset = new TreeSet();
        for (Datalock datalock : this.datalocks) {
            this.nameset.add(datalock.getName());
        }
        this.modelNameSkipResolvForeignKey = this.createModelNameSkipResolvForeignKey();
    }

    @Override
    public String getClassname() {
        return "LockObjectCreatorImpl";
    }

    public String getClassExplanation() {
        return rman.getValue("lockobjectcreator.comment.class");
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" implements LockObjectCreator");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String[] getDefaultImport() {
        return this.defaultImportStatement;
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, AppSchemaUtil.getStoreModel(this.smodel));
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, AppSchemaUtil.getStoreModel(this.smodel));
    }

    protected String gHeader() {
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append(CR);
        }
        this.gImport(sb);
        sb.append(CR);
        this.gClassComment(sb);
        sb.append(CR);
        return sb.toString();
    }

    private void gClassComment(StringBuilder sb) {
        boolean useCVSFlag = this.project.getUseCVS();
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] commentStr = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (commentStr != null) {
            for (String c : commentStr) {
                sb.append(" * ");
                sb.append(c);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
    }

    private void gImport(StringBuilder sb) {
        String[] ary = this.getDefaultImport();
        if (ary != null) {
            for (String c : ary) {
                sb.append("import ");
                sb.append(c);
                sb.append(";");
                sb.append(CR);
            }
        }
        if (AppSchemaUtil.isStoreModel(this.smodel)) {
            String stmt = AppSchemaUtil.getPackagename(this.smodel, this.project) + "*";
            sb.append("import ");
            sb.append(stmt);
            sb.append(";");
            sb.append(CR);
        }
    }

    @Override
    public String process0() {
        String appctxid = SourceGenerator.capFirst(this.smodel.getId()) + "LockObjectCreator";
        String classname = this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule() + "." + this.getClassname();
        String beanId = SpringApplicationContextContainer.addApplicationContextBean(new ApplicationContextBean(appctxid, classname, null, true));
        beanIdMap.put(this.smodel.getId(), new ApplicationContextBean.ReferenceElement(beanId));
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gLoggerReady(this.getClassname()));
        sb.append(this.gVariable());
        sb.append(this.gCreateLockObjectForData());
        sb.append(this.gCreateLockObjectActionParameter());
        sb.append(this.gCreateLockObject());
        sb.append(this.gCreateLockObjectForAll());
        sb.append(this.gEnd());
        return sb.toString();
    }

    protected String gVariable() {
        return "";
    }

    protected String gCreateLockObjectForData() {
        String classname = AppSchemaUtil.getClassname(this.smodel);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(this.smodel, this.project);
        StringBuilder sb = new StringBuilder();
        String[] params = new String[]{"_modelname " + rman.getValue("lockobjectcreator.comment.modelname"), "_data " + rman.getValue("lockobjectcreator.comment.data"), "_sessionid " + rman.getValue("lockobjectcreator.comment.sessionid"), "p " + rman.getValue("lockobjectcreator.comment.p")};
        sb.append(CommentGenerator.gComment(rman.getValue("lockobjectcreator.comment.createLockObjectForData"), params, "lock object"));
        sb.append("    ");
        sb.append("public LockObject createLockObjectForData(");
        sb.append(CR);
        sb.append("            ");
        sb.append("String _modelname, Object _data, String _sessionid, ");
        sb.append("ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append(classname + " " + STOREDATA_VARNAME + " = (" + classname + ") _data;");
        sb.append(CR);
        String pkeyname = this.gCreatePrimaryKeyVarCode(classname, pkeys, sb);
        if (this.isMultipleItemInDatalock()) {
            this.gCreateLockObjectItemListCode(classname, pkeyname, sb);
        } else {
            this.gCreateDatalockKeyVarCode(classname, pkeyname, sb);
            this.gCreateLockObjectItemArrayCode(sb);
        }
        this.gCreateLockObject(sb, pkeyname);
        sb.append("        ");
        sb.append("return _lo;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void gCreateLockObject(StringBuilder sb, String pkeyname) {
        sb.append("        ");
        sb.append("LockObject _lo =");
        sb.append(CR);
        sb.append("            ");
        sb.append("new LockObjectImpl(");
        sb.append(CR);
        sb.append("                ");
        sb.append("_modelname, " + pkeyname + ", _sessionid, p.user, false, _items);");
        sb.append(CR);
    }

    private void gCreateLockObjectItemListCode(String classname, String pkeyname, StringBuilder sb) {
        sb.append("        ");
        sb.append("LinkedHashSet<LockObjectItem> _itemlist =");
        sb.append(" new LinkedHashSet<LockObjectItem>();");
        sb.append(CR);
        HashSet<String> keynameset = new HashSet<String>();
        keynameset.add(pkeyname);
        for (Datalock datalock : this.datalocks) {
            block4: {
                try {
                    if (this.isMultipleItemInDatalock(datalock)) {
                        this.gCreateLockObjectItemMultiple(classname, pkeyname, datalock, sb, "        ");
                    }
                    break block4;
                }
                catch (IllegalStateException e) {
                    logger.error("[Internal Error] illegal lock key.", (Throwable)e);
                }
                continue;
            }
            this.gCreateLockObjectItemSingle(classname, keynameset, datalock, sb, "        ");
        }
        sb.append("        ");
        sb.append("LockObjectItem[] _items =");
        sb.append(CR);
        sb.append("            ");
        sb.append("(LockObjectItem[])_itemlist.toArray(");
        sb.append("new LockObjectItem[_itemlist.size()]);");
        sb.append(CR);
    }

    private void gCreateLockObjectItemSingle(String classname, HashSet<String> keynameset, Datalock datalock, StringBuilder sb, String tab) {
        String[] keymitems = StringUtils.split((String)datalock.getKeyModelitems());
        String keyname = ControllerGenerator2.createDatalockKeyName(keymitems);
        if (!keynameset.contains(keyname)) {
            keynameset.add(keyname);
            this.gCreateDatalockKeyVarCode(classname, sb, tab, keymitems, keyname);
        }
        sb.append(tab);
        sb.append("_itemlist.add(new LockObjectItemImpl(\"");
        sb.append(datalock.getName());
        sb.append("\", ");
        sb.append(keyname);
        sb.append(", false));");
        sb.append(CR);
        sb.append(CR);
    }

    private void gCreateLockObjectItemMultiple(String classname, String pkeyname, Datalock datalock, StringBuilder sb, String tab) {
        String[] keymitems = StringUtils.split((String)datalock.getKeyModelitems());
        String keyname = ControllerGenerator2.createDatalockKeyName(keymitems);
        int loopdepth = this.gCreateLockObjectItemBeginLoop(sb, tab, keymitems);
        StringBuilder tabbuf = new StringBuilder(tab);
        for (int j = 0; j < loopdepth; ++j) {
            tabbuf.append("    ");
        }
        String tab1 = tabbuf.toString();
        this.gCreateDatalockKeyVarCode(classname, sb, tab1, keymitems, keyname);
        sb.append(tab1);
        sb.append("_itemlist.add(new LockObjectItemImpl(\"");
        sb.append(datalock.getName());
        sb.append("\", ");
        sb.append(keyname);
        sb.append(", false));");
        sb.append(CR);
        for (int i = loopdepth - 1; i >= 0; --i) {
            sb.append(tab);
            for (int j = 0; j < i; ++j) {
                sb.append("    ");
            }
            sb.append("}");
            sb.append(CR);
        }
    }

    private int gCreateLockObjectItemBeginLoop(StringBuilder sb, String tab, String[] keymitems) {
        int loopdepth = 0;
        HashSet<String> pnameSet = new HashSet<String>();
        for (String keymitemname : keymitems) {
            String pname;
            String msg;
            Modelitem mitem = AppSchemaUtil.getModelitem(keymitemname, this.smodel);
            if (mitem == null) {
                msg = rman.getValue("modelitem.notfound", new Object[]{this.smodel.getId(), keymitemname});
                throw new IllegalStateException(msg);
            }
            if (mitem.getMultiple()) {
                if (!mitem.getHasChild()) {
                    this.gCreateLockObjectItemBeginLoopMulti(sb, tab, keymitemname, loopdepth);
                    ++loopdepth;
                    continue;
                }
                msg = rman.getValue("ControllerGenerator2.lock.cannotusecontainer", new Object[]{keymitemname, this.smodel.getId()});
                throw new IllegalStateException(msg);
            }
            if (!AppSchemaUtil.hasChildPart(keymitemname) || pnameSet.contains(pname = AppSchemaUtil.getParentPart(keymitemname))) continue;
            this.gCreateLockObjectItemBeginLoopCont(sb, tab, pname, loopdepth);
            pnameSet.add(pname);
            ++loopdepth;
        }
        return loopdepth;
    }

    private void gCreateLockObjectItemBeginLoopCont(StringBuilder sb, String tab, String pname, int loopdepth) {
        sb.append(tab);
        for (int j = 0; j < loopdepth; ++j) {
            sb.append("    ");
        }
        sb.append("for (");
        sb.append(AppSchemaUtil.getModelitemClassname(pname, this.smodel));
        sb.append(" ");
        sb.append(StringUtil.convertJavaVariableString((String)pname));
        sb.append(" : _sdata");
        sb.append(JavaSourceGenerator.getterFullMethod(pname));
        sb.append(") {");
        sb.append(CR);
    }

    private void gCreateLockObjectItemBeginLoopMulti(StringBuilder sb, String tab, String keymitemname, int loopdepth) {
        sb.append(tab);
        for (int j = 0; j < loopdepth; ++j) {
            sb.append("    ");
        }
        String mitemtype = AppSchemaUtil.getPkeyType(this.smodel, keymitemname, null, this.project);
        if (JavaSourceGenerator.isBasicType(mitemtype)) {
            sb.append("for (");
            sb.append(JavaSourceGenerator.b2wc(mitemtype));
            sb.append(" ");
            sb.append(StringUtil.convertJavaVariableString((String)keymitemname));
            sb.append(" : ");
            sb.append(JavaSourceGenerator.getterFullMethodAsObject(STOREDATA_VARNAME, keymitemname, mitemtype));
            sb.append(") {");
        } else if ("string".equals(mitemtype)) {
            sb.append("for (String ");
            sb.append(StringUtil.convertJavaVariableString((String)keymitemname));
            sb.append(" : _sdata");
            sb.append(JavaSourceGenerator.getterFullMethod(keymitemname));
            sb.append(") {");
        } else if (JavaSourceGenerator.isDateOrTimeType(mitemtype)) {
            sb.append("for (");
            sb.append(JavaSourceGenerator.getDateOrTimeJavaType(mitemtype));
            sb.append(" ");
            sb.append(StringUtil.convertJavaVariableString((String)keymitemname));
            sb.append(" : _sdata");
            sb.append(JavaSourceGenerator.getterFullMethod(keymitemname));
            sb.append(") {");
        }
        sb.append(CR);
    }

    private boolean isMultipleItemInDatalock() {
        for (Datalock datalock : this.datalocks) {
            try {
                if (!this.isMultipleItemInDatalock(datalock)) continue;
                return true;
            }
            catch (IllegalStateException e) {
                logger.error("[Internal Error] illegal lock key.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean isMultipleItemInDatalock(Datalock datalock) {
        String[] keymitems;
        for (String keymitemname : keymitems = StringUtils.split((String)datalock.getKeyModelitems())) {
            Modelitem mitem = AppSchemaUtil.getModelitem(keymitemname, this.smodel);
            if (mitem == null) {
                String msg = rman.getValue("modelitem.notfound", new Object[]{this.smodel.getId(), keymitemname});
                throw new IllegalStateException(msg);
            }
            if (mitem.getMultiple()) {
                if (!mitem.getHasChild()) {
                    return true;
                }
                String msg = rman.getValue("ControllerGenerator2.lock.cannotusecontainer", new Object[]{keymitemname, this.smodel.getId()});
                throw new IllegalStateException(msg);
            }
            if (!AppSchemaUtil.hasChildPart(keymitemname)) continue;
            return true;
        }
        return false;
    }

    private void gCreateLockObjectItemArrayCode(StringBuilder sb) {
        sb.append("        ");
        sb.append("LockObjectItem[] _items = {");
        sb.append(CR);
        Iterator<Datalock> it = this.datalocks.iterator();
        while (it.hasNext()) {
            Datalock datalock = it.next();
            String[] keymitems = StringUtils.split((String)datalock.getKeyModelitems());
            String keyname = ControllerGenerator2.createDatalockKeyName(keymitems);
            sb.append("            ");
            sb.append("new LockObjectItemImpl(\"");
            sb.append(datalock.getName());
            sb.append("\", ");
            sb.append(keyname);
            sb.append(", false)");
            if (it.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("};");
        sb.append(CR);
    }

    private String gCreatePrimaryKeyVarCode(String classname, PrimaryKey[] pkeys, StringBuilder sb) {
        String pkeyname = AppSchemaUtil.createPrimaryKeyName(pkeys);
        sb.append("        ");
        sb.append("String " + pkeyname + ";");
        sb.append(CR);
        if (pkeys.length == 1) {
            sb.append(ControllerGenerator2.gDeclarePrimaryKey(classname, this.smodel, pkeys, "        ", STOREDATA_VARNAME, this.project));
        } else {
            sb.append("        ").append("{").append(CR);
            sb.append(ControllerGenerator2.gDeclarePrimaryKey(classname, this.smodel, pkeys, "            ", STOREDATA_VARNAME, this.project));
            sb.append("        ").append("}").append(CR);
        }
        sb.append(CR);
        return pkeyname;
    }

    private void gCreateDatalockKeyVarCode(String classname, String pkeyname, StringBuilder sb) {
        HashSet<String> keynameset = new HashSet<String>();
        keynameset.add(pkeyname);
        for (Datalock datalock : this.datalocks) {
            String[] keymitems = StringUtils.split((String)datalock.getKeyModelitems());
            String keyname = ControllerGenerator2.createDatalockKeyName(keymitems);
            if (keynameset.contains(keyname)) continue;
            keynameset.add(keyname);
            this.gCreateDatalockKeyVarCode(classname, sb, "        ", keymitems, keyname);
        }
    }

    private void gCreateDatalockKeyVarCode(String classname, StringBuilder sb, String tab, String[] keymitems, String keyname) {
        sb.append(tab);
        sb.append("String " + keyname + ";");
        sb.append(CR);
        if (keymitems.length == 1) {
            sb.append(ControllerGenerator2.gDeclareDatalock(classname, this.smodel, keymitems, tab, STOREDATA_VARNAME, null, this.project));
        } else {
            sb.append(tab).append("{").append(CR);
            sb.append(ControllerGenerator2.gDeclareDatalock(classname, this.smodel, keymitems, tab + "    ", STOREDATA_VARNAME, null, this.project));
            sb.append(tab).append("}").append(CR);
        }
        sb.append(CR);
    }

    protected String gCreateLockObjectActionParameter() {
        String classname = AppSchemaUtil.getClassname(this.smodel);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(this.smodel, this.project);
        String pkeyname = AppSchemaUtil.createPrimaryKeyName(pkeys);
        StringBuilder sb = new StringBuilder();
        String[] params = new String[]{"_modelname " + rman.getValue("lockobjectcreator.comment.modelname"), "_pkey " + rman.getValue("lockobjectcreator.comment.pkey"), "_sessionid " + rman.getValue("lockobjectcreator.comment.sessionid"), "p " + rman.getValue("lockobjectcreator.comment.p")};
        sb.append(CommentGenerator.gComment(rman.getValue("lockobjectcreator.comment.createLockObjectActionParameter"), params, "lock object"));
        sb.append("    ");
        sb.append("public LockObject createLockObject(");
        sb.append(CR);
        sb.append("            ");
        sb.append("String _modelname, Object _pkey, String _sessionid, ");
        sb.append("ActionParameter p) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("String " + pkeyname + " = (String) _pkey;");
        sb.append(CR);
        sb.append("        ");
        sb.append(classname + " " + this.smodel.getId() + " = null;");
        sb.append(CR);
        this.gArraySkipResolvForeignKey(sb);
        this.gCreateProcessBeanCode(pkeys, pkeyname, sb);
        this.gCallProcessBeanCode(classname, sb);
        sb.append("        ");
        sb.append("return createLockObjectForData(");
        sb.append("_modelname, " + this.smodel.getId() + ", _sessionid, p);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void gCreateProcessBeanCode(PrimaryKey[] pkeys, String pkeyname, StringBuilder sb) {
        String pbeanDefaultPackagename = this.project.getPackage() + "." + SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.smodel);
        String pbeanname = AppSchemaUtil.createProcessBeanName(this.smodel.getId(), "show", null, null);
        sb.append("        ");
        sb.append("ProcessBean _pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(pbeanname, pbeanDefaultPackagename));
        sb.append(";");
        sb.append(CR);
        sb.append("        ");
        sb.append("_pbean.setActionParameter(p);");
        sb.append(";");
        sb.append(CR);
        sb.append(ControllerGenerator2.gSetPrimaryKey4Pbean1("_pbean", pkeyname, pkeys, ""));
    }

    private Set<String> createModelNameSkipResolvForeignKey() {
        LinkedHashSet<String> relSet = new LinkedHashSet<String>();
        for (IModelChoice rimc : this.smodel.getContent()) {
            Modelitem rmitem;
            Relation rrel;
            if (!(rimc instanceof Modelitem) || (rrel = AppSchemaUtil.getRelationTypeIsRef(rmitem = (Modelitem)rimc)) == null) continue;
            relSet.add(rrel.getIdref());
        }
        return relSet;
    }

    private void gArraySkipResolvForeignKey(StringBuilder sb) {
        Set<String> relSet = this.modelNameSkipResolvForeignKey;
        if (relSet.size() == 0) {
            return;
        }
        sb.append("        ");
        sb.append("final String[] SkipResolvForeignKeyList = {");
        sb.append(CR);
        Iterator<String> it = relSet.iterator();
        while (it.hasNext()) {
            String relid = it.next();
            sb.append("            ");
            sb.append("\"__jfc_control.skipResolvForeignKey_");
            sb.append(relid);
            if (it.hasNext()) {
                sb.append("\",");
            } else {
                sb.append("\"");
            }
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
    }

    private void gBackupSkipResolvForeignKey(StringBuilder sb) {
        if (this.modelNameSkipResolvForeignKey.size() == 0) {
            return;
        }
        sb.append("        ");
        sb.append("HashMap<String, Object> skipResolvForeignKeyMap =");
        sb.append(CR);
        sb.append("            ");
        sb.append("new HashMap<String, Object>();");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (String _key : SkipResolvForeignKeyList) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("skipResolvForeignKeyMap.put(_key,");
        sb.append(CR);
        sb.append("                ");
        sb.append("p.request.getAttribute(_key));");
        sb.append(CR);
        sb.append("            ");
        sb.append("p.request.removeAttribute(_key);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void gRestoreSkipResolvForeignKey(StringBuilder sb, String tab) {
        if (this.modelNameSkipResolvForeignKey.size() == 0) {
            return;
        }
        sb.append(tab);
        sb.append("for (String _key : SkipResolvForeignKeyList) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("p.request.setAttribute(_key,");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("skipResolvForeignKeyMap.get(_key));");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
    }

    private void gCallProcessBeanCode(String classname, StringBuilder sb) {
        this.gBackupSkipResolvForeignKey(sb);
        sb.append("        ");
        sb.append("Object _op = null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append("            ");
        sb.append("_op = _pbean.process();");
        sb.append(CR);
        sb.append("        ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append("            ");
        sb.append("_pbean.release();");
        sb.append(CR);
        this.gRestoreSkipResolvForeignKey(sb, "            ");
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("if (_op == null) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else if (_op instanceof String) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else if (_op instanceof " + classname + ") {");
        sb.append(CR);
        sb.append("            ");
        sb.append(this.smodel.getId() + " = (" + classname + ") _op;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
    }

    protected String gCreateLockObject() {
        StringBuilder sb = new StringBuilder();
        String[] params = new String[]{"modelname " + rman.getValue("lockobjectcreator.comment.modelname"), "pkey " + rman.getValue("lockobjectcreator.comment.pkey"), "sessionid " + rman.getValue("lockobjectcreator.comment.sessionid"), "user " + rman.getValue("lockobjectcreator.comment.user")};
        sb.append(CommentGenerator.gComment(rman.getValue("lockobjectcreator.comment.createLockObject"), params, "lock object"));
        sb.append("    ");
        sb.append("public LockObject createLockObject(");
        sb.append(CR);
        sb.append("            ");
        sb.append("String modelname, Object pkey, String sessionid, ");
        sb.append("User user) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("throw new IllegalStateException();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    protected String gCreateLockObjectForAll() {
        StringBuilder sb = new StringBuilder();
        String[] params = new String[]{"modelname " + rman.getValue("lockobjectcreator.comment.modelname"), "sessionid " + rman.getValue("lockobjectcreator.comment.sessionid"), "user " + rman.getValue("lockobjectcreator.comment.user")};
        sb.append(CommentGenerator.gComment(rman.getValue("lockobjectcreator.comment.createLockObjectForAll"), params, "lock object"));
        sb.append("    ");
        sb.append("public LockObject createLockObjectForAll(");
        sb.append(CR);
        sb.append("            ");
        sb.append("String modelname, String sessionid, User user) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("LockObjectItem[] items = {");
        sb.append(CR);
        Iterator<String> it = this.nameset.iterator();
        while (it.hasNext()) {
            String name = it.next();
            sb.append("            ");
            sb.append("new LockObjectItemImpl(\"" + name + "\", null, true)");
            if (it.hasNext()) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("        ").append("};").append(CR);
        sb.append("        ");
        sb.append("LockObject lo =");
        sb.append(CR);
        sb.append("            ");
        sb.append("new LockObjectImpl(");
        sb.append(CR);
        sb.append("                ");
        sb.append("modelname, null, sessionid, user, true, items);");
        sb.append(CR);
        sb.append("        ");
        sb.append("return lo;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    public static void reset() {
        beanIdMap = new TreeMap<String, Object>();
    }
}

