/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Menu;
import jp.jasminesoft.jfc.gen.appschema.Menubar;
import jp.jasminesoft.jfc.gen.appschema.Menulinkaction;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class MenuXmlGenerator
extends ConfigGenerator {
    public MenuXmlGenerator(Project project) {
        super(project);
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "menu";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF";
    }

    @Override
    public String process0() {
        Menubar menubar = this.project.getMenubar();
        if (menubar == null) {
            return "";
        }
        HashMap<String, MenuNode> menuMap = new HashMap<String, MenuNode>();
        MenuNode root = this.createMenuNode(menubar, menuMap);
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                Menulinkaction mactn;
                if (ipc[i] instanceof Action) {
                    Action action = (Action)ipc[i];
                    if ("userPreference".equals(action.getId()) && action.getMenuorder() == 0) continue;
                    boolean isMobile = AppSchemaUtil.isMobile(action, this.project);
                    if (StringUtils.isBlank((String)action.getMenuref())) {
                        this.logger.debug("menuref is null. skip to add menu. " + action.getId());
                        continue;
                    }
                    if (isMobile) {
                        this.logger.info("isMobile is true. skip to add menu for PC Web. " + action.getId());
                        continue;
                    }
                    this.addMenuContent(action, menuMap);
                    continue;
                }
                if (!(ipc[i] instanceof Menulinkaction) || (mactn = (Menulinkaction)ipc[i]).getMobile()) continue;
                if (StringUtils.isBlank((String)mactn.getMenuref())) {
                    this.logger.debug("menulinkaction.menuref is null, skip to add menu. " + mactn.getDescription());
                    continue;
                }
                this.addMenuContent(mactn, menuMap);
            }
        }
        return this.createBody(root);
    }

    protected MenuNode createMenuNode(Menubar menubar, Map<String, MenuNode> menuMap) {
        MenuNode mn = new MenuNode("");
        Menu[] menus = menubar.getMenu();
        if (menus == null) {
            return mn;
        }
        for (int i = 0; i < menus.length; ++i) {
            this.addMenuNode(mn, menus[i], menuMap);
        }
        return mn;
    }

    protected void addMenuNode(MenuNode parent, Menu menu, Map<String, MenuNode> menuMap) {
        if (menuMap.keySet().contains(menu.getId())) {
            this.logger.warn("found same menu id:" + menu.getId());
            return;
        }
        MenuNode mn = new MenuNode(menu.getTitle(), menu.getMenucolor(), menu.getMenulabelcolor(), menu.getMenuImgSrc(), menu.getMenuImgStyle(), menu.getMenuTooltip(), menu.getOrderAsInteger(), menu.getMenuIconClass());
        menuMap.put(menu.getId(), mn);
        parent.addMenuObject(mn);
        Object[] menus = menu.getMenu();
        if (ArrayUtils.isEmpty((Object[])menus)) {
            return;
        }
        for (int i = 0; i < menus.length; ++i) {
            this.addMenuNode(mn, (Menu)menus[i], menuMap);
        }
    }

    protected void addMenuContent(Action action, Map<String, MenuNode> menuMap) {
        String menuref = action.getMenuref();
        String desc = action.getMenutitle();
        if (StringUtils.isBlank((String)desc)) {
            desc = action.getDescription();
        }
        String menuurl = action.getMenuurl();
        int order = action.getMenuorder();
        String color = action.getMenucolor();
        String labelcolor = action.getMenulabelcolor();
        String imgSrc = action.getMenuImgSrc();
        String imgStyle = action.getMenuImgStyle();
        String tooltip = action.getMenuTooltip();
        String iconClass = action.getMenuIconClass();
        MenuNode node = menuMap.get(menuref);
        if (node == null) {
            this.logger.error("[Internal Error] Invalid menuref:" + menuref);
            return;
        }
        node.addMenuObject(new MenuContent(desc, menuurl, action, order, color, labelcolor, null, imgSrc, imgStyle, tooltip, iconClass));
    }

    protected void addMenuContent(Menulinkaction mactn, Map<String, MenuNode> menuMap) {
        String menuref = mactn.getMenuref();
        String desc = mactn.getDescription();
        if (StringUtils.isNotBlank((String)desc)) {
            desc = StringUtil.decodeStringFromXML((String)desc);
            desc = desc.replaceAll("&#10;", "\n");
        }
        String menuurl = mactn.getMenuurl();
        int order = mactn.getMenuorder();
        String color = mactn.getMenucolor();
        String labelcolor = mactn.getMenulabelcolor();
        String target = mactn.getTarget();
        String imgSrc = mactn.getMenuImgSrc();
        String imgStyle = mactn.getMenuImgStyle();
        String tooltip = mactn.getMenuTooltip();
        String iconClass = mactn.getMenuIconClass();
        MenuNode node = menuMap.get(menuref);
        if (node == null) {
            this.logger.error("[Internal Error] Invalid menuref:" + menuref);
            return;
        }
        node.addMenuObject(new MenuContent(desc, menuurl, mactn, order, color, labelcolor, target, imgSrc, imgStyle, tooltip, iconClass));
    }

    protected String createBody(MenuNode root) {
        StringBuilder sb = new StringBuilder();
        String enc = JavaSourceGenerator.getEncoding(this.project);
        sb.append("<?xml version=\"1.0\" encoding=\"").append(enc).append("\" ?>").append(CR);
        sb.append("<menubar>").append(CR);
        MenuObject[] menus = root.getAll();
        for (int i = 0; i < menus.length; ++i) {
            this.outputMenuObject(menus[i], "  ", sb);
        }
        sb.append("</menubar>").append(CR);
        return sb.toString();
    }

    protected void outputMenuObject(MenuObject mObj, String basetab, StringBuilder sb) {
        if (mObj instanceof MenuNode) {
            this.outputMenuObject((MenuNode)mObj, basetab, sb);
        } else if (mObj instanceof MenuContent) {
            this.outputMenuObject((MenuContent)mObj, basetab, sb);
        }
    }

    protected void outputMenuObject(MenuNode node, String basetab, StringBuilder sb) {
        List list;
        String rkey;
        sb.append(basetab).append("  ");
        sb.append("<menu");
        if (node.getColor() != null) {
            sb.append(" color=\"").append(node.getColor()).append("\"");
        }
        if (node.getLabelcolor() != null) {
            sb.append(" labelcolor=\"").append(node.getLabelcolor()).append("\"");
        }
        if (node.getOrder() != null) {
            sb.append(" order=\"").append(node.getOrder()).append("\"");
        }
        if (StringUtils.isNotBlank((String)node.getTooltip())) {
            rkey = JFCAppResourceGenerator.createMenuTooltipResourceKey(node.getTooltip());
            JFCAppResourceGenerator.put(rkey, node.getTooltip());
            sb.append(" tooltip=\"").append(rkey).append("\"");
        }
        if (StringUtils.isNotBlank((String)node.getIconClass())) {
            sb.append(" iconClass=\"").append(node.getIconClass()).append("\"");
        }
        sb.append(">").append(CR);
        if (node.getTitle() != null) {
            rkey = JFCAppResourceGenerator.createMenuTitleResourceKey(node.getTitle());
            JFCAppResourceGenerator.put(rkey, node.getTitle());
            sb.append(basetab).append("    ");
            sb.append("<title>").append(rkey).append("</title>").append(CR);
        }
        if (StringUtils.isNotBlank((String)node.getImgSrc())) {
            this.outputImg(node, basetab, sb);
        }
        MenuObject[] menus = node.getAll();
        TreeMap<Integer, ArrayList<MenuObject>> orderMenuMap = new TreeMap<Integer, ArrayList<MenuObject>>();
        for (MenuObject menu : menus) {
            list = (ArrayList<MenuObject>)orderMenuMap.get(menu.getOrder());
            if (list == null) {
                list = new ArrayList<MenuObject>();
                orderMenuMap.put(menu.getOrder(), (ArrayList<MenuObject>)list);
            }
            list.add(menu);
        }
        int minorder = 0;
        for (Map.Entry e : orderMenuMap.entrySet()) {
            int order = (Integer)e.getKey();
            list = (List)e.getValue();
            if (order > minorder) {
                minorder = order;
            }
            for (MenuObject obj : list) {
                obj.setOrder(minorder++);
            }
        }
        for (int i = 0; i < menus.length; ++i) {
            this.outputMenuObject(menus[i], basetab + "  ", sb);
        }
        sb.append(basetab).append("  ");
        sb.append("</menu>").append(CR).append(CR);
    }

    private void outputMenuObject(MenuContent mcon, String basetab, StringBuilder sb) {
        sb.append(basetab + "  ");
        sb.append("<item");
        if (mcon.getDescription() != null) {
            String did = null;
            if (mcon.getSource() instanceof Action) {
                did = JavaSourceGenerator.createProperId((Action)mcon.getSource());
            } else if (mcon.getSource() instanceof Menulinkaction) {
                did = "menulinkaction";
            } else {
                this.logger.error("[Internal Error] Not supported menu type." + mcon.toString());
            }
            String rkey = JFCAppResourceGenerator.createMenuDescriptionResourceKey(did, mcon.getDescription());
            JFCAppResourceGenerator.put(rkey, StringUtil.escapeStringForXML((String)mcon.getDescription()));
            sb.append(" desc=\"").append(rkey).append("\"");
        }
        if (mcon.getUrl() != null) {
            sb.append(" url=\"").append(StringUtil.escapeStringForXML((String)mcon.getUrl())).append("\"");
        }
        if (mcon.getSource() instanceof Action) {
            Action _action = (Action)mcon.getSource();
            String pagenum = "";
            if (_action.getWizard()) {
                pagenum = "1";
            }
            sb.append(" name=\"").append(JavaSourceGenerator.createProperId(_action)).append(pagenum).append("\"");
        }
        sb.append(" order=\"").append(mcon.getOrder()).append("\"");
        if (mcon.getColor() != null) {
            sb.append(" color=\"").append(mcon.getColor()).append("\"");
        }
        if (mcon.getLabelcolor() != null) {
            sb.append(" labelcolor=\"").append(mcon.getLabelcolor()).append("\"");
        }
        if (mcon.getTarget() != null) {
            sb.append(" target=\"").append(mcon.getTarget()).append("\"");
        }
        if (StringUtils.isNotBlank((String)mcon.getTooltip())) {
            String rkey = JFCAppResourceGenerator.createMenuTooltipResourceKey(mcon.getTooltip());
            JFCAppResourceGenerator.put(rkey, mcon.getTooltip());
            sb.append(" tooltip=\"").append(rkey).append("\"");
        }
        if (StringUtils.isNotBlank((String)mcon.getIconClass())) {
            sb.append(" iconClass=\"").append(mcon.getIconClass()).append("\"");
        }
        Permission permission = null;
        if (mcon.getSource() instanceof Action) {
            permission = AppSchemaUtil.getActionPermission((Action)mcon.getSource());
        } else if (mcon.getSource() instanceof Menulinkaction) {
            permission = ((Menulinkaction)mcon.getSource()).getPermission();
        }
        if (permission == null && StringUtils.isBlank((String)mcon.getImgSrc())) {
            sb.append("/>");
        } else {
            sb.append(">").append(CR);
            this.outputImg(mcon, basetab, sb);
            this.outputPermission(permission, basetab, sb);
            sb.append(basetab).append("  ");
            sb.append("</item>");
        }
        sb.append(CR);
    }

    private void outputPermission(Permission permission, String basetab, StringBuilder sb) {
        if (permission == null) {
            return;
        }
        sb.append(basetab).append("    ");
        sb.append("<permission name=\"").append(permission.getName()).append("\">").append(CR);
        sb.append(basetab).append("      ");
        sb.append("<action>");
        String menuaction = permission.getMenuaction();
        if (menuaction == null || menuaction.length() == 0) {
            menuaction = permission.getAction();
        }
        sb.append(menuaction);
        sb.append("</action>").append(CR);
        sb.append(basetab).append("    ");
        sb.append("</permission>").append(CR);
    }

    private void outputImg(MenuNode mnode, String basetab, StringBuilder sb) {
        if (StringUtils.isBlank((String)mnode.getImgSrc())) {
            return;
        }
        this.outputImg(mnode.getImgSrc(), mnode.getImgStyle(), basetab, sb);
    }

    private void outputImg(MenuContent mcon, String basetab, StringBuilder sb) {
        if (StringUtils.isBlank((String)mcon.getImgSrc())) {
            return;
        }
        this.outputImg(mcon.getImgSrc(), mcon.getImgStyle(), basetab, sb);
    }

    private void outputImg(String imgSrc, String imgStyle, String basetab, StringBuilder sb) {
        sb.append(basetab).append("    ");
        sb.append("<img src=\"").append(imgSrc).append("\"");
        if (StringUtils.isNotBlank((String)imgStyle)) {
            sb.append(" style=\"").append(imgStyle).append("\"");
        }
        sb.append("/>").append(CR);
    }

    class MenuContent
    implements MenuObject {
        String desc;
        String url;
        IProjectChoice source;
        Integer order;
        String color;
        String labelcolor;
        String target;
        String imgSrc;
        String imgStyle;
        String tooltip;
        String iconClass;

        MenuContent(String desc, String url, Action source, int order, String color, String labelcolor, String target, String imgSrc, String imgStyle, String tooltip, String iconClass) {
            this.init(desc, url, source, order, color, labelcolor, target, imgSrc, imgStyle, tooltip, iconClass);
        }

        MenuContent(String desc, String url, Menulinkaction source, int order, String color, String labelcolor, String target, String imgSrc, String imgStyle, String tooltip, String iconClass) {
            this.init(desc, url, source, order, color, labelcolor, target, imgSrc, imgStyle, tooltip, iconClass);
        }

        private void init(String desc, String url, IProjectChoice source, int order, String color, String labelcolor, String target, String imgSrc, String imgStyle, String tooltip, String iconClass) {
            this.desc = desc;
            this.url = url;
            this.source = source;
            this.order = order;
            this.color = color;
            this.labelcolor = labelcolor;
            this.target = target;
            this.imgSrc = imgSrc;
            this.imgStyle = imgStyle;
            this.tooltip = tooltip;
            this.iconClass = iconClass;
        }

        String getDescription() {
            return this.desc;
        }

        String getUrl() {
            return this.url;
        }

        IProjectChoice getSource() {
            return this.source;
        }

        @Override
        public Integer getOrder() {
            return this.order;
        }

        @Override
        public void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public String getColor() {
            return this.color;
        }

        @Override
        public String getLabelcolor() {
            return this.labelcolor;
        }

        String getTarget() {
            return this.target;
        }

        @Override
        public String getImgSrc() {
            return this.imgSrc;
        }

        @Override
        public String getImgStyle() {
            return this.imgStyle;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        public String toString() {
            String s = "MenuContent " + this.desc + " url:" + this.url;
            if (this.source instanceof Action) {
                Action a = (Action)this.source;
                s = s + " action:" + a.getId();
            } else {
                s = s + this.source.getClass().getName();
            }
            s = s + " order:" + this.order + " color:" + this.color + " labelcolor:" + this.labelcolor + " target:" + this.target;
            return s;
        }
    }

    class MenuNode
    implements MenuObject {
        String title;
        String color;
        String labelcolor;
        String imgSrc;
        String imgStyle;
        String tooltip;
        String iconClass;
        Integer order;
        List<MenuObject> list;

        MenuNode(String title) {
            this(title, null, null, null, null, null, null, null);
        }

        MenuNode(String title, String color, String labelcolor, String imgSrc, String imgStyle, String tooltip, Integer order, String iconClass) {
            this.title = title;
            this.color = color;
            this.labelcolor = labelcolor;
            this.imgSrc = imgSrc;
            this.imgStyle = imgStyle;
            this.tooltip = tooltip;
            this.order = order;
            this.iconClass = iconClass;
            this.list = new ArrayList<MenuObject>();
        }

        String getTitle() {
            return this.title;
        }

        @Override
        public String getColor() {
            return this.color;
        }

        @Override
        public String getLabelcolor() {
            return this.labelcolor;
        }

        @Override
        public String getImgSrc() {
            return this.imgSrc;
        }

        @Override
        public String getImgStyle() {
            return this.imgStyle;
        }

        @Override
        public String getTooltip() {
            return this.tooltip;
        }

        @Override
        public Integer getOrder() {
            return this.order;
        }

        public String getIconClass() {
            return this.iconClass;
        }

        @Override
        public void setOrder(Integer order) {
            this.order = order;
        }

        void addMenuObject(MenuObject mo) {
            this.list.add(mo);
        }

        MenuObject[] getAll() {
            return this.list.toArray(new MenuObject[0]);
        }

        public String toString() {
            return this.title + " color:" + this.color + " labelcolor:" + this.labelcolor + " order:" + this.order + " child:" + this.list.size();
        }
    }

    static interface MenuObject {
        public String getColor();

        public String getLabelcolor();

        public String getImgSrc();

        public String getImgStyle();

        public String getTooltip();

        public Integer getOrder();

        public void setOrder(Integer var1);
    }
}

