/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HTMLIndentProcessor;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaScriptManagerFactory;
import jp.jasminesoft.jfc.gen.JspBodyGenerator;
import jp.jasminesoft.jfc.gen.JspBodyGenerator_show;
import jp.jasminesoft.jfc.gen.XslElementNameManager;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MobileJspBodyGenerator
extends JspBodyGenerator {
    protected Logger logger = LogManager.getLogger((String)MobileJspBodyGenerator.class.getName());

    public MobileJspBodyGenerator(Project project, Action action, Presentation presentation, Model pmodel, String idref, Displaymodel displaymodel, boolean isOutputJSTL) {
        super(project, action, presentation, pmodel, idref, displaymodel, isOutputJSTL);
        this.displaymodel = displaymodel;
        this.pmodel = pmodel;
        this.idref = idref;
        this.isOutputJSTL = isOutputJSTL;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (action != null) {
            this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, action);
        } else if (idref != null) {
            this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, idref);
        }
        this.xslnman = XslElementNameManager.getInstance();
        this.hiddenlist = new ArrayList();
        this.isTilesFlag = false;
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        if (this.isOutputJSTL) {
            sb.append(this.gHeader1());
        }
        this.gBody(sb);
        this.gFinish(sb);
        HTMLIndentProcessor hpro = new HTMLIndentProcessor();
        if (this.tplman == null) {
            return hpro.process(sb.toString());
        }
        return hpro.process(sb.toString());
    }

    @Override
    protected void gBeginTable(StringBuilder sb, Map<String, Object> attrMap) {
        if (this.tplman != null) {
            return;
        }
        sb.append(this.comment("gBeginTable"));
        sb.append("<div data-dojo-type=\"dojox/mobile/RoundRect\">").append(CR);
    }

    @Override
    protected void gEndTable(StringBuilder sb) {
        if (this.tplman != null) {
            return;
        }
        sb.append(this.comment("gEndTable"));
        sb.append("</div>");
    }

    @Override
    protected void gTableTitle0(String title, StringBuilder sb, int colnum, String rkeyname) {
        if (StringUtils.isBlank((String)title)) {
            return;
        }
        String deftitlekey = this.gTableTitle0_resource(title, rkeyname);
        if (sb != null) {
            sb.append("<div").append(this.gAttrTag("class", "table_title")).append(">");
            sb.append(this.createRValueStatement(deftitlekey));
            sb.append("</div>");
        }
    }

    @Override
    protected void gActionLink0(StringBuilder sb, Link link) {
        PrimaryKey[] pkeys;
        IRNode node;
        String label;
        String laction;
        if (this.tplman == null) {
            sb.append(this.comment("gActionLink0"));
        }
        if ((laction = link.getAction()) == null) {
            laction = "";
        }
        if ((label = link.getLabel()) == null || label.length() == 0) {
            label = "Button";
        }
        Model smodel = null;
        if (this.pmodel != null && (node = this.pmodel.getIdrefAsIRNode()) != null && node instanceof Model && "list".equals((smodel = (Model)node).getType()) && (node = smodel.getIdrefAsIRNode()) != null && node instanceof Model) {
            smodel = (Model)node;
        }
        HashSet<String> hiddenSet = new HashSet<String>();
        if (link.getHidden() != null) {
            StringTokenizer st = new StringTokenizer(link.getHidden(), ", ");
            while (st.hasMoreTokens()) {
                hiddenSet.add(st.nextToken());
            }
        }
        if ((pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project)) != null) {
            for (int i = 0; i < pkeys.length; ++i) {
                PrimaryKey pkey = pkeys[i];
                hiddenSet.add(pkey.getName());
            }
        }
        String forward = link.getForward();
        String confirm = link.getConfirm();
        String rkey_confirm = null;
        if (forward != null && forward.startsWith("delete") && (confirm == null || confirm.length() == 0)) {
            rkey_confirm = "__jfc_common.confirm";
        }
        if (rkey_confirm == null) {
            rkey_confirm = this.createResourceKey(laction, confirm);
            JFCAppResourceGenerator.put(rkey_confirm, confirm);
        }
        if (forward != null && forward.length() > 0) {
            String submitcnt = null;
            submitcnt = confirm != null && confirm.length() > 0 && !StringUtil.isFullOf((String)confirm, (char)' ') ? "return doConfirm(this, '" + this.createRValueStatement(rkey_confirm) + "');" : "buttonOff(); return true;";
            if (!(forward.endsWith(".html") || forward.endsWith(".htm") || forward.endsWith(".jsp"))) {
                forward = forward + ".do";
            }
            sb.append("<form");
            sb.append(this.gAttrTag("data-dojo-type", "dijit/form/Form"));
            sb.append(this.gAttrTag("name", "Nav" + forward));
            sb.append(this.gAttrTag("action", forward));
            sb.append(this.gAttrTag("method", "post"));
            sb.append(this.gAttrTag("onSubmit", submitcnt));
            sb.append(" novalidate>");
            sb.append("<input");
            sb.append(this.gAttrTag("type", "hidden"));
            sb.append(this.gAttrTag("name", "SENDACTION"));
            sb.append("/>");
            sb.append("<input");
            sb.append(this.gAttrTag("type", "hidden"));
            sb.append(this.gAttrTag("name", "sessionId"));
            sb.append(this.gAttrTag("value", "<jfc:MD5Hash/>"));
            sb.append("/>");
            confirm = null;
        }
        for (Displayitem ditem : this.hiddenlist) {
            IModelChoice[] imc;
            String name = ditem.getName();
            Modelitem mitem = null;
            if (smodel != null && (imc = smodel.getContent()) != null) {
                int i;
                for (i = 0; !(i >= imc.length || imc[i] instanceof Modelitem && name.equals((mitem = (Modelitem)imc[i]).getName())); ++i) {
                }
                if (i >= imc.length) {
                    mitem = null;
                }
            }
            if (mitem == null) {
                Object[] o = new Object[]{this.action.getId(), name};
                this.logger.error(this.rman.getValue("value.null.hiddenlist", o));
            }
            sb.append("<input");
            sb.append(this.gAttrTag("type", "hidden"));
            sb.append(this.gAttrTag("name", name));
            sb.append(this.gAttrTag("value"));
            sb.append("<c:out value=\"${");
            sb.append(name);
            if (mitem != null && (mitem.getType().equals("masterref") || mitem.getType().equals("storeref"))) {
                sb.append("[0].id");
            }
            sb.append("}\"/>\"/>");
        }
        this.gActionLink0_inputfield(sb, laction, label, confirm, link);
        if (forward != null && forward.length() > 0) {
            sb.append("</form>");
        }
    }

    @Override
    protected void gActionLink0_inputfield(StringBuilder sb, String name, String label, String confirm, Link link) {
        sb.append("<input");
        sb.append(this.gAttrTag("type", "submit"));
        if (name != null && name.length() > 0) {
            StringBuilder code = new StringBuilder();
            code.append("this.form.SENDACTION.name='action_");
            code.append(name);
            code.append("';");
            if (confirm != null && confirm.length() > 0) {
                code.insert(0, "var ret = doConfirm(this, '" + confirm + "');if (ret) { ");
                code.append("this.form.submit(); } else return false;");
            }
            sb.append(this.gAttrTag("name", "btn" + name));
            sb.append(this.gAttrTag("onClick", code.toString()));
        }
        sb.append(this.gAttrTag("value", label));
        sb.append(">");
    }

    @Override
    protected void gBody(StringBuilder sb) {
        sb.append(this.comment("gBody"));
        this.gTemplate(sb);
    }

    @Override
    public boolean isMobile() {
        return true;
    }

    public String getStyle(Model pmodel, Displayitem ditem, String actionType, String position) {
        String stylePlace = ditem.getStylePlace();
        if ("all".equals(stylePlace)) {
            Object[] o = new Object[]{this.action.getId(), ditem.getName(), pmodel.getId()};
            this.logger.warn(this.rman.getValue("value.illegal.stylePlace.mobile", o));
            stylePlace = "around";
        }
        if (!"show".equals(actionType) && !"showList".equals(actionType) && "field".equals(position) && !"around".equals(stylePlace)) {
            return "";
        }
        if ("input".equals(position) && "around".equals(stylePlace)) {
            return "";
        }
        String style = JspBodyGenerator_show.createStyle(pmodel, ditem, actionType);
        if (StringUtils.isBlank((String)style)) {
            return "";
        }
        return style;
    }
}

