/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.appgen.component.ConditionModel;
import jp.jasminesoft.jfc.appgen.component.ListAction;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_showList;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Download;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Pbeanparam;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBeanGeneratorDownloadHibernate
extends ProcessBeanGenerator_showList {
    protected Logger logger = LogManager.getLogger((String)ProcessBeanGeneratorDownloadHibernate.class.getName());
    private static final String SeparatorVariableName = "SepChar";
    private Download download;
    private String sep;
    private static final String TEMPLETE_FILENAME_BASE = "template" + File.separator + "javasrc" + File.separator + "app" + File.separator;
    private static final String TEMPLATEFILE_CHAR_ENCODING = "UTF-8";

    public ProcessBeanGeneratorDownloadHibernate(Project project, String id, String type, Action action) {
        super(project, id, type, action);
        boolean typeSelectable;
        this.download = AppSchemaUtil.getDownload(action);
        if (this.download != null && !(typeSelectable = this.download.getTypeSelectable(false))) {
            String dtype = this.download.getType();
            this.sep = this.getSeparator(dtype);
        }
    }

    @Override
    public String getClassDeclarationSuffix() {
        Model model = this.getStoreModel();
        String classname = AppSchemaUtil.getClassname(model);
        StoreModel storeModel = new StoreModel(model);
        String pkeyclassname = storeModel.getPrimarykey().getClassName();
        return " extends DbDownloadBaseProcessBean<" + classname + ", " + pkeyclassname + ">";
    }

    @Override
    public String getClassExplanation() {
        return rman.getValue("pbean.comment.download", this.__id);
    }

    @Override
    public String[] getDefaultImport() {
        String[] defaultImport = super.getDefaultImport();
        int len = defaultImport.length;
        String[] appendImports = new String[]{"java.io.*", "java.util.*", "java.sql.Connection", "jp.jasminesoft.jfc.app.DbDownloadBaseProcessBean", "jp.jasminesoft.jfc.app.EntityHelper", "jp.jasminesoft.jfc.dao.CriteriaConverter", "jp.jasminesoft.jfc.dao.FinderContext", "jp.jasminesoft.jfc.dao.IScroller", "jp.jasminesoft.jfc.dao.ReadOnlyScroller", "jp.jasminesoft.jfc.dao.SortKey", "jp.jasminesoft.jfc.hibernate.DetachedCriteria", "jp.jasminesoft.jfc.service.JFCEntityService", "org.springframework.beans.factory.annotation.Autowired", "org.springframework.beans.factory.annotation.Qualifier"};
        int appendImportsLength = appendImports.length;
        String[] newDefaultImport = new String[len + appendImportsLength];
        System.arraycopy(defaultImport, 0, newDefaultImport, 0, len);
        for (int i = 0; i < appendImportsLength; ++i) {
            newDefaultImport[len + i] = appendImports[i];
        }
        return newDefaultImport;
    }

    @Override
    protected String gVariableDefinition() {
        String s = super.gVariableDefinition();
        StringBuilder sb = new StringBuilder(s);
        sb.append("    ");
        sb.append("public static final String CR = ");
        sb.append("System.getProperty(\"line.separator\");");
        sb.append(CR);
        if (this.sep != null) {
            sb.append("    ");
            sb.append("public static final char SepChar = '" + this.sep + "';");
            sb.append(CR);
        }
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String getInitializeCodeInConstructor() {
        if (this.download.getDisableCsvDataHeader()) {
            StringBuilder sb = new StringBuilder();
            sb.append("        ");
            sb.append("setDisableCsvDataHeader(true);");
            sb.append(CR);
            return sb.toString();
        }
        return null;
    }

    @Override
    protected String gRunMethod0(Model model) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        Model pmodel = AppSchemaUtil.getModel(this.project, id, "presentation");
        if (pmodel == null) {
            this.logger.error(rman.getValue("value.null.model.presentation", id));
            return sb.toString();
        }
        List<Modelitem> pmitems = AppSchemaUtil.getMultipleCsvOutputableModelitem(model, pmodel);
        boolean isModelitemCsv = pmitems.size() > 0;
        Map<String, String> templateContentsMap = this.createTemplateContentMap(model, pmodel);
        sb.append(this.gRunMethod1(model, pmodel, isModelitemCsv, templateContentsMap));
        sb.append(CR);
        sb.append(this.gGetCsvEncoding(templateContentsMap));
        sb.append(CR);
        if (isModelitemCsv) {
            sb.append(this.gOutputModeEnum(model, pmodel, pmitems));
            sb.append(CR);
            sb.append(this.gGetOutputModeMethod(model, pmodel, pmitems));
            sb.append(CR);
            sb.append(this.gOutputModelitemDataMethod(templateContentsMap));
            sb.append(CR);
            sb.append(this.gOutputMainDataMethod(templateContentsMap));
            sb.append(CR);
        }
        sb.append(this.gOutputAllDataMethod(templateContentsMap));
        sb.append(CR);
        sb.append(this.gExecuteQueryResults(templateContentsMap));
        sb.append(CR);
        return sb.toString();
    }

    private String gRunMethod1(Model model, Model pmodel, boolean isModelitemCsv, Map<String, String> map) {
        map = new HashMap<String, String>(map);
        if (isModelitemCsv) {
            map.put("isModelitemCsv", "true");
            map.put("isNotModelitemCsv", "");
        } else {
            map.put("isModelitemCsv", "");
            map.put("isNotModelitemCsv", "true");
        }
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(this.action);
        map.put("getConditionModel", this.gSetparam4pbean(conditionlist, true, ""));
        StringBuilder sb = new StringBuilder();
        this.gCreateOutputfilename(sb, "        ", isModelitemCsv, model);
        map.put("createOutputfilename", sb.toString());
        sb = new StringBuilder();
        this.gCreateDbDownloadProcessor(sb, "            ");
        map.put("createDbDownloadProcessor", sb.toString());
        return this.gTempleteCode(map, "DownloadProcessBean_run.vm");
    }

    @Override
    protected void gSetParam4pbean_createConditionObject(String tab, StringBuilder sb, Model _model, Model _rmodel) {
        String cond_classname = AppSchemaUtil.getClassname(_model);
        sb.append(tab);
        sb.append("if (getParameter(\"output_local\") != null && cond == null) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("cond = new ");
        sb.append(cond_classname);
        sb.append("();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(_model, this.project));
        sb.append(".initialize(cond ,p);");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    protected String gGetCsvEncoding(Map<String, String> map) {
        return this.gTempleteCode(map, "DownloadProcessBean_getCsvEncoding.vm");
    }

    private void gCreateOutputfilename(StringBuilder sb, String tab, boolean isModelitemCsv, Model model) {
        Pbeanparam[] params;
        String fileext = "csv";
        boolean typeSelectable = false;
        if (this.download != null) {
            String ext = this.download.getExt();
            fileext = ext == null || ext.length() == 0 ? this.download.getType() : ext;
            typeSelectable = this.download.getTypeSelectable();
        }
        String outputfilename = null;
        for (Pbeanparam param : params = AppSchemaUtil.getPbeanparam(this.action)) {
            if (!"filename".equals(param.getKey())) continue;
            outputfilename = StringUtil.convertJavaString((String)param.getValue());
        }
        if (typeSelectable) {
            sb.append(tab);
            sb.append("String fileext = (String)getParameter(\"fileext\");");
            sb.append(CR);
            sb.append(tab);
            sb.append("if (fileext == null || !(");
            sb.append("\"csv\".equals(fileext) || ");
            sb.append("\"tsv\".equals(fileext) || ");
            sb.append("\"xls\".equals(fileext) || ");
            sb.append("\"xlsx\".equals(fileext)");
            sb.append(")) {");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("fileext = \"" + fileext + "\";");
            sb.append(CR);
            sb.append(tab);
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append(tab);
            sb.append("final String fileext = \"" + fileext + "\";");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("String outfilename = ");
        if (StringUtils.isNotBlank((String)outputfilename)) {
            String dotfileext = "." + fileext;
            if (outputfilename.endsWith(dotfileext)) {
                outputfilename = outputfilename.substring(0, outputfilename.length() - dotfileext.length());
            }
            sb.append("\"");
            sb.append(outputfilename);
            sb.append(".\"+fileext;");
            sb.append(CR);
            if (outputfilename.indexOf("${") >= 0) {
                Conditionlist conditionlist = AppSchemaUtil.getConditionlist(this.action);
                Model cond_p_model = AppSchemaUtil.getConditionlistParameterModel(conditionlist);
                sb.append(tab);
                sb.append(AppSchemaUtil.getPackagename(cond_p_model, this.project));
                sb.append(AppSchemaUtil.getClassname(cond_p_model));
                sb.append(" cond_p = ");
                sb.append(AppSchemaUtil.getHelperClassname4Dicon(cond_p_model, this.project));
                sb.append(".s2p(getConditionModel(true), p, ");
                sb.append(AppSchemaUtil.getHelperClassname(cond_p_model, this.project));
                sb.append(".SHOW);");
                sb.append(CR);
                sb.append(tab);
                sb.append("Map _map = new jp.jasminesoft.jfc.app.ReplaceMap();");
                sb.append(CR);
                sb.append(tab);
                sb.append("_map.putAll(");
                sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(model, this.project));
                sb.append(".get(cond_p, p));");
                sb.append(CR);
                sb.append(tab);
                sb.append("outfilename = StringUtil.replaceFilename(outfilename, _map);").append(CR);
            }
        } else if (isModelitemCsv) {
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("FileUtil.createTempFilename(username+");
            sb.append("\"_data_\"+outputmode, fileext);");
        } else {
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("FileUtil.createTempFilename(username+");
            sb.append("\"_data_All\", fileext);");
        }
        sb.append(CR);
    }

    private void gCreateDbDownloadProcessor(StringBuilder sb, String tab) {
        String dtype = null;
        boolean typeSelectable = false;
        String repval = null;
        if (this.download != null) {
            dtype = this.download.getType();
            typeSelectable = this.download.getTypeSelectable();
            repval = this.download.getCsvquot();
        }
        if (!("csv".equals(dtype) || "tsv".equals(dtype) || "xls".equals(dtype) || "xlsx".equals(dtype))) {
            dtype = null;
        }
        if (typeSelectable) {
            sb.append(tab);
            sb.append("if (\"csv\".equals(fileext)) {");
            sb.append(CR);
            this.gCreateDbDownloadProcessorWithoutSepval(sb, tab + "    ", "csv", repval);
            sb.append(tab);
            sb.append("} else if (\"tsv\".equals(fileext)) {");
            sb.append(CR);
            this.gCreateDbDownloadProcessorWithoutSepval(sb, tab + "    ", "tsv", repval);
            sb.append(tab);
            sb.append("} else if (\"xls\".equals(fileext)) {");
            sb.append(CR);
            this.gCreateDbDownloadProcessorWithoutSepval(sb, tab + "    ", "xls", null);
            sb.append(tab);
            sb.append("} else if (\"xlsx\".equals(fileext)) {");
            sb.append(CR);
            this.gCreateDbDownloadProcessorWithoutSepval(sb, tab + "    ", "xlsx", null);
            sb.append(tab);
            sb.append("} else {");
            sb.append(CR);
            this.gCreateDbDownloadProcessorWithoutSepval(sb, tab + "    ", "csv", repval);
            sb.append(tab);
            sb.append("}");
            sb.append(CR);
        } else {
            String sepval = null;
            if (this.sep != null) {
                sepval = SeparatorVariableName;
            }
            this.gCreateDbDownloadProcessor(sb, tab, dtype, sepval, repval);
        }
    }

    private void gCreateDbDownloadProcessorWithoutSepval(StringBuilder sb, String tab, String dtype, String repval) {
        String sepval = this.getSeparator(dtype);
        if (sepval != null) {
            sepval = "'" + sepval + "'";
        }
        this.gCreateDbDownloadProcessor(sb, tab, dtype, sepval, repval);
    }

    private void gCreateDbDownloadProcessor(StringBuilder sb, String tab, String dtype, String sepval, String repval) {
        if (dtype == null || "csv".equals(dtype) || "tsv".equals(dtype)) {
            sb.append(tab);
            sb.append("out = new DbDownloadProcessorImpl_Csv(p, \"" + this.getStoreModelId() + "\", ostream, enc");
            if (sepval != null) {
                sb.append(", " + sepval);
            } else if (repval != null) {
                sb.append(", CSVUtil.DefaultSepChar");
            }
            if (repval != null) {
                if ("double-quotation".equals(repval)) {
                    sb.append(", '\\\"'");
                } else if ("empty".equals(repval)) {
                    sb.append(", '\\u0000'");
                }
            }
            sb.append(");");
            sb.append(CR);
        } else if ("xls".equals(dtype)) {
            sb.append(tab);
            sb.append("out = new DbDownloadProcessorImpl_Xls(ostream);");
            sb.append(CR);
            sb.append(tab);
            sb.append("((DbDownloadProcessorImpl_Xls)out).setSheetName(outfilename);");
            sb.append(CR);
        } else if ("xlsx".equals(dtype)) {
            sb.append(tab);
            sb.append("out = new DbDownloadProcessorImpl_Xlsx(ostream);");
            sb.append(CR);
            sb.append(tab);
            sb.append("((DbDownloadProcessorImpl_Xlsx)out).setSheetName(outfilename);");
            sb.append(CR);
        }
    }

    private String getSeparator(String dtype) {
        if (dtype == null) {
            return null;
        }
        if ("csv".equals(dtype)) {
            return ",";
        }
        if ("tsv".equals(dtype)) {
            return "\\t";
        }
        return null;
    }

    private String gOutputModeEnum(Model model, Model pmodel, List<Modelitem> pmitems) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("protected enum OutputMode {");
        sb.append(CR);
        sb.append("        ");
        sb.append("All");
        if (pmitems.size() > 0) {
            sb.append(",");
            sb.append(CR);
            sb.append("        ");
            sb.append("Main");
        }
        for (Modelitem pmitem : pmitems) {
            String mitemname = pmitem.getName();
            sb.append(",");
            sb.append(CR);
            sb.append("        ");
            sb.append("Modelitem_" + mitemname + "(\"" + mitemname + "\", " + pmitem.getCsvOutput() + ")");
        }
        sb.append(";");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("private String modelitemname;");
        sb.append(CR);
        sb.append("        ");
        sb.append("private boolean csvoutput;");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("OutputMode() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("OutputMode(String modelitemname, boolean csvoutput) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("this.modelitemname = modelitemname;");
        sb.append(CR);
        sb.append("            ");
        sb.append("this.csvoutput = csvoutput;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean isModelitem() {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return (modelitemname != null);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("String getModelitemName() {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return modelitemname;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("boolean getCsvOutput() {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return csvoutput;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gGetOutputModeMethod(Model model, Model pmodel, List<Modelitem> pmitems) {
        boolean isAllNotCsvOutput = true;
        for (Modelitem pmitem : pmitems) {
            if (!pmitem.getCsvOutput()) continue;
            isAllNotCsvOutput = false;
            break;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ");
        sb.append("@Override");
        sb.append(CR);
        sb.append("    ");
        sb.append("protected String getOutputModeAsString(boolean getallmodelitem) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return getOutputMode(getallmodelitem).toString();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("protected OutputMode getOutputMode(boolean getallmodelitem) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return getOutputMode((String) getParameter(\"outputmode\"), getallmodelitem);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("protected OutputMode getOutputMode(String soutputmode, boolean getallmodelitem) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (soutputmode == null) {");
        sb.append(CR);
        if (isAllNotCsvOutput) {
            sb.append("            ");
            sb.append("if (getallmodelitem) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("return OutputMode.All;");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("return OutputMode.Main;");
            sb.append(CR);
        } else {
            sb.append("            ");
            sb.append("return OutputMode.All;");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return OutputMode.valueOf(soutputmode);");
        sb.append(CR);
        sb.append("        ");
        sb.append("} catch (IllegalArgumentException e) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("return OutputMode.All;");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    private String gOutputModelitemDataMethod(Map<String, String> map) {
        return this.gTempleteCode(map, "DownloadProcessBean_outputModelitemData.vm");
    }

    private String gOutputMainDataMethod(Map<String, String> map) {
        return this.gTempleteCode(map, "DownloadProcessBean_outputMainData.vm");
    }

    private String gOutputAllDataMethod(Map<String, String> map) {
        return this.gTempleteCode(map, "DownloadProcessBean_outputAllData.vm");
    }

    private String gExecuteQueryResults(Map<String, String> map) {
        return this.gTempleteCode(map, "DownloadProcessBean_executeQueryResults.vm");
    }

    private Map<String, String> createTemplateContentMap(Model model, Model pmodel) {
        String id = model.getId();
        String packagename = AppSchemaUtil.getPackagename(model, this.project);
        String classname = AppSchemaUtil.getClassname(model);
        StoreModel storeModel = new StoreModel(model);
        String pkeyclassname = storeModel.getPrimarykey().getClassName();
        Model cmodel = AppSchemaUtil.getConditionlistIdrefModel(AppSchemaUtil.getConditionlist(this.action));
        ConditionModel conditionModel = new ConditionModel(cmodel);
        String pid = pmodel.getId();
        String ppackagename = AppSchemaUtil.getPackagename(pmodel, this.project);
        String pclassname = AppSchemaUtil.getClassname(pmodel);
        String getHelper = AppSchemaUtil.getHelperClassname4Dicon(model, this.project, "Helper");
        String getPCSVHelper = AppSchemaUtil.getHelperClassname4Dicon(pmodel, this.project, "CSVHelper");
        String getPHelper = AppSchemaUtil.getHelperClassname4Dicon(pmodel, this.project, "Helper");
        String phelperclassname = AppSchemaUtil.getHelperClassname(pmodel);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("packagename", packagename);
        map.put("classname", classname);
        map.put("conditionClassname", conditionModel.getClassName());
        map.put("pkeyclassname", pkeyclassname);
        map.put("pid", pid);
        map.put("ppackagename", ppackagename);
        map.put("pclassname", pclassname);
        map.put("getHelper", getHelper);
        map.put("getPCSVHelper", getPCSVHelper);
        map.put("getPHelper", getPHelper);
        map.put("phelperclassname", phelperclassname);
        map.put("entityServiceClassname", storeModel.getEntityServiceClassName());
        map.put("criteriaConverterClassname", new ListAction(this.action).getCriteriaConverterName());
        if (this.sep == null) {
            map.put("sep", "");
        } else {
            map.put("sep", this.sep);
        }
        if (this.isCreateCsvStringHeaderCount(model, pmodel)) {
            map.put("isCreateCsvStringHeaderCount", "true");
            map.put("isNotCreateCsvStringHeaderCount", "");
        } else {
            map.put("isCreateCsvStringHeaderCount", "");
            map.put("isNotCreateCsvStringHeaderCount", "true");
        }
        String enc = this.download.getCsvEncoding();
        String enc_code = StringUtils.isBlank((String)enc) ? "null" : "\"" + this.download.getCsvEncoding() + "\"";
        map.put("csv_encoding", enc_code);
        return map;
    }

    private String gTempleteCode(Map<String, String> map, String templateFilename) {
        StringBuilder sb = new StringBuilder();
        String templatefilename = TEMPLETE_FILENAME_BASE + templateFilename;
        FileTemplateManager tplman = new FileTemplateManager(templatefilename, TEMPLATEFILE_CHAR_ENCODING);
        tplman.addContentMap(map);
        tplman.setUseCommandFeature(true);
        sb.append(tplman.getResult());
        return sb.toString();
    }

    protected boolean isCreateCsvStringHeaderCount(Model smodel, Model pmodel) {
        IModelChoice[] imc = pmodel.getContent();
        if (imc == null || imc.length == 0) {
            return false;
        }
        IModelChoice[] simc = smodel.getContent();
        if (simc == null || simc.length == 0) {
            return false;
        }
        for (int i = 0; i < simc.length; ++i) {
            Modelitem mitem;
            if (!(simc[i] instanceof Modelitem) || !(mitem = (Modelitem)simc[i]).getMultiple()) continue;
            Modelitem pitem = null;
            if (imc != null) {
                for (int j = 0; !(j >= imc.length || imc[j] instanceof Modelitem && (pitem = (Modelitem)imc[j]).getName().equals(mitem.getName())); ++j) {
                }
            }
            return true;
        }
        return false;
    }
}

