/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator_update_base2;
import jp.jasminesoft.jfc.gen.TablenameGenerator;
import jp.jasminesoft.jfc.gen.TextSearchUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Transaction;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBeanGenerator_insert
extends ProcessBeanGenerator_update_base2 {
    public static final String RunUpdateMethodName = "runInsert";
    protected String[] defaultImportStatement = new String[]{"java.security.Permission", "java.sql.SQLException", "java.text.SimpleDateFormat", "java.util.*", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", "jp.jasminesoft.jfc.*", "jp.jasminesoft.jfc.app.HibernateUtil", "jp.jasminesoft.util.*"};
    protected String[] defaultHibernateImportStatement = new String[]{"java.util.*", "java.security.Permission", "java.text.SimpleDateFormat", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager", "org.hibernate.Session", "org.hibernate.Query", "org.hibernate.Transaction", "jp.jasminesoft.jfc.*", "jp.jasminesoft.jfc.app.HibernateUtil", "jp.jasminesoft.util.*"};
    protected Logger logger = LogManager.getLogger((String)ProcessBeanGenerator_insert.class.getName());
    private StringBuilder otherMethodBuf;

    public ProcessBeanGenerator_insert(Project project, String id, String type, Action action) {
        super(project, id, type, action);
    }

    @Override
    public String getClassExplanation() {
        return rman.getValue("pbean.comment.insertobject", this.__id);
    }

    @Override
    public String[] getDefaultImport() {
        if (this.storagetype == 5) {
            return this.defaultHibernateImportStatement;
        }
        return this.defaultImportStatement;
    }

    @Override
    protected void textSearchImportSet(Set<String> importSet) {
        if (!this.isTextSearch()) {
            return;
        }
        importSet.add("javax.servlet.http.HttpSession");
        importSet.add("jp.jasminesoft.jfc.textsearch.*");
        importSet.add("jp.jasminesoft.jfc.textsearch.app.*");
    }

    @Override
    protected boolean isTextSearch() {
        return TextSearchUtil.isTextsearchNecessary4(this.project, this.getStoreModel());
    }

    @Override
    protected String gRunMethod0(Model model) {
        String code;
        boolean isTransactionSupport = this.checkTransactionSupport();
        Map<Transaction, Modelitem> transactionMap = this.createTransactionMap(model);
        int size = transactionMap.size();
        if (isTransactionSupport && size == 0) {
            this.logger.warn(rman.getValue("pbean.illegal.transaction.none"));
            isTransactionSupport = false;
        }
        StringBuilder sb = new StringBuilder();
        this.otherMethodBuf = new StringBuilder();
        String tablename = TablenameGenerator.createTableVariableName(model);
        sb.append(CommentGenerator.gComment(rman.getValue("pbean.comment.dopbean"), null, rman.getValue("pbean.comment.dopbean.reterrormsg")));
        JavaSourceGenerator.putAnnotation(sb, "@Override", "    ");
        sb.append("    ");
        sb.append("public Object run() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("StringBuilder errmsg = new StringBuilder();");
        sb.append(CR);
        sb.append(CR);
        if (isTransactionSupport) {
            code = this.gRunMethodCode_GetParameter(model);
            if (code != null) {
                sb.append(code);
            }
            this.gRunMethod4Transaction(model, transactionMap, sb);
        }
        if ((code = this.gRunMethodCode_GetParameter(model)) != null) {
            sb.append(code);
        }
        List<Model> argList = this.createTransactionList(model, transactionMap, sb);
        Map<String, Set<Modelitem>> copyMap = AppSchemaUtil.createRefTargetItemWithRelatedItemMapWithStoreRefmodel(model, this.project);
        boolean isHibernate = false;
        if (tablename != null && tablename.length() > 0) {
            String storage = model.getStorage();
            int storagetype = AppSchemaUtil.getStorageType(storage);
            if (storagetype == 5) {
                sb.append(this.gRunMethod0_Hibernate(model, copyMap, isTransactionSupport ? argList : null));
                isHibernate = true;
            } else {
                sb.append(this.gRunMethod0_Relaxer(model, copyMap));
            }
        } else {
            sb.append(this.gRunMethod0_Empty(model));
        }
        sb.append("        ");
        sb.append("return errmsg.toString();");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        if (isHibernate) {
            sb.append(this.gRunUpdateMethod_Hibernate(model, null, copyMap, this.otherMethodBuf));
            sb.append(CR);
        }
        sb.append(this.otherMethodBuf.toString());
        if (isTransactionSupport) {
            StringBuilder sb2 = new StringBuilder();
            StringBuilder sb3 = new StringBuilder();
            sb.append("    ");
            sb.append("public String do_transaction(");
            for (int i = 0; i < argList.size(); ++i) {
                Model _rmodel = argList.get(i);
                String _id = _rmodel.getId();
                String _classname = AppSchemaUtil.getClassname(_rmodel);
                sb.append(_classname);
                sb.append(" ");
                sb.append(_id);
                sb2.append("\"").append(_id).append("\"");
                if (i < argList.size() - 1) {
                    sb.append(", ");
                    sb2.append(", ");
                }
                sb3.append("        ").append("p.request.setAttribute(\"").append(_id).append("\", ").append(_id).append(");").append(CR);
            }
            sb.append(", org.hibernate.Session _session, ActionParameter p) {");
            sb.append(CR);
            sb.append(sb3.toString());
            sb.append("        ");
            sb.append("p.request.setAttribute(\"session\", _session);").append(CR);
            sb2.append(", \"session\"");
            sb.append("        ");
            sb.append("return new ScriptCodeRunner(").append((CharSequence)sb2);
            sb.append(").process(");
            if ("copy".equals(this.action.getType())) {
                Action _insertAction = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "insert");
                if (_insertAction != null) {
                    String _classname = AppSchemaUtil.createProcessBeanName(this.__id, "insert", _insertAction, this.project, true);
                    _classname = _classname.substring(_classname.lastIndexOf(".") + 1);
                    sb.append("\"").append(_classname).append("\"");
                } else {
                    sb.append("this.getClass().getName()");
                }
            } else {
                sb.append("this.getClass().getName()");
            }
            sb.append(", \"do_transaction\", p);");
            sb.append(CR);
            sb.append("    ");
            sb.append("}");
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gRunMethod0_Relaxer(Model model, Map<String, Set<Modelitem>> copyMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gRunMethodCode_GetIsCommit(model));
        sb.append(CR);
        sb.append("        ");
        sb.append(this.gCreateTableObjectCode1(model));
        sb.append(CR);
        sb.append(this.gRunMethodCode_updateRelatedItem_Init(model, copyMap));
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_CallBeforeMethod(model));
        sb.append(this.gCreateTableObjectCode2(model));
        sb.append("            ");
        sb.append("TableConfigManager.getInstance().configTableObject(table);");
        sb.append(CR);
        sb.append("            ");
        sb.append("table.insert(");
        sb.append(this.getModelVariableName(model));
        sb.append(");");
        sb.append(CR);
        sb.append(CR);
        if (ProcessBeanGenerator_insert.isUseUpdateRelatedItem(model, copyMap)) {
            sb.append("            ");
            sb.append("// " + rman.getValue("pbean.comment.notsupport.updaterelateditem"));
            sb.append(CR);
            sb.append(CR);
            this.logger.warn(rman.getValue("pbean.comment.notsupport.updaterelateditem") + " modelid:" + model.getId());
        }
        sb.append("            ");
        sb.append("if (isCommit.booleanValue())");
        sb.append(CR);
        sb.append("                ");
        sb.append("table.commit();");
        sb.append(CR);
        sb.append(this.gUseCacheManager("            "));
        sb.append(this.gRunMethodCode_ClearCache(model, copyMap));
        sb.append("        ");
        sb.append("} catch (SQLException e) {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_CatchException(model, null));
        sb.append("        ");
        sb.append("} finally {");
        sb.append(CR);
        if (this.isCloseConintConnectionObjectForUnmodified()) {
            sb.append("            ");
            sb.append("if (table != null && isCommit.booleanValue()) {");
            sb.append(CR);
            sb.append("                ");
            sb.append("try {");
            sb.append(CR);
            sb.append("                    ");
            sb.append("table.close();");
            sb.append(CR);
            sb.append("                ");
            sb.append("} catch (SQLException e) {");
            sb.append(CR);
            sb.append("                    ");
            sb.append("logger.warn(\"failed to close conint.\", e);");
            sb.append(CR);
            sb.append("                ");
            sb.append("}");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(this.gRunMethodCode_Finally(model, null));
        sb.append(this.gRunMethodCode_updateRelatedItem_ReleaseLockObject(model, copyMap));
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gRunMethod0_Hibernate(Model model, Map<String, Set<Modelitem>> copyMap, List<Model> transactionList) {
        StringBuilder sb = new StringBuilder();
        if (!this.checkTransactionSupport()) {
            sb.append("        ");
            String sessionFactoryBeanId = new StoreModel(model).sessionFactoryBeanId();
            if (!"sessionFactory".equals(sessionFactoryBeanId)) {
                sb.append("org.hibernate.Session session");
                sb.append(CR);
                sb.append("                ");
                sb.append("= HibernateUtil.openSession(\"");
                sb.append(sessionFactoryBeanId);
                sb.append("\", p);");
            } else {
                sb.append("org.hibernate.Session session = HibernateUtil.openSession();");
            }
            sb.append(CR);
            sb.append("        ");
            sb.append("Transaction tx = session.beginTransaction();");
            sb.append(CR);
        }
        sb.append(this.gRunMethodCode_updateRelatedItem_Init(model, copyMap));
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        if (transactionList != null) {
            int size = transactionList.size();
            for (int i = 1; i < size; ++i) {
                Model rmodel = transactionList.get(i);
                Action raction = AppSchemaUtil.getActionByModelIdAndType(this.project, rmodel.getId(), "update");
                sb.append("            ");
                sb.append("// " + rman.getValue("pbean.comment.updateobject", rmodel.getId()));
                sb.append(CR);
                sb.append("            ");
                sb.append("if (" + this.getModelVariableName(rmodel) + " != null) {");
                sb.append(CR);
                if (raction != null && raction.getBeforeUpdateMethod()) {
                    sb.append("                ");
                    sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
                    sb.append(".beforeUpdate(");
                    sb.append(this.getModelVariableName(rmodel));
                    sb.append(" ,p");
                    boolean b = AppSchemaUtil.getHelperIsAdmin(raction);
                    if (b) {
                        sb.append(", true);");
                    } else {
                        sb.append(");");
                    }
                    sb.append(CR);
                }
                sb.append("                ");
                sb.append("session.update(" + this.getModelVariableName(rmodel) + ");");
                sb.append(CR);
                sb.append("            ");
                sb.append("}");
                sb.append(CR);
            }
        }
        sb.append(this.gUseCacheManager("            "));
        String mtab = "";
        if (this.checkTransactionContainerSupprt()) {
            sb.append("            ");
            sb.append("if (finalFlag) {").append(CR);
            mtab = "    ";
        }
        String mid = this.getModelVariableName(model);
        sb.append("            " + mtab);
        sb.append("String runUpdateMsg = " + this.getRunUpdateMethodName() + "(session, ");
        if (ProcessBeanGenerator_insert.isUseUpdateRelatedItem(model, copyMap)) {
            sb.append("lockobjects, ");
        } else {
            sb.append("null, ");
        }
        sb.append(mid);
        sb.append(");");
        sb.append(CR);
        sb.append("            " + mtab);
        sb.append("if (runUpdateMsg != null && runUpdateMsg.length() > 0) {");
        sb.append(CR);
        sb.append("                " + mtab);
        sb.append("errmsg.append(runUpdateMsg);");
        sb.append(CR);
        sb.append("                " + mtab);
        sb.append("return errmsg.toString();");
        sb.append(CR);
        sb.append("            " + mtab);
        sb.append("}");
        sb.append(CR);
        if (!this.checkTransactionSupport()) {
            sb.append("            " + mtab);
            sb.append("tx.commit();");
            sb.append(CR);
        }
        sb.append(this.gRunMethodCode_ClearCache(model, copyMap));
        if (this.checkTransactionContainerSupprt()) {
            sb.append("            ");
            sb.append("}").append(CR);
        }
        if (transactionList != null) {
            int size = transactionList.size();
            for (int i = 1; i < size; ++i) {
                Model rmodel = transactionList.get(i);
                sb.append("            ");
                sb.append("cman.clear");
                sb.append(AppSchemaUtil.getClassname(rmodel));
                sb.append("_update");
                sb.append("(");
                sb.append("_" + rmodel.getId());
                sb.append(");");
                sb.append(CR);
            }
        }
        sb.append("        ");
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_CatchException(model, null));
        sb.append("        ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_Finally(model, null));
        sb.append(CR);
        sb.append(this.gRunMethodCode_updateRelatedItem_ReleaseLockObject(model, copyMap));
        if (!this.checkTransactionSupport()) {
            sb.append("            ");
            sb.append("// " + rman.getValue("pbean.comment.closesession"));
            sb.append(CR);
            sb.append("            ");
            sb.append("session.close();");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gRunMethod0_Empty(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gRunMethodCode_GetIsCommit(model));
        sb.append(CR);
        sb.append("        ");
        sb.append("try {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_CallBeforeMethod(model));
        sb.append("            ");
        sb.append("//");
        sb.append(CR);
        sb.append("            ");
        sb.append("// " + rman.getValue("pbean.comment.logiccode"));
        sb.append(CR);
        sb.append("            ");
        sb.append("//");
        sb.append(CR);
        sb.append("        ");
        sb.append("} catch (SQLException e) {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_CatchException(model, null));
        sb.append("        ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(this.gRunMethodCode_Finally(model, null));
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    protected String gRunMethodCode_GetIsCommit(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        sb.append("Boolean isCommit = (Boolean)getParameter(\"isCommit\");");
        sb.append(CR);
        sb.append("        ");
        sb.append("if (isCommit == null)");
        sb.append(CR);
        sb.append("            ");
        sb.append("isCommit = Boolean.TRUE;");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String getRunUpdateMethodName() {
        return RunUpdateMethodName;
    }

    @Override
    protected String gRunMethodCode_CallBeforeMethod(Model model) {
        StringBuilder sb = new StringBuilder();
        if (this.action != null && this.action.getBeforeInsertMethod()) {
            sb.append("            ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".beforeInsert(");
            sb.append(this.getModelVariableName(model));
            sb.append(" ,p);");
            sb.append(CR);
        }
        return sb.toString();
    }

    @Override
    protected String gRunMethodCode_ClearCache(Model model, Map<String, Set<Modelitem>> copyMap) {
        StringBuilder sb = new StringBuilder();
        String mtab = "";
        if (this.checkTransactionContainerSupprt()) {
            mtab = "    ";
        }
        sb.append("            " + mtab);
        sb.append("cman.clear");
        sb.append(AppSchemaUtil.getClassname(model));
        sb.append("_insert");
        sb.append("(");
        sb.append("_" + model.getId());
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    protected String gRunMethodCode_UpdateSession(Model model) {
        StringBuilder sb = new StringBuilder();
        sb.append("            ");
        sb.append("session.save(" + this.getModelVariableName(model) + ");");
        sb.append(CR);
        if (StringUtils.isNotBlank((String)model.getUseGeneration())) {
            sb.append("            ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".saveAsGeneration(" + this.getModelVariableName(model) + ", jp.jasminesoft.jfc.GenerationType.INSERT, p);");
            sb.append(CR);
        }
        if (this.isTextSearch()) {
            sb.append("            ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".addIndex(" + this.getModelVariableName(model) + ", p);");
            sb.append(CR);
            sb.append(CR);
        }
        return sb.toString();
    }
}

