/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_recalc_base;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_update_base;
import jp.jasminesoft.jfc.gen.HelperStoreGenerator;
import jp.jasminesoft.jfc.gen.JFCControl_updateModeFlag;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ProcessBeanGenerator;
import jp.jasminesoft.jfc.gen.RelatedModelNode;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Multipart;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.Uploadupdate;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessBeanGenerator_uploadUpdate_runnable
extends ProcessBeanGenerator {
    protected String[] defaultImportStatement = new String[]{"java.io.*", "java.util.*", "java.security.Permission", "java.sql.Connection", "java.sql.SQLException", "javax.servlet.http.HttpSession", "javax.servlet.http.HttpServletRequest", "jp.jasminesoft.jfc.*", "jp.jasminesoft.jfc.app.HibernateUtil", "jp.jasminesoft.jfc.app.UploadUpdateCSVHelper", "jp.jasminesoft.jfc.app.CacheManagerBaseMethodImpl_threadLocal", "jp.jasminesoft.jfc.core.exception.BusinessLogicException", "jp.jasminesoft.jfc.core.util.PageLockUtils", "jp.jasminesoft.jfc.error.*", "jp.jasminesoft.jfc.service.JfcConfig", "jp.jasminesoft.util.*", "org.apache.commons.lang3.mutable.MutableObject", "org.apache.commons.lang3.StringUtils", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager"};
    private static final Logger logger = LogManager.getLogger(ProcessBeanGenerator_uploadUpdate_runnable.class);
    private String fileext = "csv";
    private String sep;
    private boolean checkpkey;
    private boolean isUseForeignKey;
    private Map<String, String> numberFormatMap = new HashMap<String, String>();
    private RelatedModelNode rootNode;
    private boolean sameInsertAndUpdateTargetitems;

    public ProcessBeanGenerator_uploadUpdate_runnable(Project project, String id, String type, Action action) {
        super(project, id, type, action);
        Uploadupdate uu = AppSchemaUtil.getUploadupdate(action);
        if (uu != null && uu.getType() != null) {
            this.fileext = uu.getType();
        }
        this.sep = null;
        if (uu != null && uu.getType() != null) {
            if (uu.getType().equals("csv")) {
                this.sep = ",";
            } else if (uu.getType().equals("tsv")) {
                this.sep = "\\t";
            }
        }
        this.checkpkey = true;
        if (uu != null) {
            this.checkpkey = uu.getCheckPrimarykeyHeader();
        }
        HelperStoreGenerator hgen = new HelperStoreGenerator(project, this.getStoreModel());
        this.rootNode = hgen.rootNode;
    }

    @Override
    public String getClassExplanation() {
        return rman.getValue("pbean.comment.uploadupdate.classexplanation");
    }

    @Override
    public String getClassname() {
        return AppSchemaUtil.getProcessBeanRunnableClassname(this.__id, this.__type, this.action, this.project);
    }

    @Override
    public String[] getDefaultImport() {
        Model[] rmodels = AppSchemaUtil.getDataitemAsModel(this.action, "presentation");
        if (rmodels == null || rmodels.length == 0) {
            return this.defaultImportStatement;
        }
        Model rmodel = rmodels[0];
        String rpackagename = AppSchemaUtil.getPackagename(rmodel, this.project);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.defaultImportStatement));
        list.add(rpackagename + "*");
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gUploadUpdateRunnableClass(this.getStoreModel()));
        return sb.toString();
    }

    private String gTargetitemsInstance(Model smodel, String tab) {
        List<String> updateMitemnames;
        List<String> insertMitemnames;
        StringBuilder sb = new StringBuilder();
        Model[] pmodels = AppSchemaUtil.getDataitemAsModel(this.action, "presentation");
        if (pmodels == null || pmodels.length == 0) {
            logger.error(rman.getValue("value.null.pmodels", this.action.getId()));
            return "";
        }
        Model pmodel = pmodels[0];
        ArrayList<Modelitem> list = new ArrayList<Modelitem>();
        IModelChoice[] smitems = smodel.getContent();
        IModelChoice[] pmitems = pmodel.getContent();
        for (int i = 0; i < smitems.length; ++i) {
            if (!(smitems[i] instanceof Modelitem)) continue;
            Modelitem smitem = (Modelitem)smitems[i];
            Modelitem pmitem = null;
            if (pmitems != null) {
                for (int j = 0; j < pmitems.length; ++j) {
                    Modelitem mitem;
                    if (!(pmitems[j] instanceof Modelitem) || !(mitem = (Modelitem)pmitems[j]).getName().equals(smitem.getName())) continue;
                    pmitem = mitem;
                    break;
                }
            }
            if (pmitem == null || !AppSchemaUtil.isCsvUploadUpdate(pmitem)) continue;
            list.add(smitem);
            String numberformat = pmitem.getCsvUploadUpdateNumberformat();
            if (!StringUtils.isNotBlank((String)numberformat)) continue;
            this.numberFormatMap.put(pmitem.getName(), numberformat);
        }
        Action uuaction = AppSchemaUtil.getActionByModelIdAndType(this.project, smodel.getId(), "uploadUpdate");
        Uploadupdate uploadupdate = AppSchemaUtil.getUploadupdate(uuaction);
        boolean isUpdateReadonly = false;
        if (uploadupdate != null) {
            isUpdateReadonly = uploadupdate.getUpdatereadonly();
        }
        if (isUpdateReadonly) {
            updateMitemnames = insertMitemnames = this.createModelitemNames(smodel, list);
        } else {
            List<Modelitem> mitems = this.createModelitemExcludeReadonly(smodel, list, "insert");
            insertMitemnames = this.createModelitemNames(smodel, mitems);
            mitems = this.createModelitemExcludeReadonly(smodel, list, "update");
            updateMitemnames = this.createModelitemNames(smodel, mitems);
        }
        if (insertMitemnames.equals(updateMitemnames)) {
            this.outputTargetItems(sb, tab, "struts.comment.targetitems", "targetitems", insertMitemnames);
            this.sameInsertAndUpdateTargetitems = true;
        } else {
            this.outputTargetItems(sb, tab, "struts.comment.insertTargetitems", "insertTargetitems", insertMitemnames);
            this.outputTargetItems(sb, tab, "struts.comment.updateTargetitems", "updateTargetitems", updateMitemnames);
        }
        ArrayList<String> mitemnames = new ArrayList<String>();
        this.addPrimaryKeyName(mitemnames, smodel);
        this.outputTargetItems(sb, tab, "struts.comment.pkey_targetitems", "pkey_targetitems", mitemnames);
        mitemnames = new ArrayList();
        this.addForeignKeyPkeyName(mitemnames, smodel);
        if (mitemnames.size() > 0) {
            this.isUseForeignKey = true;
            this.outputTargetItems(sb, tab, "struts.comment.fkey_targetitems", "fkeyTargetitems", mitemnames);
        }
        return sb.toString();
    }

    private List<Modelitem> createModelitemExcludeReadonly(Model smodel, List<Modelitem> list, String actionType) {
        Presentation[] presentations1;
        HashSet<String> pkeyset = new HashSet<String>();
        this.addPrimaryKeyName(pkeyset, smodel);
        Action[] actions = AppSchemaUtil.getActionsByModelIdAndType(this.project, smodel.getId(), actionType);
        ArrayList<Presentation> presentations = new ArrayList<Presentation>();
        for (Action action : actions) {
            presentations1 = AppSchemaUtil.getPresentation(this.project, action);
            if (presentations1 == null) continue;
            presentations.addAll(Arrays.asList(presentations1));
        }
        if (presentations.size() == 0) {
            if (actionType.equals("insert")) {
                actionType = "update";
            } else if (actionType.equals("update")) {
                actionType = "insert";
            }
            for (Action action : actions = AppSchemaUtil.getActionsByModelIdAndType(this.project, smodel.getId(), actionType)) {
                presentations1 = AppSchemaUtil.getPresentation(this.project, action);
                if (presentations1 == null) continue;
                presentations.addAll(Arrays.asList(presentations1));
            }
        }
        ArrayList<Modelitem> mitems = new ArrayList<Modelitem>();
        block2: for (Modelitem mitem : list) {
            if (pkeyset.contains(mitem.getName()) || mitem.getHasChild() || mitem.getAutokey()) {
                mitems.add(mitem);
                continue;
            }
            if (presentations.size() > 0) {
                for (Presentation presentation : presentations) {
                    List<Displayitem> ditems = AppSchemaUtil.getDisplayitemList(mitem.getName(), presentation, null);
                    for (Displayitem ditem : ditems) {
                        if (ditem.getReadonly()) continue;
                        mitems.add(mitem);
                        continue block2;
                    }
                }
                continue;
            }
            mitems.add(mitem);
        }
        return mitems;
    }

    private void addPrimaryKeyName(Collection<String> pkeyset, Model smodel) {
        PrimaryKey[] pkeys;
        for (PrimaryKey pkey : pkeys = AppSchemaUtil.getPrimaryKey(smodel)) {
            String pkeyName = pkey.getName();
            pkeyset.add(pkeyName);
        }
    }

    private void addForeignKeyPkeyName(Collection<String> fkeyset, Model smodel) {
        ForeignKey[] fkeys = AppSchemaUtil.getForeignKey(smodel);
        if (fkeys == null) {
            return;
        }
        block0: for (ForeignKey fkey : fkeys) {
            PrimaryKey[] refpkeys;
            Model refmodel = (Model)fkey.getIdrefAsIRNode();
            if (refmodel == null) continue;
            String refmitemname = fkey.getRefname() != null ? fkey.getRefname() : fkey.getName();
            for (PrimaryKey refpkey : refpkeys = AppSchemaUtil.getPrimaryKey(refmodel)) {
                if (!refmitemname.equals(refpkey.getName())) continue;
                fkeyset.add(fkey.getName());
                continue block0;
            }
        }
    }

    private List<String> createModelitemNames(Model smodel, List<Modelitem> list) {
        Iterator<Modelitem> it = list.iterator();
        ArrayList<String> mitemnames = new ArrayList<String>();
        String mitemFooter = smodel.getRealFilenameRefModelitemFooter();
        while (it.hasNext()) {
            Modelitem refsitem;
            Modelitem smitem = it.next();
            mitemnames.add(smitem.getName());
            if (mitemFooter == null || mitemFooter.length() <= 0 || (refsitem = AppSchemaUtil.getModelitem(smitem.getName() + mitemFooter, smodel)) == null) continue;
            mitemnames.add(refsitem.getName());
        }
        return mitemnames;
    }

    private void outputTargetItems(StringBuilder sb, String tab, String commentrkey, String varname, List<String> mitemnames) {
        sb.append(tab);
        sb.append("/**");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * " + rman.getValue(commentrkey));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected String[] ");
        sb.append(varname);
        sb.append(" = {");
        sb.append(CR);
        Iterator<String> it = mitemnames.iterator();
        while (it.hasNext()) {
            String mitemname = it.next();
            sb.append(tab + "    ");
            sb.append("\"");
            sb.append(StringUtil.convertJavaString((String)AppSchemaUtil.getChildPart(mitemname)));
            if (it.hasNext()) {
                sb.append("\",");
            } else {
                sb.append("\"");
            }
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("};");
        sb.append(CR);
        sb.append(CR);
    }

    private String gUploadUpdateRunnableClass(Model model) {
        StringBuilder sb = new StringBuilder();
        Model[] rmodels = AppSchemaUtil.getDataitemAsModel(this.action, "presentation");
        if (rmodels == null || rmodels.length == 0) {
            logger.error(rman.getValue("value.null.rmodels", this.action.getId()));
            return "";
        }
        Model rmodel = rmodels[0];
        sb.append("class " + this.getClassname());
        sb.append(CR);
        sb.append("        extends AbstractDbUploadUpdateRunnableMonitor2");
        sb.append(CR);
        sb.append("{");
        sb.append(CR);
        sb.append(this.gTargetitemsInstance(model, "    "));
        sb.append(this.gUploadUpdateRunnable_otherMethodAndInstance(model, rmodel, "    "));
        sb.append(this.gUploadUpdateRunnable_readRowMethod(model, rmodel, "    "));
        sb.append(this.gParseCsvData(model, rmodel, "    "));
        if (this.isUseForeignKey) {
            sb.append(this.generateGetForeignKeyStoreObj(model, rmodel, "    "));
        }
        sb.append(this.gUploadUpdateRunnable_readRow_insertMethod(model, rmodel, "    "));
        sb.append(this.gUploadUpdateRunnable_readRow_updateMethod(model, rmodel, "    "));
        sb.append(this.gUploadUpdateRunnable_readRow_deleteMethod(model, rmodel, "    "));
        sb.append(this.gUploadUpdateRunnable_addLockObjectMethod(model, rmodel, "    "));
        sb.append("}");
        sb.append(CR);
        return sb.toString();
    }

    private String gUploadUpdateRunnable_otherMethodAndInstance(Model model, Model rmodel, String tab) {
        Action _uaction;
        Uploadupdate uploadupdate;
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        sb.append(tab);
        sb.append("private final static Logger logger =");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("LogManager.getLogger(" + this.getClassname() + ".class);");
        sb.append(CR);
        if (this.sep != null) {
            sb.append(tab);
            sb.append("protected final static char SepChar = '" + this.sep + "';");
            sb.append(CR);
        }
        sb.append(CR);
        if (this.sameInsertAndUpdateTargetitems) {
            sb.append(tab);
            sb.append("protected Set<String> targetSet;");
            sb.append(CR);
        } else {
            sb.append(tab);
            sb.append("protected Set<String> insertTargetSet;");
            sb.append(CR);
            sb.append(tab);
            sb.append("protected Set<String> updateTargetSet;");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("protected Set<String> pkey_targetSet;");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected Set<String> notpkey_updateTargetSet;");
        sb.append(CR);
        if (this.isUseForeignKey) {
            sb.append(tab);
            sb.append("protected Set<String> fkeyTargetSet;");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("/**");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * " + rman.getValue("pbean.comment.uploadupdate.runnable.init"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("public void init(");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("ActionParameter p, File file, String filename, MultiPartForm multi,");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("LockObject lockobject, long lastaccesstime)");
        sb.append(CR);
        sb.append(tab);
        sb.append("{");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("super.init(p, file, filename, multi, lockobject, lastaccesstime);");
        sb.append(CR);
        if (this.sep != null) {
            sb.append(tab + "    ");
            sb.append("setSeparateCharacter(SepChar);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("setProcessFileSeparateCharacter(SepChar);");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("setEncoding(getCsvEncoding());");
        sb.append(CR);
        if (this.numberFormatMap.size() > 0) {
            sb.append(tab + "    ");
            sb.append("setNumberFormat(null);");
            sb.append(CR);
        }
        if (this.sameInsertAndUpdateTargetitems) {
            sb.append(tab + "    ");
            sb.append("this.targetSet = new HashSet<String>(Arrays.asList(targetitems));");
            sb.append(CR);
        } else {
            sb.append(tab + "    ");
            sb.append("this.insertTargetSet = new HashSet<String>(Arrays.asList(insertTargetitems));");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("this.updateTargetSet = new HashSet<String>(Arrays.asList(updateTargetitems));");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("this.pkey_targetSet = new HashSet<String>(Arrays.asList(pkey_targetitems));");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("this.notpkey_updateTargetSet = new HashSet<String>(");
        if (this.sameInsertAndUpdateTargetitems) {
            sb.append("this.targetSet);");
        } else {
            sb.append("this.updateTargetSet);");
        }
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("this.notpkey_updateTargetSet.removeAll(this.pkey_targetSet);");
        sb.append(CR);
        if (this.isUseForeignKey) {
            sb.append(tab + "    ");
            sb.append("this.fkeyTargetSet = new HashSet<String>(Arrays.asList(fkeyTargetitems));");
            sb.append(CR);
        }
        if ((uploadupdate = AppSchemaUtil.getUploadupdate(_uaction = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "uploadUpdate"))) != null) {
            boolean isUpdateuserid = uploadupdate.getUpdateuserid();
            boolean isUpdatetime = uploadupdate.getUpdatetime();
            if (!isUpdateuserid || !isUpdatetime) {
                sb.append(CR);
                if (!isUpdateuserid) {
                    sb.append(tab + "    ");
                    sb.append("p.pageMap.put(\"__jfc_control.skipUpdateuser\", Boolean.TRUE);");
                    sb.append(CR);
                }
                if (!isUpdatetime) {
                    sb.append(tab + "    ");
                    sb.append("p.pageMap.put(\"__jfc_control.skipUpdatetime\", Boolean.TRUE);");
                    sb.append(CR);
                }
            }
        }
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("JFCUtils.setVolatilityValueToRequestObject(p.request);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("JFCUtils.setHasAllPrincipalStatus(p.user, p.request);");
        sb.append(CR);
        Action iuaction = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "insert");
        if (iuaction == null) {
            iuaction = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "update");
        }
        Multipart mp = AppSchemaUtil.getMultipart(iuaction);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("attachmentFileMap.setUseTempFile(");
        if (mp == null || mp.getUsetempfilename()) {
            sb.append("true);");
        } else {
            sb.append("false);");
        }
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("attachmentFileMap.setKeepSuffix(");
        if (mp != null && mp.getKeepsuffix()) {
            sb.append("true);");
        } else {
            sb.append("false);");
        }
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("attachmentFileMap.setConvertAsciiFilename(");
        if (mp != null && !mp.getConvertasciifilename()) {
            sb.append("false);");
        } else {
            sb.append("true);");
        }
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("attachmentFileMap.setTempFilePrefix(\"__multi\");");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("this.originalRequest = p.request;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("this.originalAppMap = p.appMap;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("this.originalPageMap = p.pageMap;");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("protected String getCsvEncoding() {");
        sb.append(CR);
        String csv_encoding = uploadupdate.getCsvEncoding();
        if (StringUtils.isNotBlank((String)csv_encoding)) {
            sb.append(tab + "    ");
            sb.append("final String DefaultCsvEncoding = \"");
            sb.append(csv_encoding);
            sb.append("\";");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("return DefaultCsvEncoding;");
            sb.append(CR);
        } else {
            sb.append(tab + "    ");
            sb.append("JfcConfig jfcConfig = p.appctx.getBean(JfcConfig.class);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("return jfcConfig.getCsvEncoding();");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("protected UploadUpdateCSVHelper getUploadUpdateCSVHelper()");
        sb.append(" {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return ((UploadUpdateCSVHelper)");
        sb.append(AppSchemaUtil.getBean4DiconNoCast(rmodel, this.project, "CSVHelper"));
        sb.append(");");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("protected File createTempProcessFile()");
        sb.append(" throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return File.createTempFile(\"process_" + id + "\", \".");
        sb.append(this.fileext + "\");");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("protected File createTempErrorProcessFile()");
        sb.append(" throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return File.createTempFile(\"error_" + id + "\", \".");
        sb.append(this.fileext + "\");");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        if (!this.checkpkey) {
            sb.append(tab);
            sb.append("@Override");
            sb.append(CR);
            sb.append(tab);
            sb.append("protected boolean getCheckPrimaryKey() {");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("return false;");
            sb.append(CR);
            sb.append(tab);
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected File getAttachmentFileParentDir() throws IOException {");
        sb.append(CR);
        ControllerGenerator2_update_base.gCreateSavedirCode(sb, tab + "    ", mp);
        sb.append(tab + "    ");
        sb.append("return dir;");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected File getCurrentDir() {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("File catalinahome_bin_dir = ");
        sb.append("new File(System.getProperty(\"catalina.home\"), \"bin\");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return catalinahome_bin_dir;");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("/**");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * " + rman.getValue("pbean.comment.uploadupdate.processStart"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void processStart() {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("super.processStart();");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("/**");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * " + rman.getValue("pbean.comment.uploadupdate.processEnd"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("public void processEnd() {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("super.processEnd();");
        sb.append(CR);
        if ("jholiday".equals(id)) {
            sb.append(tab + "    ").append("HolidayManager.getInstance().reset();").append(CR);
        }
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("@Override");
        sb.append(CR);
        sb.append(tab);
        sb.append("public String getModelId() {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return \"");
        sb.append(model.getId());
        sb.append("\";");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gUploadUpdateRunnable_readRowMethod(Model model, Model rmodel, String tab) {
        boolean isModelitemCsv;
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        sb.append(tab);
        sb.append("/**");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * " + rman.getValue("pbean.comment.uploadupdate.readRow.1"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void readRow() throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("incrementProcessCount();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("datastatus = null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("data = null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("DbUploadUpdateRunnableMonitorFileProcessor.CellAttrs cwa = readRowDataWithAttr();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("data = cwa.getValues();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (header.length > data.length) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("String[] _data = new String[header.length];");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("System.arraycopy(data, 0, _data, 0, data.length);");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("Arrays.fill(_data, data.length, header.length, \"\");");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("data = _data;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("cellattr = cwa.getCellAttr();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (cellattr == null) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("cellattr = new DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[header.length];");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} else if (header.length > cellattr.length) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] _cellattr = new DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[header.length];");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("System.arraycopy(cellattr, 0, _cellattr, 0, cellattr.length);");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("cellattr = _cellattr;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        List<Modelitem> pmitems = AppSchemaUtil.getMultipleCsvOutputableModelitem(model, rmodel);
        boolean bl = isModelitemCsv = pmitems.size() > 0;
        if (isModelitemCsv) {
            sb.append("        ");
            sb.append("String[] _data;");
            sb.append(CR);
            sb.append("        ");
            sb.append("String[] _header;");
            sb.append(CR);
            sb.append("        ");
            sb.append("if (isModelitemCsv) {");
            sb.append(CR);
            this.outputGetModelitemCsvRowListCode(sb, rmodel);
            this.outputConvertModelitemCsvToNormalCsvCode(sb, rmodel);
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append("            ");
            sb.append("_data = data;");
            sb.append(CR);
            sb.append("            ");
            sb.append("_header = header;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
            sb.append(CR);
        } else {
            sb.append(tab + "    ");
            sb.append("String[] _data = data;");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("String[] _header = header;");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("// " + rman.getValue("pbean.comment.uploadupdate.readRow.getCsvDataStatus"));
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("datastatus = getCsvDataStatus(_data, _header, p);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} catch (IllegalStateException e) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("// " + rman.getValue("pbean.comment.uploadupdate.readRow.ErrorIllegalStateException"));
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("Object[] ep = { e.getMessage(), p.user.getUsername() };");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("p.errors.addJfcerror");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("    (errorManager.getJfcerror(\"error.uploadUpdateProcessBean.illegal_status_column\", ep, p.locale));");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (datastatus == CsvDataStatus.Auto) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (isAllEmptyStringArray(_data)) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("// " + rman.getValue("pbean.comment.uploadupdate.readRow.NotProcessRow"));
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("datastatus = CsvDataStatus.None;");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        if (!this.checkpkey) {
            sb.append(tab + "        ");
            sb.append("String[] pkey_data = ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
            sb.append(".getPrimaryKeyForCsvData(_data, _header, p);");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("if (isExistsEmptyStringArray(pkey_data)) {");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("datastatus = CsvDataStatus.Insert;");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("// " + rman.getValue("pbean.comment.uploadupdate.readRow.getPrimaryKey"));
        sb.append(CR);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        for (int i = 0; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append(tab + "    ");
            sb.append("String _" + pkey_name + " = null;");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("if (datastatus != CsvDataStatus.Insert) {");
        sb.append(CR);
        sb.append(this.gUploadUpdateRunnable_readRow_getpkey(model, rmodel, tab + "        "));
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.show.readdata", classname));
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(classname + " " + id + " = null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (datastatus == CsvDataStatus.Auto || datastatus == CsvDataStatus.Update) {");
        sb.append(CR);
        Action showpbean_action = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "show");
        String showpbean_classname = AppSchemaUtil.createProcessBeanName(model.getId(), "show", showpbean_action, this.project);
        sb.append(tab + "        ");
        sb.append("ProcessBean pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(showpbean_classname, ProcessBeanGenerator_uploadUpdate_runnable.getPackageNameAsJavaRule(this.project, this.getStoreModel())));
        sb.append(";");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("pbean.setActionParameter(p);");
        sb.append(CR);
        for (int i = 0; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append(tab + "        ");
            sb.append("pbean.setParameter(\"");
            sb.append(StringUtil.convertJavaString((String)pkey_name));
            sb.append("\", _");
            sb.append(pkey_name);
            sb.append(");");
            sb.append(CR);
        }
        sb.append(tab + "        ");
        sb.append("Object op = null;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("op = pbean.process();");
        sb.append(CR);
        this.gUploadUpdateRunnable_readRow_catchException(tab + "        ", sb);
        sb.append(tab + "        ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("pbean.release();");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (op == null) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append(id + " = null;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("} else if (op instanceof String) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("logger.debug(\"ShowProcessBean return value is \"+((String)op));");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append(id + " = null;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("} else if (op instanceof " + classname + ") {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append(id + " = (" + classname + ")op;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append(id + " = null;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (datastatus == CsvDataStatus.Auto) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (" + id + " == null) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("// " + rman.getValue("pbean.comment.uploadupdate.readRow.NothingData"));
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("datastatus = CsvDataStatus.Insert;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("// " + rman.getValue("pbean.comment.uploadupdate.readRow.ExistData"));
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("datastatus = CsvDataStatus.Update;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        this.gUploadUpdateRunnable_readRow_switchdatastatus(tab + "        ", sb, id, pkeys);
        this.gUploadUpdateRunnable_readRow_catchException(tab + "    ", sb);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void gUploadUpdateRunnable_readRow_switchdatastatus(String tab, StringBuilder sb, String id, PrimaryKey[] pkeys) {
        StringBuilder readRow_delete_arg = new StringBuilder();
        for (int i = 0; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            readRow_delete_arg.append("_");
            readRow_delete_arg.append(pkey_name);
            if (i + 1 >= pkeys.length) continue;
            readRow_delete_arg.append(", ");
        }
        String[] codes = new String[]{"switch (datastatus) {", "case Insert:", "    readRow_insert(_data, _header);", "    break;", "case Update:", "    if (" + id + " == null) {", "        // " + rman.getValue("pbean.comment.uploadupdate.readRow.ErrorIllegalPrimaryKey"), "        Object[] ep = { p.user.getUsername() };", "        p.errors.addJfcerror", "            (errorManager.getJfcerror(\"error.uploadUpdateProcessBean.nothing_pkey_data\", ep, p.locale));", "        failed_rowcnt++;", "        return;", "    }", "    readRow_update(_data, _header, " + id + ");", "    break;", "case Delete:", "    readRow_delete(" + readRow_delete_arg + ");", "    break;", "case None:", "    break;", "}"};
        this.outputCode(tab, sb, codes);
    }

    private void gUploadUpdateRunnable_readRow_catchException(String tab, StringBuilder sb) {
        String[] codes = new String[]{"} catch (SecurityException e) {", "    logger.warn(\"security error. user \"+p.user.getUsername()+\" \"+e.getMessage());", "    logger.debug(\"security error. user \"+p.user.getUsername(), e);", "    Object[] ep = { p.user.getUsername() };", "    p.errors.addJfcerror", "        (errorManager.getJfcerror(\"error.security.pbean\", ep, p.locale));", "    failed_rowcnt++;", "    return;", "} catch (BusinessLogicException e) {", "    logger.error(\"business logic error. user \"+p.user.getUsername(), e);", "    jp.jasminesoft.jfc.error.Jfcerror _error = new Jfcerror();", "    _error.setContent(e.getMessage());", "    p.errors.addJfcerror(_error);", "    failed_rowcnt++;", "    return;"};
        this.outputCode(tab, sb, codes);
    }

    private void outputCode(String tab, StringBuilder sb, String[] codes) {
        for (int i = 0; i < codes.length; ++i) {
            String code = codes[i];
            sb.append(tab);
            sb.append(code);
            sb.append(CR);
        }
    }

    private void outputGetModelitemCsvRowListCode(StringBuilder sb, Model rmodel) {
        sb.append("            ");
        sb.append("String[] pkeydata = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
        sb.append(".getPrimaryKeyForCsvData(data, header, p);");
        sb.append(CR);
        sb.append("            ");
        sb.append("ModelitemCsvPkey pkey = new ModelitemCsvPkey(pkeydata);");
        sb.append(CR);
        sb.append(CR);
        sb.append("            ");
        sb.append("ModelitemCsvRowList rowlist = modelitemCsvMap.get(pkey);");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (rowlist == null) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("logger.error(pkey.toString()+\" is nothing data.\");");
        sb.append(CR);
        sb.append("                ");
        sb.append("Object[] ep = { p.user.getUsername() };");
        sb.append(CR);
        sb.append("                ");
        sb.append("p.errors.addJfcerror(");
        sb.append(CR);
        sb.append("                    ");
        sb.append("errorManager.getJfcerror(");
        sb.append("\"error.uploadUpdateProcessBean.nothing_pkey_data\", ");
        sb.append("ep, p.locale));");
        sb.append(CR);
        sb.append("                ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append("                ");
        sb.append("return;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void outputConvertModelitemCsvToNormalCsvCode(StringBuilder sb, Model rmodel) {
        sb.append("            ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
        sb.append(".addModelitemCsvHeaderDataMap(");
        sb.append("rowlist, data, header, p, errorManager);");
        sb.append(CR);
        sb.append(CR);
        sb.append("            ");
        sb.append("logger.debug(pkey+");
        sb.append("\" getFileProcessCount()=\"+getFileProcessCount()+");
        sb.append("\" rowlist.getEndRowNum()=\"+rowlist.getEndRowNum());");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (getFileProcessCount() < rowlist.getEndRowNum()) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("datastatus = CsvDataStatus.None;");
        sb.append(CR);
        sb.append("                ");
        sb.append("return;");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append("            ");
        sb.append("_header = rowlist.getHeader();");
        sb.append(CR);
        sb.append("            ");
        sb.append("_data = rowlist.getData();");
        sb.append(CR);
        sb.append("            ");
        sb.append("modelitemCsvMap.remove(pkey);");
        sb.append(CR);
    }

    private String gUploadUpdateRunnable_readRow_getpkey(Model model, Model rmodel, String tab) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String rid = id + "_p";
        if (rmodel != null) {
            rid = rmodel.getId();
        }
        String vname_id = "pkey_" + id;
        String vname_rid = "pkey_" + rid;
        String vname_targetSet = "pkey_targetSet";
        this.outputHeaderDataToModelObjectCode(model, rmodel, vname_rid, vname_id, vname_targetSet, tab, sb);
        this.addCompulsoryChangeProcessInJuserModel(model, rmodel, vname_rid, vname_id, this.project, tab, sb);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        for (int i = 0; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append(tab);
            sb.append("_" + pkey_name + " = ");
            sb.append(JavaSourceGenerator.getterFullMethodAsObject(vname_id, pkey_name, "string"));
            sb.append(";");
            sb.append(CR);
        }
        return sb.toString();
    }

    private void outputHeaderDataToModelObjectCode(Model model, Model rmodel, String vname_rid, String vname_id, String vname_targetSet, String tab, StringBuilder sb) {
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String rclassname = classname + "P";
        if (rmodel != null) {
            rclassname = AppSchemaUtil.getClassname(rmodel);
        }
        sb.append(tab);
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.initdata"));
        sb.append(CR);
        sb.append(tab);
        sb.append(classname + " " + vname_id + " = new " + classname + "();");
        sb.append(CR);
        sb.append(tab);
        sb.append(rclassname + " " + vname_rid + " = new " + rclassname + "();");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow.parseCsvData"));
        sb.append(CR);
        sb.append(tab);
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
        sb.append(".parseCsvData(_data, cellattr, _header, " + vname_id + ", ");
        sb.append(vname_rid + ", p, errorManager, " + vname_targetSet + ");");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.filtering", id));
        sb.append(CR);
        sb.append(tab);
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "FilterHelper"));
        sb.append(".filter(" + vname_rid + ", " + vname_targetSet + ", p);");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.helper", id));
        sb.append(CR);
        sb.append(tab);
        sb.append(vname_id + " = ");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
        sb.append(".p2s(" + vname_rid + ", p, " + vname_id + ", " + vname_targetSet + ");");
        sb.append(CR);
    }

    private void addCompulsoryChangeProcessInJuserModel(Model model, Model rmodel, String vname_rid, String vname_id, Project project, String tab, StringBuilder sb) {
        if (!"juser".equals(model.getId())) {
            return;
        }
        Modelitem pitem = AppSchemaUtil.getModelitem("compulsoryChange", rmodel);
        if (!pitem.getCsvOutput()) {
            return;
        }
        sb.append(CR);
        sb.append(tab);
        sb.append("JuserPHelper2.setPasswdChangeFlag(");
        sb.append(vname_rid);
        sb.append(", p, ");
        sb.append(vname_id);
        sb.append(");");
        sb.append(CR);
        sb.append(CR);
    }

    private String generateGetForeignKeyStoreObj(Model model, Model rmodel, String tab) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String rid = id + "_p";
        String rclassname = classname + "P";
        if (rmodel != null) {
            rid = rmodel.getId();
            rclassname = AppSchemaUtil.getClassname(rmodel);
        }
        String vnameId = "fkey_" + id;
        String vnameRid = "fkey_" + rid;
        String vnameRid2 = "_fkey_" + rid;
        sb.append(tab);
        sb.append("/**");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.getForeignKeyStoreObj"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected ");
        sb.append(classname);
        sb.append(" getForeignKeyStoreObj(String[] _data,");
        sb.append(" String[] _header) {");
        sb.append(CR);
        String varname_targetset = this.sameInsertAndUpdateTargetitems ? "targetSet" : "insertTargetSet";
        sb.append(tab + "    ");
        sb.append("MutableObject<" + classname + "> mutableEntity = new MutableObject<" + classname + ">(new " + classname + "());");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(rclassname + " " + vnameRid + " = parseCsvData(data, header, mutableEntity, " + varname_targetset + ");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (" + vnameRid + " == null) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(classname + " " + vnameId + " = mutableEntity.getValue();");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.inputcheck"));
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(rclassname).append(" ");
        sb.append(vnameRid2).append(" = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
        sb.append(".p2p(");
        sb.append(vnameRid);
        sb.append(", p);").append(CR);
        sb.append(tab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "InputCheckHelper"));
        sb.append(".input_check(");
        sb.append(vnameId + ", " + vnameRid2 + ", p, errorManager, fkeyTargetSet, \"insert\");");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return ");
        sb.append(vnameId);
        sb.append(";");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gUploadUpdateRunnable_readRow_insertMethod(Model model, Model rmodel, String tab) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        sb.append(tab);
        sb.append("/*");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow_insert"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void readRow_insert(String[] data,");
        sb.append(" String[] header) throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ").append("p.request.setAttribute(\"UPLOADACTION\", \"insert\");").append(CR).append(CR);
        sb.append(tab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.initdata"));
        sb.append(CR);
        String varname_fkey = "fkey_" + id;
        if (this.isUseForeignKey) {
            sb.append(tab + "    ");
            sb.append(classname);
            sb.append(" " + varname_fkey);
            sb.append(" = getForeignKeyStoreObj(data, header);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("if (" + varname_fkey + " == null) {");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("failed_rowcnt++;");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("return;");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append(classname + " " + id + " = new " + classname + "();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
        sb.append(".initialize(" + id + ", p");
        if (this.isUseForeignKey) {
            ArrayList<String> mitemnames = new ArrayList<String>();
            this.addForeignKeyPkeyName(mitemnames, model);
            for (String mitemname : mitemnames) {
                sb.append(", ");
                sb.append(CR);
                sb.append(tab + "        ");
                sb.append(JavaSourceGenerator.getterFullMethodAsObject(varname_fkey, mitemname, "string"));
            }
        }
        sb.append(");");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (p.errors.sizeJfcerror() > 0) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        this.gUploadUpdateRunnable_readRow_update_base(model, rmodel, tab, sb, "insert");
        sb.append(tab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow_insert.execute"));
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (getStatus() == Stopping) return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("execute_insert(" + id + ");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("PageLockUtils.releaseAll(p);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        if (!JFCUtils.isSystemModel((String)model.getId())) {
            sb.append(tab + "    ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".calcChild(");
            sb.append(model.getId());
            sb.append(" ,p);");
            sb.append(CR);
            if (this.rootNode.getParentNode().length > 0) {
                sb.append(tab + "    ");
                sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
                sb.append(".calcAncestor(");
                sb.append(model.getId());
                sb.append(" ,p);");
                sb.append(CR);
            }
            sb.append(CR);
        }
        sb.append(tab + "    ").append("p.request.setAttribute(\"").append(model.getId()).append("\", ").append(model.getId()).append(");").append(CR);
        sb.append(tab + "    ").append("callScript(\"").append(model.getId()).append("\", p, \"AfterUpdate\");").append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void execute_insert(" + classname + " " + id + ") throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("String errmsg = null;");
        sb.append(CR);
        sb.append(CR);
        Action insertpbean_action = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "insert");
        String insertpbean_classname = AppSchemaUtil.createProcessBeanName(model.getId(), "insert", insertpbean_action, this.project);
        sb.append(tab + "    ");
        sb.append("ProcessBean pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(insertpbean_classname, ProcessBeanGenerator_uploadUpdate_runnable.getPackageNameAsJavaRule(this.project, this.getStoreModel())));
        sb.append(";");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("pbean.setActionParameter(p);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("pbean.setParameter(\"");
        sb.append(StringUtil.convertJavaString((String)id));
        sb.append("\", ");
        sb.append(id);
        sb.append(");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("errmsg = (String)pbean.process();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("pbean.release();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (errmsg != null && errmsg.length() > 0) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("Object[] ep = { errmsg };");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("p.errors.addJfcerror");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("(errorManager.getJfcerror(\"error.dbaccess.insert\", ep, p.locale));");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("insert_rowcnt++;");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gUploadUpdateRunnable_readRow_updateMethod(Model model, Model rmodel, String tab) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        sb.append(tab);
        sb.append("/*");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow_update"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void readRow_update(String[] data, ");
        sb.append("String[] header, " + classname + " " + id);
        sb.append(") throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ").append("p.request.setAttribute(\"UPLOADACTION\", \"update\");").append(CR).append(CR);
        sb.append(tab + "    ").append("p.request.setAttribute(\"").append(model.getId()).append("\", ").append(model.getId()).append(");").append(CR);
        if (StringUtils.isNotBlank((String)model.getUseGeneration())) {
            sb.append(tab + "    ");
            sb.append(classname).append(" ").append("_").append(model.getId()).append("_original = new ");
            sb.append(classname).append("(").append(model.getId()).append(");").append(CR);
        }
        sb.append(tab + "    ").append("String ret = callScript(\"").append(model.getId()).append("\", p, \"AfterRead\");").append(CR);
        sb.append(tab + "    ");
        sb.append("if (StringUtils.isNotBlank(ret)) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("jp.jasminesoft.jfc.error.Jfcerror _error = new Jfcerror();");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("_error.setContent(ret);");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("p.errors.addJfcerror(_error);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (p.errors.sizeJfcerror() > 0) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        this.gUploadUpdateRunnable_readRow_update_base(model, rmodel, tab, sb, "update");
        sb.append(tab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow_update.execute"));
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (getStatus() == Stopping) return;");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("LockObject _lo = null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (isLockData) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("_lo = addLockObject(p, " + id + ");");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("if (_lo == null) {");
        sb.append(CR);
        sb.append(tab + "                ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "                ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        if (StringUtils.isNotBlank((String)model.getUseGeneration())) {
            sb.append("            ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".saveAsGeneration(_" + model.getId() + "_original, jp.jasminesoft.jfc.GenerationType.BEFOREUPDATE, p);");
            sb.append(CR);
        }
        sb.append(tab + "        ");
        sb.append("execute_update(" + id + ");");
        sb.append(CR);
        if (!JFCUtils.isSystemModel((String)model.getId())) {
            sb.append(tab + "        ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".calcChild(");
            sb.append(model.getId());
            sb.append(" ,p);");
            sb.append(CR);
            if (this.rootNode.getParentNode().length > 0) {
                sb.append(tab + "        ");
                sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
                sb.append(".calcAncestor(");
                sb.append(model.getId());
                sb.append(" ,p);");
                sb.append(CR);
            }
            sb.append(CR);
        }
        sb.append(tab + "        ").append("p.request.setAttribute(\"").append(model.getId()).append("\", ").append(model.getId()).append(");").append(CR);
        sb.append(tab + "        ").append("callScript(\"").append(model.getId()).append("\", p, \"AfterUpdate\");").append(CR);
        sb.append(tab + "    ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (_lo != null) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("LockManager lman = LockManagerFactory.getLockManager(p);");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("lman.releaseLockObject(_lo);");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("PageLockUtils.releaseAll(p);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void execute_update(" + classname + " " + id + ") throws IOException {");
        sb.append(CR);
        if (model.getWorkflow()) {
            PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
            String pkey_name = AppSchemaUtil.createPrimaryKeyName(pkeys);
            sb.append(tab).append("    ");
            sb.append("String ").append(pkey_name).append(";").append(CR);
            sb.append(ControllerGenerator2.gDeclarePrimaryKey(classname, model, pkeys, tab + "    ", model.getId(), "sb", pkey_name, this.project));
            sb.append(tab).append("    ");
            sb.append("WorkFlowManager wman = WorkFlowManager.getInstance(p);").append(CR);
            sb.append(tab).append("    ");
            sb.append("String currentNodeName = ");
            sb.append(model.getId());
            sb.append(".getJfcWorkflowCurrentNode();").append(CR);
            sb.append(tab).append("    ");
            sb.append("// \u627f\u8a8d\u30e6\u30fc\u30b6\u30d5\u30e9\u30b0(\u627f\u8a8d\u5bfe\u8c61\u306e\u30e6\u30fc\u30b6\u306e\u5834\u5408 true)").append(CR);
            sb.append(tab).append("    ");
            sb.append("boolean isAdmitUser = wman.isAdmitUser(\"");
            sb.append(model.getId());
            sb.append("\", ");
            sb.append(pkey_name);
            sb.append(", ");
            sb.append(model.getId());
            sb.append(".getJfcWorkflowAdmitUser(), currentNodeName, p);").append(CR);
            sb.append(tab).append("    ").append("if (! isAdmitUser) {").append(CR);
            sb.append(tab + "        ");
            sb.append("p.errors.addJfcerror");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("(errorManager.getJfcerror(\"error.uploadUpdateProcessBean.workflow_notadmituser\", p.locale));");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("failed_rowcnt++;");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("return;");
            sb.append(CR);
            sb.append(tab).append("    ").append("}").append(CR);
        }
        sb.append(tab + "    ");
        sb.append("String errmsg = null;");
        sb.append(CR);
        sb.append(CR);
        Action updatepbean_action = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "update");
        String updatepbean_classname = AppSchemaUtil.createProcessBeanName(model.getId(), "update", updatepbean_action, this.project);
        sb.append(tab + "    ");
        sb.append("ProcessBean pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(updatepbean_classname, ProcessBeanGenerator_uploadUpdate_runnable.getPackageNameAsJavaRule(this.project, this.getStoreModel())));
        sb.append(";");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("pbean.setActionParameter(p);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("pbean.setParameter(\"");
        sb.append(StringUtil.convertJavaString((String)id));
        sb.append("\", ");
        sb.append(id);
        sb.append(");");
        sb.append(CR);
        String status = "\"uploadUpdate" + AppSchemaUtil.getClassname(this.getStoreModel()) + "\"";
        sb.append(ControllerGenerator2_recalc_base.gSetPrimaryKey4Pbean_update("pbean", updatepbean_action, null, "        ", this.project));
        sb.append(ControllerGenerator2_recalc_base.gSetPrimaryKey4Pbean_update_addon(id, model, status, tab + "    ", this.project));
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("errmsg = (String)pbean.process();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("pbean.release();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (errmsg != null && errmsg.length() > 0) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("Object[] ep = { errmsg };");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("p.errors.addJfcerror");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("(errorManager.getJfcerror(\"error.dbaccess.insert\", ep, p.locale));");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("update_rowcnt++;");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private int getLoopCount(Model smodel, Model pmodel) {
        IModelChoice[] imc;
        int count = 1;
        for (IModelChoice imc2 : imc = smodel.getContent()) {
            if (!(imc2 instanceof Modelitem)) continue;
            Modelitem smitem = (Modelitem)imc2;
            Relation smitem_relation = AppSchemaUtil.getRelationTypeExceptRef(smitem);
            if (smitem_relation == null) {
                smitem_relation = AppSchemaUtil.getRelationTypeIsRef(smitem);
            }
            if (smitem_relation != null && !StringUtils.isEmpty((String)smitem_relation.getRestrict())) {
                ++count;
            }
            if (!AppSchemaUtil.hasRestrictparam(smitem)) continue;
            ++count;
        }
        return count;
    }

    private void gUploadUpdateRunnable_readRow_update_base(Model model, Model rmodel, String tab, StringBuilder sb, String method) {
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String rid = id + "_p";
        String rclassname = classname + "P";
        if (rmodel != null) {
            rid = rmodel.getId();
            rclassname = AppSchemaUtil.getClassname(rmodel);
        }
        String varname_targetset = this.sameInsertAndUpdateTargetitems ? "targetSet" : (method.equals("insert") ? "insertTargetSet" : "updateTargetSet");
        sb.append(tab + "    ");
        sb.append("MutableObject<" + classname + "> mutableEntity = new MutableObject<" + classname + ">(" + id + ");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(rclassname + " " + rid + " = parseCsvData(data, header, mutableEntity, " + varname_targetset + ");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (").append(rid).append(" == null) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(id).append(" = mutableEntity.getValue();");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.inputcheck"));
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(rclassname).append(" ");
        sb.append("_").append(rid).append(" = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
        sb.append(".p2p(");
        sb.append(rid);
        sb.append(", p);").append(CR);
        sb.append(tab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "InputCheckHelper"));
        sb.append(".input_check(");
        sb.append(id + ", _" + rid + ", p, errorManager, ");
        if (method.equals("update")) {
            sb.append("notpkey_updateTargetSet");
        } else {
            sb.append(varname_targetset);
        }
        sb.append(", \"");
        sb.append(method + "\");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (p.errors.sizeJfcerror() > 0) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
    }

    private String gParseCsvData(Model model, Model rmodel, String tab) {
        StringBuilder sb = new StringBuilder();
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        String rid = id + "_p";
        String rclassname = classname + "P";
        if (rmodel != null) {
            rid = rmodel.getId();
            rclassname = AppSchemaUtil.getClassname(rmodel);
        }
        boolean force_save_refitem = false;
        Uploadupdate uu = AppSchemaUtil.getUploadupdate(this.action);
        if (uu != null) {
            force_save_refitem = uu.getForceSaveRefitem();
        }
        sb.append(tab);
        sb.append("protected ");
        sb.append(rclassname);
        sb.append(" parseCsvData(String[] data, String[] header, MutableObject<");
        sb.append(classname);
        sb.append("> mutableEntity, Set<String> targetSet) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(classname + " " + id + " = mutableEntity.getValue();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append(rclassname + " " + rid + " = null;");
        sb.append(CR);
        String loopCountTab = "";
        int loopCount = this.getLoopCount(model, rmodel);
        if (loopCount >= 2) {
            loopCountTab = "    ";
            sb.append(tab + "    ");
            sb.append(classname + " src_" + id + " = new " + classname + "(" + id + ");");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("final int MaxLoopCount = " + loopCount + ";");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("int loopCount = -1;");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("boolean isClearRestrictItem = true;");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("do {");
            sb.append(CR);
            sb.append(tab + loopCountTab + "    ");
            sb.append("loopCount++;");
            sb.append(CR);
        }
        sb.append(tab + loopCountTab + "    ");
        sb.append(rid + " = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
        sb.append(".s2p(" + id + ", p, ");
        sb.append(AppSchemaUtil.getHelperClassname(rmodel));
        sb.append(".SHOW);");
        sb.append(CR);
        sb.append(CR);
        String varname_targetset = "targetSet";
        sb.append(tab + loopCountTab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow.parseCsvData"));
        sb.append(CR);
        sb.append(tab + loopCountTab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
        sb.append(".clearNullContent(" + rid + ");");
        sb.append(CR);
        if (loopCount >= 2) {
            sb.append(tab + loopCountTab + "    ");
            sb.append("isClearRestrictItem = ");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
            sb.append(".parseCsvData(data, cellattr, header, " + id + ", " + rid + ", p, errorManager, " + "targetSet" + ", loopCount, src_" + id + ", attachmentFileMap);");
            sb.append(CR);
            sb.append(tab + loopCountTab + "    ");
            sb.append("for (Jfcerror error : p.errors.getJfcerror()) {");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append("String errorcode = error.getCode();");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append("if (!isClearRestrictItem || loopCount+1 == MaxLoopCount || errorcode == null || ");
            sb.append(CR);
            sb.append(tab + loopCountTab + "            ");
            sb.append("(!errorcode.equals(\"error.parseCsvData.tooManySameContent\") &&");
            sb.append(CR);
            sb.append(tab + loopCountTab + "            ");
            sb.append(" !errorcode.equals(\"error.parseCsvData.nothingContent\")))");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append("{");
            sb.append(CR);
            sb.append(tab + loopCountTab + "            ");
            sb.append("return null;");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append("}");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append("p.errors.removeJfcerror(error);");
            sb.append(CR);
            sb.append(tab + loopCountTab + "    ");
            sb.append("}");
            sb.append(CR);
        } else {
            sb.append(tab + loopCountTab + "    ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "CSVHelper"));
            sb.append(".parseCsvData(data, cellattr, header, " + id + ", " + rid + ", p, errorManager, " + "targetSet" + ", 0, null, attachmentFileMap);");
            sb.append(CR);
            sb.append(tab + loopCountTab + "    ");
            sb.append("if (p.errors.sizeJfcerror() > 0) {");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append("return null;");
            sb.append(CR);
            sb.append(tab + loopCountTab + "    ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(tab + loopCountTab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "Helper"));
        sb.append(".removeUnchooseValue(" + rid + ", p, null);");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + loopCountTab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.filtering", id));
        sb.append(CR);
        sb.append(tab + loopCountTab + "    ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project, "FilterHelper"));
        sb.append(".filter(" + rid + ", " + "targetSet" + ", p);");
        sb.append(CR);
        sb.append(CR);
        if ("juser".equals(id)) {
            sb.append(tab + loopCountTab + "    ");
            sb.append("p.request.setAttribute(\"__helper_jusercontrol_csvupload\", new Boolean(true));");
            sb.append(CR);
            sb.append(CR);
        }
        sb.append(tab + loopCountTab + "    ");
        sb.append("// ");
        sb.append(rman.getValue("struts.comment.helper", id));
        sb.append(CR);
        sb.append(tab + loopCountTab + "    ");
        sb.append(id + " = ");
        sb.append(CR);
        sb.append(tab + loopCountTab + "        ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
        sb.append(".p2s(" + rid + ", p, " + id + ", " + "targetSet" + ");");
        sb.append(CR);
        if (force_save_refitem) {
            sb.append(tab + loopCountTab + "    ");
            sb.append(id + " = ");
            sb.append(CR);
            sb.append(tab + loopCountTab + "        ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel, this.project));
            sb.append(".p2s(" + rid + ", p, " + id + ", " + "targetSet" + ");");
            sb.append(CR);
        }
        this.addCompulsoryChangeProcessInJuserModel(model, rmodel, rid, id, this.project, tab + loopCountTab + "    ", sb);
        if (AppSchemaUtil.hasAutocalc(model, this.project)) {
            JFCControl_updateModeFlag.gOutputControl_updateMode_On(id, tab + loopCountTab + "    ", sb);
            sb.append(tab + loopCountTab + "    ");
            sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
            sb.append(".calc(" + id + ", p);");
            sb.append(CR);
            JFCControl_updateModeFlag.gOutputControl_updateMode_Off(id, tab + loopCountTab + "    ", sb);
            sb.append(CR);
        }
        if (loopCount >= 2) {
            sb.append(tab + "    ");
            sb.append("} while(isClearRestrictItem && loopCount < MaxLoopCount);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("if (isClearRestrictItem) {");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("logger.debug(\"isClearRestrictItem is true\");");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("logger.debug(\"smodel=\"+" + id + ");");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("logger.debug(\"pmodel=\"+" + rid + ");");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("mutableEntity.setValue(" + id + ");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return " + rid + ";");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gUploadUpdateRunnable_readRow_deleteMethod(Model model, Model rmodel, String tab) {
        String pkey_name;
        PrimaryKey pkey;
        int i;
        String pkey_name2;
        PrimaryKey pkey2;
        int i2;
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("/*");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow_delete"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void readRow_delete(");
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        for (i2 = 0; i2 < pkeys.length; ++i2) {
            pkey2 = pkeys[i2];
            pkey_name2 = AppSchemaUtil.createFullPrimaryKeyName(pkey2);
            sb.append("String _" + pkey_name2);
            if (i2 + 1 >= pkeys.length) continue;
            sb.append(", ");
        }
        sb.append(") throws IOException {");
        sb.append(CR);
        sb.append(tab + "    ").append("p.request.setAttribute(\"UPLOADACTION\", \"delete\");").append(CR).append(CR);
        if (model.getWorkflow()) {
            this.gCreatePrimarykeyObj(tab + "    ", pkeys, sb, "String");
            sb.append(tab).append("    ");
            sb.append("WorkFlowManager wman = WorkFlowManager.getInstance(p);").append(CR);
            sb.append(tab).append("    ");
            sb.append("// \u524a\u9664\u53ef\u80fd(\u30ed\u30b0\u30aa\u30f3\u30e6\u30fc\u30b6\u304c\u4f5c\u6210\u8005\u3067\u7533\u8acb\u53ef\u80fd\u3001\u30ed\u30b0\u30aa\u30f3\u30e6\u30fc\u30b6\u304c\u30b7\u30b9\u30c6\u30e0\u7ba1\u7406\u8005\u306e\u5834\u5408\u3001true \u306b\u306a\u308b)");
            sb.append(CR);
            sb.append(tab).append("    ");
            sb.append("boolean isDeletable = wman.isDeletable(\"").append(model.getId());
            sb.append("\", primarykey, p);").append(CR);
            sb.append(tab).append("    ").append("if (! isDeletable) {").append(CR);
            sb.append(tab + "        ");
            sb.append("p.errors.addJfcerror");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("(errorManager.getJfcerror(\"error.uploadUpdateProcessBean.workflow_notdeletable\", p.locale));");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("failed_rowcnt++;");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("return;");
            sb.append(CR);
            sb.append(tab).append("    ").append("}").append(CR);
        }
        sb.append(tab + "    ");
        sb.append("LockObject _lo = null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (isLockData) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("_lo = addLockObject(p, ");
        for (i2 = 0; i2 < pkeys.length; ++i2) {
            pkey2 = pkeys[i2];
            pkey_name2 = AppSchemaUtil.createFullPrimaryKeyName(pkey2);
            sb.append("_" + pkey_name2);
            if (i2 + 1 >= pkeys.length) continue;
            sb.append(", ");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("if (_lo == null) {");
        sb.append(CR);
        sb.append(tab + "                ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "                ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        Uploadupdate uu = AppSchemaUtil.getUploadupdate(this.action);
        boolean isGetObjectAtDelete = uu.getGetObjectAtDelete();
        boolean isOutputReadObject = false;
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        if (this.rootNode.getParentNode().length > 0 && !JFCUtils.isSystemModel((String)id) || isGetObjectAtDelete) {
            String _pbean = AppSchemaUtil.createProcessBeanName(id, "show", null, this.project, false);
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append(classname + " " + id + " = null;");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("{");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("ProcessBean pbean = ");
            sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(_pbean, null));
            sb.append(";");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("pbean.setActionParameter(p);");
            sb.append(CR);
            if (pkeys != null && pkeys.length == 1) {
                String pkey_name3 = AppSchemaUtil.createPrimaryKeyName(pkeys);
                sb.append(tab + "            ");
                sb.append("pbean");
                sb.append(".setParameter(\"" + StringUtil.convertJavaString((String)pkey_name3) + "\", _" + pkey_name3 + ");");
                sb.append(CR);
            } else {
                for (int i3 = 0; i3 < pkeys.length; ++i3) {
                    PrimaryKey pkey3 = pkeys[i3];
                    String pkey_name4 = AppSchemaUtil.createFullPrimaryKeyName(pkey3);
                    sb.append(tab + "            ");
                    sb.append("pbean");
                    sb.append(".setParameter(\"" + StringUtil.convertJavaString((String)pkey_name4) + "\", ");
                    sb.append("_" + pkey_name4);
                    sb.append(");");
                    sb.append(CR);
                }
            }
            sb.append(ControllerGenerator2.gReadStoreModel(id, classname, model, tab + "    "));
            sb.append(tab + "            ").append("p.request.setAttribute(\"").append(id).append("\", ").append(id).append(");").append(CR);
            sb.append(tab + "            ").append("String ret = callScript(\"").append(id).append("\", p, \"AfterRead\");").append(CR);
            sb.append(tab + "            ");
            sb.append("if (StringUtils.isNotBlank(ret)) {");
            sb.append(CR);
            sb.append(tab + "                ");
            sb.append("jp.jasminesoft.jfc.error.Jfcerror _error = new Jfcerror();");
            sb.append(CR);
            sb.append(tab + "                ");
            sb.append("_error.setContent(ret);");
            sb.append(CR);
            sb.append(tab + "                ");
            sb.append("p.errors.addJfcerror(_error);");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("}");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("if (p.errors.sizeJfcerror() > 0) {");
            sb.append(CR);
            sb.append(tab + "                ");
            sb.append("failed_rowcnt++;");
            sb.append(CR);
            sb.append(tab + "                ");
            sb.append("return;");
            sb.append(CR);
            sb.append(tab + "            ");
            sb.append("}");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("}");
            sb.append(CR);
            isOutputReadObject = true;
        }
        sb.append(tab + "        ");
        sb.append("execute_delete(");
        for (i = 0; i < pkeys.length; ++i) {
            pkey = pkeys[i];
            pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append("_" + pkey_name);
            if (i + 1 >= pkeys.length) continue;
            sb.append(", ");
        }
        sb.append(");");
        sb.append(CR);
        if (isOutputReadObject) {
            if (this.rootNode.getParentNode().length > 0 && !JFCUtils.isSystemModel((String)id)) {
                sb.append(tab + "        ");
                sb.append("if (").append(id).append(" != null) {").append(CR);
                sb.append(tab + "            ");
                sb.append(AppSchemaUtil.getHelperClassname4Dicon(model, this.project));
                sb.append(".calcAncestor(");
                sb.append(id);
                sb.append(" ,p);");
                sb.append(CR);
                sb.append(tab + "        ");
                sb.append("}");
                sb.append(CR);
            }
            sb.append(tab + "        ").append("p.request.setAttribute(\"").append(id).append("\", ").append(id).append(");").append(CR);
            sb.append(tab + "        ").append("callScript(\"").append(id).append("\", p, \"AfterUpdate\");").append(CR);
        }
        sb.append(tab + "    ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("if (_lo != null) {");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("LockManager lman = LockManagerFactory.getLockManager(p);");
        sb.append(CR);
        sb.append(tab + "            ");
        sb.append("lman.releaseLockObject(_lo);");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("PageLockUtils.releaseAll(p);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("/*");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.readRow_delete"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected void execute_delete(");
        for (i = 0; i < pkeys.length; ++i) {
            pkey = pkeys[i];
            pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append("String _" + pkey_name);
            if (i + 1 >= pkeys.length) continue;
            sb.append(", ");
        }
        sb.append(") throws IOException {");
        sb.append(CR);
        Action deletepbean_action = AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "delete");
        String deletepbean_classname = AppSchemaUtil.createProcessBeanName(model.getId(), "delete", deletepbean_action, this.project);
        sb.append(tab + "    ");
        sb.append("ProcessBean pbean = ");
        sb.append(AppSchemaUtil.createNewProcessBeanInstanceCode(deletepbean_classname, ProcessBeanGenerator_uploadUpdate_runnable.getPackageNameAsJavaRule(this.project, this.getStoreModel())));
        sb.append(";");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("pbean.setActionParameter(p);");
        sb.append(CR);
        for (int i4 = 0; i4 < pkeys.length; ++i4) {
            PrimaryKey pkey4 = pkeys[i4];
            String pkey_name5 = AppSchemaUtil.createFullPrimaryKeyName(pkey4);
            sb.append(tab + "    ");
            sb.append("pbean.setParameter(\"");
            sb.append(StringUtil.convertJavaString((String)pkey_name5));
            sb.append("\", _");
            sb.append(pkey_name5);
            sb.append(");");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("String errmsg = null;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("errmsg = (String)pbean.process();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} finally {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("pbean.release();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (errmsg != null && errmsg.length() > 0) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("Object[] ep = { errmsg };");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("p.errors.addJfcerror");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("(errorManager.getJfcerror(\"error.dbaccess.delete\", ep, p.locale));");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("failed_rowcnt++;");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("return;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("delete_rowcnt++;");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private String gUploadUpdateRunnable_addLockObjectMethod(Model model, Model rmodel, String tab) {
        String pkey_name;
        PrimaryKey pkey;
        int i;
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(model, this.project);
        StringBuilder sb = new StringBuilder();
        sb.append(tab);
        sb.append("/*");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.addLockObject"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected LockObject addLockObject(ActionParameter p, " + classname + " " + id + ") {");
        sb.append(CR);
        for (i = 0; i < pkeys.length; ++i) {
            pkey = pkeys[i];
            pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append(tab + "    ");
            sb.append("String _" + pkey_name + " = ");
            sb.append(JavaSourceGenerator.getterFullMethodAsObject(id, pkey_name, "string"));
            sb.append(";");
            sb.append(CR);
        }
        sb.append(tab + "    ");
        sb.append("return addLockObject(p, ");
        for (i = 0; i < pkeys.length; ++i) {
            pkey = pkeys[i];
            pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append("_" + pkey_name);
            if (i + 1 >= pkeys.length) continue;
            sb.append(", ");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(tab);
        sb.append("/*");
        sb.append(CR);
        sb.append(tab);
        sb.append(" * ");
        sb.append(rman.getValue("pbean.comment.uploadupdate.addLockObject"));
        sb.append(CR);
        sb.append(tab);
        sb.append(" */");
        sb.append(CR);
        sb.append(tab);
        sb.append("protected LockObject addLockObject(ActionParameter p, ");
        for (i = 0; i < pkeys.length; ++i) {
            pkey = pkeys[i];
            pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append("String _" + pkey_name);
            if (i + 1 >= pkeys.length) continue;
            sb.append(", ");
        }
        sb.append(") {");
        sb.append(CR);
        String prefix = AppSchemaUtil.getModelLockKey(this.action, model);
        sb.append(tab + "    ");
        sb.append("String modelname = \"");
        sb.append(StringUtil.convertJavaString((String)prefix));
        sb.append("\";");
        sb.append(CR);
        this.gCreatePrimarykeyObj(tab + "    ", pkeys, sb, "Object");
        sb.append(tab + "    ");
        sb.append("String sessionid = (String)p.request.getAttribute(\"__jfc_sessionid\");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("return addLockObject(p, errorManager, modelname, primarykey, sessionid);");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        return sb.toString();
    }

    private void gCreatePrimarykeyObj(String tab, PrimaryKey[] pkeys, StringBuilder sb, String objclassname) {
        if (pkeys.length == 1) {
            PrimaryKey pkey = pkeys[0];
            String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
            sb.append(tab);
            sb.append(objclassname);
            sb.append(" primarykey = _" + pkey_name + ";");
            sb.append(CR);
        } else {
            sb.append(tab);
            sb.append("StringBuilder sb = new StringBuilder();");
            sb.append(CR);
            for (int i = 0; i < pkeys.length; ++i) {
                PrimaryKey pkey = pkeys[i];
                String pkey_name = AppSchemaUtil.createFullPrimaryKeyName(pkey);
                sb.append(tab);
                sb.append("sb.append(_" + pkey_name + ");");
                if (i + 1 >= pkeys.length) continue;
                sb.append(tab);
                sb.append("sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());");
                sb.append(CR);
            }
            sb.append(tab);
            sb.append(objclassname);
            sb.append(" primarykey = sb.toString();");
            sb.append(CR);
        }
    }
}

