/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IPropertiesfileChoice;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Propertiesfile;
import jp.jasminesoft.jfc.gen.appschema.PropertiesfileComment;
import jp.jasminesoft.jfc.gen.appschema.PropertiesfileItem;
import jp.jasminesoft.util.StringUtil;

public class PropertiesfileGenerator
extends SourceGenerator {
    public static final String ENCODE = "UTF8";
    private Propertiesfile propertiesfile;

    public PropertiesfileGenerator(Project project, Propertiesfile propertiesfile) {
        super(project);
        this.propertiesfile = propertiesfile;
    }

    @Override
    public String getEncoding() {
        return ENCODE;
    }

    @Override
    public String getFileSuffix() {
        return ".properties." + this.getEncoding();
    }

    public String getFilename() {
        return this.propertiesfile.getFilename();
    }

    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF" + File.separator + "classes";
    }

    @Override
    public void process() {
        String content = this.process0();
        String filename = this.getFilename();
        String subpackagename = this.getSubpackageName();
        if (content != null) {
            content = this.getGeneratorClassName() + content;
            this.createSource(content, filename, subpackagename, false);
        }
    }

    public String process0() {
        IPropertiesfileChoice[] contents;
        StringBuilder sb = new StringBuilder();
        for (IPropertiesfileChoice content : contents = this.propertiesfile.getContent()) {
            if (content instanceof PropertiesfileComment) {
                PropertiesfileComment comment = (PropertiesfileComment)content;
                String value = comment.getContent();
                if (value == null) continue;
                sb.append("# ");
                sb.append(this.encodeValue(value));
                sb.append(CR);
                continue;
            }
            if (!(content instanceof PropertiesfileItem)) continue;
            PropertiesfileItem item = (PropertiesfileItem)content;
            String key = item.getName();
            String value = item.getContent();
            if (key == null || value == null) continue;
            sb.append(this.encodeKey(key));
            sb.append("=");
            sb.append(this.encodeValue(value));
            sb.append(CR);
        }
        return sb.toString();
    }

    private String encodeKey(String key) {
        return StringUtil.replaceAll((String)key, (String)":", (String)"\\:");
    }

    private String encodeValue(String value) {
        value = StringUtil.replaceAll((String)value, (String)"\r\n", (String)"\\r");
        value = StringUtil.replaceAll((String)value, (String)"\n", (String)"\\r");
        return value;
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "# genclassname:" + this.getClass().getName() + CR;
        }
        return "";
    }
}

