/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.RelaxSchemaBaseGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaCondPGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaConditionGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaEmptyGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaListGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaListPGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaMasterGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaPresentationGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaStoreGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaTotalGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaTotalPGenerator;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelaxSchemaGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)RelaxSchemaGeneratorFactory.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public static RelaxSchemaGenerator create(Project project, Model model) {
        RelaxSchemaBaseGenerator gen = null;
        if (!model.getUseRelax()) {
            return gen;
        }
        String type = model.getType();
        if ("store".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                gen = new RelaxSchemaStoreGenerator(project, model);
            }
        } else if ("presentation".equals(type)) {
            IRNode node;
            if (!model.getNoUseRelaxer() && (node = model.getIdrefAsIRNode()) != null && node instanceof Model) {
                Model smodel = (Model)node;
                if ("store".equals(smodel.getType())) {
                    gen = new RelaxSchemaPresentationGenerator(project, model);
                } else if ("list".equals(smodel.getType())) {
                    gen = new RelaxSchemaListPGenerator(project, model);
                } else if ("condition".equals(smodel.getType())) {
                    gen = new RelaxSchemaCondPGenerator(project, model);
                } else if ("total".equals(smodel.getType())) {
                    gen = new RelaxSchemaTotalPGenerator(project, model);
                }
            }
        } else if ("condition".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                gen = new RelaxSchemaConditionGenerator(project, model);
            }
        } else if ("list".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                gen = new RelaxSchemaListGenerator(project, model);
            }
        } else if ("total".equals(type)) {
            if (!model.getNoUseRelaxer()) {
                gen = new RelaxSchemaTotalGenerator(project, model);
            }
        } else if ("master".equals(type)) {
            gen = new RelaxSchemaMasterGenerator(project, model);
        } else if (!"reserved".equals(type)) {
            logger.warn(rman.getValue("relax.comment.emptytask", model.getId()));
            gen = new RelaxSchemaEmptyGenerator(project, model);
        }
        return gen;
    }
}

