/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ReplaceMapHelperGenerator_List;
import jp.jasminesoft.jfc.gen.ReplaceMapHelperGenerator_Store;
import jp.jasminesoft.jfc.gen.ReplaceTypeMapHelperGenerator_List;
import jp.jasminesoft.jfc.gen.ReplaceTypeMapHelperGenerator_Store;
import jp.jasminesoft.jfc.gen.ReplaceTypeMapHelperGenerator_base;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.TemplateExcelReportChildListFileGenerator;
import jp.jasminesoft.jfc.gen.TemplateExcelReportFileGenerator;
import jp.jasminesoft.jfc.gen.TemplateExcelReportGenerator;
import jp.jasminesoft.jfc.gen.TemplateExcelReportListFileGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public class ReplaceMapHelperGenerator_base
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "app";
    private Model[] models = null;
    private Model smodel = null;
    protected String[] defaultImportStatement = new String[]{"java.util.*", "java.text.SimpleDateFormat", "jp.jasminesoft.jfc.*", "jp.jasminesoft.jfc.app.ForeignKeyReplaceMapProxy", "jp.jasminesoft.jfc.app.RelationReplaceMapProxy", "jp.jasminesoft.jfc.app.ReplaceMap", "jp.jasminesoft.jfc.app.ReplaceMapHelperBase", "jp.jasminesoft.util.*", "org.apache.logging.log4j.Logger", "org.apache.logging.log4j.LogManager"};

    public ReplaceMapHelperGenerator_base(Project project, Model[] models) {
        super(project);
        this.models = models;
        if (this.models != null) {
            for (int i = 0; i < this.models.length; ++i) {
                if (!AppSchemaUtil.isStoreModel(models[i])) continue;
                this.smodel = models[i];
                break;
            }
        }
    }

    @Override
    public String getClassname() {
        return "ReplaceMapHelper";
    }

    public String getClassExplanation() {
        return rman.getValue("replacemaphelper.comment.class");
    }

    public String gClassDeclaration() {
        StringBuilder sb = new StringBuilder();
        Model pmodel = AppSchemaUtil.getModel(this.project, this.smodel.getId(), "presentation");
        sb.append("public class ");
        sb.append(this.getClassname());
        sb.append(" extends ReplaceMapHelperBase");
        sb.append("<");
        sb.append(AppSchemaUtil.getClassname(pmodel));
        sb.append(">");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String[] getDefaultImport() {
        return this.defaultImportStatement;
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, AppSchemaUtil.getStoreModel(this.smodel));
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, AppSchemaUtil.getStoreModel(this.smodel));
    }

    protected String gHeader() {
        String[] ary;
        StringBuilder sb = new StringBuilder();
        boolean useCVSFlag = this.project.getUseCVS();
        if (useCVSFlag) {
            sb.append("/*");
            sb.append(CR);
            sb.append(" * $Id:$");
            sb.append(CR);
            sb.append(" */");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if (this.project.getPackage() != null) {
            sb.append("package ");
            sb.append(this.project.getPackage());
            sb.append(".");
            sb.append(this.getSubpackageNameAsJavaRule());
            sb.append(";");
            sb.append(CR);
            sb.append("");
            sb.append(CR);
        }
        if ((ary = this.getDefaultImport()) != null) {
            for (int i = 0; i < ary.length; ++i) {
                sb.append("import ");
                sb.append(ary[i]);
                sb.append(";");
                sb.append(CR);
            }
        }
        TreeSet<String> importSet = new TreeSet<String>();
        Model model = null;
        if (this.models != null) {
            for (int i = 0; i < this.models.length; ++i) {
                model = this.models[i];
                Model pmodel = AppSchemaUtil.getModel(this.project, model.getId(), "presentation");
                String s = AppSchemaUtil.getPackagename(pmodel, this.project);
                if (s != null && s.length() > 0) {
                    s = s + "*";
                    importSet.add(s);
                }
                if (!AppSchemaUtil.isStoreModel(model)) continue;
                s = this.project.getPackage() + "." + SUB_PACKAGE_NAME + "." + model.getId() + ".*";
                importSet.add(s);
            }
        }
        for (String stmt : importSet) {
            sb.append("import ");
            sb.append(stmt);
            sb.append(";");
            sb.append(CR);
        }
        sb.append("");
        sb.append(CR);
        sb.append("/**");
        sb.append(CR);
        sb.append(" * " + AppSchemaUtil.getTitle(this.project));
        sb.append(CR);
        String[] comment_str = StringUtil.separateLine((String)this.getClassExplanation(), (int)72);
        if (comment_str != null) {
            for (int i = 0; i < comment_str.length; ++i) {
                sb.append(" * ");
                sb.append(comment_str[i]);
                sb.append(CR);
            }
        }
        sb.append(" *");
        sb.append(CR);
        if (useCVSFlag) {
            sb.append(" * @version $Revision:$ ");
            sb.append("$Date:$");
            sb.append(CR);
        }
        sb.append(" * @author " + this.project.getAuthor());
        sb.append(CR);
        sb.append(" */");
        sb.append(CR);
        sb.append("");
        sb.append(CR);
        return sb.toString();
    }

    @Override
    public String process0() {
        AppSchemaUtil.getReplaceMapHelperClassname4Dicon(this.smodel, this.project);
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader());
        sb.append(this.gClassDeclaration());
        sb.append(this.gBegin());
        sb.append(this.gLoggerReady(this.getClassname()));
        sb.append(this.gVariable());
        sb.append(this.gGetMethod());
        sb.append(this.gEnd());
        return sb.toString();
    }

    protected String gVariable() {
        return "";
    }

    protected String gGetMethod() {
        TemplateExcelReportGenerator gen;
        Set filenames;
        List processedKeyList;
        StringBuilder sb = new StringBuilder();
        if (this.models == null) {
            return sb.toString();
        }
        HashMap<String, List> rmap4smodel = new HashMap<String, List>();
        HashMap<String, List> rmap4lmodel = new HashMap<String, List>();
        HashMap pname_map4smodel = new HashMap();
        HashMap pname_map4lmodel = new HashMap();
        for (int i = 0; i < this.models.length; ++i) {
            ReplaceTypeMapHelperGenerator_base rtgen;
            Object rgen;
            Model model = this.models[i];
            String type = model.getType();
            ArrayList<Action> actionList = new ArrayList<Action>();
            if ("store".equals(type)) {
                actionList.add(AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "show"));
                actionList.add(AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "insert"));
                actionList.add(AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "copy"));
                actionList.add(AppSchemaUtil.getActionByModelIdAndType(this.project, model.getId(), "update"));
            } else if ("list".equals(type)) {
                Model smodel = (Model)model.getIdrefAsIRNode();
                actionList.add(AppSchemaUtil.getActionByModelIdAndType(this.project, smodel.getId(), "showList"));
            }
            for (Action action : actionList) {
                Print[] prints = AppSchemaUtil.getPrint(action);
                if (prints == null || prints.length <= 0) continue;
                HashSet<String> filenames2 = null;
                if ("store".equals(type)) {
                    filenames2 = (HashSet<String>)pname_map4smodel.get(model.getId());
                } else if ("list".equals(type)) {
                    filenames2 = (Set)pname_map4lmodel.get(model.getId());
                }
                if (filenames2 == null) {
                    filenames2 = new HashSet<String>();
                }
                Print[] printArray = prints;
                int n = printArray.length;
                for (int j = 0; j < n; ++j) {
                    Print print = printArray[j];
                    Printlayout printlayout = (Printlayout)print.getIdrefAsIRNode();
                    filenames2.add(printlayout.getFilename());
                }
                if ("store".equals(type)) {
                    pname_map4smodel.put(model.getId(), filenames2);
                    continue;
                }
                if (!"list".equals(type)) continue;
                pname_map4lmodel.put(model.getId(), filenames2);
            }
            if ("store".equals(type) || "condition".equals(type)) {
                rgen = new ReplaceMapHelperGenerator_Store(this.project, model);
                sb.append(((ReplaceMapHelperGenerator_Store)rgen).process());
                rtgen = new ReplaceTypeMapHelperGenerator_Store(this.project, model);
                sb.append(((ReplaceTypeMapHelperGenerator_Store)rtgen).process());
                this.setTypeInfo(((ReplaceMapHelperGenerator_Store)rgen).processedKeyList, ((ReplaceTypeMapHelperGenerator_Store)rtgen).processedTypeMap);
                rmap4smodel.put(model.getId(), ((ReplaceMapHelperGenerator_Store)rgen).processedKeyList);
            }
            if (!"list".equals(type)) continue;
            rgen = new ReplaceMapHelperGenerator_List(this.project, model);
            sb.append(((ReplaceMapHelperGenerator_Store)rgen).process());
            rtgen = new ReplaceTypeMapHelperGenerator_List(this.project, model);
            sb.append(((ReplaceTypeMapHelperGenerator_List)rtgen).process());
            this.setTypeInfo(((ReplaceMapHelperGenerator_List)rgen).processedKeyList, ((ReplaceTypeMapHelperGenerator_List)rtgen).processedTypeMap);
            rmap4lmodel.put(model.getId(), ((ReplaceMapHelperGenerator_List)rgen).processedKeyList);
        }
        for (String mid : rmap4smodel.keySet()) {
            processedKeyList = (List)rmap4smodel.get(mid);
            filenames = (Set)pname_map4smodel.get(mid);
            if (filenames == null) continue;
            for (String filename : filenames) {
                if (!StringUtils.isNotBlank((String)filename)) continue;
                gen = new TemplateExcelReportFileGenerator(filename);
                gen.process(processedKeyList);
            }
        }
        for (String mid : rmap4lmodel.keySet()) {
            processedKeyList = (List)rmap4lmodel.get(mid);
            filenames = (Set)pname_map4lmodel.get(mid);
            if (filenames != null) {
                for (String filename : filenames) {
                    if (!StringUtils.isNotBlank((String)filename)) continue;
                    gen = new TemplateExcelReportListFileGenerator(filename);
                    gen.process(processedKeyList);
                }
                continue;
            }
            Model model = AppSchemaUtil.getStoreModel(AppSchemaUtil.getModel(this.project, mid));
            ForeignKey[] fkeys = AppSchemaUtil.getForeignKey(model);
            if (fkeys == null || fkeys.length == 0) continue;
            HashSet<String> processedFnameSet = new HashSet<String>();
            for (ForeignKey fkey : fkeys) {
                Print[] prints;
                Model fmodel = (Model)fkey.getIdrefAsIRNode();
                Action action = AppSchemaUtil.getActionByModelIdAndType(this.project, fmodel.getId(), "show");
                if (action == null || (prints = AppSchemaUtil.getPrint(action)) == null || prints.length == 0) continue;
                StringBuilder fname = new StringBuilder();
                fname.append("showList").append(SourceGenerator.capFirst(model.getId() + "_lp"));
                fname.append("In").append(SourceGenerator.capFirst(fmodel.getId()));
                if (processedFnameSet.contains(fname.toString())) continue;
                TemplateExcelReportChildListFileGenerator gen2 = new TemplateExcelReportChildListFileGenerator(fname.toString());
                gen2.process(processedKeyList);
                processedFnameSet.add(fname.toString());
            }
        }
        return sb.toString();
    }

    private void setTypeInfo(List processedKeyList, Map<String, String> processedTypeMap) {
        int size = processedKeyList.size();
        for (int i = 0; i < size; ++i) {
            Object o = processedKeyList.get(i);
            if (o instanceof LabelPlaceHolderPair) {
                String type;
                LabelPlaceHolderPair p = (LabelPlaceHolderPair)o;
                String key = this.changeProperKeyName(p.placeholder);
                if (key == null || !StringUtils.isNotBlank((String)(type = processedTypeMap.get(key)))) continue;
                p.type = type;
                continue;
            }
            if (!(o instanceof List)) continue;
            List ilist = (List)o;
            for (LabelPlaceHolderPair p : ilist) {
                String type;
                String key = this.changeProperKeyName(p.placeholder);
                if (key == null || !StringUtils.isNotBlank((String)(type = processedTypeMap.get(key)))) continue;
                p.type = type;
            }
        }
    }

    private String changeProperKeyName(String s) {
        if (s.endsWith(".#")) {
            s = s.substring(0, s.length() - ".#".length());
        }
        s = s.replace(".0.", ".\"+(_i)+\".");
        s = s.replace(".1.", ".\"+(_i)+\".");
        s = s.replace(".2.", ".\"+(_i)+\".");
        s = s.replace(".3.", ".\"+(_i)+\".");
        s = s.replace(".4.", ".\"+(_i)+\".");
        s = s.replace(".5.", ".\"+(_i)+\".");
        s = s.replace(".6.", ".\"+(_i)+\".");
        s = s.replace(".7.", ".\"+(_i)+\".");
        s = s.replace(".8.", ".\"+(_i)+\".");
        s = s.replace(".9.", ".\"+(_i)+\".");
        return s;
    }

    public static class LabelPlaceHolderPair {
        public String label;
        public String placeholder;
        public String type;

        public LabelPlaceHolderPair(String label, String placeholder) {
            this.label = label;
            this.placeholder = placeholder;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.label).append("=").append(this.placeholder).append(" (").append(this.type).append(") ").append("]");
            return sb.toString();
        }
    }
}

