/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.ApplicationContextBeanByName;
import jp.jasminesoft.jfc.gen.CommentGenerator;
import jp.jasminesoft.jfc.gen.ControllerGenerator;
import jp.jasminesoft.jfc.gen.ControllerGenerator2;
import jp.jasminesoft.jfc.gen.ControllerGenerator2_showList;
import jp.jasminesoft.jfc.gen.HookProcessor;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.ReportUtils;
import jp.jasminesoft.jfc.gen.StrutsGeneratorDataitem_list;
import jp.jasminesoft.jfc.gen.SubpackageUtil;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportListServiceImplGenerator
extends JavaSourceGenerator
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)ReportListServiceImplGenerator.class.getName());
    private static final String TEMPLATE_FILE_PATH = "template/javasrc/app/ReportListServiceImpl.vm";
    private static final String SUB_PACKAGE_NAME = "app";
    protected String modelid;
    protected List<Action> actions;
    protected Model smodel;
    private boolean useJasperreports;
    private static final Pattern ReplaceReturnCodeInDoPrintPattern = Pattern.compile("return (\"[^\"]*\");");
    protected StringBuilder hsb = new StringBuilder();
    protected Set<String> hookMethodSet = new LinkedHashSet<String>();

    public ReportListServiceImplGenerator(Project project, String modelid, List<Action> actions) {
        super(project);
        this.modelid = modelid;
        this.actions = actions;
        this.smodel = AppSchemaUtil.getModel(project, modelid);
    }

    protected String getTemplateFilePath() {
        return TEMPLATE_FILE_PATH;
    }

    @Override
    public String getClassname() {
        return ReportListServiceImplGenerator.capFirst(this.modelid) + "ReportListServiceImpl";
    }

    @Override
    public String getSubpackageName() {
        return SubpackageUtil.createPackageNameDir(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    private Model getStoreModel() {
        return this.smodel;
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return SubpackageUtil.createPackageName(SUB_PACKAGE_NAME, this.getStoreModel());
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        this.useJasperreports = false;
        this.gActionNamesArray(sb);
        this.gGetTemplateId(sb);
        this.gGetActionName(sb);
        sb.append(this.gGetDataBindingContext());
        this.gDoPrint(sb);
        for (Action action : this.actions) {
            this.process0(action, sb);
        }
        sb.append((CharSequence)this.hsb);
        Map<String, Object> map = this.createParameterMap();
        map.put("usejasperreports", this.useJasperreports);
        map.put("code", sb.toString());
        return VelocityUtils.mergeContent((String)this.getTemplateFilePath(), map);
    }

    private void gActionNamesArray(StringBuilder sb) {
        sb.append("    ");
        sb.append("private final static ActionName[] ACTION_NAMES = {");
        sb.append(CR);
        for (Action action : this.actions) {
            String screentype = ReportListServiceImplGenerator.getScreentype(action);
            if (screentype == null) continue;
            Print[] prints = AppSchemaUtil.getPrint(action);
            for (int i = 0; i < prints.length; ++i) {
                String templateid;
                Print print = prints[i];
                Printlayout pl = (Printlayout)print.getIdrefAsIRNode();
                if (pl == null || (templateid = ReportUtils.getTemplateId(pl.getFilename())) == null) continue;
                sb.append("        ");
                sb.append("new ActionName(\"");
                sb.append(screentype);
                sb.append("\", \"");
                sb.append(print.getAction());
                sb.append("\", \"");
                sb.append(templateid);
                sb.append("\"),");
                sb.append(CR);
            }
        }
        sb.append("    ");
        sb.append("};");
        sb.append(CR);
        sb.append("    ");
        sb.append("private final static Map<String, ActionName> ACTION_NAME_MAP = new HashMap<>();");
        sb.append(CR);
        sb.append(CR);
        sb.append("    ");
        sb.append("static {");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (ActionName nameinfo : ACTION_NAMES) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("ACTION_NAME_MAP.put(nameinfo.getTemplateId(), nameinfo);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void gGetTemplateId(StringBuilder sb) {
        sb.append("    ");
        sb.append("public Set<String> getTemplateId() {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return Collections.unmodifiableSet(ACTION_NAME_MAP.keySet());");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    private void gGetActionName(StringBuilder sb) {
        sb.append("    ");
        sb.append("public ActionName getActionName(String templateid) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("return ACTION_NAME_MAP.get(templateid);");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    public ApplicationContextBean getApplicationContextBean() {
        ApplicationContextBeanByName bean = new ApplicationContextBeanByName(ReportListServiceImplGenerator.capFirst(this.modelid) + "ReportListService", this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule() + "." + this.getClassname(), null, true);
        bean.addProperty("entityService", new ApplicationContextBean.ReferenceElement(ReportListServiceImplGenerator.capFirst(this.modelid) + "EntityService"));
        bean.addProperty("conditionHelper", new ApplicationContextBean.ReferenceElement(ReportListServiceImplGenerator.capFirst(this.modelid) + "CHelper"));
        return bean;
    }

    private Map<String, Object> createParameterMap() {
        Model smodel = this.getStoreModel();
        Map<String, Object> map = ControllerGenerator.createParameterMap(this.project, smodel);
        map.put("packageName", this.getPackage());
        map.put("className", this.getClassname());
        TreeSet<String> condFullClassNameSet = new TreeSet<String>();
        TreeSet<String> condPFullClassNameSet = new TreeSet<String>();
        String cPackageName = null;
        String cClassName = null;
        for (Action action : this.actions) {
            Model cmodel = AppSchemaUtil.getConditionModel(this.project, action);
            String cpackagename = AppSchemaUtil.getPackagename(cmodel, this.project);
            String cclassname = AppSchemaUtil.getClassname(cmodel);
            condFullClassNameSet.add(cpackagename + cclassname);
            if (cClassName == null) {
                cPackageName = cpackagename;
                cClassName = cclassname;
            }
            Conditionlist conditionlist = AppSchemaUtil.getConditionlist(action);
            String cond_p_id = conditionlist.getParameter();
            IRNode node = conditionlist.getParameterAsIRNode();
            if (cond_p_id == null || node == null || !(node instanceof Model)) continue;
            Model cond_p_model = (Model)node;
            String cond_p_packagename = AppSchemaUtil.getPackagename(cond_p_model, this.project);
            String cond_p_classname = AppSchemaUtil.getClassname(cond_p_model);
            condPFullClassNameSet.add(cond_p_packagename + cond_p_classname);
        }
        map.put("cFullClassNames", condFullClassNameSet);
        map.put("cpFullClassNames", condPFullClassNameSet);
        map.put("cPackageName", cPackageName);
        map.put("cClassName", cClassName);
        return map;
    }

    protected String gGetDataBindingContext() {
        Model smodel = this.getStoreModel();
        Action action = this.actions.get(0);
        return new ControllerGenerator2_showList(this.project, action).gGetDataBindingContext(smodel);
    }

    public void process0(Action action, StringBuilder sb) {
        Model smodel = this.getStoreModel();
        this.gDoPrintService(smodel, action, sb);
    }

    private void gDoPrint(StringBuilder sb) {
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, this.actions.get(0));
        String cclassname = AppSchemaUtil.getClassname(cmodel);
        String[] msg_param = new String[]{"p ActionParameter"};
        String[] msg_exception = new String[]{"IOException", "ServletException"};
        sb.append(CommentGenerator.gComment(rman.getValue("struts.comment.setdata"), msg_param, "String", msg_exception));
        JavaSourceGenerator.putAnnotation(sb, "@Override", "    ");
        sb.append("    ");
        sb.append("public String do_print(");
        sb.append("ActionParameter p, ");
        sb.append("FinderContext<" + cclassname + "> finderContext, ");
        sb.append("int limit, ");
        sb.append("boolean printAllPage, ");
        sb.append("String controllerClassname, ");
        sb.append("String screentype, ");
        sb.append("String action)");
        sb.append(CR);
        sb.append("        ");
        sb.append("throws ");
        for (int i = 0; i < msg_exception.length - 1; ++i) {
            sb.append(msg_exception[i] + ", ");
        }
        sb.append(msg_exception[msg_exception.length - 1]);
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        for (Action action : this.actions) {
            String screentype = ReportListServiceImplGenerator.getScreentype(action);
            if (screentype == null) continue;
            sb.append("        ");
            sb.append("if (screentype.equals(\"");
            sb.append(screentype);
            sb.append("\")) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("return do_print_");
            sb.append(action.getId());
            sb.append("(");
            sb.append("p, ");
            sb.append("finderContext, ");
            sb.append("limit, ");
            sb.append("printAllPage, ");
            sb.append("controllerClassname, ");
            sb.append("screentype, ");
            sb.append("action);");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
    }

    public static String getScreentype(Action action) {
        if (action.getId().startsWith("showList")) {
            return "showList";
        }
        if (action.getId().startsWith("reportList")) {
            return "reportList";
        }
        return null;
    }

    private void gDoPrintService(Model model, Action action, StringBuilder sb) {
        boolean isDefineArray;
        String screentype = ReportListServiceImplGenerator.getScreentype(action);
        if (screentype == null) {
            return;
        }
        String id = model.getId();
        String classname = AppSchemaUtil.getClassname(model);
        Model cmodel = AppSchemaUtil.getConditionModel(this.project, this.actions.get(0));
        String cclassname = AppSchemaUtil.getClassname(cmodel);
        Datalist datalist = AppSchemaUtil.getDatalist(action);
        if (datalist == null) {
            throw new IllegalStateException();
        }
        Dataitem[] dataitems = datalist.getDataitem();
        if (dataitems == null || dataitems.length == 0) {
            throw new IllegalStateException();
        }
        Dataitem dataitem = dataitems[0];
        IRNode node = dataitem.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            throw new IllegalStateException();
        }
        Model rmodel = (Model)node;
        String[] msg_param = new String[]{"p ActionParameter"};
        String[] msg_exception = new String[]{"IOException", "ServletException"};
        sb.append(CommentGenerator.gComment(rman.getValue("struts.comment.setdata"), msg_param, "String", msg_exception));
        sb.append("    ");
        sb.append("public String do_print_");
        sb.append(action.getId());
        sb.append("(");
        sb.append("ActionParameter p, ");
        sb.append("FinderContext<" + cclassname + "> finderContext, ");
        sb.append("int limit, ");
        sb.append("boolean printAllPage, ");
        sb.append("String controllerClassname, ");
        sb.append("String screentype, ");
        sb.append("String action)");
        sb.append(CR);
        sb.append("        ");
        sb.append("throws ");
        for (int i = 0; i < msg_exception.length - 1; ++i) {
            sb.append(msg_exception[i] + ", ");
        }
        sb.append(msg_exception[msg_exception.length - 1]);
        sb.append(CR);
        sb.append("    ");
        sb.append("{");
        sb.append(CR);
        sb.append("        ");
        sb.append("String _forward = null;");
        sb.append(CR);
        sb.append("        ");
        sb.append("List<" + classname + "> coll = new ArrayList<" + classname + ">();");
        sb.append(CR);
        sb.append(CR);
        sb.append("        ");
        sb.append("if (printAllPage) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("finderContext = new FinderContext<");
        sb.append(cclassname);
        sb.append(">(finderContext);");
        sb.append(CR);
        sb.append("            ");
        sb.append("finderContext.first();");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (limit > 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("finderContext.setPageSize(limit);");
        sb.append(CR);
        sb.append("            ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("                ");
        sb.append("finderContext.setPageSize(0);");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        Model smodel = this.getStoreModel();
        String sclassname = AppSchemaUtil.getClassname(smodel);
        sb.append("            ");
        sb.append("List<");
        sb.append(sclassname);
        sb.append("> coll0 = find(finderContext, p);");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (coll0 != null && coll0.size() > 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("coll.addAll(coll0);");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("            ");
        sb.append("List<");
        sb.append(sclassname);
        sb.append("> coll0 = find(finderContext, p);");
        sb.append(CR);
        sb.append("            ");
        sb.append("if (coll0 != null && coll0.size() != 0) {");
        sb.append(CR);
        sb.append("                ");
        sb.append("if (limit > 0 && coll0.size() > limit) {");
        sb.append(CR);
        sb.append("                    ");
        sb.append("coll0 = coll0.subList(0, limit);");
        sb.append(CR);
        sb.append("                ");
        sb.append("}");
        sb.append(CR);
        sb.append("                ");
        sb.append("coll.addAll(coll0);");
        sb.append(CR);
        sb.append("            ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append(this.gHook("do_print", "before_output", "        ", action));
        StrutsGeneratorDataitem_list sgen = new StrutsGeneratorDataitem_list(this.project, action);
        sb.append(sgen.gOutputData_list0(model, rmodel, dataitem, datalist, false, false));
        String outputData_condition_code = this.gOutputData_condition(action);
        boolean isOutputData_condition = false;
        if (outputData_condition_code != null && outputData_condition_code.length() > 0) {
            sb.append(outputData_condition_code);
            isOutputData_condition = true;
        }
        sb.append(CR);
        String code1 = sb.toString();
        if (code1.indexOf(" coll = ") > 0) {
            sb.append("        ");
            sb.append("coll = null;");
            sb.append(CR);
        }
        boolean bl = isDefineArray = code1.indexOf(" array = ") > 0;
        if (isDefineArray) {
            sb.append("        ");
            sb.append("if (! new ScriptCodeRunner(\"").append(id).append("\").isProcessable(controllerClassname, \"print\", p)) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("array = null;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
        if (code1.indexOf(".s2l(array, p);") > 0) {
            Model rmodel0 = null;
            IRNode node1 = rmodel.getIdrefAsIRNode();
            if (node1 != null && node1 instanceof Model) {
                rmodel0 = (Model)node1;
            }
            if (rmodel0 != null) {
                sb.append("        ");
                sb.append(AppSchemaUtil.getHelperClassname4Dicon(rmodel0, this.project));
                sb.append(".clearRequestCache(p);");
                sb.append(CR);
            }
        }
        if (code1.indexOf(" _list =") > 0) {
            sb.append("        ");
            sb.append("_list = null;");
            sb.append(CR);
        }
        if (code1.indexOf(" items = ") > 0) {
            sb.append("        ");
            sb.append("items = null;");
            sb.append(CR);
        }
        sb.append(CR);
        String rid = rmodel.getId();
        String rclassname = AppSchemaUtil.getClassname(rmodel);
        sb.append("        ");
        sb.append("// " + rman.getValue("struts.comment.print.start", rid));
        sb.append(CR);
        StringBuilder sb2 = new StringBuilder();
        Print[] prints = AppSchemaUtil.getPrint(action);
        for (int i = 0; i < prints.length; ++i) {
            String methodName;
            Print print = prints[i];
            Printlayout printlayout = null;
            node = print.getIdrefAsIRNode();
            if (node != null && node instanceof Printlayout) {
                printlayout = (Printlayout)node;
            }
            if (printlayout == null) continue;
            String type = printlayout.getType();
            String library = printlayout.getUselibrary();
            if ("pdf".equals(type)) {
                if (library == null || library.equals("")) {
                    library = "fop";
                }
            } else if ("excel".equals(type)) {
                if (library == null || library.equals("")) {
                    library = "poi";
                }
            } else if ("rtf".equals(type)) {
                if (library == null || library.equals("")) {
                    library = "jasperreports";
                }
            } else {
                Object[] o = new Object[]{action.getId(), print.getIdref(), type};
                logger.error(rman.getValue("struts.comment.print.invalidtype", o));
            }
            if ("jasperreports".equals(library)) {
                this.useJasperreports = true;
            }
            sb.append("        ");
            if (i == 0) {
                sb.append("if");
            } else {
                sb.append("} else if");
            }
            sb.append(" (action.equals(\"");
            sb.append(print.getAction());
            sb.append("\")) {");
            sb.append(CR);
            if ("pdf".equals(type) && "fop".equals(library)) {
                methodName = "do_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
                sb.append("            ").append("_forward = ").append(methodName).append("(cond_p, _listp, finderContext, p);").append(CR);
            } else if ("jasperreports".equals(library) || "excel".equals(type) && ("jexcelapi".equals(library) || "poi".equals(library))) {
                methodName = "createReplaceMap_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
                sb.append("            ").append("ShowListPrintData _data = ").append(methodName).append("(cond_p, _listp, finderContext, p);").append(CR);
                sb.append("            ").append("_listp = null;").append(CR);
                sb.append("            ").append("finderContext = null;").append(CR);
                sb.append("            ").append("if (_data.getErrorforward() != null) {").append(CR);
                sb.append("                ").append("return _data.getErrorforward();").append(CR);
                sb.append("            ").append("}").append(CR);
                methodName = "do_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
                sb.append("            ").append("_forward = ").append(methodName).append("(p, _data);").append(CR);
                sb.append("            ").append("_data = null;").append(CR);
            }
            this.gDoPrint_print(sb2, model, id, classname, rmodel, isOutputData_condition, rclassname, print, printlayout, type, library, cclassname, action, screentype);
        }
        sb.append("        ").append("}").append(CR);
        sb.append("        ").append("final String DownloadTempFileKey = getClass().getName() + \"_print_downloadTempFile\";").append(CR);
        sb.append("        ").append("File downloadTempFile = (File) p.request.getAttribute(DownloadTempFileKey);").append(CR);
        sb.append("        ").append("if (downloadTempFile != null) {").append(CR);
        sb.append("            ").append("p.request.removeAttribute(DownloadTempFileKey);").append(CR);
        sb.append("            ").append("OutputStream ostream = p.response.getOutputStream();").append(CR);
        sb.append("            ").append("try {").append(CR);
        sb.append("                ").append("org.apache.commons.io.FileUtils.copyFile(").append(CR);
        sb.append("                    ").append("downloadTempFile, ostream);").append(CR);
        sb.append("                ").append("ostream.flush();").append(CR);
        sb.append("            ").append("} finally {").append(CR);
        sb.append("                ").append("IOUtils.closeQuietly(ostream);").append(CR);
        sb.append("                ").append("downloadTempFile.delete();").append(CR);
        sb.append("            ").append("}").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append(CR);
        sb.append("        ").append("if (_forward != null) {").append(CR);
        sb.append("            ").append("return _forward;").append(CR);
        sb.append("        ").append("}").append(CR);
        sb.append(CR);
        sb.append(this.gHook("do_print", "after_output", "        ", action));
        if (isDefineArray) {
            sb.append("        ").append("if (array != null) {").append(CR);
            sb.append("            ").append("for (Object _o : array) {").append(CR);
            sb.append("                ").append("p.request.setAttribute(ScriptCodeRunner.JSOBJECTPREFIX+\"").append(id).append("\", _o);").append(CR);
            sb.append("                ").append("String _status = new ScriptCodeRunner(\"").append(id).append("\").process(controllerClassname, \"print\", p);").append(CR);
            sb.append("                ").append("if (StringUtils.isNotBlank(_status)) {").append(CR);
            sb.append("                  ").append("throw new jp.jasminesoft.jfc.core.exception.BusinessLogicException(_status);").append(CR);
            sb.append("                ").append("}").append(CR);
            sb.append("            ").append("}").append(CR);
            sb.append("        ").append("}").append(CR).append(CR);
        }
        sb.append("        ");
        sb.append("return null;");
        sb.append(CR);
        sb.append("    ");
        sb.append("}");
        sb.append(CR);
        sb.append(CR);
        sb.append((CharSequence)sb2);
    }

    protected void gGetPreserveObjectCode(StringBuilder sb, String tab, String classname, String varname, String id, boolean is_define_localvar) {
        ControllerGenerator2._gGetPreserveObjectCode(sb, tab, classname, varname, id, is_define_localvar);
    }

    private ReportUtils createReportUtils(final Action action) {
        ReportUtils reportUtils = new ReportUtils(this.project, action);
        reportUtils.setReturnInputForwardCode("FORWARD_INPUT");
        reportUtils.setHookProcessor(new HookProcessor(){

            @Override
            public String gHook(String method_name, String position, String basetab) {
                return ReportListServiceImplGenerator.this.gHook(method_name, position, basetab, action);
            }
        });
        return reportUtils;
    }

    private void gDoPrint_print(StringBuilder sb2, Model model, String id, String classname, Model rmodel, boolean isOutputData_condition, String rclassname, Print print, Printlayout printlayout, String type, String library, String cclassname, Action action, String screentype) {
        String methodName;
        StringBuilder declare = new StringBuilder();
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(action);
        String cond_p_id = conditionlist.getParameter();
        String cond_p_packagename = null;
        String cond_p_classname = null;
        IRNode node = conditionlist.getParameterAsIRNode();
        if (cond_p_id != null && node != null && node instanceof Model) {
            Model cond_p_model = (Model)node;
            cond_p_packagename = AppSchemaUtil.getPackagename(cond_p_model, this.project);
            cond_p_classname = AppSchemaUtil.getClassname(cond_p_model);
        }
        String list_p_packagename = AppSchemaUtil.getPackagename(rmodel, this.project);
        String list_p_classname = AppSchemaUtil.getClassname(rmodel);
        sb2.append((CharSequence)declare);
        ReportUtils reportUtils = this.createReportUtils(action);
        StringBuilder sb3 = new StringBuilder();
        if ("pdf".equals(type) && "fop".equals(library)) {
            methodName = "do_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
            sb2.append("    ").append("public String ").append(methodName).append("(");
            sb2.append(cond_p_packagename).append(cond_p_classname).append(" cond_p, ");
            sb2.append(list_p_packagename).append(list_p_classname).append(" _listp, ");
            sb2.append("FinderContext<");
            sb2.append(cclassname);
            sb2.append("> finderContext, ActionParameter p)");
            sb2.append(" throws IOException, ServletException {").append(CR);
            sb3.append(reportUtils.gDoPrint0_pdf_fop(model, printlayout, id, classname, "_listp", rclassname));
        } else if ("jasperreports".equals(library)) {
            boolean useConnection = false;
            if ("jdbc".equals(printlayout.getDatasource())) {
                useConnection = true;
            }
            String methodName2 = "createReplaceMap_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
            sb2.append("    ").append("public ShowListPrintData ").append(methodName2).append("(");
            sb2.append(cond_p_packagename).append(cond_p_classname).append(" cond_p, ");
            sb2.append(list_p_packagename).append(list_p_classname).append(" _listp, ");
            sb2.append("FinderContext<");
            sb2.append(cclassname);
            sb2.append("> finderContext, ActionParameter p)");
            sb2.append(" throws IOException, ServletException {").append(CR);
            String code = reportUtils.gDoPrint0_createData(printlayout, "_listp", 2, isOutputData_condition, useConnection, ReportUtils.PrintMode.Single, action, "        ");
            code = ReportListServiceImplGenerator.replaceReturnCodeInDoPrint(code);
            sb2.append(code);
            sb2.append("        ");
            sb2.append("return new ShowListPrintData(_map, _omap, _document);").append(CR);
            sb2.append("    ");
            sb2.append("}").append(CR);
            sb2.append(CR);
            methodName2 = "do_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
            sb2.append("    ").append("public String ").append(methodName2).append("(ActionParameter p, ShowListPrintData _data)");
            sb2.append(" throws IOException, ServletException {").append(CR);
            sb2.append("        ");
            sb2.append("Map _map = _data.getMap();");
            sb2.append(CR);
            sb2.append("        ");
            sb2.append("Map _omap = _data.getOmap();");
            sb2.append(CR);
            sb2.append("        ");
            sb2.append("org.w3c.dom.Document _document = _data.getDocument();");
            sb2.append(CR);
            sb3.append(reportUtils.gDoPrint0_prepare(printlayout, model, "            ", true));
            reportUtils.gDoPrint0_jasperreports(sb3, model, rmodel, printlayout, id, classname, "_listp", rclassname, isOutputData_condition);
        } else if ("excel".equals(type) && ("jexcelapi".equals(library) || "poi".equals(library))) {
            methodName = "createReplaceMap_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
            sb2.append("    ").append("public ShowListPrintData ").append(methodName).append("(");
            sb2.append(cond_p_packagename).append(cond_p_classname).append(" cond_p, ");
            sb2.append(list_p_packagename).append(list_p_classname).append(" _listp, ");
            sb2.append("FinderContext<");
            sb2.append(cclassname);
            sb2.append("> finderContext, ActionParameter p)");
            sb2.append(" throws IOException, ServletException {").append(CR);
            String code = reportUtils.gDoPrint0_createData(printlayout, "_listp", 1, isOutputData_condition, false, ReportUtils.PrintMode.Single, action, "    ");
            code = ReportListServiceImplGenerator.replaceReturnCodeInDoPrint(code);
            sb2.append(code);
            sb2.append("        ");
            sb2.append("return new ShowListPrintData(_map, _typemap);").append(CR);
            sb2.append("    ");
            sb2.append("}").append(CR);
            sb2.append(CR);
            methodName = "do_" + screentype + "_" + StringUtil.convertJavaVariableString((String)print.getAction());
            sb2.append("    ").append("public String ").append(methodName).append("(ActionParameter p, ShowListPrintData _data)");
            sb2.append(" throws IOException, ServletException {").append(CR);
            sb2.append("        ");
            sb2.append("Map _map = _data.getMap();");
            sb2.append(CR);
            sb2.append("        ");
            sb2.append("Map _typemap = _data.getTypemap();");
            sb2.append(CR);
            sb3.append(reportUtils.gDoPrint0_prepare(printlayout, model, "            ", true));
            sb3.append(reportUtils.gDoPrint0_excel_report(model, printlayout, id, classname, "_listp", rclassname, isOutputData_condition));
        }
        String code = sb3.toString();
        String[] lines = StringUtil.split((String)code, (String)CR);
        for (int l = 0; l < lines.length; ++l) {
            int ptr2;
            String line = lines[l];
            if (l < lines.length - 1) {
                sb2.append(line.substring("    ".length())).append(CR);
                continue;
            }
            int RIGHTCOUNT = 0;
            String tmp = sb2.toString();
            int ptr = tmp.lastIndexOf("IOUtils.closeQuietly(_os);");
            if ((ptr = (tmp = tmp.substring(ptr + "IOUtils.closeQuietly(_os);".length())).indexOf("if (")) >= 0 && (ptr2 = tmp.lastIndexOf("FORWARD_INPUT")) > 0) {
                tmp = tmp.substring(ptr2);
                int ptr3 = tmp.indexOf(";");
                tmp = tmp.substring(ptr3 + 1);
                RIGHTCOUNT = 1;
            }
            int count = 0;
            for (int k = 0; k < tmp.length(); ++k) {
                char ch = tmp.charAt(k);
                if (ch != '}') continue;
                ++count;
            }
            if (count == RIGHTCOUNT) {
                String ntab = "    ";
                if (lines[l - 1].startsWith("            ")) {
                    ntab = "        ";
                }
                sb2.append(ntab).append("}").append(CR);
            }
            sb2.append("        ").append("return null;").append(CR);
            sb2.append("    ").append("}").append(CR).append(CR);
        }
    }

    private static String replaceReturnCodeInDoPrint(String code) {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        Matcher mat = ReplaceReturnCodeInDoPrintPattern.matcher(code);
        while (mat.find()) {
            sb.append(code.substring(cnt, mat.start()));
            sb.append("return new ShowListPrintData(" + mat.group(1) + ");");
            cnt = mat.end() + 1;
        }
        if (cnt == 0) {
            return code;
        }
        if (code.length() > cnt) {
            sb.append(code.substring(cnt));
        }
        return sb.toString();
    }

    protected String gOutputData_condition(Action action) {
        StringBuilder sb = new StringBuilder();
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(action);
        if (conditionlist == null) {
            return sb.toString();
        }
        String cond_id = conditionlist.getIdref();
        String cond_classname = null;
        Model cond_model = null;
        IRNode node = conditionlist.getIdrefAsIRNode();
        if (cond_id != null && node != null && node instanceof Model) {
            cond_model = (Model)node;
            cond_classname = AppSchemaUtil.getClassname(cond_model);
        }
        String cond_p_id = conditionlist.getParameter();
        String cond_p_classname = null;
        Model cond_p_model = null;
        node = conditionlist.getParameterAsIRNode();
        if (cond_p_id != null && node != null && node instanceof Model) {
            cond_p_model = (Model)node;
            cond_p_classname = AppSchemaUtil.getClassname(cond_p_model);
        }
        if (cond_classname == null || cond_p_classname == null) {
            return sb.toString();
        }
        sb.append(this.gHook("do_print", "before_getcondition", "        ", action));
        this.gGetPreserveObjectCode(sb, "        ", cond_classname, "cond", cond_id, true);
        sb.append("        ");
        sb.append(cond_p_classname);
        sb.append(" cond_p = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(cond_p_model, this.project));
        sb.append(".s2p(");
        sb.append("cond, p,");
        sb.append(AppSchemaUtil.getHelperClassname(cond_p_model, this.project));
        sb.append(".UPDATE");
        sb.append(");");
        sb.append(CR);
        return sb.toString();
    }

    private String gHook(String method_name, String position, String basetab, Action action) {
        return ControllerGenerator2.gHook(method_name, position, basetab, this.hsb, this.project, action, this.hookMethodSet);
    }
}

