/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.IActionParameter;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HookProcessor;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Print;
import jp.jasminesoft.jfc.gen.appschema.Printlayout;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.repgen.ReportGeneratorBureau;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportUtils
implements ISourceVariable,
IGeneratorFactory,
IActionParameter {
    protected static Logger logger = LogManager.getLogger((String)ReportUtils.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    protected static final int LIBRARY_TYPE_FOP = 0;
    protected static final int LIBRARY_TYPE_EXCEL_REPORT = 1;
    protected static final int LIBRARY_TYPE_JASPERREPORTS = 2;
    protected Project project;
    protected Action action;
    private String modelId;
    private String getInputForwardCode = "(getInputForward(p))";
    private HookProcessor hookProc = null;

    public ReportUtils(Project project, Action action) {
        this.project = project;
        this.action = action;
        this.modelId = action != null && action.getIdrefAsIRNode() != null ? AppSchemaUtil.getStoreModel((Model)action.getIdrefAsIRNode()).getId() : "__empty";
    }

    public void setReturnInputForwardCode(String code) {
        this.getInputForwardCode = code;
    }

    protected String gDoPrint0_pdf_fop(Model model, Printlayout printlayout, String id, String classname, String pid, String pclassname) {
        return this.gDoPrint0_pdf_fop(model, printlayout, id, classname, pid, pclassname, PrintMode.Single, "        ");
    }

    protected String gDoPrint0_pdf_fop(Model model, Printlayout printlayout, String id, String classname, String pid, String pclassname, PrintMode mode, String basetab) {
        StringBuilder sb = new StringBuilder();
        String appname = AppSchemaUtil.getWebappName(this.project);
        String configfilename = "/font/userconfig-ja-win.xml";
        String xsltfilename = printlayout.getFilename();
        if (xsltfilename == null) {
            Object[] o = new Object[]{this.action.getId(), printlayout.getId()};
            logger.error(rman.getValue("struts.comment.print.fop_pdf.invalidparam.xsltfilename", o));
            return "";
        }
        if (!xsltfilename.startsWith("/")) {
            xsltfilename = "/" + xsltfilename;
        }
        sb.append(basetab);
        sb.append("PDFBuilderFactory pdfBuilderFactory = PDFBuilderFactory.getInstance();");
        sb.append(CR);
        sb.append(basetab);
        sb.append("PDFBuilder pdfBuilder = pdfBuilderFactory.newPDFBuilder();");
        sb.append(CR);
        sb.append(CR);
        sb.append(basetab);
        sb.append("String _baseDir = \"");
        sb.append("../webapps/");
        sb.append(StringUtil.convertJavaString((String)appname));
        sb.append("/WEB-INF\";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("String _xsltfilename = \"");
        sb.append(StringUtil.convertJavaString((String)xsltfilename));
        sb.append("\";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("String _configfilename = \"");
        sb.append(StringUtil.convertJavaString((String)configfilename));
        sb.append("\";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("pdfBuilder.createPDF(");
        sb.append(pid);
        sb.append(".toString(),");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("_baseDir,");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("_xsltfilename,");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("_configfilename,");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("p.response);");
        sb.append(CR);
        return sb.toString();
    }

    protected String gDoPrint0_excel_report(Model model, Printlayout printlayout, String id, String classname, String pid, String pclassname) {
        return this.gDoPrint0_excel_report(model, printlayout, id, classname, pid, pclassname, false);
    }

    protected String gDoPrint0_excel_report(Model model, Printlayout printlayout, String id, String classname, String pid, String pclassname, boolean isOutputData_condition) {
        return this.gDoPrint0_excel_report(model, printlayout, id, classname, pid, pclassname, isOutputData_condition, PrintMode.Single, this.action, "        ");
    }

    private ReportGeneratorBureau.ReportType getReportType(Action targetAction) {
        if ("show".equals(targetAction.getType()) || "update".equals(targetAction.getType()) || "insert".equals(targetAction.getType()) || "copy".equals(targetAction.getType())) {
            return ReportGeneratorBureau.ReportType.DETAIL;
        }
        if ("showList".equals(targetAction.getType())) {
            return ReportGeneratorBureau.ReportType.LIST;
        }
        return null;
    }

    protected String gDoPrint0_excel_report(Model model, Printlayout printlayout, String id, String classname, String pid, String pclassname, boolean isOutputData_condition, PrintMode mode, Action targetAction, String basetab) {
        ArrayList<String> containerNameList;
        StringBuilder sb = new StringBuilder();
        if (targetAction == null) {
            targetAction = this.action;
        }
        String tab = null;
        tab = !this.isPrintReportList(printlayout.getId()) ? basetab : basetab + "    ";
        String library = printlayout.getUselibrary();
        String repgen_packagename = "jexcelapi".equals(library) ? "jp.jasminesoft.jfc.repgen.excel.jexcelapi." : "jp.jasminesoft.jfc.repgen.excel.poi.";
        ReportGeneratorBureau.ReportType reportType = this.getReportType(targetAction);
        if (mode != PrintMode.Sheet && ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
            sb.append(tab + "");
            sb.append("final int _SheetNo = 0;").append(CR);
            sb.append(tab + "");
            sb.append("ReportWorkbook _rw = null;").append(CR);
        }
        sb.append(tab + "");
        sb.append("try {");
        sb.append(CR);
        sb.append(tab + "    ");
        if (mode == PrintMode.Sheet) {
            sb.append("WorkbookReportGenerator _repgen = null;");
        } else if (ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
            sb.append(repgen_packagename);
            sb.append("ReportGeneratorImpl _repgen = null;");
        } else if (ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType)) {
            sb.append("ReportGenerator _repgen = null;");
        }
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("_repgen = ");
        if (mode == PrintMode.Sheet) {
            sb.append("(WorkbookReportGenerator)");
        } else if (ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
            sb.append("(").append(repgen_packagename).append("ReportGeneratorImpl)");
        }
        sb.append("ReportGeneratorBureau.getGenerator(ReportGeneratorBureau.GeneratorType.EXCEL_");
        if ("jexcelapi".equals(library)) {
            sb.append("JEXCELAPI");
        } else {
            sb.append("POI");
        }
        sb.append(", ");
        if (ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
            sb.append("ReportGeneratorBureau.ReportType.DETAIL");
        } else if (ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType)) {
            sb.append("ReportGeneratorBureau.ReportType.LIST");
        } else {
            Object[] o = new Object[]{targetAction.getId(), targetAction.getType()};
            logger.error(rman.getValue("struts.comment.print.excel_poi.invalid.actiontype", o));
            return "";
        }
        sb.append(");");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("_repgen.setFailedParametersToWhiteSpace(Boolean.TRUE);");
        sb.append(CR);
        if (mode == PrintMode.Sheet) {
            sb.append(tab + "    ");
            sb.append("ReportWorkbook _rw = (ReportWorkbook)p.request.getAttribute(\"__jfc_printall_reportworkbook\");");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("if (_rw == null) {");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("_rw = _repgen.createReportWorkbook(new File(_baseDir + _templatefilename), _os);");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("p.request.setAttribute(\"__jfc_printall_reportworkbook\", _rw);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("}");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("int _sheetnum = _rw.cloneSheet(0);");
            sb.append(CR);
            containerNameList = new ArrayList();
            for (IModelChoice imc : model.getContent()) {
                Modelitem mitem;
                if (!(imc instanceof Modelitem) || !(mitem = (Modelitem)imc).getHasChild()) continue;
                containerNameList.add(mitem.getName());
            }
            int size = containerNameList.size();
            if (size > 0) {
                sb.append(tab + "    ");
                sb.append(repgen_packagename).append("ContainerReportGeneratorImpl _repgen4cont = null;");
                sb.append(CR);
                sb.append(tab + "    ");
                sb.append("Map<String, Object> _map4cont = null;").append(CR);
                for (int i = 0; i < size; ++i) {
                    String s = (String)containerNameList.get(i);
                    sb.append(tab + "    ");
                    sb.append("_repgen4cont =").append(CR);
                    sb.append(tab + "        ");
                    sb.append("new ").append(repgen_packagename).append("ContainerReportGeneratorImpl(\"");
                    sb.append(model.getId()).append("_p").append(".").append(s);
                    sb.append("\");").append(CR);
                    sb.append(tab + "    ");
                    sb.append("_repgen4cont.setFailedParametersToWhiteSpace(");
                    if (i < size - 1) {
                        sb.append("false");
                    } else {
                        sb.append("_repgen.isFailedParametersToWhiteSpace()");
                    }
                    sb.append(");");
                    sb.append(CR);
                    sb.append(tab + "    ");
                    sb.append("_map4cont = new jp.jasminesoft.jfc.app.ReplaceMap<String, Object>(_map);").append(CR);
                    sb.append(tab + "    ");
                    sb.append("_repgen4cont.generateContainer(_rw, _sheetnum, _map4cont, _typemap");
                    if (i < size - 1) {
                        sb.append(" ,false");
                    }
                    sb.append(");");
                    sb.append(CR);
                    sb.append(CR);
                }
            }
            sb.append(tab + "    ");
            sb.append("if (StringUtils.isNotBlank(_outputfilename)");
            sb.append(" || StringUtils.isNotBlank(_sheetname)");
            sb.append(") {").append(CR);
            sb.append(tab + "        ");
            sb.append("if (_outputfilename.endsWith(\".xls\")) {").append(CR);
            sb.append(tab + "            ");
            sb.append("_outputfilename = _outputfilename.substring(0, _outputfilename.length()-\".xls\".length());").append(CR);
            sb.append(tab + "        ");
            sb.append("} else if (_outputfilename.endsWith(\".xlsx\")) {").append(CR);
            sb.append(tab + "            ");
            sb.append("_outputfilename = _outputfilename.substring(0, _outputfilename.length()-\".xlsx\".length());").append(CR);
            sb.append(tab + "        ");
            sb.append("}").append(CR);
            sb.append(tab + "        ");
            sb.append("_map.put(\"${sheet}\", Integer.toString(_sheetnum));").append(CR);
            sb.append(tab + "        ");
            sb.append("_outputfilename = StringUtil.replaceFilename(_outputfilename, _map);").append(CR);
            sb.append(tab + "        ");
            sb.append("if (StringUtils.isNotBlank(_sheetname)) {").append(CR);
            sb.append(tab + "            ");
            sb.append("_sheetname = StringUtil.replace(_sheetname, _map);").append(CR);
            sb.append(tab + "            ");
            sb.append("_rw.setSheetName(_sheetnum, _sheetname);").append(CR);
            sb.append(tab + "        ");
            sb.append("} else {").append(CR);
            sb.append(tab + "            ");
            sb.append("_rw.setSheetName(_sheetnum, _outputfilename);").append(CR);
            sb.append(tab + "        ");
            sb.append("}").append(CR);
            sb.append(tab + "    ");
            sb.append("}").append(CR);
            sb.append(tab + "    ");
            sb.append("_repgen.generate(_rw, _map, _typemap, _sheetnum);");
            sb.append(CR);
        } else if (ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType)) {
            sb.append(tab + "    ");
            sb.append("_map.put(\"#sheetName\", _sheetname);").append(CR);
            sb.append(tab + "    ");
            sb.append("_repgen.generate(");
            sb.append(CR);
            sb.append(tab + "        ");
            sb.append("new File(_baseDir + _templatefilename), _os, _map, _typemap);");
            sb.append(CR);
        } else if (ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
            sb.append(tab + "    ");
            sb.append("File templateFile = new File(_baseDir + _templatefilename);");
            sb.append(CR);
            if (mode == PrintMode.Batch) {
                sb.append(tab + "    ");
                sb.append("final int TEMPLATEFILE_MAX_SIZE = (Integer.MAX_VALUE >> 1);");
                sb.append(CR);
                sb.append(tab + "    ");
                sb.append("if (templateFile.length() > TEMPLATEFILE_MAX_SIZE) {");
                sb.append(CR);
                sb.append(tab + "        ");
                sb.append("throw new IllegalStateException(\"Template file \" + templateFile + \" is too large.\");");
                sb.append(CR);
                sb.append(tab + "    ");
                sb.append("}");
                sb.append(CR);
                sb.append(tab + "    ");
                sb.append("int bufsize = ((int) templateFile.length()) << 1;");
                sb.append(CR);
                sb.append(tab + "    ");
                sb.append("ByteArrayOutputStream baos = new ByteArrayOutputStream(bufsize);");
                sb.append(CR);
            }
            sb.append(tab + "    ");
            sb.append("_rw = _repgen.createReportWorkbook(");
            sb.append("templateFile, ");
            if (mode == PrintMode.Batch) {
                sb.append("baos);");
            } else {
                sb.append("_os);");
            }
            sb.append(CR);
            containerNameList = new ArrayList<String>();
            IModelChoice[] size = model.getContent();
            int i = size.length;
            for (int s = 0; s < i; ++s) {
                Modelitem mitem;
                IModelChoice imc = size[s];
                if (!(imc instanceof Modelitem) || !(mitem = (Modelitem)imc).getHasChild()) continue;
                containerNameList.add(mitem.getName());
            }
            int size2 = containerNameList.size();
            if (size2 > 0) {
                sb.append(tab + "    ");
                sb.append(repgen_packagename).append("ContainerReportGeneratorImpl _repgen4cont = null;");
                sb.append(CR);
                sb.append(tab + "    ");
                sb.append("Map<String, Object> _map4cont = null;").append(CR);
                for (i = 0; i < size2; ++i) {
                    String s = (String)containerNameList.get(i);
                    sb.append(tab + "    ");
                    sb.append("_repgen4cont =").append(CR);
                    sb.append(tab + "        ");
                    sb.append("new ").append(repgen_packagename).append("ContainerReportGeneratorImpl(\"");
                    sb.append(model.getId()).append("_p").append(".").append(s);
                    sb.append("\");").append(CR);
                    sb.append(tab + "    ");
                    sb.append("_repgen4cont.setFailedParametersToWhiteSpace(");
                    if (i < size2 - 1) {
                        sb.append("false");
                    } else {
                        sb.append("_repgen.isFailedParametersToWhiteSpace()");
                    }
                    sb.append(");");
                    sb.append(CR);
                    sb.append(tab + "    ");
                    sb.append("_map4cont = new jp.jasminesoft.jfc.app.ReplaceMap<String, Object>(_map);").append(CR);
                    sb.append(tab + "    ");
                    sb.append("_repgen4cont.generateContainer(_rw, _SheetNo, _map4cont, _typemap");
                    if (i < size2 - 1) {
                        sb.append(" ,false");
                    }
                    sb.append(");");
                    sb.append(CR);
                    sb.append(CR);
                }
            }
            sb.append(tab + "    ");
            sb.append("_repgen.generate(_rw, _map, _typemap, _SheetNo);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("_rw.setSheetName(_SheetNo, _sheetname);").append(CR);
            sb.append(tab + "    ");
            sb.append("_rw.write();").append(CR);
            if (mode == PrintMode.Batch) {
                sb.append(tab + "    ");
                sb.append("baos.close();").append(CR);
                sb.append(tab + "    ");
                sb.append("baos.writeTo(_os);").append(CR);
            }
        }
        sb.append(tab + "    ");
        sb.append("if (_os != null) {");
        sb.append(CR);
        sb.append(tab + "        ");
        sb.append("_os.flush();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "");
        sb.append("} catch (ReportGeneratorException e) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("Object[] ep = { _outputfilename, e.getMessage() };").append(CR);
        sb.append(tab + "    ");
        sb.append("p.errors.addJfcerror").append(CR);
        sb.append(tab + "        ");
        sb.append("(getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.print\", ep, p.locale));").append(CR);
        sb.append(tab + "    ");
        sb.append("logger.error(e.getMessage());");
        sb.append(CR);
        sb.append(tab + "");
        sb.append("} catch (IOException e) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("Object[] ep = { _outputfilename, e.getMessage() };").append(CR);
        sb.append(tab + "    ");
        sb.append("p.errors.addJfcerror").append(CR);
        sb.append(tab + "        ");
        sb.append("(getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.print\", ep, p.locale));").append(CR);
        sb.append(tab + "    ");
        sb.append("logger.error(e.getMessage());");
        sb.append(CR);
        sb.append(tab + "");
        sb.append("}");
        if (mode == PrintMode.Single) {
            sb.append(" finally {");
            sb.append(CR);
            if (ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
                sb.append(tab + "    ");
                sb.append("if (_rw != null) {").append(CR);
                sb.append(tab + "        ");
                sb.append("try {").append(CR);
                sb.append(tab + "            ");
                sb.append("_rw.close();").append(CR);
                sb.append(tab + "        ");
                sb.append("} catch (ReportGeneratorException e) {").append(CR);
                sb.append(tab + "            ");
                sb.append("logger.error(e.getMessage());");
                sb.append(CR);
                sb.append(tab + "        ");
                sb.append("}").append(CR);
                sb.append(tab + "    ");
                sb.append("}").append(CR);
            }
            sb.append(tab + "    ");
            sb.append("IOUtils.closeQuietly(_os);");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("logger.info(\"id=\" + _templateId + ((_outputfilename != null) ? \",outputfilename=\"+_outputfilename : \"\"));");
            sb.append(CR);
            String templatefilename = printlayout.getFilename();
            if (templatefilename.startsWith("TEMPLATE(")) {
                sb.append(tab + "    ").append("if (_outputType == JfcreporttemplateUtil.OutputType.ServerFolderOverride ||").append(CR);
                sb.append(tab + "        ").append("_outputType == JfcreporttemplateUtil.OutputType.ServerFolderNoOverride) {").append(CR);
                sb.append(tab + "        ").append("Object[] ep = { _outputfilename };").append(CR);
                sb.append(tab + "        ").append("p.errors.addJfcinfo").append(CR);
                sb.append(tab + "            ").append("(getJFCErrorManager().getJfcinfo(\"" + this.modelId + ".success.print\", ep, p.locale));").append(CR);
                sb.append(tab + "        ").append("return " + this.getInputForwardCode + ";").append(CR);
                sb.append(tab + "    ").append("}").append(CR);
            }
            sb.append(tab + "");
            sb.append("}");
        } else if (mode == PrintMode.Batch) {
            sb.append(" finally {");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_zos.closeEntry();");
            sb.append(CR);
            sb.append(basetab);
            sb.append("}");
        }
        sb.append(CR);
        return sb.toString();
    }

    protected void gDoPrint0_jasperreports(StringBuilder sb, Model model, Model rmodel, Printlayout printlayout, String id, String classname, String pid, String pclassname, boolean isOutputData_condition) {
        this.gDoPrint0_jasperreports(sb, model, rmodel, printlayout, id, classname, pid, pclassname, isOutputData_condition, PrintMode.Single, this.action, "        ");
    }

    protected void gDoPrint0_jasperreports(StringBuilder sb, Model model, Model rmodel, Printlayout printlayout, String id, String classname, String pid, String pclassname, boolean isOutputData_condition, PrintMode mode, Action targetAction, String basetab) {
        if (targetAction == null) {
            targetAction = this.action;
        }
        boolean useConnection = false;
        if ("jdbc".equals(printlayout.getDatasource())) {
            useConnection = true;
        }
        boolean useWildCard = false;
        if (AppSchemaUtil.useWildcard(printlayout)) {
            useWildCard = true;
        }
        if (useConnection) {
            sb.append(basetab).append("java.sql.Connection _con = JFCUtils.getConnectionSilently(logger);").append(CR);
        }
        this.gCreateJasperPrintReady4Virtualizer(sb, basetab);
        sb.append(basetab);
        sb.append("try {");
        sb.append(CR);
        if (useWildCard) {
            String tempfilename_header = this.convertProperTemplatefilename(printlayout);
            sb.append(basetab + "    ");
            sb.append("JasperPrint _print = null;").append(CR);
            sb.append(basetab + "    ");
            sb.append("jp.jasminesoft.util.PrefixSuffixFilter _filter =").append(CR);
            sb.append(basetab + "        ");
            sb.append("new jp.jasminesoft.util.PrefixSuffixFilter();").append(CR);
            sb.append(basetab + "    ");
            sb.append("_filter.setPermitPrefix(\"");
            sb.append(tempfilename_header);
            sb.append("\");").append(CR);
            sb.append(basetab + "    ");
            sb.append("_filter.setPermitSuffix(\"");
            sb.append("jrxml");
            sb.append("\");").append(CR);
            sb.append(basetab + "    ");
            sb.append("File _baseDirAsFile = new File(_baseDir);").append(CR);
            sb.append(basetab + "    ");
            sb.append("if (_baseDirAsFile.exists() && _baseDirAsFile.isDirectory()) {").append(CR);
            sb.append(basetab + "        ");
            sb.append("File[] _templatefiles = _baseDirAsFile.listFiles(_filter);").append(CR);
            sb.append(basetab + "        ");
            sb.append("if (ArrayUtils.isNotEmpty(_templatefiles)) {").append(CR);
            sb.append(basetab + "            ");
            sb.append("int _size = _templatefiles.length;").append(CR);
            sb.append(basetab + "            ");
            sb.append("for (int i=0; i<_size; i++) {").append(CR);
            sb.append(basetab + "                ");
            sb.append("File _templatefile = _templatefiles[i];").append(CR);
            sb.append(basetab + "                ");
            sb.append("String _templatefile_suffix = org.apache.commons.io.FilenameUtils.getExtension(_templatefile.getName());").append(CR);
            this.gCreateJasperPrint(sb, basetab + "                ", useConnection, "_report", "__print", "_templatefile_suffix", "_templatefile.getAbsolutePath()");
            sb.append(basetab + "                ");
            sb.append("if (i == 0) {").append(CR);
            sb.append(basetab + "                    ");
            sb.append("_print = __print;").append(CR);
            sb.append(basetab + "                ");
            sb.append("} else {").append(CR);
            sb.append(basetab + "                    ");
            sb.append("List<JRPrintPage> _pages = __print.getPages();").append(CR);
            sb.append(basetab + "                    ");
            sb.append("for (JRPrintPage _page : _pages) {").append(CR);
            sb.append(basetab + "                        ");
            sb.append("_print.addPage(_page);").append(CR);
            sb.append(basetab + "                    ");
            sb.append("}").append(CR);
            sb.append(basetab + "                ");
            sb.append("}").append(CR);
            sb.append(basetab + "            ");
            sb.append("}").append(CR);
            sb.append(basetab + "        ");
            sb.append("}").append(CR);
            sb.append(basetab + "    ");
            sb.append("}").append(CR);
        } else {
            String templatefilename;
            this.gCreateJasperPrint(sb, basetab + "    ", useConnection, "_report", "_print", "_templatefilename_suffix", "_baseDir + _templatefilename");
            if (mode == PrintMode.BatchJasperReport) {
                sb.append(basetab + "    ");
                sb.append("JasperPrint _print_root = (JasperPrint) p.request.getAttribute(\"__jfc_printall_jasperreport\");");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("if (_print_root == null) {");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("p.request.setAttribute(\"__jfc_printall_jasperreport\", _print);");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("} else {");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("List<JRPrintPage> _pages = _print.getPages();");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("for (JRPrintPage _page : _pages) {");
                sb.append(CR);
                sb.append(basetab + "            ");
                sb.append("_print_root.addPage(_page);");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("}");
                sb.append(CR);
                sb.append(basetab + "        ");
                sb.append("_print = _print_root;");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("}");
                sb.append(CR);
            }
            if (StringUtils.isNotBlank((String)(templatefilename = printlayout.getFilename())) && (templatefilename = templatefilename.trim()).startsWith("TEMPLATE(") && templatefilename.endsWith(")")) {
                sb.append(basetab + "    ");
                sb.append("int _clength = StringUtil.intValue(_valueMap.get(\"ctemplatefilelength\"));");
                sb.append(CR);
                sb.append(basetab + "    ");
                sb.append("if (_clength > 0) {").append(CR);
                sb.append(basetab + "        ");
                sb.append("for (int i=0; i<_clength; i++) {").append(CR);
                sb.append(basetab + "            ");
                sb.append("String _ctemplatefilename = _valueMap.get(\"ctemplatefilename.\"+i);").append(CR);
                sb.append(basetab + "            ");
                sb.append("String _ctemplatefilename_suffix = _valueMap.get(\"ctemplatefilename_original_suffix.\"+i);").append(CR);
                this.gCreateJasperPrint(sb, basetab + "            ", useConnection, "__report", "__print", "_ctemplatefilename_suffix", "_ctemplatefilename");
                sb.append(basetab + "            ");
                sb.append("List<JRPrintPage> _pages = __print.getPages();").append(CR);
                sb.append(basetab + "            ");
                sb.append("for (JRPrintPage _page : _pages) {").append(CR);
                sb.append(basetab + "                ");
                sb.append("_print.addPage(_page);").append(CR);
                sb.append(basetab + "            ");
                sb.append("}").append(CR);
                sb.append(basetab + "        ");
                sb.append("}").append(CR);
                sb.append(basetab + "    ");
                sb.append("}").append(CR);
            }
        }
        ReportGeneratorBureau.ReportType reportType = this.getReportType(targetAction);
        if (ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType) && targetAction.getDisplayNoReportDataMessage() && useConnection) {
            sb.append(basetab + "    ");
            sb.append("if (_print == null || _print.getPages() == null || _print.getPages().size() <= 0) {");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("p.errors.addJfcerror(getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.report.nodata\", p.locale));");
            sb.append(CR);
            sb.append(basetab + "        ");
            sb.append("return \"reportListError\";");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("}");
            sb.append(CR);
            String templatefilename = printlayout.getFilename();
            templatefilename = templatefilename.trim();
            String dispositiontype = null;
            if (templatefilename.startsWith("TEMPLATE(")) {
                dispositiontype = " _dispositiontype";
                if (sb.indexOf("String _dispositiontype =") < 0) {
                    sb.append(basetab).append("    ").append("String _dispositiontype = \"inline\";").append(CR);
                }
            } else {
                dispositiontype = "\"" + printlayout.getDispositiontype() + "\"";
            }
            sb.append(basetab + "    ");
            sb.append("p.response.reset();");
            sb.append(CR);
            sb.append(basetab + "    ");
            if ("excel".equals(printlayout.getType())) {
                sb.append("if (_outputfilename.endsWith(\".xlsx\")) {").append(CR);
                sb.append(basetab + "        ");
                sb.append("p.response.setContentType(\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\");").append(CR);
                sb.append(basetab + "    ");
                sb.append("} else {").append(CR);
                sb.append(basetab + "        ");
                sb.append("p.response.setContentType(\"application/vnd.ms-excel\");").append(CR);
                sb.append(basetab + "    ");
                sb.append("}");
            } else {
                sb.append("p.response.setContentType(\"application/" + printlayout.getType() + "\");");
            }
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("p.response.setHeader(\"Cache-Control\", \"no-store, no-cache, must-revalidate, private\");");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("p.response.setHeader(\"Pragma\", \"no-cache\");").append(CR);
            sb.append(basetab + "    ");
            sb.append("p.response.setHeader(\"Expires\", JFCUtils.getHTTPDate());");
            sb.append(CR);
            sb.append(basetab).append("    ").append("p.response.setHeader(\"Content-disposition\",").append(CR);
            sb.append(basetab).append("        ").append("WebStringEncodeUtilities.getContentDisposition(_outputfilename, ").append(CR);
            sb.append(basetab).append("            ").append("p.request, ");
            sb.append(dispositiontype).append("));").append(CR);
            sb.append(basetab + "    ");
            sb.append("_os = p.response.getOutputStream();");
            sb.append(CR);
        }
        if (mode != PrintMode.BatchJasperReport) {
            sb.append(basetab + "    ");
            sb.append("Exporter _exporter = ");
            if ("pdf".equals(printlayout.getType())) {
                sb.append("new JRPdfExporter();");
            } else if ("rtf".equals(printlayout.getType())) {
                sb.append("new JRRtfExporter();");
            } else {
                logger.error("non support printlayout/@type : " + printlayout.getType());
            }
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_exporter.setExporterInput(new SimpleExporterInput(_print));");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(_os));");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("_exporter.exportReport();");
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("} catch (Exception e) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append("logger.error(e.getMessage());");
        sb.append(CR);
        if (ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType) && targetAction.getDisplayNoReportDataMessage() && useConnection) {
            sb.append(basetab + "    ");
            sb.append("p.errors.addJfcerror(getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.report.illegal\", p.locale));");
            sb.append(CR);
            sb.append(basetab + "    ");
            sb.append("return \"reportListError\";");
            sb.append(CR);
        }
        sb.append(basetab);
        sb.append("}");
        if (mode == PrintMode.Single) {
            sb.append(" finally {");
            sb.append(CR);
            sb.append(basetab + "    ").append("if (__virtualizer != null) {").append(CR);
            sb.append(basetab + "        ").append("__virtualizer.cleanup();").append(CR);
            sb.append(basetab + "    ").append("}").append(CR);
            sb.append(basetab + "    ");
            sb.append("IOUtils.closeQuietly(_os);");
            sb.append(CR);
            if (useConnection) {
                sb.append(basetab + "    ").append("JFCUtils.releaseConnectionSilently(_con, logger);").append(CR);
            }
            sb.append(basetab);
            sb.append("}");
        } else if (mode == PrintMode.Batch || mode == PrintMode.BatchJasperReport) {
            sb.append(" finally {");
            sb.append(CR);
            if (mode == PrintMode.Batch) {
                sb.append(basetab + "    ");
                sb.append("_zos.closeEntry();");
                sb.append(CR);
            }
            if (useConnection) {
                sb.append(basetab + "    ").append("JFCUtils.releaseConnectionSilently(_con, logger);").append(CR);
            }
            sb.append(basetab);
            sb.append("}");
        }
        sb.append(CR);
    }

    protected void gCreateJasperPrintReady4Virtualizer(StringBuilder sb, String basetab) {
        sb.append(basetab).append("JRFileVirtualizer __virtualizer = null;").append(CR);
        sb.append(basetab).append("DefaultJasperReportsContext __context = DefaultJasperReportsContext.getInstance();").append(CR);
        sb.append(basetab).append("JRPropertiesUtil.getInstance(__context).setProperty(").append(CR);
        sb.append(basetab + "    ").append("\"net.sf.jasperreports.xpath.executer.factory\",").append(CR);
        sb.append(basetab + "    ").append("\"net.sf.jasperreports.engine.util.xml.JaxenXPathExecuterFactory\");").append(CR);
        sb.append(basetab).append("JasperFillManager __jasperFillManager = JasperFillManager.getInstance(__context);").append(CR);
    }

    protected void gCreateJasperPrint(StringBuilder sb, String basetab, boolean useConnection, String var_report, String var_print, String var_suffix, String var_templatefilenamel) {
        sb.append(basetab);
        sb.append("JasperReport ");
        sb.append(var_report);
        sb.append(";");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (");
        sb.append(var_suffix);
        sb.append(".toLowerCase().equals(\"jasper\")) {");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(var_report);
        sb.append(" = (JasperReport) JRLoader.loadObjectFromFile(");
        sb.append(var_templatefilenamel);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab).append("} else {").append(CR);
        sb.append(basetab + "    ");
        sb.append(var_report);
        sb.append(" = JasperCompileManager.compileReport(");
        sb.append(var_templatefilenamel);
        sb.append(");");
        sb.append(CR);
        sb.append(basetab).append("}").append(CR);
        sb.append(CR);
        if (!useConnection) {
            sb.append(basetab);
            sb.append("_map.put(JRXPathQueryExecuterFactory.PARAMETER_XML_DATA_DOCUMENT, _document);");
            sb.append(CR);
        }
        sb.append(basetab).append("__virtualizer = new JRFileVirtualizer(2, System.getProperty(\"java.io.tmpdir\"));").append(CR);
        sb.append(basetab).append("_map.put(JRParameter.REPORT_VIRTUALIZER, __virtualizer);").append(CR);
        sb.append(basetab);
        sb.append("JasperPrint ");
        sb.append(var_print);
        sb.append(" = __jasperFillManager.fillReport(");
        sb.append(CR);
        sb.append(basetab + "    ");
        sb.append(var_report);
        sb.append(", _map");
        if (useConnection) {
            sb.append(", _con");
        }
        sb.append(");");
        sb.append(CR);
    }

    protected String gDoPrint0_prepare_basedir(Printlayout printlayout, String basetab) {
        StringBuilder sb = new StringBuilder();
        boolean useJfcreporttemplateByValue = false;
        boolean useJfcreporttemplateAsFixValue = false;
        String templatefilename = printlayout.getFilename();
        if (templatefilename == null) {
            Object[] o = new Object[]{this.action.getId(), printlayout.getId()};
            logger.error(rman.getValue("struts.comment.print.excel_poi.invalidparam.xlsfilename", o));
            return "";
        }
        if ((templatefilename = templatefilename.trim()).startsWith("TEMPLATE(") && templatefilename.endsWith(")")) {
            templatefilename = ReportUtils.getNewTemplateId(templatefilename);
            useJfcreporttemplateAsFixValue = true;
        } else {
            templatefilename = ReportUtils.getOldTemplateId(templatefilename);
        }
        String tab = basetab;
        if (useJfcreporttemplateAsFixValue || useJfcreporttemplateByValue) {
            sb.append(tab);
            sb.append("String _baseDir = \"\";").append(CR);
            sb.append(tab);
            sb.append("Map<String, String> _valueMap = new HashMap<String, String>();").append(CR);
            sb.append(tab);
            sb.append("String _templateId = ");
            if (useJfcreporttemplateAsFixValue) {
                sb.append("\"");
                sb.append(templatefilename);
                sb.append("\";").append(CR);
            } else {
                sb.append(this.action.getIdref());
                sb.append(JavaSourceGenerator.getterFullMethod(templatefilename));
                sb.append(";").append(CR);
            }
            sb.append(tab);
            sb.append("JfcreporttemplateUtil.OutputType _outputType =").append(CR);
            sb.append(tab + "    ").append("readReportTemplateValues(");
            sb.append("_templateId, _valueMap, p);").append(CR);
            sb.append(tab);
            sb.append("String _templatefilename = _valueMap.get(\"templatefilename\");").append(CR);
            sb.append(tab);
            sb.append("String _templatefilename_suffix = _valueMap.get(\"templatefilename_original_suffix\");").append(CR);
            sb.append(tab);
            sb.append("String _outputfilename = _valueMap.get(\"outputfilename\");").append(CR);
            sb.append(tab);
            sb.append("String _sheetname = _valueMap.get(\"sheetname\");").append(CR);
        } else {
            sb.append(tab);
            sb.append("javax.servlet.ServletContext _sc = p.request.getSession().getServletContext();");
            sb.append(CR);
            sb.append(tab);
            sb.append("String _baseDir = _sc.getRealPath(\"/WEB-INF/report_templates/");
            if ("jasperreports".equals(printlayout.getUselibrary())) {
                sb.append("jrxml/\");");
            } else {
                sb.append("excel/\");");
            }
            sb.append(CR);
            if (!AppSchemaUtil.useWildcard(printlayout)) {
                sb.append(tab);
                sb.append("String _templatefilename = \"");
                sb.append(StringUtil.convertJavaString((String)templatefilename));
                sb.append("\";");
                sb.append(CR);
                String suffix = "";
                int cnt = templatefilename.lastIndexOf(".");
                if (cnt > 0 && templatefilename.length() > cnt + 1) {
                    suffix = templatefilename.substring(cnt + 1);
                }
                sb.append(tab);
                sb.append("String _templatefilename_suffix = \"");
                sb.append(StringUtil.convertJavaString((String)suffix));
                sb.append("\";");
                sb.append(CR);
            }
            sb.append(tab);
            sb.append("String _sheetname = null;").append(CR);
            sb.append(tab);
            sb.append("String _templateId = null;").append(CR);
        }
        return sb.toString();
    }

    public static String getTemplateId(String templatefilename) {
        if ((templatefilename = templatefilename.trim()).startsWith("TEMPLATE(") && templatefilename.endsWith(")")) {
            return ReportUtils.getNewTemplateId(templatefilename);
        }
        return ReportUtils.getOldTemplateId(templatefilename);
    }

    private static String getNewTemplateId(String templatefilename) {
        templatefilename = templatefilename.substring("TEMPLATE(".length(), templatefilename.length() - ")".length());
        if ((templatefilename = templatefilename.trim()).startsWith("${") && templatefilename.endsWith("}")) {
            templatefilename = templatefilename.substring(2, templatefilename.length() - 1);
        } else if (templatefilename.startsWith("\"") && templatefilename.endsWith("\"")) {
            templatefilename = templatefilename.substring(1, templatefilename.length() - 1);
        }
        return templatefilename;
    }

    private static String getOldTemplateId(String templatefilename) {
        if (!templatefilename.startsWith("/")) {
            templatefilename = "/" + templatefilename;
        }
        return templatefilename;
    }

    protected String gDoPrint0_prepare(Printlayout printlayout, Model model, String basetab) {
        return this.gDoPrint0_prepare(printlayout, model, basetab, false);
    }

    protected String gDoPrint0_prepare(Printlayout printlayout, Model model, String basetab, boolean isOutputTempFile) {
        ReportGeneratorBureau.ReportType reportType;
        String expr;
        String efilename;
        StringBuilder sb = new StringBuilder();
        if (isOutputTempFile) {
            sb.append(basetab);
            sb.append("final String DownloadTempFileKey = getClass().getName() + \"_print_downloadTempFile\";");
            sb.append(CR);
            sb.append(basetab);
            sb.append("p.request.removeAttribute(DownloadTempFileKey);");
            sb.append(CR);
        }
        sb.append(this.gDoPrint0_prepare_basedir(printlayout, basetab));
        String tab = !this.isPrintReportList(printlayout.getId()) ? basetab : basetab + "    ";
        String extension = null;
        extension = "excel".equals(printlayout.getType()) ? "xls" : printlayout.getType();
        String templatefilename = printlayout.getFilename();
        templatefilename = templatefilename.trim();
        if (templatefilename.startsWith("TEMPLATE(")) {
            sb.append(tab);
            sb.append("if (_outputfilename == null || _outputfilename.trim().length() == 0) {").append(CR);
            efilename = printlayout.getOutputfilename();
            if (StringUtils.isNotBlank((String)efilename)) {
                expr = JavaSourceGenerator.parsePlaceHolder(efilename, model);
                sb.append(tab + "    ");
                sb.append("_outputfilename = ");
                sb.append(expr);
                sb.append(" + \"." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            } else if (StringUtils.isNotEmpty((String)templatefilename)) {
                sb.append(tab + "    ");
                sb.append("_outputfilename = ");
                sb.append("_valueMap.get(\"templatefilename_original\")");
                if ("excel".equals(printlayout.getType())) {
                    sb.append(" + \".\" + StringUtils.defaultIfEmpty(_valueMap.get(\"templatefilename_original_suffix\"), \"" + extension + "\")");
                } else {
                    sb.append(" + \"." + extension + "\"");
                }
                sb.append(";");
                sb.append(CR);
            } else {
                sb.append(tab + "    ");
                sb.append("_outputfilename = ");
                sb.append("\"" + this.action.getId() + "." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            }
            sb.append(tab);
            sb.append("}").append(CR);
        } else {
            efilename = printlayout.getOutputfilename();
            if (StringUtils.isNotBlank((String)efilename)) {
                expr = JavaSourceGenerator.parsePlaceHolder(efilename, model);
                sb.append(tab);
                sb.append("String _outputfilename = ");
                sb.append(expr);
                sb.append(" + \"." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            } else if (StringUtils.isNotEmpty((String)templatefilename)) {
                templatefilename = this.convertProperTemplatefilename(templatefilename, printlayout);
                sb.append(tab);
                sb.append("String _outputfilename = ");
                sb.append("\"" + templatefilename + "." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            } else {
                sb.append(tab);
                sb.append("String _outputfilename = ");
                sb.append("\"" + this.action.getId() + "." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(tab);
        sb.append("_outputfilename = StringUtil.replaceFilename(_outputfilename, ");
        if ("pdf".equals(printlayout.getType()) && "jasperreports".equals(printlayout.getUselibrary())) {
            sb.append("_omap");
        } else {
            sb.append("_map");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(tab);
        sb.append("if (!_map.containsKey(\"${sheet}\")) {").append(CR);
        sb.append(tab + "    ");
        sb.append("_map.put(\"${sheet}\", \"\");").append(CR);
        sb.append(tab);
        sb.append("}").append(CR);
        sb.append(tab);
        sb.append("_sheetname = (_sheetname != null) ? StringUtil.replace(_sheetname, ");
        if ("pdf".equals(printlayout.getType()) && "jasperreports".equals(printlayout.getUselibrary())) {
            sb.append("_omap");
        } else {
            sb.append("_map");
        }
        sb.append(") : null;");
        sb.append(CR);
        String dispositiontype = null;
        if (templatefilename.startsWith("TEMPLATE(")) {
            dispositiontype = " _dispositiontype";
            sb.append(tab).append("String _dispositiontype = \"inline\";").append(CR);
        } else {
            dispositiontype = "\"" + printlayout.getDispositiontype() + "\"";
        }
        sb.append(tab);
        sb.append("OutputStream _os = null;").append(CR);
        String mtab = "";
        if (templatefilename.startsWith("TEMPLATE(")) {
            mtab = "    ";
            sb.append(tab);
            sb.append("if (_outputType == JfcreporttemplateUtil.OutputType.Browser ||").append(CR);
            sb.append(tab + mtab).append("_outputType == JfcreporttemplateUtil.OutputType.Download) {").append(CR);
            sb.append(tab + mtab);
            sb.append("if (_outputType == JfcreporttemplateUtil.OutputType.Download) {").append(CR);
            sb.append(tab + mtab + "    ");
            sb.append("_dispositiontype = \"attachment\";").append(CR);
            sb.append(tab + mtab);
            sb.append("}").append(CR);
        } else {
            dispositiontype = "\"" + printlayout.getDispositiontype() + "\"";
        }
        boolean useConnection = false;
        if ("jdbc".equals(printlayout.getDatasource())) {
            useConnection = true;
        }
        if (!(ReportGeneratorBureau.ReportType.LIST.equals((Object)(reportType = this.getReportType(this.action))) && this.action.getDisplayNoReportDataMessage() && useConnection)) {
            sb.append(tab + mtab);
            sb.append("p.response.reset();");
            sb.append(CR);
            sb.append(tab + mtab);
            if ("excel".equals(printlayout.getType())) {
                sb.append("if (_outputfilename.endsWith(\".xlsx\")) {").append(CR);
                sb.append(tab + mtab + "    ");
                sb.append("p.response.setContentType(\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\");").append(CR);
                sb.append(tab + mtab);
                sb.append("} else {").append(CR);
                sb.append(tab + mtab + "    ");
                sb.append("p.response.setContentType(\"application/vnd.ms-excel\");").append(CR);
                sb.append(tab + mtab);
                sb.append("}");
            } else {
                sb.append("p.response.setContentType(\"application/" + printlayout.getType() + "\");");
            }
            sb.append(CR);
            sb.append(tab + mtab);
            sb.append("p.response.setHeader(\"Cache-Control\", \"no-store, no-cache, must-revalidate, private\");");
            sb.append(CR);
            sb.append(tab + mtab);
            sb.append("p.response.setHeader(\"Pragma\", \"no-cache\");").append(CR);
            sb.append(tab + mtab);
            sb.append("p.response.setHeader(\"Expires\", JFCUtils.getHTTPDate());");
            sb.append(CR);
            sb.append(tab).append(mtab).append("p.response.setHeader(\"Content-disposition\",").append(CR);
            sb.append(tab).append(mtab).append("    ").append("WebStringEncodeUtilities.getContentDisposition(_outputfilename,").append(CR);
            sb.append(tab).append(mtab).append("        ").append("p.request, ");
            sb.append(dispositiontype).append("));").append(CR);
        }
        if (!(ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType) && this.action.getDisplayNoReportDataMessage() && useConnection)) {
            if (isOutputTempFile) {
                sb.append(tab + mtab);
                sb.append("File downloadTempFile = File.createTempFile(getClass().getName() + \"_print\", \".tmp\");");
                sb.append(CR);
                sb.append(tab + mtab);
                sb.append("_os = new FileOutputStream(downloadTempFile);");
                sb.append(CR);
                sb.append(tab + mtab);
                sb.append("p.request.setAttribute(DownloadTempFileKey, downloadTempFile);");
                sb.append(CR);
            } else {
                sb.append(tab + mtab);
                sb.append("_os = p.response.getOutputStream();");
                sb.append(CR);
            }
        }
        sb.append(tab + mtab);
        sb.append("p.request.setAttribute(IActionParameter.isDeniedNullForwardRequestName, Boolean.FALSE);");
        sb.append(CR);
        if (templatefilename.startsWith("TEMPLATE(")) {
            String[] codes;
            sb.append(tab);
            sb.append("} else {").append(CR);
            for (String code : codes = new String[]{"String _outputfolder = _valueMap.get(\"outputfolder\");", "if (StringUtils.isBlank(_outputfolder)) {", "    logger.error(\"The folder for saving the report file is not specified. \"+_outputfilename);", "    Object[] ep = { _outputfilename };", "    p.errors.addJfcerror", "        (getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.print.nullfolder\", ep, p.locale));", "    return " + this.getInputForwardCode + ";", "}", "File __outputfolder = new File(_outputfolder);", "if (! __outputfolder.exists()) {", "    try {", "        org.apache.commons.io.FileUtils.forceMkdir(__outputfolder);", "        logger.info(\"Create folder \"+_outputfolder+\" to save report, \"+_outputfilename);", "    } catch (Exception e) {", "        logger.error(\"Failed to create folder \"+_outputfolder+\" to save report, \"+_outputfilename, e);", "        Object[] ep = { _outputfolder, _outputfilename };", "        p.errors.addJfcerror", "            (getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.print.createfolder\", ep, p.locale));", "        return " + this.getInputForwardCode + ";", "    }", "}", "File __target = new File(_outputfolder, _outputfilename);", "if (_outputType == JfcreporttemplateUtil.OutputType.ServerFolderNoOverride) {", "    __target = JfcreporttemplateUtil.createUniqueFile(__target);", "}", "p.request.setAttribute(\"__jfc_report_ServerFolderSavedFile\", __target);", "_os = new FileOutputStream(__target);"}) {
                sb.append(tab + "    ");
                sb.append(code).append(CR);
            }
            sb.append(tab);
            sb.append("}").append(CR);
        }
        return sb.toString();
    }

    protected String gDoPrint0_createData(Printlayout printlayout, String pid, int libraryType, boolean isOutputData_condition) {
        return this.gDoPrint0_createData(printlayout, pid, libraryType, isOutputData_condition, false, PrintMode.Single, this.action, "        ");
    }

    protected String gDoPrint0_createData(Printlayout printlayout, String pid, int libraryType, boolean isOutputData_condition, boolean useConnection, PrintMode mode, Action targetAction, String basetab) {
        StringBuilder sb = new StringBuilder();
        if (targetAction == null) {
            targetAction = this.action;
        }
        String tab = null;
        tab = !this.isPrintReportList(printlayout.getId()) ? basetab : basetab + "    ";
        ReportGeneratorBureau.ReportType reportType = this.getReportType(targetAction);
        if (ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType) && targetAction.getDisplayNoReportDataMessage() && useConnection) {
            sb.append(tab);
            sb.append("if (_listp.sizeItem() == 0) {").append(CR);
            sb.append(tab + "    ");
            sb.append("p.errors.addJfcerror(getJFCErrorManager().getJfcerror(\"" + this.modelId + ".error.report.nodata\", p.locale));");
            sb.append(CR);
            sb.append(tab + "    ");
            sb.append("return \"reportListError\";");
            sb.append(CR);
            sb.append(tab);
            sb.append("}").append(CR);
        }
        if (libraryType == 1 || libraryType == 2) {
            sb.append(tab);
            sb.append("Map _map = new jp.jasminesoft.jfc.app.ReplaceMap();");
            sb.append(CR);
            if (libraryType == 1) {
                sb.append(tab);
                sb.append("Map _typemap = new HashMap();");
                sb.append(CR);
            }
        }
        ArrayList<String> childvarlist = new ArrayList<String>();
        if (mode == PrintMode.Batch || mode == PrintMode.Sheet || ReportGeneratorBureau.ReportType.DETAIL.equals((Object)reportType)) {
            Dataitem[] dataitems = AppSchemaUtil.getDataitems(targetAction);
            if (dataitems == null) {
                return "";
            }
            boolean isReverse = false;
            for (Dataitem dataitem : dataitems) {
                if (!"reverse".equals(dataitem.getType())) continue;
                isReverse = true;
                break;
            }
            for (int i = 0; i < dataitems.length; ++i) {
                childvarlist.addAll(this.gDoPrint0_createData_dataitem(pid, libraryType, sb, tab, dataitems[i], isReverse));
            }
        } else if (mode == PrintMode.Single && ReportGeneratorBureau.ReportType.LIST.equals((Object)reportType)) {
            Model dsmodel = AppSchemaUtil.getModel(this.project, targetAction.getIdref());
            if (dsmodel == null) {
                Object[] o = new Object[]{targetAction.getId(), targetAction.getIdref()};
                sb.append(tab);
                sb.append("// " + rman.getValue("replacemaphelper.model.notfound", o));
                sb.append(CR);
                sb.append(CR);
            } else if (dsmodel != null && StringUtils.isBlank((String)dsmodel.getGenmodelidref())) {
                sb.append(tab);
                sb.append("_map.putAll(");
                sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                sb.append(".get(finderContext.getRowCount(), p));");
                sb.append(CR);
                if (libraryType == 1 || libraryType == 2) {
                    if (libraryType == 1) {
                        sb.append(tab);
                        sb.append("_typemap.putAll(");
                        sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                        sb.append(".get(finderContext.getRowCount(), p));");
                        sb.append(CR);
                    }
                    sb.append(tab);
                    sb.append("_map.putAll(");
                    sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                    sb.append(".get(");
                    sb.append(pid);
                    sb.append(", p));");
                    sb.append(CR);
                    if (libraryType == 1) {
                        sb.append(tab);
                        sb.append("_typemap.putAll(");
                        sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                        sb.append(".getType(");
                        sb.append(pid);
                        sb.append(", p));");
                        sb.append(CR);
                    }
                    if (isOutputData_condition) {
                        sb.append(tab);
                        sb.append("_map.putAll(");
                        sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                        sb.append(".get(cond_p, p));");
                        sb.append(CR);
                        if (libraryType == 1) {
                            sb.append(tab);
                            sb.append("_typemap.putAll(");
                            sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                            sb.append(".getType(cond_p, p));");
                            sb.append(CR);
                        }
                    }
                }
                if (libraryType == 2) {
                    // empty if block
                }
            }
        }
        if (libraryType == 2) {
            sb.append(tab);
            sb.append("org.w3c.dom.Document _document = null;");
            sb.append(CR);
            sb.append(tab).append("try {").append(CR);
            if (childvarlist.size() != 0) {
                ArrayList<String> varlist = new ArrayList<String>();
                varlist.add(pid);
                varlist.addAll(childvarlist);
                if (isOutputData_condition) {
                    varlist.add("cond_p");
                }
                ArrayList<String> codes = new ArrayList<String>();
                codes.add("String[] xmlstrlist = new String[" + varlist.size() + "];");
                int cnt = 0;
                for (String var : varlist) {
                    codes.add("xmlstrlist[" + cnt + "] = " + var + ".toString();");
                    ++cnt;
                }
                codes.add("_document = jp.jasminesoft.jfc.core.support.xml.DomUtils.createWrappedDocument(\"root\", xmlstrlist);");
                for (String code : codes) {
                    sb.append(tab + "    ");
                    sb.append(code);
                    sb.append(CR);
                }
            } else {
                sb.append(tab + "    ").append("_document = jp.jasminesoft.jfc.core.support.xml.DomUtils.createWrappedDocument(");
                sb.append("\"root\", ");
                sb.append(pid);
                sb.append(".toString()");
                if (isOutputData_condition) {
                    sb.append(", cond_p.toString()");
                }
                sb.append(");").append(CR);
            }
            sb.append(tab).append("} catch (javax.xml.parsers.ParserConfigurationException e) {").append(CR);
            sb.append(tab + "    ").append("logger.error(\"Illegal xml document\", e);").append(CR);
            sb.append(tab).append("}").append(CR);
        }
        if (libraryType == 2) {
            sb.append(tab);
            sb.append("Map _omap = new HashMap(_map);").append(CR);
            sb.append(tab);
            sb.append("_map = convertParameterMapKeyName(_map);");
            sb.append(CR);
        }
        sb.append(tab);
        sb.append("remakeParameterMap(_map, ");
        if (libraryType == 1) {
            sb.append("_typemap, ");
        } else {
            sb.append("null, ");
        }
        sb.append("p);");
        sb.append(CR);
        return sb.toString();
    }

    private List<String> gDoPrint0_createData_dataitem(String pid, int libraryType, StringBuilder sb, String tab, Dataitem dataitem, boolean isReverse) {
        ArrayList<String> didlist = new ArrayList<String>();
        String did = dataitem.getIdref();
        String LpFooter = "_lp";
        String UlpFooter = "_ulp";
        if (did.endsWith("_ulp")) {
            did = did.substring(0, did.length() - "_ulp".length()) + "_lp";
        }
        if (libraryType == 1 || libraryType == 2) {
            Model dsmodel_store;
            IRNode node;
            Model dmodel = AppSchemaUtil.getModel(this.project, did);
            Model dsmodel = null;
            IRNode iRNode = node = dmodel != null ? dmodel.getIdrefAsIRNode() : null;
            if (node != null && node instanceof Model) {
                dsmodel = (Model)node;
            }
            if ((dsmodel_store = AppSchemaUtil.getStoreModel(dmodel)) != null && StringUtils.isNotBlank((String)dsmodel_store.getGenmodelidref())) {
                return Collections.emptyList();
            }
            if (!"presentation".equals(dataitem.getType()) && isReverse) {
                String didpackagename = AppSchemaUtil.getPackagename(dmodel, this.project);
                String didclassname = AppSchemaUtil.getClassname(dmodel);
                sb.append(tab);
                sb.append(didpackagename);
                sb.append(didclassname).append(" ").append(did).append(" = (");
                sb.append(didpackagename);
                sb.append(didclassname).append(")p.request.getAttribute(\"");
                sb.append(did);
                if (dataitem.getType().equals("reverse")) {
                    sb.append("_rev");
                }
                sb.append("\");");
                sb.append(CR);
            }
            sb.append(tab);
            sb.append("_map.putAll(");
            sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
            sb.append(".get(");
            sb.append(did + ", p)");
            sb.append(");");
            sb.append(CR);
            if (libraryType == 1) {
                sb.append(tab);
                sb.append("_typemap.putAll(");
                sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(dsmodel, this.project));
                sb.append(".getType(");
                sb.append(did + ", p)");
                sb.append(");");
                sb.append(CR);
            }
            if (dsmodel.getWorkflow()) {
                Model jfcworkstate = AppSchemaUtil.getModel(this.project, "jfcworkstate");
                Model jfcworkstatelp = AppSchemaUtil.getModel(this.project, "jfcworkstate_lp");
                String jfcwkpackagename = AppSchemaUtil.getPackagename(jfcworkstatelp, this.project);
                sb.append(tab);
                sb.append(jfcwkpackagename);
                sb.append("JfcworkstateLp _jfcworkstate_lp =").append(CR);
                sb.append(tab + "    ");
                sb.append("(");
                sb.append(jfcwkpackagename);
                sb.append("JfcworkstateLp)p.request.getAttribute(\"jfcworkstate_lp\");");
                sb.append(CR);
                sb.append(tab);
                sb.append("if (_jfcworkstate_lp != null) {").append(CR);
                sb.append(tab + "    ");
                sb.append("_map.putAll(");
                sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(jfcworkstate, this.project));
                sb.append(".get(_jfcworkstate_lp, p));").append(CR);
                if (libraryType == 1) {
                    sb.append(tab + "    ");
                    sb.append("_typemap.putAll(");
                    sb.append(AppSchemaUtil.getReplaceMapHelperClassname4Dicon(jfcworkstate, this.project));
                    sb.append(".getType(_jfcworkstate_lp, p));").append(CR);
                }
                sb.append(tab);
                sb.append("}").append(CR);
                didlist.add("_jfcworkstate_lp");
            }
        }
        if (!did.equals(pid)) {
            didlist.add(did);
        }
        return didlist;
    }

    protected String gDoPrintPrepare(Model model, boolean outputSetAttributeFlag, String basetab) {
        StringBuilder sb = new StringBuilder();
        Model pmodel = AppSchemaUtil.getModel(this.project, model.getId(), "presentation");
        if (pmodel == null) {
            Object[] o = new Object[]{this.action.getId(), model.getId()};
            logger.error(rman.getValue("struts.comment.print.invalidmodel", o));
            return "";
        }
        String id = model.getId();
        String pid = pmodel.getId();
        String pclassname = AppSchemaUtil.getClassname(pmodel);
        String packagename = AppSchemaUtil.getPackagename(pmodel, this.project);
        sb.append(basetab);
        sb.append(packagename);
        sb.append(pclassname);
        sb.append(" ");
        sb.append(pid);
        sb.append(" = ");
        sb.append(AppSchemaUtil.getHelperClassname4Dicon(pmodel, this.project));
        sb.append(".s2p(");
        sb.append(id);
        sb.append(", p, ");
        sb.append(AppSchemaUtil.getHelperClassname(pmodel, this.project));
        sb.append(".SHOW);");
        sb.append(CR);
        if (outputSetAttributeFlag) {
            sb.append(basetab);
            sb.append("p.request.setAttribute(\"");
            sb.append(pid);
            sb.append("\", ");
            sb.append(pid);
            sb.append(");");
        }
        return sb.toString();
    }

    protected String gDoPrint0(Model model, Print[] prints) {
        return this.gDoPrint0(model, this.action, prints, PrintMode.Single, "        ");
    }

    protected String gDoPrint0(Model model, Action targetAction, Print[] prints, PrintMode mode, String basetab) {
        StringBuilder sb = new StringBuilder();
        if (targetAction == null) {
            targetAction = this.action;
        }
        int cnt = 0;
        for (int i = 0; i < prints.length; ++i) {
            Print print = prints[i];
            Printlayout printlayout = null;
            IRNode node = print.getIdrefAsIRNode();
            if (node != null && node instanceof Printlayout) {
                printlayout = (Printlayout)node;
            }
            if (printlayout == null) {
                Object[] o = new Object[]{targetAction.getId(), print.getIdref()};
                logger.error(rman.getValue("struts.comment.print.noprintlayout", o));
                continue;
            }
            String type = printlayout.getType();
            Library library = null;
            try {
                String lib = printlayout.getUselibrary();
                if (StringUtils.isNotBlank((String)lib)) {
                    library = Library.valueOf(lib);
                }
                library = this.checkPrintLayoutType(targetAction, mode, print, type, library);
            }
            catch (IllegalArgumentException e) {
                logger.error("Unknown library " + printlayout.getUselibrary());
                continue;
            }
            catch (IllegalStateException e) {
                continue;
            }
            Model pmodel = AppSchemaUtil.getModel(this.project, model.getId(), "presentation");
            String id = model.getId();
            String classname = AppSchemaUtil.getClassname(model);
            String pid = pmodel.getId();
            String pclassname = AppSchemaUtil.getClassname(pmodel);
            String mtab0 = "";
            if (mode == PrintMode.Single) {
                sb.append(basetab);
                if (cnt == 0) {
                    sb.append("if");
                } else {
                    sb.append("} else if");
                }
                sb.append(" (p.action.equals(\"");
                sb.append(print.getAction());
                sb.append("\")) {");
                sb.append(CR);
                ++cnt;
            } else if (mode == PrintMode.Batch || mode == PrintMode.BatchJasperReport) {
                if (prints.length > 1) {
                    String key = StringUtils.substringAfter((String)print.getIdref(), (String)"_");
                    sb.append(basetab);
                    sb.append("if (targetSet.size() > 0 && targetSet.contains(\"" + key + "\")) {");
                    sb.append(CR);
                    mtab0 = "    ";
                }
            } else if (prints.length > 1) {
                String key = StringUtils.substringAfter((String)print.getIdref(), (String)"_");
                sb.append(basetab);
                if (cnt == 0) {
                    sb.append("if");
                } else {
                    sb.append("} else if");
                }
                sb.append(" (targetSet.size() > 0 && targetSet.contains(\"" + key + "\")) {");
                sb.append(CR);
                ++cnt;
                mtab0 = "    ";
            }
            if ("pdf".equals(type) && Library.fop.equals((Object)library)) {
                assert (mode != PrintMode.Sheet);
                assert (mode != PrintMode.BatchJasperReport);
                sb.append(this.gDoPrint0_pdf_fop(model, printlayout, id, classname, pid, pclassname, mode, basetab + mtab0));
            } else if (Library.jasperreports.equals((Object)library)) {
                assert (mode != PrintMode.Sheet);
                boolean useConnection = false;
                if ("jdbc".equals(printlayout.getDatasource())) {
                    useConnection = true;
                }
                sb.append(this.gDoPrint0_createData(printlayout, pid, 2, false, useConnection, mode, targetAction, basetab + mtab0));
                if (mode == PrintMode.Single) {
                    sb.append(this.gDoPrint0_prepare(printlayout, model, basetab));
                } else if (mode == PrintMode.Batch) {
                    sb.append(this.gDoPrint0_prepare_basedir(printlayout, basetab + mtab0));
                    sb.append(this.gDoPrint0_prepare_zipentry(printlayout, model, basetab + mtab0));
                } else if (mode == PrintMode.BatchJasperReport) {
                    sb.append(this.gDoPrint0_prepare_basedir(printlayout, basetab + mtab0));
                }
                this.gDoPrint0_jasperreports(sb, model, null, printlayout, id, classname, pid, pclassname, false, mode, targetAction, basetab + mtab0);
            } else if ("excel".equals(type) && (Library.jexcelapi.equals((Object)library) || Library.poi.equals((Object)library))) {
                assert (mode != PrintMode.BatchJasperReport);
                sb.append(this.gDoPrint0_createData(printlayout, pid, 1, false, false, mode, targetAction, basetab + mtab0));
                if (mode == PrintMode.Single) {
                    sb.append(this.gDoPrint0_prepare(printlayout, model, basetab));
                } else if (mode == PrintMode.Batch) {
                    sb.append(this.gDoPrint0_prepare_basedir(printlayout, basetab + mtab0));
                    sb.append(this.gDoPrint0_prepare_zipentry(printlayout, model, basetab + mtab0));
                } else if (mode == PrintMode.Sheet) {
                    sb.append(this.gDoPrint0_prepare_basedir(printlayout, basetab + mtab0));
                }
                sb.append(this.gDoPrint0_excel_report(model, printlayout, id, classname, pid, pclassname, false, mode, targetAction, basetab + mtab0));
            }
            if (mode != PrintMode.Batch && mode != PrintMode.BatchJasperReport || prints.length <= 1) continue;
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
        }
        if ((mode == PrintMode.Single || mode == PrintMode.Sheet) && cnt > 0) {
            sb.append(basetab);
            sb.append("}");
            sb.append(CR);
        }
        return sb.toString();
    }

    private Library checkPrintLayoutType(Action targetAction, PrintMode mode, Print print, String type, Library library) {
        if ("excel".equals(type)) {
            if (library == null) {
                library = Library.poi;
            }
            if (library != Library.poi && library != Library.jexcelapi) {
                logger.debug("Printlayout.TYPE_EXCEL is poi or jexcelapi only (library is " + (Object)((Object)library) + ")");
                throw new IllegalStateException();
            }
        } else if ("pdf".equals(type)) {
            if (library == null) {
                library = Library.jasperreports;
            }
            if (library != Library.jasperreports && library != Library.fop) {
                logger.debug("Printlayout.TYPE_PDF is jasperreports or fop only (library is " + (Object)((Object)library) + ")");
                throw new IllegalStateException();
            }
        } else if ("rtf".equals(type)) {
            if (library == null) {
                library = Library.jasperreports;
            }
            if (library != Library.jasperreports) {
                logger.debug("Printlayout.TYPE_RTF is jasperreports only (library is " + (Object)((Object)library) + ")");
                throw new IllegalStateException();
            }
        } else {
            Object[] o = new Object[]{targetAction.getId(), print.getIdref(), type};
            logger.error(rman.getValue("struts.comment.print.invalidtype", o));
            throw new IllegalStateException();
        }
        if (mode == PrintMode.Sheet) {
            if (library != Library.poi && library != Library.jexcelapi) {
                logger.debug("PrintMode.Sheet is poi or jexcelapi only (library is " + (Object)((Object)library) + ")");
                throw new IllegalStateException();
            }
            if (!"excel".equals(type)) {
                logger.debug("PrintMode.Sheet is excel only (type is " + type + ")");
                throw new IllegalStateException();
            }
        } else if (mode == PrintMode.BatchJasperReport) {
            if (library != Library.jasperreports) {
                logger.debug("PrintMode.BatchJasperReport is jasperreport only (library is " + (Object)((Object)library) + ")");
                throw new IllegalStateException();
            }
            if (!"pdf".equals(type) && !"rtf".equals(type)) {
                logger.debug("PrintMode.BatchJasperReport is pdf or rtf only (type is " + type + ")");
                throw new IllegalStateException();
            }
        }
        return library;
    }

    protected String gDoPrint0_prepare_zipentry(Printlayout printlayout, Model model, String basetab) {
        StringBuilder sb = new StringBuilder();
        String extension = null;
        extension = "excel".equals(printlayout.getType()) ? "xls" : printlayout.getType();
        String templatefilename = printlayout.getFilename();
        if ((templatefilename = templatefilename.trim()).startsWith("TEMPLATE(")) {
            sb.append(basetab);
            sb.append("if (_outputfilename == null || _outputfilename.trim().length() == 0) {").append(CR);
            String efilename = printlayout.getOutputfilename();
            if (StringUtils.isNotBlank((String)efilename)) {
                String expr = JavaSourceGenerator.parsePlaceHolder(efilename, model);
                sb.append(basetab + "    ");
                sb.append("_outputfilename = ");
                sb.append(expr);
                if ("excel".equals(printlayout.getType())) {
                    sb.append(" + \".\" + StringUtils.defaultIfEmpty(_valueMap.get(\"templatefilename_original_suffix\"), \"" + extension + "\")");
                } else {
                    sb.append(" + \"." + extension + "\"");
                }
                sb.append(";");
                sb.append(CR);
            } else {
                sb.append(basetab + "    ");
                sb.append("_outputfilename = ");
                sb.append("_valueMap.get(\"templatefilename_original\")");
                sb.append(" + ");
                if ("excel".equals(printlayout.getType())) {
                    sb.append("(_doneCount+1) + \".\" + StringUtils.defaultIfEmpty(_valueMap.get(\"templatefilename_original_suffix\"), \"" + extension + "\")");
                } else {
                    sb.append("(_doneCount+1) + \"." + extension + "\"");
                }
                sb.append(";");
                sb.append(CR);
            }
            sb.append(basetab);
            sb.append("}").append(CR);
        } else {
            templatefilename = this.convertProperTemplatefilename(templatefilename, printlayout);
            String efilename = printlayout.getOutputfilename();
            if (StringUtils.isNotBlank((String)efilename)) {
                String expr = JavaSourceGenerator.parsePlaceHolder(efilename, model);
                sb.append(basetab);
                sb.append("String _outputfilename = ");
                sb.append(expr);
                sb.append(" + \"." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            } else {
                sb.append(basetab);
                sb.append("String _outputfilename = ");
                sb.append("\"" + templatefilename + "\" + ");
                sb.append("(_doneCount+1) + \"." + extension + "\"");
                sb.append(";");
                sb.append(CR);
            }
        }
        sb.append(basetab);
        sb.append("_outputfilename = StringUtil.replaceFilename(_outputfilename, ");
        if ("pdf".equals(printlayout.getType()) && "jasperreports".equals(printlayout.getUselibrary())) {
            sb.append("_omap");
        } else {
            sb.append("_map");
        }
        sb.append(");");
        sb.append(CR);
        sb.append(basetab);
        sb.append("if (!_map.containsKey(\"${sheet}\")) {").append(CR);
        sb.append(basetab + "    ");
        sb.append("_map.put(\"${sheet}\", \"\");").append(CR);
        sb.append(basetab);
        sb.append("}").append(CR);
        sb.append(basetab);
        sb.append("_sheetname = (_sheetname != null) ? StringUtil.replace(_sheetname, ");
        if ("pdf".equals(printlayout.getType()) && "jasperreports".equals(printlayout.getUselibrary())) {
            sb.append("_omap");
        } else {
            sb.append("_map");
        }
        sb.append(") : null;");
        sb.append(CR);
        sb.append(basetab);
        sb.append("ZipEntry _ze = new ZipEntry(_outputfilename);");
        sb.append(CR);
        sb.append(basetab);
        sb.append("_zos.putNextEntry(_ze);");
        sb.append(CR);
        return sb.toString();
    }

    private String convertProperTemplatefilename(Printlayout printlayout) {
        return this.convertProperTemplatefilename(printlayout.getFilename(), printlayout);
    }

    private String convertProperTemplatefilename(String templatefilename, Printlayout printlayout) {
        int ptr = templatefilename.indexOf("__AsTeRiSk__");
        if (ptr > 0) {
            templatefilename = templatefilename.substring(0, ptr);
        }
        if ((ptr = (templatefilename = StringUtil.convertJavaString((String)templatefilename)).indexOf("/")) > 0) {
            templatefilename = StringUtil.lastToken((String)templatefilename, (String)"/");
        }
        if ((ptr = templatefilename.indexOf(".")) > 0) {
            templatefilename = templatefilename.substring(0, ptr);
        }
        return templatefilename;
    }

    protected void gDoPrintBase(String mode, Model model, StringBuilder sb, StringBuilder sb2, String id, String classname, String pid, String pclassname) {
        Print[] prints = AppSchemaUtil.getPrint(this.action);
        if (prints == null || prints.length == 0) {
            return;
        }
        sb.append(this.gHook("do_" + mode, "before_" + mode, "        "));
        String code = this.gDoPrint0(model, prints);
        String[] lines = StringUtil.split((String)code, (String)CR);
        StringBuilder childsb = null;
        ArrayList<String> childids = null;
        for (String string : lines) {
            if (!StringUtil.removePreAndPostWhitespace((String)string).startsWith("_map.putAll")) continue;
            int bptr = string.indexOf(".get(");
            int eptr = string.substring(bptr).indexOf(",");
            String tid = string.substring(bptr + ".get(".length(), bptr + eptr);
            if (tid.equals(id + "_p") || !tid.endsWith("_lp") || tid.equals("_jfcworkstate_lp")) continue;
            if (childids == null) {
                childids = new ArrayList<String>();
            }
            if (childids.contains(tid)) continue;
            childids.add(tid);
        }
        ArrayList<String> skipids = null;
        if (childids != null) {
            block1: for (String tid : childids) {
                for (String line : lines) {
                    if (line.endsWith("p.request.getAttribute(\"" + tid + "\");") || line.endsWith("p.request.getAttribute(\"" + tid + "_rev\");")) {
                        if (skipids == null) {
                            skipids = new ArrayList<String>();
                        }
                        skipids.add(tid);
                        continue block1;
                    }
                    if (StringUtil.removePreAndPostWhitespace((String)line).startsWith("remakeParameterMap")) continue block1;
                }
            }
        }
        if (childids != null && skipids != null) {
            childids.removeAll(skipids);
        }
        if (childids != null) {
            for (String tid : childids) {
                Model model2 = AppSchemaUtil.getModel(this.project, tid);
                String packagename_lp = AppSchemaUtil.getPackagename(model2, this.project);
                String classname_lp = AppSchemaUtil.getClassname(model2);
                if (childsb == null) {
                    childsb = new StringBuilder();
                }
                childsb.append(packagename_lp).append(classname_lp).append(" ").append(tid).append(", ");
            }
        }
        boolean firstFlag = true;
        for (int l = 0; l < lines.length; ++l) {
            String string = lines[l];
            if (string.indexOf("p.action.equals(") > 0) {
                if (firstFlag) {
                    sb.append("        ").append("String _action = p.action;").append(CR);
                    sb.append("        ").append("if (_action.indexOf(\":\") > 0) {").append(CR);
                    sb.append("            ").append("_action = _action.substring(0, _action.indexOf(\":\"));").append(CR);
                    sb.append("        ").append("}").append(CR);
                    firstFlag = false;
                }
                String string2 = string.replace("p.action.equals", "_action.equals");
                sb.append(string2).append(CR);
                int bptr = string2.indexOf("\"");
                int eptr = string2.lastIndexOf("\"");
                String methodName = "do_" + StringUtil.convertJavaVariableString((String)string2.substring(bptr + 1, eptr));
                sb.append("            ").append("_forward = ").append(methodName).append("(").append(id).append(", ");
                sb.append(id).append("_p, ");
                if (childids != null) {
                    for (String childid : childids) {
                        sb.append(childid).append(", ");
                    }
                }
                sb.append("p);").append(CR);
                if (string2.indexOf("else ") > 0) {
                    sb2.append("        ").append("return null;").append(CR);
                    sb2.append("    ").append("}").append(CR).append(CR);
                }
                sb2.append("    ").append("public String ").append(methodName).append("(").append(classname).append(" ").append(id).append(", ");
                sb2.append(pclassname).append(" ").append(pid).append(", ");
                if (childsb != null) {
                    sb2.append(childsb.toString());
                }
                sb2.append("ActionParameter p)");
                sb2.append(" throws IOException, ServletException {").append(CR);
                continue;
            }
            if (l < lines.length - 1) {
                sb2.append(string).append(CR);
                continue;
            }
            sb2.append("        ").append("return null;").append(CR);
            sb2.append("    ").append("}").append(CR).append(CR);
        }
        sb.append("        ").append("}").append(CR);
        sb.append(this.gHook("do_" + mode, "after_" + mode, "        "));
        sb.append("        ").append("p.request.setAttribute(ScriptCodeRunner.JSOBJECTPREFIX+\"").append(id).append("\", ").append(id).append(");").append(CR);
        sb.append("        ").append("String _status = new ScriptCodeRunner(\"").append(id).append("\").process(this.getClass().getName(), \"print\", p);").append(CR);
        sb.append("        ").append("if (StringUtils.isNotBlank(_status)) {").append(CR);
        sb.append("            ").append("throw new jp.jasminesoft.jfc.core.exception.BusinessLogicException(_status);").append(CR);
        sb.append("        ").append("}").append(CR);
    }

    protected final boolean isPrintReportList(String id) {
        return StringUtils.startsWith((String)id, (String)"printshowList") || StringUtils.startsWith((String)id, (String)"printreportList");
    }

    public void setHookProcessor(HookProcessor proc) {
        this.hookProc = proc;
    }

    private String gHook(String method_name, String position, String basetab) {
        if (this.hookProc == null) {
            return "";
        }
        return this.hookProc.gHook(method_name, position, basetab);
    }

    static enum Library {
        poi,
        fop,
        jasperreports,
        jexcelapi;

    }

    public static enum PrintMode {
        Single,
        Batch,
        Sheet,
        BatchJasperReport;

    }
}

