/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.core.util.LineSeparator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ScriptUtils;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Script;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptDirectoryGenerator {
    public static final String BaseDirectory = "webpage" + File.separator + "WEB-INF";
    protected static Logger logger = LogManager.getLogger(ScriptDirectoryGenerator.class);
    private String basedir;
    private Project project;
    private Set<String> ignoreModelIdSet;
    private Map<String, String> filenamePatternMap;
    private Map<String, String> envFilenamePatternMap;
    private Set<String> processedFileSet;

    public ScriptDirectoryGenerator(Project project, String basedir) {
        this.project = project;
        this.basedir = basedir;
        this.ignoreModelIdSet = new HashSet<String>();
        this.ignoreModelIdSet.add("seq");
        this.ignoreModelIdSet.add("jprincipal");
        this.ignoreModelIdSet.add("jfclicenseholder");
        this.ignoreModelIdSet.add("jfcmodel");
        this.ignoreModelIdSet.add("jfcmodel4m");
        this.ignoreModelIdSet.add("jfcjob");
        this.ignoreModelIdSet.add("jcategory");
        this.filenamePatternMap = new HashMap<String, String>();
        this.filenamePatternMap.put("beforeInsert", "${id}Helper_beforeInsert.js");
        this.filenamePatternMap.put("initialize", "${id}Helper_initialize.js");
        this.filenamePatternMap.put("initializeInSearch", "${id}CHelper_initialize.js");
        this.filenamePatternMap.put("beforeUpdate", "${id}Helper_beforeUpdate.js");
        this.filenamePatternMap.put("beforeShow", "${id}Helper_beforeShow.js");
        this.filenamePatternMap.put("beforeShowInUpdate", "${id}Helper_beforeShowInUpdate.js");
        this.filenamePatternMap.put("beforeShowInInsert", "${id}Helper_beforeShowInInsert.js");
        this.filenamePatternMap.put("beforeShowInShowList", "${id}Helper_beforeShowInShowList.js");
        this.filenamePatternMap.put("beforeShowInUploadUpdate", "${id}Helper_beforeShowInUploadUpdate.js");
        this.filenamePatternMap.put("beforeSearch", "${id}CHelper_beforeSearch.js");
        this.filenamePatternMap.put("beforeDelete", "${id}Helper_beforeDelete.js");
        this.filenamePatternMap.put("calc", "${id}Helper_calc.js");
        this.filenamePatternMap.put("doUpdateRule", "ShowList${id}Controller_do_updateRule.js");
        this.filenamePatternMap.put("doAfterPrint", "Show${id}Controller_print.js");
        this.filenamePatternMap.put("doAfterPrintList", "ShowList${id}Controller_print.js");
        this.filenamePatternMap.put("replaceMapHelper", "ReplaceMapHelper_remake.js");
        this.filenamePatternMap.put("inputCheck", "${id}PInputCheckHelper_input_check.js");
        this.filenamePatternMap.put("inputCheckInSearch", "${id}CpInputCheckHelper_input_check.js");
        this.filenamePatternMap.put("filter", "${id}PFilterHelper_filter.js");
        this.filenamePatternMap.put("filterInSearch", "${id}CpFilterHelper_filter.js");
        this.filenamePatternMap.put("logicalDelete", "${id}Helper_logicalDelete.js");
        this.filenamePatternMap.put("insertTransaction", "${id}EntityService_doTransactionBy${itemname}InsertTransaction.js");
        this.filenamePatternMap.put("updateTransaction", "${id}EntityService_doTransactionBy${itemname}UpdateTransaction.js");
        this.filenamePatternMap.put("deleteTransaction", "${id}EntityService_doTransactionBy${itemname}DeleteTransaction.js");
        this.filenamePatternMap.put("inputCheckInUpdateList", "${id}UlpInputCheckHelper_input_check.js");
        this.filenamePatternMap.put("filterInUpdateList", "${id}UlpFilterHelper_filter.js");
        this.filenamePatternMap.put("downloadStart", "Download${id}_processStart.js");
        this.filenamePatternMap.put("downloadEnd", "Download${id}_processEnd.js");
        this.filenamePatternMap.put("uploadUpdateStart", "UploadUpdate${id}_processStart.js");
        this.filenamePatternMap.put("uploadUpdateAfterRead", "UploadUpdate${id}_AfterRead.js");
        this.filenamePatternMap.put("uploadUpdateEnd", "UploadUpdate${id}_processEnd.js");
        this.filenamePatternMap.put("criteriaConverter", "${id}CriteriaConverter_convert.js");
        this.filenamePatternMap.put("s2p", "${id}PHelper_s2p.js");
        this.filenamePatternMap.put("p2s", "${id}PHelper_p2s.js");
        this.filenamePatternMap.put("groupSelection", "${id}PHelper_groupSelection.js");
        this.filenamePatternMap.put("DownloadFile_beforeDownload", "DownloadFile_beforeDownload.js");
        this.filenamePatternMap.put("UpdateFile_afterUpload", "UpdateFile_afterUpload.js");
        this.filenamePatternMap.put("uploadUpdateReadHeader", "UploadUpdate${id}_readHeader.js");
        this.filenamePatternMap.put("downloadOutputCsv", "Download${id}_outputCsv.js");
        this.filenamePatternMap.put("uploadUpdateReadRowDataInFileProcessor", "UploadUpdate${id}_readRowDataInFileProcessor.js");
        this.filenamePatternMap.put("updateListCriteriaConverter", "UpdateList${id}CriteriaConverter_convert.js");
        this.filenamePatternMap.put("searchListCriteriaConverter", "SearchList${id}CriteriaConverter_convert.js");
        this.filenamePatternMap.put("calendarViewCriteriaConverter", "CalendarView${id}CriteriaConverter_convert.js");
        this.filenamePatternMap.put("reportListCriteriaConverter", "ReportList${id}CriteriaConverter_convert.js");
        this.filenamePatternMap.put("downloadCriteriaConverter", "Download${id}CriteriaConverter_convert.js");
        this.envFilenamePatternMap = new HashMap<String, String>();
        this.envFilenamePatternMap.put("myfunction", "myfunction.js");
        this.envFilenamePatternMap.put("DownloadFile_beforeDownload", "DownloadFile_beforeDownload.js");
        this.envFilenamePatternMap.put("UpdateFile_afterUpload", "UpdateFile_afterUpload.js");
    }

    public void process() {
        this.processedFileSet = new HashSet<String>();
        File base = new File(this.basedir + File.separator + BaseDirectory);
        if (!base.exists() || !base.isDirectory()) {
            return;
        }
        File base2 = new File(base.getAbsolutePath() + File.separator + "script");
        if (!base2.exists()) {
            base2.mkdir();
        }
        for (IProjectChoice ipc : this.project.getContent()) {
            String id;
            Model model;
            if (!(ipc instanceof Model) || !(model = (Model)ipc).getType().equals("store") || this.ignoreModelIdSet.contains(id = model.getId())) continue;
            File dir = new File(base2.getAbsolutePath() + File.separator + id);
            if (dir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)dir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!dir.exists()) {
                    dir.mkdir();
                }
            }
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "insert"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "update"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "show"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "showList"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "delete"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "uploadUpdate"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getActionByModelIdAndType(this.project, id, "download"), dir);
            this.writeScripts(this.project, AppSchemaUtil.getUpdateListActionByModelId(this.project, id), dir);
        }
        HashMap<String, String> filterScriptMap = new HashMap<String, String>();
        List<Script> envscripts = AppSchemaUtil.getEnvironmentScript(this.project.getEnvironment());
        for (Script script : envscripts) {
            String type = script.getType();
            if (type.startsWith("userDefinedFilter")) {
                this.appendFilterScript(script, filterScriptMap);
                continue;
            }
            String filename = this.envFilenamePatternMap.get(type);
            if (filename == null) {
                logger.error("illegal environment script pattern, " + type);
                continue;
            }
            boolean isComplementProcessFunc = true;
            if ("myfunction".equals(type)) {
                isComplementProcessFunc = false;
            }
            this.writeScript(this.project, filename, script, base2, isComplementProcessFunc);
        }
        if (filterScriptMap.size() > 0) {
            Script script = new Script();
            script.setType("filter");
            script.setContent(this.createFilterScript(filterScriptMap));
            this.writeScript(this.project, "__filter.js", script, base2, false);
        }
    }

    private void appendFilterScript(Script script, Map<String, String> map) {
        String type = script.getType();
        String funcName = "filter" + type.substring("userDefinedFilter".length());
        String code = "function " + funcName + "(s) {" + LineSeparator.SYSTEM + script.getContent() + LineSeparator.SYSTEM + "}";
        map.put(funcName, code);
    }

    private String createFilterScript(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (String s : map.values()) {
            sb.append(s);
            sb.append(LineSeparator.SYSTEM);
            sb.append(LineSeparator.SYSTEM);
        }
        return sb.toString();
    }

    private void writeScripts(Project project, Action action, File dir) {
        if (action == null) {
            return;
        }
        Script[] scripts = AppSchemaUtil.getScript(action);
        if (scripts == null) {
            return;
        }
        for (Script script : scripts) {
            String filename = this.createScriptFilename(action.getIdref(), script);
            this.writeScript(project, filename, script, dir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeScript(Project project, String filename, Script script, File dir, boolean isComplementProcessFunc) {
        if (filename == null) {
            return;
        }
        File sfile = new File(dir.getAbsolutePath() + File.separator + filename);
        filename = sfile.getAbsolutePath();
        if (this.processedFileSet.contains(filename)) {
            return;
        }
        if (!sfile.exists()) {
            String origin = sfile.getAbsolutePath().substring(0, project.getBasedir().length());
            String rest = sfile.getAbsolutePath().substring(project.getBasedir().length());
            String[] folders = StringUtils.split((String)rest, (String)File.separator);
            if (folders != null && folders.length > 0) {
                for (int i = 0; i < folders.length - 1; ++i) {
                    String folder = folders[i];
                    File f = new File(origin + File.separator + folder);
                    if (f.exists()) continue;
                    f.mkdir();
                    origin = f.getAbsolutePath();
                }
            }
            try {
                FileUtils.touch((File)sfile);
            }
            catch (IOException e) {
                System.out.println("Failed to touch " + sfile.getAbsolutePath() + " " + e);
            }
        }
        String scriptEngine = ScriptUtils.chooseScriptEngine(project);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), project.getEncoding())));
            out.print(ScriptUtils.createProperScript(scriptEngine, script.getContent(), isComplementProcessFunc));
        }
        catch (IOException e) {
            logger.error(filename + " write error.", (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            this.processedFileSet.add(filename);
        }
    }

    private String createScriptFilename(String id, Script script) {
        String type = script.getType();
        String filename = null;
        if (type.startsWith("controller_")) {
            String rest = type.substring("controller_".length());
            int ptr = rest.indexOf("_");
            String action = rest.substring(0, ptr);
            String event = rest.substring(ptr + 1);
            if ("ShowList".equals(action) && ("Show".equals(event) || "Update".equals(event) || "Copy".equals(event))) {
                action = event;
            }
            if ("UpdateTransaction".equals(event)) {
                event = "updateTransaction";
            }
            filename = action + "${id}_" + event + ".js";
        } else {
            filename = this.filenamePatternMap.get(type);
        }
        if (filename == null) {
            logger.error("illegal script pattern, " + type);
            return null;
        }
        if (filename.indexOf("${id}") >= 0) {
            filename = filename.replace("${id}", StringUtil.capFirst((String)id));
        }
        if (filename.indexOf("${itemname}") >= 0) {
            String name = script.getName();
            if (name.indexOf("/") > 0) {
                name = AppSchemaUtil.getChildPart(name);
            }
            filename = filename.replace("${itemname}", StringUtil.capFirst((String)name));
        }
        return filename;
    }
}

