/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptPropertyCreator {
    protected Logger logger = LogManager.getLogger((String)ScriptPropertyCreator.class.getName());
    protected Map<String, Object> propertyMap = new TreeMap<String, Object>();

    public void setProperty(String key, String value) {
        this.propertyMap.put(key, value);
    }

    public void setProperty(String key, int value) {
        StringBuilder sb = new StringBuilder();
        sb.append("'").append(value).append("'");
        this.propertyMap.put(key, sb.toString());
    }

    public void setProperty(String key, boolean value) {
        this.propertyMap.put(key, value);
    }

    public boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    public String create() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder propString = new StringBuilder();
        for (String key : this.propertyMap.keySet()) {
            Object obj = this.propertyMap.get(key);
            if (obj == null) continue;
            if (propString.length() > 0) {
                propString.append(", ");
            }
            propString.append(key).append(": ");
            if (obj instanceof String) {
                String s = (String)obj;
                if (key.startsWith("on")) {
                    propString.append("function(event) { ").append(s).append(" }");
                    continue;
                }
                propString.append(s);
                continue;
            }
            if (!(obj instanceof Boolean)) continue;
            Boolean b = (Boolean)obj;
            propString.append(b);
        }
        return propString.toString();
    }
}

