/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.text.DecimalFormat;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CompatibilityManager;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.appschema.AwsConnectInfo;
import jp.jasminesoft.jfc.gen.appschema.Environment;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.FileTemplateManager;
import org.apache.commons.lang.StringUtils;

public class SetClasspathGenerator
extends ConfigGenerator {
    static final int UNIX_SH = 0;
    static final int WINDOWS_BATCH = 1;
    static final int WINDOWS_TOMCAT5EXE = 2;
    private String outputfilename;
    private int type;
    private boolean isFullBuild;

    public SetClasspathGenerator(String tmplatefilename, Project project, String outputfilename, int type) {
        this(tmplatefilename, project, outputfilename, type, true);
    }

    public SetClasspathGenerator(String tmplatefilename, Project project, String outputfilename, int type, boolean isFullBuild) {
        super(tmplatefilename, project);
        this.outputfilename = outputfilename;
        this.type = type;
        this.isFullBuild = isFullBuild;
    }

    @Override
    public String getFileSuffix() {
        if (this.type == 1 || this.type == 2) {
            return ".bat";
        }
        return ".sh";
    }

    @Override
    public String getFilename() {
        return this.outputfilename;
    }

    @Override
    public String getSubpackageName() {
        return "bin";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = null;
        tplman = this.type == 0 ? new FileTemplateManager(this.tmplatefilename, null, "\n") : new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        Environment env = this.project.getEnvironment();
        SetClasspathGenerator.addContentMemorySetting(tplman, env);
        String options = "";
        if (env != null && (options = env.getTomcatOption()) == null) {
            options = "";
        }
        if (CompatibilityManager.getInstance().getBooleanValue("jp.jasminesoft.jfc.gen.SetClasspathGenerator.noverify") && !this.isFullBuild) {
            options = options + " -noverify -XX:TieredStopAtLevel=1";
        }
        AwsConnectInfo aci = AppSchemaUtil.getAwsConnectInfo(env);
        String aws_region = null;
        if (aci != null) {
            if (StringUtils.isNotBlank((String)aci.getAccessKey())) {
                options = options + " -Daws.accessKeyId=" + aci.getAccessKey();
            }
            if (StringUtils.isNotBlank((String)aci.getSecretKey())) {
                options = options + " -Daws.secretAccessKey=" + aci.getSecretKey();
            }
            aws_region = aci.getRegion();
        }
        if (StringUtils.isNotBlank(aws_region)) {
            if (this.type == 2) {
                tplman.addContent("AWS_REGION_ENV", " --Environment AWS_REGION=" + aws_region);
            } else if (this.type == 1 || this.type == 0) {
                tplman.addContent("AWS_REGION", aws_region);
                tplman.addContent("AWS_REGION_COMMENT", "");
            }
        } else if (this.type == 2) {
            tplman.addContent("AWS_REGION_ENV", "");
        } else if (this.type == 1 || this.type == 0) {
            tplman.addContent("AWS_REGION", "ap-northeast-1");
            if (this.type == 1) {
                tplman.addContent("AWS_REGION_COMMENT", "rem ");
            } else if (this.type == 0) {
                tplman.addContent("AWS_REGION_COMMENT", "# ");
            }
        }
        if (options != null) {
            StringBuilder sb;
            if (options.length() == 0) {
                tplman.addContent("options", options);
            } else if (this.type == 1) {
                String[] ops;
                sb = new StringBuilder();
                for (String op : ops = options.trim().split(" +")) {
                    if (StringUtils.isBlank((String)op)) continue;
                    sb.append(" ");
                    sb.append("\"");
                    sb.append(op);
                    sb.append("\"");
                }
                tplman.addContent("options", sb.toString());
            } else if (this.type == 2) {
                sb = new StringBuilder();
                StringTokenizer st = new StringTokenizer(options);
                while (st.hasMoreTokens()) {
                    sb.append(";");
                    sb.append(st.nextToken());
                }
                String s = sb.toString();
                tplman.addContent("options", s);
            } else if (this.type == 0) {
                sb = new StringBuilder();
                StringTokenizer st = new StringTokenizer(options);
                while (st.hasMoreTokens()) {
                    sb.append("\\ ");
                    sb.append(st.nextToken());
                }
                String s = sb.toString();
                tplman.addContent("options", s);
            }
        }
        String deployname = AppSchemaUtil.getWebappName(this.project);
        tplman.addContent("appname", deployname);
        return tplman.getResult();
    }

    public static void addContentMemorySetting(FileTemplateManager tplman, Environment env) {
        MemorySetting memsetting = new MemorySetting(env);
        tplman.addContent("mxmem", memsetting.getMxmem());
        tplman.addContent("msmem", memsetting.getMsmem());
        tplman.addContent("maxRAMPercentage", memsetting.getMaxRAMPercentage());
        tplman.addContent("initialRAMPercentage", memsetting.getInitialRAMPercentage());
        tplman.addContent("maxramoption", memsetting.getMaxramoption());
        tplman.addContent("initramoption", memsetting.getInitramoption());
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            if (this.type == 1 || this.type == 2) {
                return "rem genclassname:" + this.getClass().getName() + "\r\n";
            }
            return "# genclassname:" + this.getClass().getName() + "\n";
        }
        return "";
    }

    public static class MemorySetting {
        private static final int DEFAULT_MXMEM = 512;
        private static final int DEFAULT_MSMEM = 64;
        String mxmem;
        String msmem;
        String maxRAMPercentage;
        String initialRAMPercentage;
        String maxramoption;
        String initramoption;

        public MemorySetting(Environment env) {
            String mxmem1 = null;
            String msmem1 = null;
            Double maxRAMPercentage1 = null;
            Double initialRAMPercentage1 = null;
            if (env != null) {
                mxmem1 = env.getMxmem();
                msmem1 = env.getMsmem();
                maxRAMPercentage1 = env.getMaxRAMPercentageAsDouble();
                this.maxRAMPercentage = maxRAMPercentage1 == null ? "" : ((Object)maxRAMPercentage1).toString();
                initialRAMPercentage1 = env.getInitialRAMPercentageAsDouble();
                this.initialRAMPercentage = initialRAMPercentage1 == null ? "" : ((Object)initialRAMPercentage1).toString();
            }
            int mxmem2 = StringUtils.isNotBlank(mxmem1) ? Integer.parseInt(mxmem1) : 512;
            this.mxmem = Integer.toString(mxmem2);
            int msmem2 = StringUtils.isNotBlank((String)msmem1) ? Integer.parseInt(msmem1) : 64;
            this.msmem = Integer.toString(msmem2);
            if (msmem2 > mxmem2) {
                this.mxmem = this.msmem;
            }
            DecimalFormat format = new DecimalFormat("#.0");
            this.maxramoption = StringUtils.isNotBlank((String)this.maxRAMPercentage) ? "-XX:MaxRAMPercentage=" + format.format(maxRAMPercentage1) : "-Xmx" + this.mxmem + "m";
            this.initramoption = StringUtils.isNotBlank((String)this.initialRAMPercentage) ? "-XX:InitialRAMPercentage=" + format.format(initialRAMPercentage1) : "-Xms" + this.msmem + "m";
        }

        public String getMxmem() {
            return this.mxmem;
        }

        public String getMsmem() {
            return this.msmem;
        }

        public String getMaxRAMPercentage() {
            return this.maxRAMPercentage;
        }

        public String getInitialRAMPercentage() {
            return this.initialRAMPercentage;
        }

        public String getMaxramoption() {
            return this.maxramoption;
        }

        public String getInitramoption() {
            return this.initramoption;
        }
    }
}

