/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.File;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceWriter;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displaymenubar;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Navigationbar;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SourceGenerator
implements ISourceVariable {
    protected Project project;
    protected Logger logger = null;

    public SourceGenerator(Project project) {
        this.project = project;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public boolean isDebug() {
        return false;
    }

    public boolean isWagby() {
        return this.project != null && StringUtil.doubleValue((String)this.project.getVersion()) >= 5.0;
    }

    public static boolean isWagby(Project project) {
        return project != null && StringUtil.doubleValue((String)project.getVersion()) >= 5.0;
    }

    public Project getProject() {
        return this.project;
    }

    public abstract String getFileSuffix();

    protected void createSource(String content, String filename) {
        this.createSource(content, filename, null, true);
    }

    protected void createSource(String content, String filename, String subpackagename) {
        this.createSource(content, filename, subpackagename, true);
    }

    protected void createSource(String content, String filename, String subpackagename, boolean p) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return;
        }
        try {
            if (this.isDebug()) {
                System.out.println(this.project.getBasedir());
                System.out.println(p);
                System.out.println(this.getPackageName());
                System.out.println(subpackagename);
                System.out.println(filename);
                System.out.println(this.getFileSuffix());
                System.out.println(this.getEncoding());
                System.out.println(this.getModelPackageName());
            }
            SourceWriter.write(this.project.getBasedir(), p ? this.getPackageName() : "", subpackagename, filename, this.getFileSuffix(), content, this.getEncoding(), this.getModelPackageName());
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public String getPackageName() {
        return this.project.getPackage();
    }

    public String getModelPackageName() {
        return null;
    }

    public abstract void process();

    public String getEncoding() {
        return JavaSourceGenerator.getEncoding(this.project);
    }

    public String gBegin() {
        return "{" + CR;
    }

    public String gEnd() {
        return "}" + CR;
    }

    public static String convClassname4Relax(String s) {
        return StringUtil.convClassname4Relax((String)s);
    }

    public static String convRelaxnameToOriginal(String s) {
        StringBuilder sb = new StringBuilder();
        if (s == null) {
            return sb.toString();
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append("_");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String convertELId(String name) {
        return name;
    }

    public static String convertELProperty(String name) {
        return StringUtil.convertELProperty((String)name);
    }

    public static String convertRequestAttributeKey(String attrkey) {
        return SourceGenerator.convClassname4Relax(attrkey);
    }

    public static String convertRdbColumnname(String name) {
        return SourceGenerator.convClassname4Relax(name);
    }

    public static String convertInstanceNameInRelaxerObject(String name) {
        return StringUtil.convertInstanceNameInRelaxerObject((String)name);
    }

    public static String convertJspFilename(String filename) {
        return SourceGenerator.convClassname4Relax(filename);
    }

    public static String convertPrintlayoutXslFilename(String filename) {
        return SourceGenerator.convClassname4Relax(filename);
    }

    public static String convMasterID(String id) {
        if (id != null && id.endsWith("_m")) {
            id = id.substring(0, id.length() - "_m".length()) + "M";
        }
        return id;
    }

    public static String capFirst(String name) {
        return StringUtil.capFirst((String)name);
    }

    public static String uncapFirst(String name) {
        return StringUtil.uncapFirst((String)name);
    }

    public static String gProperCondition(String src) {
        String ret;
        String string = ret = src != null ? src.toUpperCase() : "=";
        if ("GE".equals(ret)) {
            ret = ">=";
        } else if ("LE".equals(ret)) {
            ret = "<=";
        } else if ("GT".equals(ret)) {
            ret = ">";
        } else if ("LT".equals(ret)) {
            ret = "<";
        } else if ("EQ".equals(ret)) {
            ret = "==";
        } else if ("NEQ".equals(ret) || "NE".equals(ret)) {
            ret = "!=";
        }
        return ret;
    }

    public static String getElementNameByNestLevel(String s, int i) {
        if (i < 0) {
            return null;
        }
        if (s.charAt(0) == '/') {
            s = s.substring(1);
        }
        int nextp = 0;
        while (i-- > 0) {
            nextp = s.indexOf("/");
            if (nextp < 0) {
                return null;
            }
            s = s.substring(nextp + 1);
        }
        nextp = s.indexOf("/");
        if (nextp > 0) {
            s = s.substring(0, nextp);
        }
        return s;
    }

    public static String getFullNameByNestLevel(String s, int i) {
        if (i < 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (s.charAt(0) == '/') {
            buf.append('/');
            s = s.substring(1);
        }
        int nextp = 0;
        while (i-- > 0) {
            nextp = s.indexOf("/");
            if (nextp < 0) {
                return null;
            }
            buf.append(s.substring(0, nextp + 1));
            s = s.substring(nextp + 1);
        }
        nextp = s.indexOf("/");
        if (nextp > 0) {
            s = s.substring(0, nextp);
        }
        buf.append(s);
        return buf.toString();
    }

    private static String getXsltFilename(String prefix, String id) {
        return prefix + SourceGenerator.capFirst(id) + ".xsl";
    }

    private static String getJspFilename(String prefix, String id) {
        return prefix + SourceGenerator.capFirst(id) + ".jsp";
    }

    public static String getXsltFilename(Navigationbar navigationbar) {
        String outputfilename;
        String string = outputfilename = navigationbar != null ? navigationbar.getXslt() : null;
        if (outputfilename == null || outputfilename.length() == 0) {
            outputfilename = SourceGenerator.getXsltFilename("nav", navigationbar.getIdref());
        } else if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith("xsl")) {
            outputfilename = outputfilename + "xsl";
        }
        return outputfilename;
    }

    public static String getOutputFilename(Navigationbar navigationbar, Project project) {
        String outputfilename = null;
        String suffix = null;
        if (SourceGenerator.isWagby(project)) {
            outputfilename = navigationbar != null ? navigationbar.getOutputfilename() : null;
            suffix = ".jsp";
        } else {
            outputfilename = navigationbar.getXslt();
            if (outputfilename == null || outputfilename.length() == 0) {
                outputfilename = navigationbar.getOutputfilename();
            }
            suffix = ".xsl";
        }
        if (outputfilename == null || outputfilename.length() == 0) {
            outputfilename = SourceGenerator.isWagby(project) ? SourceGenerator.getJspFilename("nav", navigationbar.getIdref()) : SourceGenerator.getXsltFilename("nav", navigationbar.getIdref());
        } else if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith(suffix)) {
            outputfilename = outputfilename + suffix;
        }
        return outputfilename;
    }

    public static String getXsltFilename(Displaycondition displaycondition) {
        String outputfilename;
        String string = outputfilename = displaycondition != null ? displaycondition.getXslt() : null;
        if (outputfilename == null || outputfilename.length() == 0) {
            if (displaycondition.getIdref() != null) {
                outputfilename = displaycondition.getIdref();
            }
            outputfilename = SourceGenerator.getXsltFilename("condition", outputfilename);
        } else if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith(".xsl")) {
            outputfilename = outputfilename + ".xsl";
        }
        return outputfilename;
    }

    public static String getOutputFilename(Displaycondition displaycondition, Project project) {
        return SourceGenerator.getOutputFilename(displaycondition, "", project);
    }

    public static String getOutputFilename(Displaycondition displaycondition, String prefix, Project project) {
        String outputfilename = null;
        String suffix = null;
        String string = prefix = prefix == null ? "" : prefix;
        if (SourceGenerator.isWagby(project)) {
            outputfilename = displaycondition != null ? displaycondition.getOutputfilename() : null;
            suffix = ".jsp";
        } else {
            String string2 = outputfilename = displaycondition != null ? displaycondition.getXslt() : null;
            if (outputfilename == null || outputfilename.length() == 0) {
                outputfilename = displaycondition != null ? displaycondition.getOutputfilename() : null;
            }
            suffix = ".xsl";
        }
        if (outputfilename == null || outputfilename.length() == 0) {
            if (displaycondition != null && displaycondition.getIdref() != null) {
                outputfilename = displaycondition.getIdref();
            }
            outputfilename = SourceGenerator.isWagby(project) ? SourceGenerator.getJspFilename("condition" + prefix, outputfilename) : SourceGenerator.getXsltFilename("condition" + prefix, outputfilename);
        } else if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith(suffix)) {
            outputfilename = outputfilename + suffix;
        }
        if (displaycondition != null && displaycondition.getTextsearch()) {
            if (outputfilename.endsWith(suffix)) {
                outputfilename = outputfilename.substring(0, outputfilename.length() - suffix.length());
            }
            outputfilename = outputfilename + "Index" + suffix;
        }
        return outputfilename;
    }

    public static String getXsltFilename(String xslt_prefix, String idref, Displaymodel displaymodel) {
        String outputfilename;
        String string = outputfilename = displaymodel != null ? displaymodel.getXslt() : null;
        if (outputfilename == null || outputfilename.length() == 0) {
            String type = displaymodel.getType();
            outputfilename = type != null && type.length() > 0 ? SourceGenerator.getXsltFilename(type, idref) : SourceGenerator.getXsltFilename(xslt_prefix, idref);
        } else if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith(".xsl")) {
            outputfilename = outputfilename + ".xsl";
        }
        return outputfilename;
    }

    public static String getOutputFilename(String prefix, String idref, Displaymodel displaymodel, Project project) {
        String outputfilename = null;
        String suffix = null;
        if (SourceGenerator.isWagby(project)) {
            outputfilename = displaymodel != null ? displaymodel.getOutputfilename() : null;
            suffix = ".jsp";
        } else {
            String string = outputfilename = displaymodel != null ? displaymodel.getXslt() : null;
            if (outputfilename == null || outputfilename.length() == 0) {
                outputfilename = displaymodel.getOutputfilename();
            }
            suffix = ".xsl";
        }
        if (outputfilename == null || outputfilename.length() == 0) {
            String type = displaymodel.getType();
            outputfilename = type != null && type.length() > 0 ? (SourceGenerator.isWagby(project) ? SourceGenerator.getJspFilename(type, idref) : SourceGenerator.getXsltFilename(type, idref)) : (SourceGenerator.isWagby(project) ? SourceGenerator.getJspFilename(prefix, idref) : SourceGenerator.getXsltFilename(prefix, idref));
        } else if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith(suffix)) {
            outputfilename = outputfilename + suffix;
        }
        return outputfilename;
    }

    public static String getXsltFilename(Displaymenubar displaymenubar) {
        String xsltfilename;
        String string = xsltfilename = displaymenubar != null ? displaymenubar.getXslt() : null;
        if (xsltfilename == null || xsltfilename.length() == 0) {
            return null;
        }
        if (!(xsltfilename = SourceGenerator.convClassname4Relax(xsltfilename)).endsWith(".xsl")) {
            xsltfilename = xsltfilename + ".xsl";
        }
        return xsltfilename;
    }

    public static String getOutputFilename(Displaymenubar displaymenubar, Project project) {
        String outputfilename = null;
        String suffix = null;
        if (SourceGenerator.isWagby(project)) {
            outputfilename = displaymenubar != null ? displaymenubar.getOutputfilename() : null;
            suffix = ".jsp";
        } else {
            String string = outputfilename = displaymenubar != null ? displaymenubar.getXslt() : null;
            if (outputfilename == null || outputfilename.length() == 0) {
                outputfilename = displaymenubar.getOutputfilename();
            }
            suffix = ".xsl";
        }
        if (outputfilename == null || outputfilename.length() == 0) {
            return null;
        }
        if (!(outputfilename = SourceGenerator.convClassname4Relax(outputfilename)).endsWith(suffix)) {
            outputfilename = outputfilename + suffix;
        }
        return outputfilename;
    }

    protected String addModelidToFilename(Action action, String filename) {
        String modelid = action != null ? action.getIdref() : null;
        return this.addModelidToFilename(modelid, filename);
    }

    protected String addModelidToFilename(String modelid, String filename) {
        if (modelid == null || modelid.length() == 0) {
            modelid = "system";
        }
        filename = modelid + File.separator + filename;
        return filename;
    }

    protected String getGeneratorClassName() {
        return "genclassname:" + this.getClass().getName();
    }
}

