/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.sourcefilemanager.GeneratorControllerFile;
import jp.jasminesoft.jfc.gen.sourcefilemanager.IGeneratorController;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceWriter {
    private static final String CUSTOMIZED_FILE_SUFFIX = ".gen";
    protected static Logger logger = LogManager.getLogger((String)SourceWriter.class.getName());
    private static int num_of_files = 0;
    private static long num_of_text = 0L;
    private static long num_of_line = 0L;

    public static void write(String basedir, String pkgname, String subpkgname, String filename, String suffix, String contents, String enc) throws IOException {
        SourceWriter.write(basedir, pkgname, subpkgname, filename, suffix, contents, enc, null);
    }

    public static void write(String basedir, String pkgname, String subpkgname, String filename, String suffix, String contents, String enc, String modelpackagename) throws IOException {
        StringBuilder filepath = new StringBuilder();
        if (modelpackagename != null && modelpackagename.length() > 0) {
            String _modelpkgname = JavaSourceGenerator.convPackage2FilePath(modelpackagename);
            filepath.append("/").append(_modelpkgname);
        } else {
            if (pkgname != null && pkgname.length() > 0) {
                String _pkgname = JavaSourceGenerator.convPackage2FilePath(pkgname);
                filepath.append("/").append(_pkgname);
            }
            if (subpkgname != null && subpkgname.length() > 0) {
                String _subpkgname = JavaSourceGenerator.convPackage2FilePath(subpkgname);
                filepath.append("/").append(_subpkgname);
            }
        }
        filepath.append("/").append(filename);
        if (!filepath.toString().endsWith(suffix)) {
            filepath.append(suffix);
        }
        if (ApplicationContextBean.existsCustomizeFile(filepath.toString())) {
            filepath.append(CUSTOMIZED_FILE_SUFFIX);
        }
        SourceWriter.write(basedir, filepath.toString(), contents, enc);
    }

    public static void write(String basedir, String filepath, String contents, String enc) throws IOException {
        if (enc == null || enc.length() == 0) {
            enc = System.getProperty("file.encoding");
        }
        PrintWriter out = null;
        IGeneratorController controller = GeneratorControllerFile.getInstance(basedir, enc);
        filepath = "/" + filepath;
        filepath = SourceWriter.normalizeFilepath(filepath);
        File fullfilepath = new File(SourceWriter.normalizeFilepath(basedir + "/" + filepath));
        fullfilepath.getParentFile().mkdirs();
        int hashCode = contents.hashCode();
        long time = new Date().getTime();
        if (!controller.isCreate(filepath, time, hashCode)) {
            return;
        }
        if (!controller.hasContain(filepath)) {
            controller.adjustFilePathCase(fullfilepath);
        }
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullfilepath), enc)));
            out.print(contents);
            controller.insertOrUpdate(filepath, time, hashCode);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            ++num_of_files;
            num_of_text += (long)contents.length();
            num_of_line += SourceWriter.getNumOfLine(contents);
        }
    }

    public static String normalizeFilepath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            path = path.replace('\\', File.separatorChar);
        }
        path = path.replaceAll("[" + Pattern.quote(File.separator) + "]+", Matcher.quoteReplacement(File.separator));
        path = StringUtils.removeStart((String)path, (String)("." + File.separator));
        return path;
    }

    public static int getFileNum() {
        return num_of_files;
    }

    public static long getTextSize() {
        return num_of_text;
    }

    public static long getLineSize() {
        return num_of_line;
    }

    private static long getNumOfLine(String s) {
        long count = 0L;
        if (s == null) {
            return count;
        }
        String _s = null;
        for (int i = 0; i < s.length() - ISourceVariable.CR.length() + 1; ++i) {
            _s = s.substring(i, i + ISourceVariable.CR.length());
            if (!ISourceVariable.CR.equals(_s)) continue;
            ++count;
        }
        return count;
    }

    public static void close(Set<String> targetModelIdSet) {
        IGeneratorController controller = GeneratorControllerFile.getInstance();
        controller.commit(targetModelIdSet);
        SourceWriter.reset();
    }

    public static void reset() {
        num_of_files = 0;
        num_of_text = 0L;
        num_of_line = 0L;
    }
}

