/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.appschema.ActionUtils;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ApplicationContextBean;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpringApplicationContextContainer
implements ISourceVariable {
    protected static Logger logger = LogManager.getLogger((String)SpringApplicationContextContainer.class.getName());
    private static Map<String, ApplicationContextBean> applicationContextMap;

    public static String addApplicationContextBean(String beanId, String beanClass) {
        return SpringApplicationContextContainer.addApplicationContextBean(new ApplicationContextBean(beanId, beanClass));
    }

    public static String addApplicationContextBean(String beanId, String beanClass, String applicationContextPath) {
        return SpringApplicationContextContainer.addApplicationContextBean(new ApplicationContextBean(beanId, beanClass, applicationContextPath));
    }

    public static String addApplicationContextBean(ApplicationContextBean bean) {
        return SpringApplicationContextContainer.addApplicationContextBean(bean, 1);
    }

    private static String addApplicationContextBean(ApplicationContextBean bean, int suffix) {
        ApplicationContextBean _bean = applicationContextMap.get(bean.getBeanId());
        if (_bean != null && !_bean.getBeanClass().equals(bean.getBeanClass())) {
            return SpringApplicationContextContainer.addApplicationContextBean(_bean.getBeanId() + ++suffix, _bean.getBeanClass(), _bean.getApplicationContextPath());
        }
        if (_bean != null && !_bean.getApplicationContextPath().equals(bean.getApplicationContextPath())) {
            logger.error("same bean id exists, but another applicationContextPath!");
        }
        if (_bean == null) {
            logger.debug("bean.getBeanId():" + bean.getBeanId());
            if (bean.getBeanId().endsWith("PCSVHelper")) {
                bean.addProperty("presentationHelper", new ApplicationContextBean.ReferenceElement(bean.getBeanId().replace("PCSVHelper", "PHelper")));
            }
            applicationContextMap.put(bean.getBeanId(), bean);
        }
        return bean.getBeanId();
    }

    public static boolean isExistApplicationContextBean(ApplicationContextBean bean) {
        ApplicationContextBean _bean = applicationContextMap.get(bean.getBeanId());
        return _bean != null && !_bean.getBeanClass().equals(bean.getBeanClass());
    }

    public static String[] getApplicationContextPaths() {
        TreeSet<String> paths = new TreeSet<String>();
        Iterator<String> it = applicationContextMap.keySet().iterator();
        while (it.hasNext()) {
            ApplicationContextBean bean = applicationContextMap.get(it.next());
            paths.add(bean.getApplicationContextPath());
        }
        return paths.toArray(new String[0]);
    }

    public static ApplicationContextBean[] getApplicationContextBeans(String applicationContextPath) {
        if (applicationContextPath == null) {
            return null;
        }
        ArrayList<ApplicationContextBean> list = new ArrayList<ApplicationContextBean>();
        for (ApplicationContextBean bean : applicationContextMap.values()) {
            if (!applicationContextPath.equals(bean.getApplicationContextPath())) continue;
            list.add(bean);
        }
        return list.toArray(new ApplicationContextBean[0]);
    }

    public static void addEntityService(String daoClassName, String daoHelperClassName, String entityServiceClassName, Model storeModel) {
        ApplicationContextBean service = SpringApplicationContextContainer.createApplicationContextBean(entityServiceClassName);
        service.setSingleton(true);
        SpringApplicationContextContainer.addApplicationContextBean(service);
        ApplicationContextBean dao = SpringApplicationContextContainer.createApplicationContextBean(daoClassName);
        dao.setSingleton(true);
        SpringApplicationContextContainer.addApplicationContextBean(dao);
        ApplicationContextBean daoHelper = SpringApplicationContextContainer.createApplicationContextBean(daoHelperClassName);
        daoHelper.setSingleton(true);
        SpringApplicationContextContainer.addApplicationContextBean(daoHelper);
        String helperClassName = AppSchemaUtil.getHelperClassBeanName4Dicon(storeModel, ModelUtils.getProject(storeModel));
        service.addProperty("entityHelper", new ApplicationContextBean.ReferenceElement(helperClassName));
        service.addProperty("dao", dao);
        service.addLookupMethod("getActionParameterContainer", "ActionParameterContainer");
        dao.addProperty("sessionFactory", new ApplicationContextBean.ReferenceElement(new StoreModel(storeModel).sessionFactoryBeanId()));
        dao.addProperty("helper", daoHelper);
        dao.addLookupMethod("getRequestScopedInterceptors", "RequestScopedInterceptors");
        daoHelper.addProperty("entityHelper", new ApplicationContextBean.ReferenceElement(helperClassName));
        daoHelper.addLookupMethod("getActionParameterContainer", "ActionParameterContainer");
    }

    public static void addCriteriaConverter(String criteriaConverterClassName, Action action) {
        ApplicationContextBean criteriaConverter = SpringApplicationContextContainer.createApplicationContextBean(criteriaConverterClassName);
        Project project = ActionUtils.getProject(action);
        Model conditionModel = AppSchemaUtil.getConditionModel(project, action);
        String helperClassName = AppSchemaUtil.getHelperClassBeanName4Dicon(conditionModel, project);
        criteriaConverter.addProperty("conditionHelper", new ApplicationContextBean.ReferenceElement(helperClassName));
        SpringApplicationContextContainer.addApplicationContextBean(criteriaConverter);
    }

    public static void addFinderContext(String criteriaConverterClassName, Action showlistAction) {
        SpringApplicationContextContainer.addCriteriaConverter(criteriaConverterClassName, showlistAction);
        String finderContextBeanId = ActionUtils.getFinderContextBeanId(showlistAction);
        ApplicationContextBean finderContext = new ApplicationContextBean(finderContextBeanId, "jp.jasminesoft.jfc.dao.FinderContext", null, showlistAction.getIdref());
        finderContext.setScope("session");
        SpringApplicationContextContainer.addApplicationContextBean(finderContext);
        finderContext.addProperty("criteriaConverter", new ApplicationContextBean.ReferenceElement(ClassUtils.getShortClassName((String)criteriaConverterClassName)));
    }

    public static void addMapBasedCriteriaConverter(Model model) {
        StoreModel smodel = new StoreModel(model);
        String beanid = smodel.getBeanName();
        String ccbeanid = beanid + "MapBasedCriteriaConverter";
        String metaclass = smodel.getPackage() + "." + smodel.getMetaClassName();
        ApplicationContextBean ccbean = new ApplicationContextBean(ccbeanid, "jp.jasminesoft.jfc.dao.MapBasedCriteriaConverter", null, model.getId());
        ccbean.setScope("prototype");
        ApplicationContextBean.ConstructorArgType cargtype = new ApplicationContextBean.ConstructorArgType();
        cargtype.setContent("<bean class=\"" + metaclass + "\" scope=\"prototype\"/>");
        ccbean.addConstructorArg(cargtype);
        SpringApplicationContextContainer.addApplicationContextBean(ccbean);
    }

    public static void setPropertyForMapBasedCriteriaConverter(Model model) {
        StoreModel smodel = new StoreModel(model);
        String beanid = smodel.getBeanName();
        String ccbeanid = beanid + "MapBasedCriteriaConverter";
        ApplicationContextBean ccbean = applicationContextMap.get(ccbeanid);
        if (ccbean == null) {
            return;
        }
        String dccbeanid = beanid + "CriteriaConverter";
        if (applicationContextMap.containsKey(dccbeanid)) {
            ccbean.addProperty("defaultCriteriaConverter", new ApplicationContextBean.ReferenceElement(dccbeanid));
        }
    }

    public static void addShowFkeyFinderContext(Action action) {
        Dataitem[] dataitems = AppSchemaUtil.getDataitems(action);
        if (dataitems == null) {
            return;
        }
        for (Dataitem dataitem : dataitems) {
            if (!dataitem.getType().equals("array2list") && !dataitem.getType().equals("reverse")) continue;
            SpringApplicationContextContainer.addShowFkeyFinderContext(action, dataitem);
        }
    }

    protected static void addShowFkeyFinderContext(Action action, Dataitem dataitem) {
        Model model = (Model)action.getIdrefAsIRNode();
        if (model == null) {
            return;
        }
        Model smodel = AppSchemaUtil.getStoreModel(model);
        if (smodel == null) {
            return;
        }
        Model rmodel = (Model)dataitem.getIdrefAsIRNode();
        if (rmodel == null) {
            return;
        }
        Model r3model = AppSchemaUtil.getStoreModel(rmodel);
        if (r3model == null) {
            return;
        }
        StoreModel modelstoremodel = new StoreModel(smodel);
        StoreModel r3storemodel = new StoreModel(r3model);
        String beanid = r3storemodel.getBeanName();
        String ccbeanid = beanid + "ForeignKeyCriteriaConverter";
        if (dataitem.getType().equals("reverse")) {
            ccbeanid = beanid + "MapBasedCriteriaConverter";
        }
        String finderContextBeanId = "show" + modelstoremodel.getBeanName() + "Fkey" + r3storemodel.getBeanName() + "FinderContext";
        ApplicationContextBean finderContext = new ApplicationContextBean(finderContextBeanId, "jp.jasminesoft.jfc.dao.FinderContext", null, action.getIdref());
        finderContext.setScope("session");
        if (dataitem.getType().equals("reverse")) {
            finderContext.addProperty("criteriaConverter", new ApplicationContextBean.ReferenceElement(ccbeanid));
        } else {
            ApplicationContextBean criteriaConverter = new ApplicationContextBean("", "jp.jasminesoft.jfc.dao.ForeignKeyCriteriaConverter");
            ReflectionUtils.setPrivateField((Object)criteriaConverter, (String)"beanId", null);
            criteriaConverter.setScope("prototype");
            criteriaConverter.addProperty("parentModelId", smodel.getId());
            if (SpringApplicationContextContainer.includingImplicit(r3model) && dataitem.getIncludingImplicit()) {
                criteriaConverter.addProperty("includingImplicit", "true");
            }
            ApplicationContextBean.ConstructorArgType cargtype = new ApplicationContextBean.ConstructorArgType();
            cargtype.setContent("<bean class=\"" + r3storemodel.getPackage() + "." + r3storemodel.getMetaClassName() + "\" scope=\"prototype\"/>");
            criteriaConverter.addConstructorArg(cargtype);
            finderContext.addProperty("criteriaConverter", new ApplicationContextBean.XmlString(StringUtils.enclose((String)criteriaConverter.makeTextDocument("      "), (String)CR, (String)(CR + "    "))));
        }
        int maxresults = dataitem.checkMaxresult() ? dataitem.getMaxresult() : -1;
        finderContext.addProperty("pageSize", Integer.toString(maxresults));
        SpringApplicationContextContainer.addApplicationContextBean(finderContext);
        ApplicationContextBean finderContextShowArray = new ApplicationContextBean(finderContextBeanId + "ShowArray", finderContext);
        finderContextShowArray.setScope("prototype");
        SpringApplicationContextContainer.addApplicationContextBean(finderContextShowArray);
    }

    private static boolean includingImplicit(Model model) {
        Action action = AppSchemaUtil.getActionByModelIdAndType(ModelUtils.getProject(model), model.getId(), "showList");
        return AppSchemaUtil.isUseImplicitCondition(action);
    }

    public static void addRestDataConverter(String restDataConverterClassName) {
        ApplicationContextBean restDataConverter = SpringApplicationContextContainer.createApplicationContextBean(restDataConverterClassName);
        SpringApplicationContextContainer.addApplicationContextBean(restDataConverter);
    }

    public static ApplicationContextBean createApplicationContextBean(String className) {
        return new ApplicationContextBean(ClassUtils.getShortClassName((String)className), className);
    }

    public static void reset() {
        applicationContextMap = new TreeMap<String, ApplicationContextBean>();
    }

    static {
        SpringApplicationContextContainer.reset();
    }
}

