/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Autocalc;
import jp.jasminesoft.jfc.gen.appschema.Column;
import jp.jasminesoft.jfc.gen.appschema.Control;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Panelgroup;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextSearchUtil {
    private static Logger logger = LogManager.getLogger(TextSearchUtil.class);
    public static final int TEXTSEARCH_SUGGEST_PAGE_SIZE = 20;

    public static Model getMainmodel(Project project, Model model) {
        if (model.getMainmodelidref() != null) {
            return AppSchemaUtil.getModel(project, model.getMainmodelidref());
        }
        return null;
    }

    public static Model[] getSubmodelTextsearchReady(Project project, Model model) {
        Model[] models = AppSchemaUtil.getSubmodels(model, project);
        if (models == null) {
            models = new Model[]{};
        }
        ArrayList<Model> mList = new ArrayList<Model>();
        for (Model m : models) {
            if (!m.getTextsearch()) continue;
            mList.add(m);
        }
        return mList.toArray(new Model[0]);
    }

    public static boolean isTextsearchNecessary4(Project project, Model model) {
        if (model == null) {
            logger.debug("model:null return false: no model");
            return false;
        }
        if (model.getTextsearch()) {
            logger.debug("model:" + model.getId() + " return true: itself for textsearch");
            return true;
        }
        if (model.getMainmodelidref() != null) {
            Model mainModel = AppSchemaUtil.getModel(project, model.getMainmodelidref());
            if (mainModel != null && mainModel.getTextsearch()) {
                logger.debug("model:" + model.getId() + " return true: find main model:" + mainModel.getId());
                return true;
            }
            if (TextSearchUtil.isSubmodelTextsearchReady(project, mainModel)) {
                logger.debug("model:" + model.getId() + " return true: one of submodels of main model is textsearch ready");
                return true;
            }
        }
        return TextSearchUtil.isSubmodelTextsearchReady(project, model);
    }

    public static boolean isSubmodelTextsearchReady(Project project, Model model) {
        Model[] models = AppSchemaUtil.getSubmodels(model, project);
        if (models == null) {
            logger.debug("model:" + model.getId() + " return false: no submodels");
            return false;
        }
        for (Model m : models) {
            if (!m.getTextsearch()) continue;
            logger.debug("model:" + model.getId() + " return true: find sub model:" + m.getId());
            return true;
        }
        logger.debug("model:" + model.getId() + " return false: neither main model nor sub model");
        return false;
    }

    public static Modelitem[] getModelitem(Model model) {
        ArrayList<Modelitem> ret = new ArrayList<Modelitem>();
        for (IModelChoice imc : model.getContent()) {
            if (!(imc instanceof Modelitem)) continue;
            ret.add((Modelitem)imc);
        }
        return ret.toArray(new Modelitem[0]);
    }

    public static Model[] getModelUsingTextsearch(Project project) {
        ArrayList<Model> ret = new ArrayList<Model>();
        for (IProjectChoice ipc : project.getContent()) {
            Model model;
            if (!(ipc instanceof Model) || !TextSearchUtil.isTextsearchNecessary4(project, model = (Model)ipc)) continue;
            ret.add(model);
        }
        return ret.toArray(new Model[0]);
    }

    public static String createModel2MapFullname(Model model, Project project) {
        return AppSchemaUtil.getPackagename_app(model, project) + TextSearchUtil.createModel2MapClassname(model);
    }

    public static String createModel2MapClassname(Model model) {
        return AppSchemaUtil.getClassname(model) + "2Map";
    }

    public static String createShowListProcessBeanName(Model model, Project project) {
        return AppSchemaUtil.createProcessBeanName(model.getId(), "showList", AppSchemaUtil.getActionByModelIdAndType(project, model.getId(), "showList"), null, true);
    }

    static Model[] removeSubmodel(Model[] models) {
        ArrayList<Model> ret = new ArrayList<Model>();
        for (Model model : models) {
            if (AppSchemaUtil.isSubModel(model)) continue;
            ret.add(model);
        }
        return ret.toArray(new Model[ret.size()]);
    }

    public static String createTextSearchTargetModelDefinition(Project project) {
        TreeSet<String> midSet = new TreeSet<String>();
        HashMap<String, Model> modelMap = new HashMap<String, Model>();
        for (Model model : TextSearchUtil.removeSubmodel(TextSearchUtil.getModelUsingTextsearch(project))) {
            midSet.add(model.getId());
            modelMap.put(model.getId(), model);
        }
        StringBuilder mb = new StringBuilder();
        mb.append("[");
        boolean firstFlag = true;
        for (String mid : midSet) {
            if (!firstFlag) {
                mb.append(", ");
            }
            Model model = (Model)modelMap.get(mid);
            String classname = AppSchemaUtil.getPackagename(model, project) + AppSchemaUtil.getClassname(model);
            mb.append("{model:\"");
            mb.append(mid);
            mb.append("\",model2Map:\"");
            mb.append(TextSearchUtil.createModel2MapClassname(model));
            mb.append("\",showListBean:\"");
            mb.append(TextSearchUtil.createShowListProcessBeanName(model, project));
            mb.append("\",classname:\"");
            mb.append(classname);
            mb.append("\"}");
            if (!firstFlag) continue;
            firstFlag = false;
        }
        mb.append("]");
        return mb.toString();
    }

    public static boolean isModelitemForTextSearch(Project project, Modelitem mitem) {
        if (!mitem.checkTextsearch()) {
            return false;
        }
        if (!mitem.getTextsearch()) {
            return false;
        }
        if (mitem.getMultiple() && mitem.getHasChild()) {
            return false;
        }
        if (AppSchemaUtil.hasChildPart(mitem.getName()) && !TextSearchUtil.isStringType(project, mitem)) {
            return false;
        }
        return !TextSearchUtil.isModelitemAutocalc(mitem) || TextSearchUtil.isStringType(project, mitem);
    }

    public static boolean isStringType(Project project, Modelitem mitem) {
        Relation relation;
        if (JavaSourceGenerator.isStringType(mitem.getType())) {
            return true;
        }
        if ("storeref".equals(mitem.getType()) && !mitem.getTransient() && (relation = AppSchemaUtil.getRelationTypeIsRef(mitem)) != null) {
            Modelitem mm = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(project, "", mitem);
            if (JavaSourceGenerator.isStringType(mm.getType())) {
                return true;
            }
            Relation relation2 = AppSchemaUtil.getRelationTypeExceptRef(mm);
            if (relation2 != null) {
                Model rmodel = (Model)relation2.getIdrefAsIRNode();
                PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKey(rmodel);
                if (r_pkeys == null || r_pkeys.length > 1) {
                    return false;
                }
                Modelitem r_pkey_item = AppSchemaUtil.getModelitem(r_pkeys[0].getName(), rmodel);
                if (JavaSourceGenerator.isStringType(r_pkey_item.getType())) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isModelitemAutocalc(Modelitem mitem) {
        for (int i = 0; i < mitem.sizeContent(); ++i) {
            IModelitemChoice choice = mitem.getContent(i);
            if (!(choice instanceof Autocalc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModelitemForSuggest(Modelitem mitem) {
        if (mitem.getMultiple() && mitem.getHasChild()) {
            return false;
        }
        return !AppSchemaUtil.hasChildPart(mitem.getName());
    }

    public static Model getCPModel(Project project, Model model) {
        Model cm = AppSchemaUtil.getModel(project, model.getId(), "condition");
        if (cm == null) {
            return null;
        }
        Model cpm = AppSchemaUtil.getModel(project, cm.getId(), "presentation");
        if (!cpm.getId().endsWith("_cp")) {
            logger.error("this is not condtion presentation:" + cpm);
        }
        return cpm;
    }

    public static Model getPModel(Project project, Model model) {
        Model m = AppSchemaUtil.getModel(project, model.getId(), "presentation");
        if (!m.getId().endsWith("_p")) {
            logger.error("this is not presentation:" + m);
        }
        return m;
    }

    public static Control getControlTypeIsHidden(Modelitem mitem, Model targetModel) {
        Modelitem targetMitem = AppSchemaUtil.getModelitem(mitem.getName(), targetModel);
        if (targetMitem == null) {
            logger.debug("Mitem " + mitem.getName() + " is not found in " + targetModel.getId());
            return null;
        }
        return AppSchemaUtil.getControlTypeIsHidden(targetMitem, targetModel);
    }

    public static boolean isHiddenByPermissionInternal(Modelitem mitem, Model target) {
        if (target == null) {
            return false;
        }
        Control control = TextSearchUtil.getControlTypeIsHidden(mitem, target);
        if (control != null && StringUtils.isNotBlank((String)control.getPermactions())) {
            logger.debug("isHiddenByPermissionInternal:mitem:" + mitem.getName());
            return true;
        }
        return false;
    }

    public static boolean isHiddenByPermissionWithConditionInternal(Modelitem mitem, Model target) {
        if (target == null) {
            return false;
        }
        Control control = TextSearchUtil.getControlTypeIsHidden(mitem, target);
        if (control != null && StringUtils.isNotBlank((String)control.getPermactions()) && StringUtils.isNotBlank((String)control.getCondition())) {
            logger.debug("isHiddenByPermissionInternal:mitem:" + mitem.getName());
            return true;
        }
        return false;
    }

    public static boolean isHiddenByPermissionWithCondition(Modelitem mitem, Project project, Model model) {
        return TextSearchUtil.isHiddenByPermissionWithConditionInternal(mitem, TextSearchUtil.getCPModel(project, model)) || TextSearchUtil.isHiddenByPermissionWithConditionInternal(mitem, TextSearchUtil.getPModel(project, model));
    }

    public static Action[] findShowListActions(Action[] actions) {
        ArrayList<Action> ret = new ArrayList<Action>();
        for (Action action : actions) {
            if (!"showList".equals(action.getType())) continue;
            ret.add(action);
        }
        return ret.toArray(new Action[ret.size()]);
    }

    public static Presentation[] findListPresentations(Project project, Model model) {
        ArrayList<Presentation> ret = new ArrayList<Presentation>();
        Action[] actions = AppSchemaUtil.getActionByModelId(project, model.getId());
        if (actions != null) {
            for (Action showListAction : TextSearchUtil.findShowListActions(actions)) {
                Presentation[] pres = AppSchemaUtil.getPresentation(project, showListAction);
                if (pres == null) continue;
                for (Presentation pre : pres) {
                    ret.add(pre);
                }
            }
        }
        return ret.toArray(new Presentation[ret.size()]);
    }

    public static List<Displaymodel> findDisplaymodels(Panel panel) {
        ArrayList<Displaymodel> ret = new ArrayList<Displaymodel>();
        if (panel.getContent() == null) {
            return ret;
        }
        for (IPanelChoice ipc : panel.getContent()) {
            if (ipc instanceof Displaymodel) {
                Displaymodel displaymodel = (Displaymodel)ipc;
                ret.add(displaymodel);
                continue;
            }
            if (ipc instanceof Displaymodelgroup && ((Displaymodelgroup)ipc).getContent() != null) {
                for (IDisplaymodelgroupChoice iDisplaymodelgroupChoice : ((Displaymodelgroup)ipc).getContent()) {
                    if (iDisplaymodelgroupChoice instanceof Displaymodel) {
                        ret.add((Displaymodel)iDisplaymodelgroupChoice);
                        continue;
                    }
                    if (!(iDisplaymodelgroupChoice instanceof Panelgroup)) continue;
                    Panelgroup panelgroup = (Panelgroup)iDisplaymodelgroupChoice;
                    for (Panel _panel : panelgroup.getPanel()) {
                        List<Displaymodel> _ret = TextSearchUtil.findDisplaymodels(_panel);
                        if (_ret == null || _ret.size() <= 0) continue;
                        ret.addAll(_ret);
                    }
                }
                continue;
            }
            if (ipc instanceof Panel) {
                for (Displaymodel d : TextSearchUtil.findDisplaymodels((Panel)ipc)) {
                    ret.add(d);
                }
                continue;
            }
            if (ipc instanceof Column && ((Column)ipc).getPanel() != null) {
                for (Panel panel2 : ((Column)ipc).getPanel()) {
                    for (Displaymodel d : TextSearchUtil.findDisplaymodels(panel2)) {
                        ret.add(d);
                    }
                }
                continue;
            }
            if (!(ipc instanceof Panelgroup) || ((Panelgroup)ipc).getPanel() == null) continue;
            for (Panel panel3 : ((Panelgroup)ipc).getPanel()) {
                for (Displaymodel d : TextSearchUtil.findDisplaymodels(panel3)) {
                    ret.add(d);
                }
            }
        }
        return ret;
    }

    public static List<Displaymodel> findDisplaymodels(Presentation pre) {
        ArrayList<Displaymodel> ret = new ArrayList<Displaymodel>();
        if (pre.getLayout() == null || pre.getLayout().getPanel() == null) {
            return ret;
        }
        for (Panel panel : pre.getLayout().getPanel()) {
            for (Displaymodel dm : TextSearchUtil.findDisplaymodels(panel)) {
                ret.add(dm);
            }
        }
        return ret;
    }

    public static Displayitem[] findDisplayitems(Project project, Model model) {
        ArrayList<Displayitem> items = new ArrayList<Displayitem>();
        for (Presentation pre : TextSearchUtil.findListPresentations(project, model)) {
            for (Displaymodel dm : TextSearchUtil.findDisplaymodels(pre)) {
                for (Displayitem di : AppSchemaUtil.getDisplayitems(dm)) {
                    items.add(di);
                }
            }
        }
        return items.toArray(new Displayitem[items.size()]);
    }

    public static String getModelitemname(Modelitem mitem) {
        if (mitem == null || mitem.getName() == null) {
            return "";
        }
        String mitemName = mitem.getName();
        if (mitemName.endsWith("_jshfilename")) {
            mitemName = mitemName.substring(0, mitemName.lastIndexOf("_jshfilename"));
        }
        return mitemName;
    }

    public static boolean isHiddenOnShowList(Modelitem mitem, Project project, Model model) {
        Displayitem[] dItems = TextSearchUtil.findDisplayitems(project, model);
        String mitemName = TextSearchUtil.getModelitemname(mitem);
        for (Displayitem ditem : dItems) {
            if (!mitemName.equals(ditem.getName()) || !AppSchemaUtil.isHiddenDisplayitem(ditem)) continue;
            logger.debug("isHiddenOnShowList:mitem:" + mitemName + " ditem:" + ditem.getName());
            return true;
        }
        return false;
    }

    public static Control getControl4Permission(Project project, Model model, Modelitem mitem) {
        Control cntrl;
        if (TextSearchUtil.getCPModel(project, model) != null && (cntrl = TextSearchUtil.getControlTypeIsHidden(mitem, TextSearchUtil.getCPModel(project, model))) != null) {
            return cntrl;
        }
        if (TextSearchUtil.getPModel(project, model) != null && (cntrl = TextSearchUtil.getControlTypeIsHidden(mitem, TextSearchUtil.getPModel(project, model))) != null) {
            return cntrl;
        }
        return null;
    }
}

