/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ConfigGenerator;
import jp.jasminesoft.jfc.gen.IWebSourceVariable;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.sourcefilemanager.GeneratorControllerFile;
import jp.jasminesoft.jfc.gen.sourcefilemanager.IGeneratorController;
import jp.jasminesoft.util.FileTemplateManager;

public class TilesDefs2Generator
extends ConfigGenerator
implements IWebSourceVariable {
    private final String ENTRY_STR = "<tiles2:insertAttribute name=\"";
    private Map<String, String> layoutMap = new HashMap<String, String>();
    private Set<String> jspcSet = new HashSet<String>();

    public TilesDefs2Generator(String tmplatefilename, String[][] layouttable, Project project) {
        super(tmplatefilename, project);
        if (layouttable != null) {
            for (int i = 0; i < layouttable.length; ++i) {
                this.layoutMap.put(layouttable[i][0], layouttable[i][1]);
            }
        }
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public String getFilename() {
        return "tiles-defs2";
    }

    @Override
    public String getSubpackageName() {
        return "webpage" + File.separator + "WEB-INF";
    }

    @Override
    public String process0() {
        FileTemplateManager tplman = new FileTemplateManager(this.tmplatefilename);
        if (!tplman.isValid()) {
            return "";
        }
        HashSet<String> baseSet = new HashSet<String>();
        LinkedHashMap<String, Definition> ruleMap = new LinkedHashMap<String, Definition>();
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc != null) {
            for (int i = 0; i < ipc.length; ++i) {
                String layouttype;
                Presentation presentation;
                Layout layout;
                if (!(ipc[i] instanceof Presentation) || (layout = (presentation = (Presentation)ipc[i]).getLayout()) == null || (layouttype = layout.getType()) == null || !layouttype.startsWith("tiles:")) continue;
                String layoutname = layouttype.substring("tiles:".length());
                baseSet.add(layouttype);
                this.addTask(presentation, layoutname, ruleMap);
            }
        }
        tplman.addContent("basedefs", this.createBasedefs(baseSet));
        tplman.addContent("definitions", this.createDefinitions(ruleMap));
        this.saveDefaultJspcFiles();
        return tplman.getResult();
    }

    protected String createBasedefs(Set<String> baseSet) {
        StringBuilder sb = new StringBuilder();
        for (String name : baseSet) {
            Definition def = null;
            String filename = "tiles2-" + this.layoutMap.get(name);
            String name0 = name.substring("tiles:".length());
            if (filename != null) {
                def = new Definition(name0, filename);
                String[] entry = this.findAllEntry("template" + File.separator + "tiles2" + File.separator + filename);
                if (entry != null) {
                    for (int i = 0; i < entry.length; ++i) {
                        String jspcomponentfilename = entry[i] + ".jsp";
                        def.addPutEntry(entry[i], "/parts/" + jspcomponentfilename);
                        this.jspcSet.add(jspcomponentfilename);
                    }
                }
            }
            if (def == null) continue;
            sb.append(this.gDef(def));
            sb.append(CR);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] findAllEntry(String filename) {
        BufferedReader in = null;
        HashSet<String> entrySet = new HashSet<String>();
        String enc = JavaSourceGenerator.getWebEncoding(this.project);
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), enc));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("<tiles2:insertAttribute name=\"") < 0) continue;
                this.findEntry(line, entrySet);
            }
        }
        catch (IOException e) {
            this.logger.warn(this.rman.getValue("file.read.error", filename));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return entrySet.toArray(new String[0]);
    }

    protected void findEntry(String line, Set<String> entrySet) {
        if (line == null || line.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int ptr = line.indexOf("<tiles2:insertAttribute name=\"");
        if (ptr >= 0) {
            char c;
            int i;
            String _s = line.substring(ptr + "<tiles2:insertAttribute name=\"".length());
            int _length = _s.length();
            for (i = 0; i < _length && (c = _s.charAt(i)) != '\"'; ++i) {
                sb.append(c);
            }
            String _entry = sb.toString();
            entrySet.add(_entry);
            ptr = i + "\"/>".length();
            if (_s.length() > ptr) {
                String _next = _s.substring(ptr);
                this.findEntry(_next, entrySet);
            }
        }
    }

    protected void addTask(Presentation presentation, String layoutname, Map<String, Definition> ruleMap) {
        Layout layout;
        if (presentation == null || layoutname == null) {
            return;
        }
        String pid = presentation.getIdref();
        Action action = AppSchemaUtil.getAction(this.project, pid);
        String id = presentation.getFilename();
        if (id == null || id.length() == 0) {
            if (action != null) {
                id = JavaSourceGenerator.createProperId(action);
            } else {
                id = pid;
                this.logger.warn(this.rman.getValue("strutsconfig.presentation.id.invalid", pid));
            }
        }
        if ((layout = presentation.getLayout()) == null) {
            return;
        }
        Panel[] panels = layout.getPanel();
        if (panels == null) {
            return;
        }
        Definition d = new Definition(id);
        d.setType(layoutname);
        String predir = "";
        String filename = null;
        for (int i = 0; i < panels.length; ++i) {
            Panel panel = panels[i];
            filename = id + "_" + panel.getName();
            filename = action != null ? action.getIdref() + File.separator + filename : "system" + File.separator + filename;
            if (predir != null && predir.length() > 0) {
                filename = predir + File.separator + filename;
            }
            this.addDefinitionEntry(d, panel.getName(), filename, panel.getForce());
        }
        filename = action != null ? action.getIdref() + File.separator + id : "system" + File.separator + id;
        if (predir != null && predir.length() > 0) {
            filename = predir + File.separator + filename;
        }
        this.addDefinitionEntry(d, "javascript", filename + "_javascript");
        this.addDefinitionEntry(d, "beandef", filename + "_beandef");
        this.addDefinitionEntry(d, "css", filename + "_css");
        this.addDefinitionEntry(d, "title", filename + "_title");
        this.addDefinitionEntry(d, "stylesheet", filename + "_stylesheet");
        ruleMap.put(id, d);
    }

    private void addDefinitionEntry(Definition d, String id, String filename) {
        this.addDefinitionEntry(d, id, filename, false);
    }

    private void addDefinitionEntry(Definition d, String id, String filename, boolean forceFlag) {
        String fullfilename;
        IGeneratorController cont = GeneratorControllerFile.getInstance();
        boolean isChecked = cont.isChecked(fullfilename = "/webpage/" + filename + ".jsp");
        if (isChecked || forceFlag) {
            d.addPutEntry(id, "/" + filename);
        } else if (cont.isKeep(fullfilename)) {
            d.addPutEntry(id, "/" + filename);
        }
    }

    protected String createDefinitions(Map<String, Definition> ruleMap) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keyList = new ArrayList<String>(ruleMap.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String id = (String)keyList.get(i);
            Definition d = ruleMap.get(id);
            sb.append(this.gDef(d));
            sb.append(CR);
        }
        return sb.toString();
    }

    protected String gDef(Definition def) {
        StringBuilder sb = new StringBuilder();
        boolean noContentFlag = false;
        Map<String, String> putMap = def.getPutMap();
        if (putMap.size() == 0) {
            noContentFlag = true;
        }
        sb.append("  ");
        sb.append("<definition name=\"");
        sb.append(def.getName());
        sb.append("\" ");
        String path = def.getPath();
        if (path != null && path.length() > 0) {
            sb.append("template=\"");
            sb.append(path);
            sb.append("\"");
        } else {
            String type = def.getType();
            if (type != null && type.length() > 0) {
                sb.append("extends=\"");
                sb.append(type);
                sb.append("\"");
            }
        }
        if (noContentFlag) {
            sb.append("/>");
            sb.append(CR);
            return sb.toString();
        }
        sb.append(">");
        sb.append(CR);
        for (String pname : putMap.keySet()) {
            String pvalue = putMap.get(pname);
            if (!(pvalue.endsWith(".html") || pvalue.endsWith(".htm") || pvalue.endsWith(".jsp"))) {
                pvalue = pvalue + ".jsp";
            }
            sb.append("    ");
            sb.append("<put-attribute name=\"");
            sb.append(pname);
            sb.append("\" value=\"");
            sb.append(pvalue);
            sb.append("\"/>");
            sb.append(CR);
        }
        sb.append("  ");
        sb.append("</definition>");
        sb.append(CR);
        return sb.toString();
    }

    protected void saveDefaultJspcFiles() {
        for (String filename : this.jspcSet) {
            JspcFile jspcfile = new JspcFile(filename, this.project);
            jspcfile.process();
        }
    }

    class JspcFile
    extends SourceGenerator {
        private String filename;

        public JspcFile(String filename, Project project) {
            super(project);
            this.filename = filename;
        }

        @Override
        public String getFileSuffix() {
            return ".jsp";
        }

        public String getFilename() {
            return JspcFile.convertJspFilename(this.filename);
        }

        public String getSubpackageName() {
            return "webpage" + File.separator;
        }

        @Override
        public String getEncoding() {
            return JavaSourceGenerator.getWebEncoding(this.project);
        }

        public boolean isOutputOverrideMessage() {
            return false;
        }

        @Override
        public void process() {
            StringBuilder sb = new StringBuilder();
            sb.append("<%@ page pageEncoding=\"");
            sb.append(this.getEncoding());
            sb.append("\"%>");
            this.filename = "parts" + File.separator + this.filename;
            this.createSource(this.getGeneratorClassName() + sb.toString(), this.filename, this.getSubpackageName(), false);
        }

        @Override
        protected String getGeneratorClassName() {
            if (System.getProperty("jfc.output.genclassname") != null) {
                return "<%-- genclassname:" + this.getClass().getName() + " --%>" + CR;
            }
            return "";
        }
    }

    class Definition {
        String name;
        String path;
        String type;
        Map<String, String> putMap;

        Definition(String name) {
            this(name, null);
        }

        Definition(String name, String path) {
            this.name = name;
            this.path = path;
            if (!this.name.endsWith(".page")) {
                this.name = this.name + ".page";
            }
            this.putMap = new TreeMap<String, String>();
        }

        String getName() {
            return this.name;
        }

        String getPath() {
            return this.path;
        }

        String getType() {
            return this.type;
        }

        void setType(String type) {
            this.type = type;
            if (this.type != null && !this.type.endsWith(".page")) {
                this.type = this.type + ".page";
            }
        }

        void addPutEntry(String name, String value) {
            this.putMap.put(name, value);
        }

        Map<String, String> getPutMap() {
            return this.putMap;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<Definition>");
            if (this.name != null) {
                sb.append("<name>" + this.name + "</name>");
            }
            if (this.path != null) {
                sb.append("<path>" + this.path + "</path>");
            }
            if (this.type != null) {
                sb.append("<type>" + this.type + "</type>");
            }
            if (this.putMap != null && this.putMap.size() > 0) {
                sb.append("<map>" + this.putMap + "</map>");
            }
            sb.append("</Definition>");
            return sb.toString();
        }
    }
}

