/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TipsManager {
    private static TipsManager _instance = new TipsManager();
    private static Map<String, Map<String, Content>> tipsMap;
    protected Logger logger = LogManager.getLogger((String)TipsManager.class.getName());

    private TipsManager() {
        tipsMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    public static TipsManager getInstance() {
        return _instance;
    }

    public void add(String target, String id, String content) {
        Map<String, Content> omap = tipsMap.get(target);
        if (omap == null) {
            omap = Collections.synchronizedMap(new LinkedHashMap());
            tipsMap.put(target, omap);
        }
        omap.put(id, new Content(content));
    }

    public void mark(String target, String id) {
        Map<String, Content> omap = tipsMap.get(target);
        if (omap == null) {
            return;
        }
        Content content = omap.get(id);
        if (content == null) {
            return;
        }
        content.setMark(true);
    }

    public String[] getTipsID(String target) {
        Map<String, Content> omap = tipsMap.get(target);
        if (omap == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String id : omap.keySet()) {
            Content content = omap.get(id);
            if (content.getMark()) continue;
            l.add(id);
        }
        return l.toArray(new String[0]);
    }

    public Map<String, String> getTipsMap(String target) {
        Map<String, Content> omap = tipsMap.get(target);
        if (omap == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String id : omap.keySet()) {
            Content content = omap.get(id);
            map.put(id, content.getContent());
        }
        return map;
    }

    public String[] getTipsMapAllKey() {
        Set<String> keySet = tipsMap.keySet();
        String[] ret = keySet.toArray(new String[0]);
        return ret;
    }

    public static void reset() {
        _instance = new TipsManager();
    }

    static {
        TipsManager.reset();
    }

    class Content {
        boolean mark = false;
        String content;

        Content(String cnt) {
            this.content = cnt;
        }

        boolean getMark() {
            return this.mark;
        }

        void setMark(boolean b) {
            this.mark = b;
        }

        String getContent() {
            return this.content;
        }
    }
}

