/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.VariableValidatorDatalock;
import jp.jasminesoft.jfc.gen.VariableValidator_classname;
import jp.jasminesoft.jfc.gen.VariableValidator_database;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.Filterlist;
import jp.jasminesoft.jfc.gen.appschema.Forward;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplayconditionChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Inhibitlist;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Mapping;
import jp.jasminesoft.jfc.gen.appschema.Menu;
import jp.jasminesoft.jfc.gen.appschema.Menubar;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Panelgroup;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableValidator {
    protected Project project;
    protected ResourceManager rman;
    protected List<Errorinfo> errorlist = null;
    protected static Logger logger;
    protected static final String[] reserved_parts;
    protected static final String[] reserved_keywords_java;
    protected static final String[] reserved_keywords_other;
    protected static Set<String> reservedKeywordsSet_java;
    protected static Set<String> reservedKeywordsSet_other;

    public VariableValidator(Project project) {
        this.project = project;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        this.errorlist = new ArrayList<Errorinfo>();
    }

    public static boolean isReservedKeyword(String name) {
        if (reservedKeywordsSet_java.contains(name = name.toLowerCase())) {
            return true;
        }
        if (reservedKeywordsSet_other.contains(name)) {
            return true;
        }
        return name.startsWith("xml");
    }

    private static boolean isJavaReservedKeyword(String name) {
        return reservedKeywordsSet_java.contains(name = name.toLowerCase());
    }

    public static final boolean isValidId(String name) {
        if (name == null) {
            return false;
        }
        if (VariableValidator.isReservedKeyword(name)) {
            return false;
        }
        if ("service".equals(name.toLowerCase())) {
            return false;
        }
        if ("master".equals(name.toLowerCase())) {
            return false;
        }
        if (!StringUtil.isValidXmlName((String)name)) {
            return false;
        }
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static final boolean isValidModelId(String name) {
        return VariableValidator.isValidId(name);
    }

    public static final boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        ArrayList<String> mitemnames = new ArrayList<String>();
        if (name.indexOf(47) < 0) {
            mitemnames.add(name);
        } else {
            int cnt2;
            int namelen = name.length();
            int cnt1 = 0;
            do {
                if ((cnt2 = name.indexOf(47, cnt1)) < 0) {
                    mitemnames.add(name.substring(cnt1));
                    break;
                }
                mitemnames.add(name.substring(cnt1, cnt2));
            } while ((cnt1 = cnt2 + 1) != namelen);
        }
        for (String mitemname : mitemnames) {
            int len = mitemname.length();
            if (len == 0) {
                return false;
            }
            if (VariableValidator.isReservedKeyword(mitemname)) {
                return false;
            }
            if (!StringUtil.isValidXmlName((String)mitemname)) {
                return false;
            }
            char c = mitemname.charAt(0);
            if (!Character.isLetter(c) && c != '_') {
                return false;
            }
            for (int i = 1; i < len; ++i) {
                c = mitemname.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isValidProjectName(String name) {
        if (name == null) {
            return false;
        }
        int len = name.length();
        if (len == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public final boolean isValidPackage(String name) {
        if (name == null) {
            return false;
        }
        ArrayList<String> packagenames = new ArrayList<String>();
        if (name.indexOf(46) < 0) {
            packagenames.add(name);
        } else {
            int cnt2;
            int namelen = name.length();
            int cnt1 = 0;
            do {
                if ((cnt2 = name.indexOf(46, cnt1)) < 0) {
                    packagenames.add(name.substring(cnt1));
                    break;
                }
                packagenames.add(name.substring(cnt1, cnt2));
            } while ((cnt1 = cnt2 + 1) != namelen);
        }
        for (String packagename : packagenames) {
            int len = packagename.length();
            if (len == 0) {
                return false;
            }
            if (VariableValidator.isJavaReservedKeyword(packagename)) {
                return false;
            }
            char c = packagename.charAt(0);
            if (!Character.isLetter(c) && c != '_') {
                return false;
            }
            for (int i = 1; i < len; ++i) {
                c = packagename.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isValidLabel(String label) {
        if (label == null || label.length() == 0) {
            return true;
        }
        label = StringUtil.decodeStringFromXML((String)label);
        int length = label.length();
        for (int i = 0; i < length; ++i) {
            char c = label.charAt(i);
            switch (c) {
                case '&': 
                case '<': 
                case '>': 
                case '\\': {
                    return false;
                }
            }
        }
        return true;
    }

    public String[][] validate() {
        IProjectChoice[] ipc;
        Menubar menubar;
        String packagename;
        String id = null;
        String label = null;
        String name = this.project.getName();
        if (!this.isValidProjectName(name)) {
            this.errorlist.add(new Errorinfo("project/@name", name));
        }
        if (!this.isValidPackage(packagename = this.project.getPackage())) {
            this.errorlist.add(new Errorinfo("project/@package", packagename));
        }
        if ((menubar = this.project.getMenubar()) != null) {
            Menu[] menu;
            id = menubar.getId();
            if (!VariableValidator.isValidId(id)) {
                this.errorlist.add(new Errorinfo("project/menubar/@id", id));
            }
            if ((menu = menubar.getMenu()) != null) {
                for (int i = 0; i < menu.length; ++i) {
                    id = menu[i].getId();
                    if (VariableValidator.isValidId(id)) continue;
                    this.errorlist.add(new Errorinfo("project/menubar/menu[" + i + "]/@id", id));
                }
            }
        }
        if ((ipc = this.project.getContent()) == null) {
            if (this.errorlist.size() == 0) {
                return null;
            }
            return this.createErrors();
        }
        VariableValidator_classname validator_classname = new VariableValidator_classname(this.project);
        int filterlistcount = 0;
        int inhibitlistcount = 0;
        for (int i = 0; i < ipc.length; ++i) {
            Panel[] panels;
            Presentation presentation;
            Layout layout;
            int j;
            if (ipc[i] instanceof Filterlist) {
                Filterlist filterlist = (Filterlist)ipc[i];
                id = filterlist.getId();
                if (VariableValidator.isValidId(id)) continue;
                this.errorlist.add(new Errorinfo("project/filterlist[" + ++filterlistcount + "]/@id", id));
                continue;
            }
            if (ipc[i] instanceof Inhibitlist) {
                Inhibitlist inhibitlist = (Inhibitlist)ipc[i];
                id = inhibitlist.getId();
                if (VariableValidator.isValidId(id)) continue;
                this.errorlist.add(new Errorinfo("project/inhibitlist[" + ++inhibitlistcount + "]/@id", id));
                continue;
            }
            if (ipc[i] instanceof Model) {
                Model model = (Model)ipc[i];
                id = model.getId();
                if (!VariableValidator.isValidModelId(id)) {
                    this.errorlist.add(new Errorinfo("project/model/@id", id));
                    continue;
                }
                HashSet<String> processedNameSet = new HashSet<String>();
                IModelChoice[] imc = model.getContent();
                if (imc == null) continue;
                for (j = 0; j < imc.length; ++j) {
                    int k;
                    if (!(imc[j] instanceof Modelitem)) continue;
                    Modelitem mitem = (Modelitem)imc[j];
                    id = mitem.getName();
                    if (!VariableValidator.isValidName(id)) {
                        this.errorlist.add(new Errorinfo("project/model[@id=\"" + model.getId() + "\"]/modelitem/@name", id));
                    }
                    if (!VariableValidator.isValidLabel(label = mitem.getLabel())) {
                        this.errorlist.add(new Errorinfo("project/model[@id=\"" + model.getId() + "\"]/modelitem/@label", id));
                    }
                    boolean isWhitespaceFlag = false;
                    for (k = 0; k < id.length(); ++k) {
                        if (!Character.isWhitespace(id.charAt(k))) continue;
                        isWhitespaceFlag = true;
                        break;
                    }
                    if (isWhitespaceFlag) {
                        this.errorlist.add(new Errorinfo("variable.invalid.whitespace", "project/model[@id=\"" + model.getId() + "\"]/modelitem/@name", mitem.getName()));
                    }
                    if (id.indexOf("/") >= 0) {
                        id = id.substring(id.indexOf("/") + 1);
                    }
                    if (model.getId().equals(id)) {
                        this.errorlist.add(new Errorinfo("variable.invalid.duplicate.modelandmodelitem", "project/model[@id=\"" + model.getId() + "\"]", mitem.getName()));
                    }
                    if (processedNameSet.contains(id)) {
                        this.errorlist.add(new Errorinfo("variable.invalid.duplicate.modelitem", "project/model[@id=\"" + model.getId() + "\"]", id.equals(mitem.getName()) ? id : id + "," + mitem.getName()));
                    } else {
                        processedNameSet.add(id);
                    }
                    if (reserved_parts == null) continue;
                    for (k = 0; k < reserved_parts.length; ++k) {
                        if (id.indexOf(reserved_parts[k]) < 0) continue;
                        this.errorlist.add(new Errorinfo("variable.invalid.reserved.parts", "project/model[@id=\"" + model.getId() + "\"]/modelitem[@name=\"" + mitem.getName() + "\"]", reserved_parts[k]));
                    }
                }
                validator_classname.check(model);
                continue;
            }
            if (ipc[i] instanceof Action) {
                Action action = (Action)ipc[i];
                id = action.getId();
                if (!VariableValidator.isValidId(id)) {
                    this.errorlist.add(new Errorinfo("project/action/@id", id));
                    continue;
                }
                IActionChoice[] imc = action.getContent();
                if (imc == null) continue;
                for (int j2 = 0; j2 < imc.length; ++j2) {
                    Forward forward;
                    Mapping[] mappings;
                    int k;
                    if (imc[j2] instanceof Conditionlist) {
                        Conditionlist conditionlist = (Conditionlist)imc[j2];
                        Condition[] conditions = AppSchemaUtil.getAllInnerCondition(conditionlist);
                        if (conditions == null) continue;
                        for (k = 0; k < conditions.length; ++k) {
                            id = conditions[k].getName();
                            if (VariableValidator.isValidName(id)) continue;
                            this.errorlist.add(new Errorinfo("project/action[@id=\"" + action.getId() + "\"]/conditionlist/condition/@name", id));
                        }
                        continue;
                    }
                    if (!(imc[j2] instanceof Forward) || (mappings = (forward = (Forward)imc[j2]).getMapping()) == null) continue;
                    for (k = 0; k < mappings.length; ++k) {
                        Mapping mapping = mappings[k];
                        id = mapping.getName();
                        if (id == null || id.length() == 0 || VariableValidator.isValidId(id)) continue;
                        this.errorlist.add(new Errorinfo("project/action[@id=\"" + action.getId() + "\"]/forward/mapping/@name", id));
                    }
                }
                continue;
            }
            if (!(ipc[i] instanceof Presentation) || (layout = (presentation = (Presentation)ipc[i]).getLayout()) == null || (panels = layout.getPanel()) == null) continue;
            for (j = 0; j < panels.length; ++j) {
                String xpath = "project/presentation[";
                String idref = presentation.getIdref();
                xpath = idref == null || idref.length() == 0 ? xpath + "@filename=\"" + presentation.getFilename() + "\"" : xpath + "@idref=\"" + idref + "\"";
                xpath = xpath + "/layout/panel[" + (j + 1) + "]";
                Panel panel = panels[j];
                this.validate_panel(xpath, panel);
            }
        }
        VariableValidator_database validator_database = new VariableValidator_database(this.project);
        validator_database.check();
        VariableValidatorDatalock validatorDatalock = new VariableValidatorDatalock(this.project);
        validatorDatalock.check(this.errorlist);
        if (this.errorlist.size() == 0) {
            return null;
        }
        return this.createErrors();
    }

    private void validate_panel(String xpath, Panel panel) {
        IPanelChoice[] ipac = panel.getContent();
        if (ipac == null) {
            return;
        }
        for (int k = 0; k < ipac.length; ++k) {
            int l;
            String xpath0;
            if (ipac[k] instanceof Displaycondition) {
                Displaycondition dc = (Displaycondition)ipac[k];
                IDisplayconditionChoice[] idc = dc.getContent();
                if (idc == null) continue;
                xpath0 = xpath + "/displaycondition";
                for (l = 0; l < idc.length; ++l) {
                    if (idc[l] instanceof Displayitemgroup) {
                        Displayitemgroup ditemg = (Displayitemgroup)idc[l];
                        this.checkDisplayitemgroup(xpath0 + "/displayitemgroup", ditemg);
                        continue;
                    }
                    if (!(idc[l] instanceof Displayitem)) continue;
                    Displayitem ditem = (Displayitem)idc[l];
                    this.checkDisplayitem(xpath0 + "/displayitem", ditem);
                }
                continue;
            }
            if (ipac[k] instanceof Displaymodelgroup) {
                Displaymodelgroup dmg = (Displaymodelgroup)ipac[k];
                IDisplaymodelgroupChoice[] idmgc = dmg.getContent();
                if (idmgc == null) continue;
                xpath0 = xpath + "/displaymodelgroup";
                for (l = 0; l < idmgc.length; ++l) {
                    if (idmgc[l] instanceof Displaymodel) {
                        Displaymodel dm = (Displaymodel)idmgc[l];
                        this.checkDisplaymodel(xpath0 + "/displaymodel", dm);
                        continue;
                    }
                    if (!(idmgc[l] instanceof Panelgroup)) continue;
                    Panelgroup panelgroup = (Panelgroup)idmgc[l];
                    for (Panel _panel : panelgroup.getPanel()) {
                        this.validate_panel(xpath0 + "/panelgroup/panel", _panel);
                    }
                }
                continue;
            }
            if (!(ipac[k] instanceof Displaymodel)) continue;
            Displaymodel dm = (Displaymodel)ipac[k];
            this.checkDisplaymodel(xpath + "/displaymodel", dm);
        }
    }

    private void checkDisplayitemgroup(String xpath, Displayitemgroup ditemg) {
        IDisplayitemgroupChoice[] idigc = ditemg.getContent();
        if (idigc == null) {
            return;
        }
        for (int i = 0; i < idigc.length; ++i) {
            if (idigc[i] instanceof Displayitemgroup) {
                Displayitemgroup ditemg2 = (Displayitemgroup)idigc[i];
                this.checkDisplayitemgroup(xpath + "/displayitemgroup", ditemg2);
                continue;
            }
            if (!(idigc[i] instanceof Displayitem)) continue;
            Displayitem ditem = (Displayitem)idigc[i];
            this.checkDisplayitem(xpath + "/displayitem", ditem);
        }
    }

    private void checkDisplayitem(String xpath, Displayitem ditem) {
        String name = ditem.getName();
        if (!VariableValidator.isValidName(name)) {
            this.errorlist.add(new Errorinfo(xpath + "/@name", name));
        }
    }

    private void checkDisplaymodel(String xpath, Displaymodel dm) {
        IDisplaymodelChoice[] idmc = dm.getContent();
        if (idmc == null) {
            return;
        }
        for (int i = 0; i < idmc.length; ++i) {
            if (idmc[i] instanceof Displayitemgroup) {
                Displayitemgroup ditemg = (Displayitemgroup)idmc[i];
                this.checkDisplayitemgroup(xpath + "/displayitemgroup", ditemg);
                continue;
            }
            if (!(idmc[i] instanceof Displayitem)) continue;
            Displayitem ditem = (Displayitem)idmc[i];
            this.checkDisplayitem(xpath + "/displayitem", ditem);
        }
    }

    private String[][] createErrors() {
        int size = this.errorlist.size();
        String[][] ret = new String[size][3];
        for (int i = 0; i < size; ++i) {
            Errorinfo errorinfo = this.errorlist.get(i);
            ret[i] = errorinfo.toArray();
        }
        return ret;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.exit(1);
        }
        VariableValidator vv = new VariableValidator(null);
        System.out.println(args[0] + " is " + VariableValidator.isValidId(args[0]));
    }

    static {
        int i;
        logger = LogManager.getLogger((String)VariableValidator.class.getName());
        reserved_parts = null;
        reserved_keywords_java = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "null", "true", "false", "enum", "assert"};
        reserved_keywords_other = new String[]{"page", "pageContext", "request", "response", "session", "application", "error", "exception", "out", "now", "item", "action", "pageScope", "requestScope", "sessionScope", "applicationScope", "param", "paramValues", "header", "headerValues", "cookie", "initParam"};
        reservedKeywordsSet_java = new HashSet<String>();
        reservedKeywordsSet_other = new HashSet<String>();
        for (i = 0; i < reserved_keywords_java.length; ++i) {
            reservedKeywordsSet_java.add(reserved_keywords_java[i].toLowerCase());
        }
        for (i = 0; i < reserved_keywords_other.length; ++i) {
            reservedKeywordsSet_other.add(reserved_keywords_other[i].toLowerCase());
        }
    }

    static class Errorinfo {
        String id;
        String name;
        String value;
        String[] options;

        Errorinfo(String name, String value) {
            this("variable.invalid", name, value);
        }

        Errorinfo(String id, String name, String value) {
            this(id, name, value, new String[0]);
        }

        Errorinfo(String id, String name, String value, String ... options) {
            this.id = id;
            this.name = name;
            this.value = value;
            this.options = options;
        }

        String[] toArray() {
            int initSize = 3;
            String[] ret = new String[3 + this.options.length];
            ret[0] = this.id;
            ret[1] = this.name;
            ret[2] = this.value;
            for (int i = 0; i < this.options.length; ++i) {
                ret[i + 3] = this.options[i];
            }
            return ret;
        }
    }
}

