/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.List;
import java.util.TreeMap;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.VariableValidator;
import jp.jasminesoft.jfc.gen.appschema.Datalock;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableValidatorDatalock {
    protected static Logger logger = LogManager.getLogger(VariableValidatorDatalock.class);
    protected Project project;

    public VariableValidatorDatalock(Project project) {
        this.project = project;
    }

    public void check(List<VariableValidator.Errorinfo> errorlist) {
        IProjectChoice[] ipc = this.project.getContent();
        if (ipc == null) {
            return;
        }
        TreeMap<String, ModelDatalock> locknameModelMap = new TreeMap<String, ModelDatalock>();
        for (int i = 0; i < ipc.length; ++i) {
            Model smodel;
            if (!(ipc[i] instanceof Model) || !(smodel = (Model)ipc[i]).getType().equals("store")) continue;
            List<Datalock> datalocks = AppSchemaUtil.getDatalock(smodel);
            for (Datalock datalock : datalocks) {
                String datalockname = datalock.getName();
                if (!this.checkDatalockType(smodel, datalock, errorlist) || !this.checkModel(smodel, datalock, errorlist)) continue;
                ModelDatalock md1 = (ModelDatalock)locknameModelMap.get(datalockname);
                if (md1 == null) {
                    locknameModelMap.put(datalock.getName(), new ModelDatalock(smodel, datalock));
                    continue;
                }
                ModelDatalock md2 = new ModelDatalock(smodel, datalock);
                if (this.checkDatalock(md1, md2, errorlist)) continue;
            }
        }
    }

    private boolean checkDatalockType(Model smodel, Datalock datalock, List<VariableValidator.Errorinfo> errorlist) {
        String[] keymitems1;
        boolean b = true;
        String keymitemsStr1 = datalock.getKeyModelitems();
        for (String keymitem : keymitems1 = StringUtils.split((String)keymitemsStr1)) {
            if (this.checkDatalockType(smodel, datalock, keymitem, errorlist)) continue;
            b = false;
        }
        return b;
    }

    private boolean checkDatalockType(Model smodel, Datalock datalock, String mitemname, List<VariableValidator.Errorinfo> errorlist) {
        String modelId = smodel.getId();
        Modelitem sitem = AppSchemaUtil.getModelitem(mitemname, smodel);
        if (AppSchemaUtil.isCheckRelation(sitem, this.project, null)) {
            errorlist.add(new VariableValidator.Errorinfo("variable.invalid.datalock.checkbox", "model/datalock/@name", mitemname, modelId));
            return false;
        }
        return true;
    }

    private boolean checkDatalock(ModelDatalock md1, ModelDatalock md2, List<VariableValidator.Errorinfo> errorlist) {
        if (!this.isSameDatalockType(md1, md2)) {
            errorlist.add(new VariableValidator.Errorinfo("variable.invalid.datalock.notsametype_datalock", "model/datalock/@name", md1.datalock.getName(), md1.datalock.getKeyModelitems(), md1.smodel.getId(), md2.datalock.getName(), md2.datalock.getKeyModelitems(), md2.smodel.getId()));
            return false;
        }
        return true;
    }

    private boolean isSameDatalockType(ModelDatalock md1, ModelDatalock md2) {
        String mitemtype2;
        String mitemtype1 = this.createKeyModelitemTypes(md1);
        return mitemtype1.equals(mitemtype2 = this.createKeyModelitemTypes(md2));
    }

    private String createKeyModelitemTypes(ModelDatalock md1) {
        String keymitemsStr1 = md1.datalock.getKeyModelitems();
        String[] keymitems1 = StringUtils.split((String)keymitemsStr1);
        StringBuilder sb1 = new StringBuilder();
        for (int i = 0; i < keymitems1.length; ++i) {
            Modelitem mitem1 = AppSchemaUtil.getModelitem(keymitems1[i], md1.smodel);
            String mitemtype1 = AppSchemaUtil.getModelitemType(this.project, md1.smodel.getId(), mitem1, "roleid");
            sb1.append(mitemtype1);
            if (i + 1 >= keymitems1.length) continue;
            sb1.append(PrimaryKeyUtils.PKEY_SEPARATOR());
        }
        return sb1.toString();
    }

    private boolean checkModel(Model smodel, Datalock datalock, List<VariableValidator.Errorinfo> errorlist) {
        List<Datalock> datalocks1;
        String datalockname = datalock.getName();
        Model model1 = AppSchemaUtil.getModel(this.project, datalockname);
        if (model1 == null) {
            return true;
        }
        if (model1.getType().equals("master")) {
            errorlist.add(new VariableValidator.Errorinfo("variable.invalid.datalock.notuse_mastermodel_datalockname", "model/datalock/@name", datalockname, smodel.getId()));
            return false;
        }
        if (model1.getType().equals("store") && (datalocks1 = AppSchemaUtil.getDatalock(model1)).size() == 0 && !this.checkPrimaryKeyType(smodel, datalock, model1)) {
            errorlist.add(new VariableValidator.Errorinfo("variable.invalid.datalock.notsametype_datalock_pkey", "model/datalock/@name", datalockname, smodel.getId()));
            return false;
        }
        return true;
    }

    private boolean checkPrimaryKeyType(Model smodel, Datalock datalock, Model model1) {
        String keymitemsStr;
        String[] keymitems;
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(model1);
        if (pkeys.length != (keymitems = StringUtils.split((String)(keymitemsStr = datalock.getKeyModelitems()))).length) {
            return false;
        }
        for (int i = 0; i < pkeys.length; ++i) {
            String mitemtype2;
            Modelitem mitem1 = AppSchemaUtil.getModelitem(pkeys[i].getName(), model1);
            Modelitem mitem2 = AppSchemaUtil.getModelitem(keymitems[i], smodel);
            String mitemtype1 = AppSchemaUtil.getModelitemType(this.project, model1.getId(), mitem1, "roleid");
            if (mitemtype1.equals(mitemtype2 = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), mitem2, "roleid"))) continue;
            return false;
        }
        return true;
    }

    private static class ModelDatalock {
        private Model smodel;
        private Datalock datalock;

        ModelDatalock(Model smodel, Datalock datalock) {
            this.smodel = smodel;
            this.datalock = datalock;
        }
    }
}

