/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.HashSet;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.XslGenerator;
import jp.jasminesoft.jfc.gen.XslGenerator_condition;
import jp.jasminesoft.jfc.gen.XslGenerator_insert;
import jp.jasminesoft.jfc.gen.XslGenerator_insert_multi;
import jp.jasminesoft.jfc.gen.XslGenerator_insert_multi_table;
import jp.jasminesoft.jfc.gen.XslGenerator_jobentry;
import jp.jasminesoft.jfc.gen.XslGenerator_jobentryList;
import jp.jasminesoft.jfc.gen.XslGenerator_navigationbar;
import jp.jasminesoft.jfc.gen.XslGenerator_show;
import jp.jasminesoft.jfc.gen.XslGenerator_showList;
import jp.jasminesoft.jfc.gen.XslGenerator_showTotal;
import jp.jasminesoft.jfc.gen.XslGenerator_showTotal2;
import jp.jasminesoft.jfc.gen.XslGenerator_show_multi;
import jp.jasminesoft.jfc.gen.XslGenerator_show_multi_table;
import jp.jasminesoft.jfc.gen.XslGenerator_update;
import jp.jasminesoft.jfc.gen.XslGenerator_update_multi;
import jp.jasminesoft.jfc.gen.XslGenerator_update_multi_table;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Column;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Navigationbar;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XslGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)XslGeneratorFactory.class.getName());
    protected static ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");

    public static XslGenerator[] create(Project project, Presentation presentation) {
        XslGenerator[] gens = new XslGenerator[]{};
        Action action = null;
        IRNode node = presentation.getIdrefAsIRNode();
        if (node != null && node instanceof Action) {
            action = (Action)node;
        }
        if (action == null && presentation.getIdref() != null) {
            logger.warn(rman.getValue("value.null.action.pr", presentation.getIdref()));
            return gens;
        }
        HashSet set = new HashSet();
        Layout layout = presentation.getLayout();
        if (layout == null) {
            return gens;
        }
        Panel[] panels = layout.getPanel();
        if (panels == null) {
            return gens;
        }
        for (int i = 0; i < panels.length; ++i) {
            Panel panel = panels[i];
            XslGeneratorFactory.create0(panel, presentation, action, project, set);
        }
        if (set.size() > 0) {
            gens = set.toArray(new XslGenerator[0]);
        }
        return gens;
    }

    public static void create0(Panel panel, Presentation presentation, Action action, Project project, Set set) {
        if (panel == null) {
            return;
        }
        IPanelChoice[] ipc = panel.getContent();
        if (ipc == null) {
            return;
        }
        XslGenerator xslgen = null;
        boolean canCreateFlag = true;
        if (StringUtil.doubleValue((String)project.getVersion()) >= 5.0) {
            canCreateFlag = false;
        }
        for (int j = 0; j < ipc.length; ++j) {
            Navigationbar navigationbar;
            if (ipc[j] instanceof Panel) {
                Panel _panel = (Panel)ipc[j];
                XslGeneratorFactory.create0(_panel, presentation, action, project, set);
                continue;
            }
            if (ipc[j] instanceof Column) {
                Column column = (Column)ipc[j];
                Panel[] _panels = column.getPanel();
                if (_panels == null || _panels.length == 0) continue;
                for (int k = 0; k < _panels.length; ++k) {
                    XslGeneratorFactory.create0(_panels[k], presentation, action, project, set);
                }
                continue;
            }
            if (ipc[j] instanceof Displaymodelgroup) {
                Displaymodelgroup dmg = (Displaymodelgroup)ipc[j];
                IDisplaymodelgroupChoice[] idgc = dmg.getContent();
                if (idgc == null || idgc.length == 0) continue;
                IRNode node0 = dmg.getIdrefAsIRNode();
                if (node0 == null || !(node0 instanceof Model)) {
                    Object[] o = new Object[]{presentation.getIdref(), dmg.getIdref()};
                    logger.error(rman.getValue("value.null.displaymodelgroup.rmodel", o));
                    continue;
                }
                Model pmodel = (Model)node0;
                for (int k = 0; k < idgc.length; ++k) {
                    String usefile;
                    if (!(idgc[k] instanceof Displaymodel)) continue;
                    Displaymodel dm = (Displaymodel)idgc[k];
                    String type = XslGeneratorFactory.getType(action, dm);
                    if (type == null) {
                        logger.error(rman.getValue("value.null.action.type", action.getId()));
                        return;
                    }
                    if (dm.getNooutputxslt() || dm.getNooutput() || (usefile = dm.getUsefile()) != null && usefile.length() > 0) continue;
                    String _idref = dmg.getAliasid();
                    if (_idref == null || _idref.length() == 0) {
                        _idref = dmg.getIdref();
                    }
                    if ((xslgen = XslGeneratorFactory.createXslGenerator(panel, project, action, presentation, type, pmodel, _idref, dm)) == null) continue;
                    set.add(xslgen);
                }
                continue;
            }
            if (ipc[j] instanceof Displaymodel) {
                Displaymodel dm = (Displaymodel)ipc[j];
                IRNode node0 = dm.getIdrefAsIRNode();
                if (node0 == null || !(node0 instanceof Model)) {
                    if (XslGeneratorFactory.isReservedKeyword(dm.getIdref())) continue;
                    Object[] o = new Object[]{presentation.getIdref(), dm.getIdref()};
                    logger.error(rman.getValue("value.null.displaymodel.rmodel", o));
                    continue;
                }
                Model pmodel = (Model)node0;
                String type = XslGeneratorFactory.getType(action, dm);
                if (type == null) {
                    logger.error(rman.getValue("value.null.action.type", action.getId()));
                    return;
                }
                String usefile = dm.getUsefile();
                if (usefile != null && usefile.length() > 0) continue;
                String _idref = dm.getAliasid();
                if (_idref == null || _idref.length() == 0) {
                    _idref = dm.getIdref();
                }
                if ((xslgen = XslGeneratorFactory.createXslGenerator(panel, project, action, presentation, type, pmodel, _idref, dm)) == null) continue;
                set.add(xslgen);
                continue;
            }
            if (canCreateFlag && ipc[j] instanceof Displaycondition) {
                Displaycondition dc = (Displaycondition)ipc[j];
                Model pmodel = null;
                String _idref = null;
                IRNode node0 = dc.getIdrefAsIRNode();
                if (node0 != null && node0 instanceof Model) {
                    pmodel = (Model)node0;
                    _idref = dc.getIdref();
                }
                set.add(new XslGenerator_condition(project, action, presentation, pmodel, _idref, dc));
                continue;
            }
            if (!canCreateFlag || !(ipc[j] instanceof Navigationbar) || (navigationbar = (Navigationbar)ipc[j]).getIdref() == null) continue;
            set.add(new XslGenerator_navigationbar(project, action, presentation, navigationbar));
        }
    }

    protected static String getType(Action action, Displaymodel displaymodel) {
        String type = displaymodel.getType();
        if ((type == null || type.length() == 0) && action != null) {
            type = action.getType();
        }
        type = type == null ? "" : type;
        return type;
    }

    protected static XslGenerator createXslGenerator(Panel panel, Project project, Action action, Presentation presentation, String type, Model pmodel, String idref, Displaymodel displaymodel) {
        XslGenerator_show xslgen = null;
        boolean canCreateFlag = true;
        if (StringUtil.doubleValue((String)project.getVersion()) >= 5.0) {
            canCreateFlag = false;
        }
        if (displaymodel.getIdref() != null && displaymodel.getIdref().length() > 0 && ((idref = displaymodel.getAliasid()) == null || idref.length() == 0)) {
            idref = displaymodel.getIdref();
        }
        if (canCreateFlag && "show".equals(type)) {
            if (displaymodel.getMultiple()) {
                IDisplaymodelChoice[] idmc = displaymodel.getContent();
                boolean hasDitemgFlag = false;
                for (int i = 0; i < idmc.length; ++i) {
                    if (!(idmc[i] instanceof Displayitemgroup)) continue;
                    hasDitemgFlag = true;
                    break;
                }
                xslgen = !hasDitemgFlag ? new XslGenerator_show_multi_table(project, action, presentation, pmodel, idref, displaymodel) : new XslGenerator_show_multi(project, action, presentation, pmodel, idref, displaymodel);
            } else {
                xslgen = new XslGenerator_show(project, action, presentation, pmodel, idref, displaymodel);
            }
        } else if ("showList".equals(type)) {
            if ("total".equals(action.getView())) {
                Object[] o;
                Item[] _items;
                int numOfDimension = 0;
                View view = AppSchemaUtil.getView(action, idref);
                if (view != null && (_items = view.getItem()) != null) {
                    for (int i = 0; i < _items.length; ++i) {
                        Item _item = _items[i];
                        if (!"dimension".equals(_item.getName())) continue;
                        ++numOfDimension;
                    }
                }
                if (numOfDimension == 1) {
                    xslgen = new XslGenerator_showTotal(project, action, presentation, pmodel, idref, displaymodel);
                } else if (numOfDimension == 2) {
                    xslgen = new XslGenerator_showTotal2(project, action, presentation, pmodel, idref, displaymodel);
                } else if (numOfDimension == 0) {
                    o = new Object[]{action.getId()};
                    logger.error(rman.getValue("xslt.total.dimension.zero", o));
                } else if (numOfDimension > 2) {
                    o = new Object[]{action.getId(), Integer.toString(numOfDimension), "2"};
                    logger.error(rman.getValue("xslt.total.dimension.over", o));
                }
            } else if (canCreateFlag) {
                xslgen = new XslGenerator_showList(project, action, presentation, pmodel, idref, displaymodel, panel);
            }
        } else if (canCreateFlag && "update".equals(type)) {
            if (displaymodel.getMultiple()) {
                IDisplaymodelChoice[] idmc = displaymodel.getContent();
                boolean hasDitemgFlag = false;
                for (int i = 0; i < idmc.length; ++i) {
                    if (!(idmc[i] instanceof Displayitemgroup)) continue;
                    hasDitemgFlag = true;
                    break;
                }
                xslgen = !hasDitemgFlag ? new XslGenerator_update_multi_table(project, action, presentation, pmodel, idref, displaymodel) : new XslGenerator_update_multi(project, action, presentation, pmodel, idref, displaymodel);
            } else {
                xslgen = new XslGenerator_update(project, action, presentation, pmodel, idref, displaymodel);
            }
        } else if (canCreateFlag && ("insert".equals(type) || "copy".equals(type))) {
            if (displaymodel.getMultiple()) {
                IDisplaymodelChoice[] idmc = displaymodel.getContent();
                boolean hasDitemgFlag = false;
                for (int i = 0; i < idmc.length; ++i) {
                    if (!(idmc[i] instanceof Displayitemgroup)) continue;
                    hasDitemgFlag = true;
                    break;
                }
                xslgen = !hasDitemgFlag ? new XslGenerator_insert_multi_table(project, action, presentation, pmodel, idref, displaymodel) : new XslGenerator_insert_multi(project, action, presentation, pmodel, idref, displaymodel);
            } else {
                xslgen = new XslGenerator_insert(project, action, presentation, pmodel, idref, displaymodel);
            }
        } else if (canCreateFlag && "jobentry".equals(type)) {
            xslgen = new XslGenerator_jobentry(project, action, presentation, pmodel, idref, displaymodel);
        } else if (canCreateFlag && "jobentryList".equals(type)) {
            xslgen = new XslGenerator_jobentryList(project, action, presentation, pmodel, idref, displaymodel);
        }
        return xslgen;
    }

    protected static boolean isReservedKeyword(String id) {
        if (id == null) {
            return false;
        }
        return "menubar".equals(id) || "master_lp".equals(id);
    }
}

