/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.TabBuffer;
import jp.jasminesoft.jfc.gen.XslGenerator_showList;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XslGenerator_showTotal
extends XslGenerator_showList {
    Model model = null;
    View view = null;
    Item[] majors = null;
    Item[] dimensions = null;
    String total_numberformat = null;
    Set<String> masterItemSet = null;
    boolean masterrefMode = false;
    Set<String> uncalculatableMajorItemSet = null;
    boolean isColumnTotal = false;
    boolean isRowTotal = false;
    protected Logger logger = LogManager.getLogger((String)XslGenerator_showTotal.class.getName());

    public XslGenerator_showTotal(Project project, Action action, Presentation presentation, Model pmodel, String idref, Displaymodel displaymodel) {
        super(project, action, presentation, pmodel, idref, displaymodel);
        String displaysum;
        Item[] _items;
        Model lmodel;
        this.masterItemSet = new HashSet<String>();
        this.uncalculatableMajorItemSet = new HashSet<String>();
        IRNode node = pmodel.getIdrefAsIRNode();
        if (node != null && node instanceof Model && (lmodel = (Model)node) != null) {
            node = lmodel.getIdrefAsIRNode();
            this.model = node != null && node instanceof Model ? (Model)node : lmodel;
        }
        this.view = AppSchemaUtil.getView(action, idref);
        if (this.view != null && (_items = this.view.getItem()) != null) {
            ArrayList<Item> mlist = new ArrayList<Item>();
            ArrayList<Item> dlist = new ArrayList<Item>();
            for (int i = 0; i < _items.length; ++i) {
                Item _item = _items[i];
                Modelitem _sitem = AppSchemaUtil.getModelitem(_item.getContent(), this.model);
                if (_sitem != null && "major".equals(_item.getName())) {
                    Modelitem _sitem2 = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(project, this.model.getId(), _sitem);
                    String type = _sitem2.getType();
                    if ("masterref".equals(type) || "storeref".equals(type)) {
                        this.masterItemSet.add(_item.getContent());
                    } else if (!JavaSourceGenerator.isBasicType(type)) {
                        this.uncalculatableMajorItemSet.add(_item.getContent());
                    }
                }
                if ("major".equals(_item.getName())) {
                    mlist.add(_item);
                    continue;
                }
                if (!"dimension".equals(_item.getName())) continue;
                dlist.add(_item);
            }
            this.majors = mlist.toArray(new Item[0]);
            this.dimensions = dlist.toArray(new Item[0]);
            this.total_numberformat = this.searchTotalNumberFormat();
        }
        if (this.majors.length == 0) {
            Object[] o = new Object[]{action.getId()};
            this.logger.error(this.rman.getValue("xslt.total.major.zero", o));
        }
        if (StringUtils.isNotBlank((String)(displaysum = this.view.getDisplaysum()))) {
            String[] rules;
            for (String rule : rules = displaysum.split(",")) {
                if ("col".equals(rule)) {
                    this.isColumnTotal = true;
                    continue;
                }
                if (!"row".equals(rule)) continue;
                this.isRowTotal = true;
            }
        }
    }

    @Override
    protected void gHeader_option(TabBuffer sb) {
        Item[] _items;
        HashSet<String> typeSet = new HashSet<String>();
        for (Item _item : _items = this.view.getItem()) {
            String type = _item.getType();
            if (!StringUtils.isNotBlank((String)type)) continue;
            typeSet.add(type);
        }
        if (typeSet.contains("avg")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"AVERAGE\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("multi")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"MULTI\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("max")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"MAX\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("min")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"MIN\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("median")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"MEDIAN\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("mode")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"MODE\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("stdev")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"STDEV\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("stdevp")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"STDEVP\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("var")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"VAR\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.contains("varp")) {
            sb.append_cr("<lxslt:component prefix=\"xmlutils\"");
            sb.append_cr("                 functions=\"VARP\">");
            sb.append_cr("  <lxslt:script lang=\"javaclass\" src=\"xalan://jp.jasminesoft.util.XMLUtil\"/>");
            sb.append_cr("</lxslt:component>");
        }
        if (typeSet.size() > 0) {
            sb.cr();
        }
    }

    @Override
    protected void gHeader(TabBuffer sb) {
        super.gHeader(sb);
        sb.append("<xsl:param name=\"__jfc_ratio_show\">false</xsl:param>");
        sb.cr();
        sb.append("<xsl:param name=\"__jfc_ratio_number_format\">'('##0.0%')'</xsl:param>");
        sb.cr();
        sb.cr();
    }

    @Override
    protected boolean isSetClassOnTR() {
        return false;
    }

    @Override
    protected boolean isSetClassOnTD() {
        return true;
    }

    @Override
    protected void gTableTitle(TabBuffer sb) {
    }

    @Override
    protected void gBeforeTemplate(TabBuffer sb) {
        sb.append(this.comment("gBeforeTemplate"));
        if (this.majors != null && (this.isRowTotal || this.isColumnTotal)) {
            Item _item;
            int i;
            for (i = 0; i < this.majors.length; ++i) {
                _item = this.majors[i];
                String var_name = StringUtil.convertXslVariableString((String)(_item.getType() + "_" + _item.getContent()));
                sb.append("<xsl:variable name=\"");
                sb.append(var_name);
                sb.append("\" select=\"");
                sb.append(this.getProperFunction(_item));
                sb.append("(");
                sb.append("/");
                sb.append(this.idref);
                sb.append("/item/");
                sb.append(_item.getContent());
                if (this.masterItemSet.contains(_item.getContent())) {
                    sb.append("/@content");
                }
                sb.append(")\"/>");
                sb.cr();
                String total_func_varname = StringUtil.convertXslVariableString((String)("total_" + _item.getType() + "_" + _item.getContent()));
                sb.append("<xsl:variable name=\"");
                sb.append(total_func_varname);
                sb.append("\" select=\"");
                sb.append("$" + var_name);
                sb.append("\"/>");
                sb.cr();
            }
            sb.cr();
            sb.append("<xsl:variable name=\"total_sum_all");
            sb.append("\" select=\"");
            for (i = 0; i < this.majors.length; ++i) {
                _item = this.majors[i];
                sb.append("$" + StringUtil.convertXslVariableString((String)(_item.getType() + "_" + _item.getContent())));
                if (i >= this.majors.length - 1) continue;
                sb.append("+");
            }
            sb.append("\"/>");
            sb.cr();
        }
    }

    protected String getProperFunction(Item item) {
        String type = item.getType();
        if ("sum".equals(type)) {
            return "sum";
        }
        if ("avg".equals(type)) {
            return "xmlutils:AVERAGE";
        }
        if ("max".equals(type)) {
            return "xmlutils:MAX";
        }
        if ("min".equals(type)) {
            return "xmlutils:MIN";
        }
        if ("count".equals(type)) {
            return "sum";
        }
        if ("multi".equals(type)) {
            return "xmlutils:MULTI";
        }
        if ("median".equals(type)) {
            return "xmlutils:MEDIAN";
        }
        if ("mode".equals(type)) {
            return "xmlutils:MODE";
        }
        if ("stdev".equals(type)) {
            return "xmlutils:STDEV";
        }
        if ("stdevp".equals(type)) {
            return "xmlutils:STDEVP";
        }
        if ("var".equals(type)) {
            return "xmlutils:VAR";
        }
        if ("varp".equals(type)) {
            return "xmlutils:VARP";
        }
        return "sum";
    }

    @Override
    protected void gTemplate2(TabBuffer sb) {
        int i;
        sb.indent();
        sb.append(this.comment("gTemplate2"));
        sb.append_cr("<xsl:apply-templates select=\"item\">");
        boolean isOutputSortElement = false;
        if (this.dimensions != null) {
            for (i = 0; i < this.dimensions.length; ++i) {
                if (i == 0) {
                    sb.forward();
                } else {
                    sb.indent();
                }
                Item item = this.dimensions[i];
                String itemname = item.getContent();
                Modelitem mitem = AppSchemaUtil.getModelitem(itemname, this.model);
                if (mitem == null) {
                    Object[] o = new Object[]{this.action.getId(), this.model.getId(), itemname};
                    this.logger.error(this.rman.getValue("xslt.total.modelitem.null", o));
                    continue;
                }
                isOutputSortElement = this.gOutputSortRule(mitem, 0, sb);
            }
        }
        if (isOutputSortElement) {
            sb.back();
        } else {
            sb.indent();
        }
        sb.append_cr("</xsl:apply-templates>");
        sb.indent();
        if (this.isRowTotal || this.isColumnTotal) {
            sb.append_cr(this.gElemTag("tr"));
            sb.forward();
            if (this.isRowTotal) {
                sb.append_cr(this.gElemTag("th"));
                sb.forward();
                sb.append_cr(this.gAttrTag("class", "display_label_total"));
                sb.indent();
                sb.append_cr(this.createRValueStatement(this.getResourceKeyAsRowTotal(this.majors)));
                sb.back();
                sb.append_cr(this.gElemTag("/th"));
            }
            if (this.majors != null) {
                if (this.isRowTotal) {
                    for (i = 0; i < this.majors.length; ++i) {
                        Item _item = this.majors[i];
                        if (this.masterItemSet.contains(_item.getContent()) || this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                            String target = null;
                            if (this.masterItemSet.contains(_item.getContent())) {
                                target = "/@content";
                            } else if (this.uncalculatableMajorItemSet.contains(_item.getContent())) {
                                target = "";
                            }
                            this.gRowTotal_masterref(sb, _item, target);
                            continue;
                        }
                        this.gRowTotal_normal(sb, _item);
                    }
                }
                if (this.isColumnTotal && this.isRowTotal) {
                    sb.indent();
                    sb.append_cr(this.gElemTag("td"));
                    sb.forward();
                    sb.append_cr(this.gAttrTag("class", "display_field_total"));
                    sb.indent();
                    boolean isOutputStyle = false;
                    for (int i2 = 0; i2 < this.majors.length; ++i2) {
                        Item _item = this.majors[i2];
                        if (i2 == 0) {
                            String style = AppSchemaUtil.getCommonStyleInAllDisplayitems(this.presentation);
                            if (StringUtils.isNotBlank((String)style)) {
                                sb.indent();
                                sb.append_cr("<xsl:element name=\"span\">");
                                sb.forward();
                                sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
                                sb.indent();
                                isOutputStyle = true;
                            }
                            sb.append("<xsl:variable name=\"total_sum_major\" select=\"");
                        }
                        sb.append("$");
                        sb.append(StringUtil.convertXslVariableString((String)(_item.getType() + "_" + _item.getContent())));
                        if (i2 < this.majors.length - 1) {
                            sb.append("+");
                        }
                        if (i2 != this.majors.length - 1) continue;
                        sb.append("\"/>");
                        sb.cr();
                    }
                    sb.indent();
                    sb.append("<xsl:value-of select=\"format-number($total_sum_major, '" + this.total_numberformat + "')\"/>");
                    sb.cr();
                    sb.indent();
                    sb.append("<xsl:if test=\"$__jfc_ratio_show = 'true'\">");
                    sb.cr();
                    sb.forward();
                    sb.append("<xsl:value-of select=\"format-number($total_sum_major div $total_sum_all, $__jfc_ratio_number_format)\"/>");
                    sb.cr();
                    sb.back();
                    sb.append("</xsl:if>");
                    sb.cr();
                    if (isOutputStyle) {
                        sb.indent();
                        sb.append_cr("</xsl:element><!-- span -->");
                    }
                    sb.back();
                    sb.append_cr(this.gElemTag("/td"));
                }
            }
            sb.back();
            sb.append_cr(this.gElemTag("/tr"));
        }
    }

    protected String getResourceKeyAsRowTotal(Item[] items) {
        return "__jfc_common.total";
    }

    protected String getResourceKeyAsColumnTotal(Item[] items) {
        return "__jfc_common.total";
    }

    protected boolean gOutputSortRule(Modelitem sitem, int num, TabBuffer sb) {
        boolean isOutputSortElement = false;
        Relation relation = AppSchemaUtil.getRelation(sitem);
        if (("storeref".equals(sitem.getType()) || "masterref".equals(sitem.getType())) && !sitem.getTransient()) {
            String targetitemname;
            Model _r_model;
            String order = relation.getOrder();
            String sortRule = relation.getSortrule().substring("role".length());
            String type = null;
            sb.append("<xsl:sort select=\"");
            sb.append(AppSchemaUtil.getChildPart(sitem.getName()));
            sb.append("/@");
            if ("storeref".equals(sitem.getType())) {
                sb.append(sortRule);
            } else if ("content".equals(sortRule)) {
                sb.append("label");
            } else {
                sb.append(sortRule);
            }
            sb.append("\" ");
            if ("priority".equals(sortRule)) {
                type = "number";
            } else if ("id".equals(sortRule)) {
                if ("masterref".equals(sitem.getType())) {
                    type = "number";
                } else {
                    _r_model = (Model)relation.getIdrefAsIRNode();
                    targetitemname = AppSchemaUtil.getRoleid(relation, this.project);
                    if (StringUtils.isBlank((String)targetitemname)) {
                        targetitemname = relation.getName();
                    }
                    if (StringUtils.isNotBlank((String)targetitemname)) {
                        Modelitem _r_mitem = AppSchemaUtil.getModelitem(targetitemname, _r_model);
                        String __r_type = AppSchemaUtil.getModelitemType(this.project, _r_model.getId(), _r_mitem);
                        if (JavaSourceGenerator.isBasicType(__r_type)) {
                            type = "number";
                        }
                    }
                }
            } else {
                type = null;
            }
            if (type != null) {
                sb.append("data-type=\"" + type + "\" ");
            }
            if (order != null) {
                sb.append("order=\"" + order + "\"");
            }
            sb.append_cr("/>");
            isOutputSortElement = true;
            if (num == 0 && !"id".equals(sortRule)) {
                _r_model = (Model)relation.getIdrefAsIRNode();
                targetitemname = null;
                targetitemname = "ref".equals(relation.getType()) ? relation.getName() : AppSchemaUtil.getRoleid(relation, this.project);
                String __r_type = null;
                if (StringUtils.isBlank((String)targetitemname)) {
                    targetitemname = relation.getName();
                }
                if (StringUtils.isNotBlank((String)targetitemname)) {
                    Modelitem _r_mitem = AppSchemaUtil.getModelitem(targetitemname, _r_model);
                    __r_type = AppSchemaUtil.getModelitemType(this.project, _r_model.getId(), _r_mitem);
                }
                sb.indent();
                sb.append("<xsl:sort select=\"");
                sb.append(AppSchemaUtil.getChildPart(sitem.getName()));
                sb.append("/@id\" ");
                if (JavaSourceGenerator.isBasicType(__r_type)) {
                    sb.append("data-type=\"number\"");
                }
                sb.append_cr("/>");
            }
        } else {
            Relation last_rel;
            sb.append("<xsl:sort select=\"");
            sb.append(AppSchemaUtil.getChildPart(sitem.getName()));
            if ("combo".equals(sitem.getDualinputmethod())) {
                sb.append("/@content");
            } else if (relation != null && "ref".equals(relation.getType()) && (last_rel = AppSchemaUtil.getRelatedLastRelation(relation)) != null && !"ref".equals(last_rel.getType())) {
                sb.append("/@id");
            }
            sb.append("\"");
            if (JavaSourceGenerator.isBasicType(sitem.getType())) {
                sb.append(" data-type=\"number\"");
            }
            sb.append_cr("/>");
            isOutputSortElement = true;
        }
        return isOutputSortElement;
    }

    protected void gRowTotal_masterref(TabBuffer sb, Item item) {
        this.gRowTotal_masterref(sb, item, "/@content");
    }

    protected void gRowTotal_masterref(TabBuffer sb, Item item, String target) {
        String name = item.getContent();
        String numberformat = this.searchNumberFormat(name);
        sb.indent();
        sb.append("<xsl:for-each select=\"item[1]/");
        sb.append(name);
        sb.append_cr("\">");
        sb.forward();
        sb.append_cr("<xsl:variable name=\"p\" select=\"position()\"/>");
        sb.indent();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        sb.append_cr(this.gAttrTag("class", "display_field_total"));
        sb.indent();
        boolean isOutputStyle = false;
        String style = AppSchemaUtil.getCommonStyleInAllDisplayitems(this.presentation);
        if (StringUtils.isNotBlank((String)style)) {
            sb.indent();
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
            isOutputStyle = true;
        }
        sb.append("<xsl:variable name=\"total_sum_major\" select=\"sum(");
        sb.append("/");
        sb.append(this.idref);
        sb.append("/item/");
        sb.append(name);
        sb.append("[position() = $p]");
        sb.append(target);
        sb.append(")\"/>");
        sb.cr();
        sb.indent();
        sb.append("<xsl:value-of select=\"format-number($total_sum_major, ");
        sb.append("'" + numberformat + "')\"/>");
        sb.cr();
        sb.indent();
        sb.append("<xsl:if test=\"$__jfc_ratio_show = 'true'\">");
        sb.cr();
        sb.forward();
        sb.append("<xsl:value-of select=\"format-number($total_sum_major div $total_sum_all, $__jfc_ratio_number_format)\"/>");
        sb.cr();
        sb.back();
        sb.append("</xsl:if>");
        sb.cr();
        sb.back();
        if (isOutputStyle) {
            sb.append_cr("</xsl:element><!-- span -->");
        }
        sb.append_cr(this.gElemTag("/td"));
        sb.back();
        sb.append_cr("</xsl:for-each>");
    }

    protected void gRowTotal_normal(TabBuffer sb, Item item) {
        String style;
        String name = item.getContent();
        String type = item.getType();
        String numberformat = this.searchNumberFormat(name);
        sb.indent();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        sb.append_cr(this.gAttrTag("class", "display_field_total"));
        sb.indent();
        boolean isOutputStyle = false;
        Displayitem ditem = AppSchemaUtil.getDisplayitem(name, this.presentation);
        if (ditem != null && StringUtils.isNotBlank((String)(style = ditem.getStyle()))) {
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
            isOutputStyle = true;
        }
        sb.append("<xsl:value-of select=\"format-number(");
        sb.append("$");
        sb.append(StringUtil.convertXslVariableString((String)(type + "_" + name)));
        sb.append(", '" + numberformat + "')\"/>");
        sb.cr();
        sb.indent();
        sb.append("<xsl:if test=\"$__jfc_ratio_show = 'true'\">");
        sb.cr();
        sb.forward();
        sb.append("<xsl:value-of select=\"format-number($");
        sb.append(StringUtil.convertXslVariableString((String)(type + "_" + name)));
        sb.append(" div $total_" + StringUtil.convertXslVariableString((String)(type + "_" + name)) + ", $__jfc_ratio_number_format)\"/>");
        sb.cr();
        sb.back();
        sb.append("</xsl:if>");
        sb.cr();
        if (isOutputStyle) {
            sb.back();
            sb.append_cr("</xsl:element><!-- span -->");
        }
        sb.back();
        sb.append_cr(this.gElemTag("/td"));
    }

    @Override
    protected void gAfterItem(TabBuffer sb) {
        if (this.majors != null && this.majors.length > 0 && this.isColumnTotal) {
            sb.indent();
            sb.append_cr(this.gElemTag("td"));
            sb.forward();
            sb.append_cr(this.gAttrTag("class", "display_field_total"));
            sb.indent();
            boolean isOutputStyle = false;
            for (int i = 0; i < this.majors.length; ++i) {
                Item _item = this.majors[i];
                String name = _item.getContent();
                if (i == 0) {
                    String style = AppSchemaUtil.getCommonStyleInAllDisplayitems(this.presentation);
                    if (StringUtils.isNotBlank((String)style)) {
                        sb.indent();
                        sb.append_cr("<xsl:element name=\"span\">");
                        sb.forward();
                        sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
                        sb.indent();
                        isOutputStyle = true;
                    }
                    sb.append("<xsl:variable name=\"total_sum_major\" select=\"");
                }
                if (this.masterItemSet.contains(name) || this.uncalculatableMajorItemSet.contains(name)) {
                    sb.append("sum(");
                    sb.append(name);
                    if (this.masterItemSet.contains(name)) {
                        sb.append("/@content");
                    }
                    sb.append(")");
                } else {
                    sb.append(name);
                }
                if (i >= this.majors.length - 1) continue;
                sb.append("+");
            }
            sb.append_cr("\"/>");
            sb.indent();
            sb.append("<xsl:value-of select=\"format-number($total_sum_major, '" + this.total_numberformat + "')\"/>");
            sb.cr();
            sb.indent();
            sb.append("<xsl:if test=\"$__jfc_ratio_show = 'true'\">");
            sb.cr();
            sb.forward();
            sb.append("<xsl:value-of select=\"format-number($total_sum_major div $total_sum_all, $__jfc_ratio_number_format)\"/>");
            sb.cr();
            sb.back();
            sb.append("</xsl:if>");
            sb.cr();
            if (isOutputStyle) {
                sb.back();
                sb.append_cr("</xsl:element><!-- span -->");
            }
            sb.back();
            sb.append_cr(this.gElemTag("/td"));
        }
    }

    @Override
    protected void gDisplayRowName0(TabBuffer sb, IModelChoice[] imc, int rownum, List<XslGenerator_showList.LNode> labelList, String _width) {
        sb.indent();
        sb.append_cr(this.gElemTag("tr"));
        sb.forward();
        int width_length = this.gDisplayRowName_addinfo(sb, imc);
        if (rownum == 0) {
            rownum = 1;
        }
        int width_value = width_length / rownum;
        boolean isAutoalignment = this.displaymodel.getAutoalignment();
        XslGenerator_showList.LNode ln = null;
        for (int i = 0; i < labelList.size(); ++i) {
            ln = labelList.get(i);
            sb.indent();
            if (ln.isHidden) {
                sb.append("<xsl:if test=\"item/");
                sb.append(ln.name);
                sb.append_cr("\">");
                sb.forward();
            }
            if (this.masterItemSet.contains(ln.name) || this.uncalculatableMajorItemSet.contains(ln.name)) {
                sb.append("<xsl:for-each select=\"item[1]/");
                sb.append(ln.name);
                sb.append_cr("\">");
                sb.forward();
            }
            sb.append_cr(this.gElemTag("th"));
            sb.forward();
            sb.append_cr(this.gAttrTag("class", "display_label"));
            _width = isAutoalignment ? width_value + "%" : ln.width;
            if (_width != null) {
                sb.indent();
                sb.append_cr(this.gAttrTag("width", _width));
            }
            if (ln.isNoWrap) {
                sb.indent();
                sb.append_cr(this.gAttrTag("nowrap", "nowrap"));
            }
            if (this.masterItemSet.contains(ln.name) || this.uncalculatableMajorItemSet.contains(ln.name)) {
                sb.indent();
                sb.append_cr("<xsl:value-of select=\"@label\"/>");
            } else {
                this.outputLabel(ln, sb);
                sb.cr();
            }
            sb.back();
            sb.append_cr(this.gElemTag("/th"));
            if (this.masterItemSet.contains(ln.name) || this.uncalculatableMajorItemSet.contains(ln.name)) {
                sb.back();
                sb.append_cr("</xsl:for-each>");
            }
            if (!ln.isHidden) continue;
            sb.back();
            sb.append_cr("</xsl:if>");
        }
        this.outputAdditionalLabel(sb);
        sb.back();
        sb.append_cr(this.gElemTag("/tr"));
    }

    @Override
    protected void outputLabel(XslGenerator_showList.LNode ln, TabBuffer sb) {
        String style;
        String rkey = this.createResourceKey(ln.label);
        JFCAppResourceGenerator.put(rkey, ln.label);
        boolean isOutputStyle = false;
        Displayitem ditem = AppSchemaUtil.getDisplayitem(ln.name, this.presentation);
        if (ditem != null && StringUtils.isNotBlank((String)(style = ditem.getStyle()))) {
            sb.indent();
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
            isOutputStyle = true;
        }
        sb.indent();
        sb.append("<xsl:value-of select=\"jfcutils:getRValue('");
        sb.append(rkey);
        sb.append("', $__jfc_locale)\" disable-output-escaping=\"yes\"/>");
        if (isOutputStyle) {
            sb.cr();
            sb.back();
            sb.append_cr("</xsl:element><!-- span -->");
        }
    }

    @Override
    protected void outputAdditionalLabel(TabBuffer sb) {
        if (!this.isColumnTotal) {
            return;
        }
        sb.indent();
        sb.append_cr(this.gElemTag("th"));
        sb.forward();
        sb.append_cr(this.gAttrTag("class", "display_label_total"));
        sb.indent();
        boolean isOutputStyle = false;
        String style = AppSchemaUtil.getCommonStyleInAllDisplayitems(this.presentation);
        if (StringUtils.isNotBlank((String)style)) {
            sb.indent();
            sb.append_cr("<xsl:element name=\"span\">");
            sb.forward();
            sb.append_cr("<xsl:attribute name=\"style\">" + style + "</xsl:attribute>");
            sb.indent();
            isOutputStyle = true;
        }
        sb.append_cr(this.createRValueStatement(this.getResourceKeyAsColumnTotal(this.majors)));
        if (isOutputStyle) {
            sb.back();
            sb.append_cr("</xsl:element><!-- span -->");
        }
        sb.back();
        sb.append_cr(this.gElemTag("/th"));
    }

    @Override
    protected boolean gStartElement(TabBuffer sb, Displayitem ditem, Modelitem mitem, Map<String, Object> attrMap) {
        if (this.masterItemSet.contains(mitem.getName()) || this.uncalculatableMajorItemSet.contains(mitem.getName())) {
            this.masterrefMode = true;
            return this.gStartElement_total_masterref(sb, ditem, mitem, attrMap);
        }
        return super.gStartElement(sb, ditem, mitem, attrMap);
    }

    protected boolean gStartElement_total_masterref(TabBuffer sb, Displayitem ditem, Modelitem mitem, Map<String, Object> attrMap) {
        sb.indent();
        sb.append_cr(this.comment("gStartElement"));
        sb.indent();
        sb.append_cr("<xsl:variable name=\"pos\" select=\"position()\"/>");
        sb.indent();
        sb.append("<xsl:for-each select=\"");
        sb.append(mitem.getName());
        sb.append_cr("\">");
        sb.forward();
        sb.append_cr(this.gElemTag("td"));
        sb.forward();
        if (this.isSetClassOnTD()) {
            if (attrMap != null && !attrMap.keySet().contains("valueClass")) {
                attrMap.put("valueClass", "display_field");
            }
            String[] attrs = new String[]{"valueClass", "align", "nowrap"};
            this.gExpandAttrMap(attrMap, attrs, "$pos", sb);
        } else {
            String[] attrs = new String[]{"align", "nowrap"};
            this.gExpandAttrMap(attrMap, attrs, "$pos", sb);
        }
        return true;
    }

    @Override
    protected void gValueOf_single0(TabBuffer sb, Displayitem ditem, Modelitem sitem, Modelitem pitem, String name) {
        if (this.masterItemSet.contains(name) || this.uncalculatableMajorItemSet.contains(name)) {
            String numberformat = this.searchNumberFormat(ditem.getName());
            sb.indent();
            sb.append("<xsl:value-of select=\"format-number(");
            if (this.masterItemSet.contains(name)) {
                sb.append("@content");
            } else if (this.uncalculatableMajorItemSet.contains(name)) {
                sb.append(".");
            }
            sb.append(", '");
            sb.append(numberformat);
            sb.append_cr("')\"/>");
            sb.indent();
            sb.append("<xsl:if test=\"$__jfc_ratio_show = 'true'\">");
            sb.cr();
            sb.forward();
            sb.append("<xsl:value-of select=\"format-number(");
            if (this.masterItemSet.contains(name)) {
                sb.append("@content");
            } else if (this.uncalculatableMajorItemSet.contains(name)) {
                sb.append(".");
            }
            sb.append(" div $total_" + StringUtil.convertXslVariableString((String)("sum_" + name)) + ", $__jfc_ratio_number_format)\"/>");
            sb.cr();
            sb.back();
            sb.append("</xsl:if>");
            sb.cr();
        } else {
            if (this.dimensions != null) {
                for (int i = 0; i < this.dimensions.length; ++i) {
                    if (!this.dimensions[i].getContent().equals(name)) continue;
                    Modelitem _sitem = AppSchemaUtil.getModelitem(name, this.model);
                    if (_sitem != null && "masterref".equals(_sitem.getType())) {
                        name = name + "/@label";
                        break;
                    }
                    if (_sitem == null || !"storeref".equals(_sitem.getType())) continue;
                    boolean needsContentSearch = false;
                    Relation _rel = AppSchemaUtil.getRelationTypeExceptRef(_sitem);
                    if (_rel != null) {
                        needsContentSearch = true;
                    } else {
                        Modelitem _rritem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, this.model.getId(), _sitem);
                        if ("storeref".equals(_rritem.getType())) {
                            needsContentSearch = true;
                        }
                    }
                    if (!needsContentSearch) break;
                    name = name + "/@content";
                    break;
                }
            }
            super.gValueOf_single0(sb, ditem, sitem, pitem, name);
        }
    }

    @Override
    protected void gValueOf_normal_number(TabBuffer sb, Modelitem sitem, String name, String numberformat, String altcontent, boolean containerFlag, boolean isCountType, String pname) {
        super.gValueOf_normal_number(sb, sitem, name, numberformat, altcontent, containerFlag, isCountType, pname);
        if (numberformat != null && numberformat.length() > 0) {
            Item[] _items;
            String type = null;
            for (Item _item : _items = this.view.getItem()) {
                if (!_item.getContent().equals(name)) continue;
                type = _item.getType();
                break;
            }
            if (type == null) {
                type = "sum";
            }
            sb.indent();
            sb.append("<xsl:if test=\"$__jfc_ratio_show = 'true'\">");
            sb.cr();
            sb.forward();
            sb.append("<xsl:value-of select=\"format-number(");
            sb.append(name);
            sb.append(" div $total_" + StringUtil.convertXslVariableString((String)(type + "_" + name)) + ", $__jfc_ratio_number_format)\"/>");
            sb.cr();
            sb.back();
            sb.append("</xsl:if>");
            sb.cr();
        }
    }

    @Override
    protected void gFinishElement(TabBuffer sb) {
        sb.back();
        sb.append(this.comment("gFinishElement"));
        sb.append_cr(this.gElemTag("/td"));
        if (this.masterrefMode) {
            sb.back();
            sb.append_cr("</xsl:for-each>");
            this.masterrefMode = false;
        }
    }

    protected String searchNumberFormat(String name) {
        String numberformat = null;
        IDisplaymodelChoice[] idmc = this.displaymodel.getContent();
        if (idmc != null) {
            for (int j = 0; j < idmc.length; ++j) {
                String _numberformat;
                Displayitem ditem;
                if (!(idmc[j] instanceof Displayitem) || !(ditem = (Displayitem)idmc[j]).getName().equals(name) || (_numberformat = ditem.getNumberformat()) == null || _numberformat.length() <= 0) continue;
                numberformat = _numberformat;
                break;
            }
        }
        if (numberformat == null || numberformat.length() == 0) {
            numberformat = "#,##0";
        }
        return numberformat;
    }

    protected String searchTotalNumberFormat() {
        HashSet<String> nfSet = new HashSet<String>();
        IDisplaymodelChoice[] idmc = this.displaymodel.getContent();
        if (idmc != null) {
            for (int j = 0; j < idmc.length; ++j) {
                Displayitem ditem;
                String _numberformat;
                if (!(idmc[j] instanceof Displayitem) || (_numberformat = (ditem = (Displayitem)idmc[j]).getNumberformat()) == null || _numberformat.length() <= 0) continue;
                nfSet.add(_numberformat);
            }
        }
        String total_numberformat = null;
        for (String nf : nfSet) {
            if (total_numberformat == null) {
                total_numberformat = nf;
                continue;
            }
            if (total_numberformat.length() >= nf.length()) continue;
            total_numberformat = nf;
        }
        if (total_numberformat == null || total_numberformat.length() == 0) {
            total_numberformat = this.rman.getValue("xslt.total.defaultformat");
        }
        return total_numberformat;
    }
}

