/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen;

import jp.jasminesoft.jfc.gen.IWebSourceVariable;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Project;

public abstract class XslSourceGenerator
extends SourceGenerator
implements IWebSourceVariable {
    protected Action action;

    public XslSourceGenerator(Project project, Action action) {
        super(project);
        this.action = action;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    public abstract String getFilename();

    @Override
    public String getFileSuffix() {
        return ".xsl";
    }

    @Override
    public void process() {
        this.init();
        String filename = this.getFilename();
        String content = this.process0();
        filename = this.addModelidToFilename(this.action, filename);
        content = content + this.getGeneratorClassName();
        this.createSource(content, filename, "webpage", false);
    }

    public void init() {
    }

    public abstract String process0();

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof XslSourceGenerator) {
            XslSourceGenerator jsg = (XslSourceGenerator)o;
            if (this.getFilename().equals(jsg.getFilename()) && this.getFileSuffix().equals(jsg.getFileSuffix())) {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<!-- genclassname:" + this.getClass().getName() + " -->" + CR;
        }
        return "";
    }
}

