/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.ClusterMachine;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IEnvironmentChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Cluster
implements Serializable,
Cloneable,
IRNode,
IEnvironmentChoice {
    private boolean useCluster_;
    private Integer connectRetry_;
    private Integer connectSleeptime_;
    private List clusterMachine_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Cluster() {
    }

    public Cluster(Cluster source) {
        this.setup(source);
    }

    public Cluster(RStack stack) {
        this.setup(stack);
    }

    public Cluster(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Cluster(Element element) {
        this.setup(element);
    }

    public Cluster(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Cluster(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Cluster(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Cluster(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Cluster(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Cluster(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Cluster source) {
        this.setUseCluster(source.getUseCluster());
        this.setConnectRetry(source.getConnectRetry());
        this.setConnectSleeptime(source.getConnectSleeptime());
        this.clusterMachine_.clear();
        int size = source.clusterMachine_.size();
        for (int i = 0; i < size; ++i) {
            this.addClusterMachine((ClusterMachine)source.getClusterMachine(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.useCluster_ = URelaxer.getAttributePropertyAsBoolean(element, "use_cluster");
        this.connectRetry_ = URelaxer.getAttributePropertyAsIntObject(element, "connect_retry");
        this.connectSleeptime_ = URelaxer.getAttributePropertyAsIntObject(element, "connect_sleeptime");
        this.clusterMachine_.clear();
        while (ClusterMachine.isMatch(stack)) {
            this.addClusterMachine(factory.createClusterMachine(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createCluster(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("cluster");
        URelaxer.setAttributePropertyByBoolean(element, "use_cluster", this.useCluster_);
        if (this.connectRetry_ != null) {
            URelaxer.setAttributePropertyByInt(element, "connect_retry", this.connectRetry_);
        }
        if (this.connectSleeptime_ != null) {
            URelaxer.setAttributePropertyByInt(element, "connect_sleeptime", this.connectSleeptime_);
        }
        int size = this.clusterMachine_.size();
        for (int i = 0; i < size; ++i) {
            ClusterMachine value = (ClusterMachine)this.clusterMachine_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final boolean getUseCluster() {
        return this.useCluster_;
    }

    public final void setUseCluster(boolean useCluster) {
        this.useCluster_ = useCluster;
    }

    public int getConnectRetry() {
        if (this.connectRetry_ == null) {
            return 3;
        }
        return this.connectRetry_;
    }

    public int getConnectRetry(int connectRetry) {
        if (this.connectRetry_ == null) {
            return connectRetry;
        }
        return this.connectRetry_;
    }

    public Integer getConnectRetryAsInteger() {
        return this.connectRetry_;
    }

    public boolean checkConnectRetry() {
        return this.connectRetry_ != null;
    }

    public void setConnectRetry(int connectRetry) {
        this.connectRetry_ = new Integer(connectRetry);
    }

    public void setConnectRetry(Integer connectRetry) {
        this.connectRetry_ = connectRetry;
    }

    public int getConnectSleeptime() {
        if (this.connectSleeptime_ == null) {
            return 5000;
        }
        return this.connectSleeptime_;
    }

    public int getConnectSleeptime(int connectSleeptime) {
        if (this.connectSleeptime_ == null) {
            return connectSleeptime;
        }
        return this.connectSleeptime_;
    }

    public Integer getConnectSleeptimeAsInteger() {
        return this.connectSleeptime_;
    }

    public boolean checkConnectSleeptime() {
        return this.connectSleeptime_ != null;
    }

    public void setConnectSleeptime(int connectSleeptime) {
        this.connectSleeptime_ = new Integer(connectSleeptime);
    }

    public void setConnectSleeptime(Integer connectSleeptime) {
        this.connectSleeptime_ = connectSleeptime;
    }

    public final ClusterMachine[] getClusterMachine() {
        ClusterMachine[] array = new ClusterMachine[this.clusterMachine_.size()];
        return this.clusterMachine_.toArray(array);
    }

    public final void setClusterMachine(ClusterMachine[] clusterMachine) {
        int i;
        this.clusterMachine_.clear();
        if (clusterMachine != null) {
            for (i = 0; i < clusterMachine.length; ++i) {
                this.addClusterMachine(clusterMachine[i]);
            }
        }
        for (i = 0; i < clusterMachine.length; ++i) {
            clusterMachine[i].rSetParentRNode(this);
        }
        for (i = 0; i < clusterMachine.length; ++i) {
            clusterMachine[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setClusterMachine(ClusterMachine clusterMachine) {
        this.clusterMachine_.clear();
        this.addClusterMachine(clusterMachine);
        if (clusterMachine != null) {
            clusterMachine.rSetParentRNode(this);
        }
        if (clusterMachine != null) {
            clusterMachine.rSetRContext(this.rGetRContext());
        }
    }

    public final void addClusterMachine(ClusterMachine clusterMachine) {
        this.clusterMachine_.add(clusterMachine);
        if (clusterMachine != null) {
            clusterMachine.rSetParentRNode(this);
        }
        if (clusterMachine != null) {
            clusterMachine.rSetRContext(this.rGetRContext());
        }
    }

    public final void addClusterMachine(ClusterMachine[] clusterMachine) {
        int i;
        for (i = 0; i < clusterMachine.length; ++i) {
            this.addClusterMachine(clusterMachine[i]);
        }
        for (i = 0; i < clusterMachine.length; ++i) {
            clusterMachine[i].rSetParentRNode(this);
        }
        for (i = 0; i < clusterMachine.length; ++i) {
            clusterMachine[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeClusterMachine() {
        return this.clusterMachine_.size();
    }

    public final ClusterMachine getClusterMachine(int index) {
        return (ClusterMachine)this.clusterMachine_.get(index);
    }

    public final void setClusterMachine(int index, ClusterMachine clusterMachine) {
        this.clusterMachine_.set(index, clusterMachine);
        if (clusterMachine != null) {
            clusterMachine.rSetParentRNode(this);
        }
    }

    public final void addClusterMachine(int index, ClusterMachine clusterMachine) {
        this.clusterMachine_.add(index, clusterMachine);
        if (clusterMachine != null) {
            clusterMachine.rSetParentRNode(this);
        }
    }

    public final void removeClusterMachine(int index) {
        this.clusterMachine_.remove(index);
    }

    public final void removeClusterMachine(ClusterMachine clusterMachine) {
        this.clusterMachine_.remove(clusterMachine);
    }

    public final void clearClusterMachine() {
        this.clusterMachine_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<cluster");
        buffer.append(" use_cluster=\"");
        buffer.append(URelaxer.getString(this.getUseCluster()));
        buffer.append("\"");
        if (this.connectRetry_ != null) {
            buffer.append(" connect_retry=\"");
            buffer.append(URelaxer.getString(this.getConnectRetry()));
            buffer.append("\"");
        }
        if (this.connectSleeptime_ != null) {
            buffer.append(" connect_sleeptime=\"");
            buffer.append(URelaxer.getString(this.getConnectSleeptime()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.clusterMachine_.size();
        for (int i = 0; i < size; ++i) {
            ClusterMachine value = (ClusterMachine)this.clusterMachine_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</cluster>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<cluster");
        buffer.write(" use_cluster=\"");
        buffer.write(URelaxer.getString(this.getUseCluster()));
        buffer.write("\"");
        if (this.connectRetry_ != null) {
            buffer.write(" connect_retry=\"");
            buffer.write(URelaxer.getString(this.getConnectRetry()));
            buffer.write("\"");
        }
        if (this.connectSleeptime_ != null) {
            buffer.write(" connect_sleeptime=\"");
            buffer.write(URelaxer.getString(this.getConnectSleeptime()));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.clusterMachine_.size();
        for (int i = 0; i < size; ++i) {
            ClusterMachine value = (ClusterMachine)this.clusterMachine_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</cluster>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<cluster");
        buffer.print(" use_cluster=\"");
        buffer.print(URelaxer.getString(this.getUseCluster()));
        buffer.print("\"");
        if (this.connectRetry_ != null) {
            buffer.print(" connect_retry=\"");
            buffer.print(URelaxer.getString(this.getConnectRetry()));
            buffer.print("\"");
        }
        if (this.connectSleeptime_ != null) {
            buffer.print(" connect_sleeptime=\"");
            buffer.print(URelaxer.getString(this.getConnectSleeptime()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.clusterMachine_.size();
        for (int i = 0; i < size; ++i) {
            ClusterMachine value = (ClusterMachine)this.clusterMachine_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</cluster>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getUseClusterAsString() {
        return URelaxer.getString(this.getUseCluster());
    }

    public String getConnectRetryAsString() {
        return URelaxer.getString(this.getConnectRetry());
    }

    public String getConnectSleeptimeAsString() {
        return URelaxer.getString(this.getConnectSleeptime());
    }

    public void setUseClusterByString(String string) {
        this.setUseCluster(new Boolean(string));
    }

    public void setConnectRetryByString(String string) {
        this.setConnectRetry(Integer.parseInt(string));
    }

    public void setConnectSleeptimeByString(String string) {
        this.setConnectSleeptime(Integer.parseInt(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.clusterMachine_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "cluster")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (ClusterMachine.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Cluster.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Cluster.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

