/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Op;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Command
implements Serializable,
Cloneable,
IRNode,
IActionChoice {
    private String default_;
    private List op_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Command() {
    }

    public Command(Command source) {
        this.setup(source);
    }

    public Command(RStack stack) {
        this.setup(stack);
    }

    public Command(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Command(Element element) {
        this.setup(element);
    }

    public Command(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Command(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Command(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Command(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Command(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Command(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Command source) {
        this.setDefault(source.getDefault());
        this.op_.clear();
        int size = source.op_.size();
        for (int i = 0; i < size; ++i) {
            this.addOp((Op)source.getOp(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.default_ = URelaxer.getAttributePropertyAsString(element, "default");
        this.op_.clear();
        while (Op.isMatch(stack)) {
            this.addOp(factory.createOp(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createCommand(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("command");
        if (this.default_ != null) {
            URelaxer.setAttributePropertyByString(element, "default", this.default_);
        }
        int size = this.op_.size();
        for (int i = 0; i < size; ++i) {
            Op value = (Op)this.op_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getDefault() {
        return this.default_;
    }

    public final void setDefault(String defaultValue) {
        this.default_ = defaultValue;
    }

    public final Op[] getOp() {
        Op[] array = new Op[this.op_.size()];
        return this.op_.toArray(array);
    }

    public final void setOp(Op[] op) {
        int i;
        this.op_.clear();
        if (op != null) {
            for (i = 0; i < op.length; ++i) {
                this.addOp(op[i]);
            }
        }
        for (i = 0; i < op.length; ++i) {
            op[i].rSetParentRNode(this);
        }
        for (i = 0; i < op.length; ++i) {
            op[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setOp(Op op) {
        this.op_.clear();
        this.addOp(op);
        if (op != null) {
            op.rSetParentRNode(this);
        }
        if (op != null) {
            op.rSetRContext(this.rGetRContext());
        }
    }

    public final void addOp(Op op) {
        this.op_.add(op);
        if (op != null) {
            op.rSetParentRNode(this);
        }
        if (op != null) {
            op.rSetRContext(this.rGetRContext());
        }
    }

    public final void addOp(Op[] op) {
        int i;
        for (i = 0; i < op.length; ++i) {
            this.addOp(op[i]);
        }
        for (i = 0; i < op.length; ++i) {
            op[i].rSetParentRNode(this);
        }
        for (i = 0; i < op.length; ++i) {
            op[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeOp() {
        return this.op_.size();
    }

    public final Op getOp(int index) {
        return (Op)this.op_.get(index);
    }

    public final void setOp(int index, Op op) {
        this.op_.set(index, op);
        if (op != null) {
            op.rSetParentRNode(this);
        }
    }

    public final void addOp(int index, Op op) {
        this.op_.add(index, op);
        if (op != null) {
            op.rSetParentRNode(this);
        }
    }

    public final void removeOp(int index) {
        this.op_.remove(index);
    }

    public final void removeOp(Op op) {
        this.op_.remove(op);
    }

    public final void clearOp() {
        this.op_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<command");
        if (this.default_ != null) {
            buffer.append(" default=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDefault())));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.op_.size();
        for (int i = 0; i < size; ++i) {
            Op value = (Op)this.op_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</command>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<command");
        if (this.default_ != null) {
            buffer.write(" default=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDefault())));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.op_.size();
        for (int i = 0; i < size; ++i) {
            Op value = (Op)this.op_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</command>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<command");
        if (this.default_ != null) {
            buffer.print(" default=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getDefault())));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.op_.size();
        for (int i = 0; i < size; ++i) {
            Op value = (Op)this.op_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</command>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getDefaultAsString() {
        return URelaxer.getString(this.getDefault());
    }

    public void setDefaultByString(String string) {
        this.setDefault(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.op_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "command")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (Op.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Command.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Command.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

