/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Datalist
implements Serializable,
Cloneable,
IRNode,
IActionChoice {
    private List dataitem_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Datalist() {
    }

    public Datalist(Datalist source) {
        this.setup(source);
    }

    public Datalist(RStack stack) {
        this.setup(stack);
    }

    public Datalist(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Datalist(Element element) {
        this.setup(element);
    }

    public Datalist(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Datalist(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Datalist(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Datalist(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Datalist(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Datalist(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Datalist source) {
        this.dataitem_.clear();
        int size = source.dataitem_.size();
        for (int i = 0; i < size; ++i) {
            this.addDataitem((Dataitem)source.getDataitem(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.dataitem_.clear();
        while (Dataitem.isMatch(stack)) {
            this.addDataitem(factory.createDataitem(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createDatalist(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("datalist");
        int size = this.dataitem_.size();
        for (int i = 0; i < size; ++i) {
            Dataitem value = (Dataitem)this.dataitem_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final Dataitem[] getDataitem() {
        Dataitem[] array = new Dataitem[this.dataitem_.size()];
        return this.dataitem_.toArray(array);
    }

    public final void setDataitem(Dataitem[] dataitem) {
        int i;
        this.dataitem_.clear();
        if (dataitem != null) {
            for (i = 0; i < dataitem.length; ++i) {
                this.addDataitem(dataitem[i]);
            }
        }
        for (i = 0; i < dataitem.length; ++i) {
            dataitem[i].rSetParentRNode(this);
        }
        for (i = 0; i < dataitem.length; ++i) {
            dataitem[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setDataitem(Dataitem dataitem) {
        this.dataitem_.clear();
        this.addDataitem(dataitem);
        if (dataitem != null) {
            dataitem.rSetParentRNode(this);
        }
        if (dataitem != null) {
            dataitem.rSetRContext(this.rGetRContext());
        }
    }

    public final void addDataitem(Dataitem dataitem) {
        this.dataitem_.add(dataitem);
        if (dataitem != null) {
            dataitem.rSetParentRNode(this);
        }
        if (dataitem != null) {
            dataitem.rSetRContext(this.rGetRContext());
        }
    }

    public final void addDataitem(Dataitem[] dataitem) {
        int i;
        for (i = 0; i < dataitem.length; ++i) {
            this.addDataitem(dataitem[i]);
        }
        for (i = 0; i < dataitem.length; ++i) {
            dataitem[i].rSetParentRNode(this);
        }
        for (i = 0; i < dataitem.length; ++i) {
            dataitem[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeDataitem() {
        return this.dataitem_.size();
    }

    public final Dataitem getDataitem(int index) {
        return (Dataitem)this.dataitem_.get(index);
    }

    public final void setDataitem(int index, Dataitem dataitem) {
        this.dataitem_.set(index, dataitem);
        if (dataitem != null) {
            dataitem.rSetParentRNode(this);
        }
    }

    public final void addDataitem(int index, Dataitem dataitem) {
        this.dataitem_.add(index, dataitem);
        if (dataitem != null) {
            dataitem.rSetParentRNode(this);
        }
    }

    public final void removeDataitem(int index) {
        this.dataitem_.remove(index);
    }

    public final void removeDataitem(Dataitem dataitem) {
        this.dataitem_.remove(dataitem);
    }

    public final void clearDataitem() {
        this.dataitem_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<datalist");
        buffer.append(">");
        int size = this.dataitem_.size();
        for (int i = 0; i < size; ++i) {
            Dataitem value = (Dataitem)this.dataitem_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</datalist>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<datalist");
        buffer.write(">");
        int size = this.dataitem_.size();
        for (int i = 0; i < size; ++i) {
            Dataitem value = (Dataitem)this.dataitem_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</datalist>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<datalist");
        buffer.print(">");
        int size = this.dataitem_.size();
        for (int i = 0; i < size; ++i) {
            Dataitem value = (Dataitem)this.dataitem_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</datalist>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.dataitem_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "datalist")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (Dataitem.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Datalist.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Datalist.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

