/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Item
implements Serializable,
Cloneable,
IRNode {
    public static final String TYPE_SUM = "sum";
    public static final String TYPE_AVG = "avg";
    public static final String TYPE_MAX = "max";
    public static final String TYPE_MIN = "min";
    public static final String TYPE_COUNT = "count";
    public static final String TYPE_MULTI = "multi";
    public static final String TYPE_MEDIAN = "median";
    public static final String TYPE_MODE = "mode";
    public static final String TYPE_STDEV = "stdev";
    public static final String TYPE_STDEVP = "stdevp";
    public static final String TYPE_VAR = "var";
    public static final String TYPE_VARP = "varp";
    private String content_;
    private String name_;
    private String beforecontent_;
    private String aftercontent_;
    private String type_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Item() {
    }

    public Item(Item source) {
        this.setup(source);
    }

    public Item(RStack stack) {
        this.setup(stack);
    }

    public Item(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Item(Element element) {
        this.setup(element);
    }

    public Item(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Item(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Item(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Item(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Item(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Item(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Item source) {
        this.setContent(source.getContent());
        this.setName(source.getName());
        this.setBeforecontent(source.getBeforecontent());
        this.setAftercontent(source.getAftercontent());
        this.setType(source.getType());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.beforecontent_ = URelaxer.getAttributePropertyAsString(element, "beforecontent");
        this.aftercontent_ = URelaxer.getAttributePropertyAsString(element, "aftercontent");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createItem(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("item");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.beforecontent_ != null) {
            URelaxer.setAttributePropertyByString(element, "beforecontent", this.beforecontent_);
        }
        if (this.aftercontent_ != null) {
            URelaxer.setAttributePropertyByString(element, "aftercontent", this.aftercontent_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getBeforecontent() {
        return this.beforecontent_;
    }

    public final void setBeforecontent(String beforecontent) {
        this.beforecontent_ = beforecontent;
    }

    public final String getAftercontent() {
        return this.aftercontent_;
    }

    public final void setAftercontent(String aftercontent) {
        this.aftercontent_ = aftercontent;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_SUM;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<item");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.beforecontent_ != null) {
            buffer.append(" beforecontent=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getBeforecontent())));
            buffer.append("\"");
        }
        if (this.aftercontent_ != null) {
            buffer.append(" aftercontent=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAftercontent())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</item>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<item");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.beforecontent_ != null) {
            buffer.write(" beforecontent=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getBeforecontent())));
            buffer.write("\"");
        }
        if (this.aftercontent_ != null) {
            buffer.write(" aftercontent=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAftercontent())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</item>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<item");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.beforecontent_ != null) {
            buffer.print(" beforecontent=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getBeforecontent())));
            buffer.print("\"");
        }
        if (this.aftercontent_ != null) {
            buffer.print(" aftercontent=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAftercontent())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</item>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getBeforecontentAsString() {
        return URelaxer.getString(this.getBeforecontent());
    }

    public String getAftercontentAsString() {
        return URelaxer.getString(this.getAftercontent());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setBeforecontentByString(String string) {
        this.setBeforecontent(string);
    }

    public void setAftercontentByString(String string) {
        this.setAftercontent(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "item")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Item.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Item.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

