/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Mapping
implements Serializable,
Cloneable,
IRNode {
    private String content_;
    private String name_;
    private String type_;
    private String param_;
    private String pattern_;
    private String action_;
    private Boolean releaselock_;
    private Integer pagenum_;
    private Boolean redirect_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Mapping() {
    }

    public Mapping(Mapping source) {
        this.setup(source);
    }

    public Mapping(RStack stack) {
        this.setup(stack);
    }

    public Mapping(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Mapping(Element element) {
        this.setup(element);
    }

    public Mapping(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Mapping(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Mapping(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Mapping(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Mapping(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Mapping(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Mapping source) {
        this.setContent(source.getContent());
        this.setName(source.getName());
        this.setType(source.getType());
        this.setParam(source.getParam());
        this.setPattern(source.getPattern());
        this.setAction(source.getAction());
        this.setReleaselock(source.getReleaselock());
        this.setPagenum(source.getPagenum());
        this.setRedirect(source.getRedirect());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.param_ = URelaxer.getAttributePropertyAsString(element, "param");
        this.pattern_ = URelaxer.getAttributePropertyAsString(element, "pattern");
        this.action_ = URelaxer.getAttributePropertyAsString(element, "action");
        this.releaselock_ = URelaxer.getAttributePropertyAsBooleanObject(element, "releaselock");
        this.pagenum_ = URelaxer.getAttributePropertyAsIntObject(element, "pagenum");
        this.redirect_ = URelaxer.getAttributePropertyAsBooleanObject(element, "redirect");
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createMapping(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("mapping");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.param_ != null) {
            URelaxer.setAttributePropertyByString(element, "param", this.param_);
        }
        if (this.pattern_ != null) {
            URelaxer.setAttributePropertyByString(element, "pattern", this.pattern_);
        }
        if (this.action_ != null) {
            URelaxer.setAttributePropertyByString(element, "action", this.action_);
        }
        if (this.releaselock_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "releaselock", this.releaselock_);
        }
        if (this.pagenum_ != null) {
            URelaxer.setAttributePropertyByInt(element, "pagenum", this.pagenum_);
        }
        if (this.redirect_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "redirect", this.redirect_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getParam() {
        return this.param_;
    }

    public final void setParam(String param) {
        this.param_ = param;
    }

    public final String getPattern() {
        return this.pattern_;
    }

    public final void setPattern(String pattern) {
        this.pattern_ = pattern;
    }

    public final String getAction() {
        return this.action_;
    }

    public final void setAction(String action) {
        this.action_ = action;
    }

    public boolean getReleaselock() {
        if (this.releaselock_ == null) {
            return true;
        }
        return this.releaselock_;
    }

    public boolean getReleaselock(boolean releaselock) {
        if (this.releaselock_ == null) {
            return releaselock;
        }
        return this.releaselock_;
    }

    public Boolean getReleaselockAsBoolean() {
        return this.releaselock_;
    }

    public boolean checkReleaselock() {
        return this.releaselock_ != null;
    }

    public void setReleaselock(boolean releaselock) {
        this.releaselock_ = new Boolean(releaselock);
    }

    public void setReleaselock(Boolean releaselock) {
        this.releaselock_ = releaselock;
    }

    public int getPagenum() {
        if (this.pagenum_ == null) {
            return 0;
        }
        return this.pagenum_;
    }

    public int getPagenum(int pagenum) {
        if (this.pagenum_ == null) {
            return pagenum;
        }
        return this.pagenum_;
    }

    public Integer getPagenumAsInteger() {
        return this.pagenum_;
    }

    public boolean checkPagenum() {
        return this.pagenum_ != null;
    }

    public void setPagenum(int pagenum) {
        this.pagenum_ = new Integer(pagenum);
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum_ = pagenum;
    }

    public boolean getRedirect() {
        if (this.redirect_ == null) {
            return false;
        }
        return this.redirect_;
    }

    public boolean getRedirect(boolean redirect) {
        if (this.redirect_ == null) {
            return redirect;
        }
        return this.redirect_;
    }

    public Boolean getRedirectAsBoolean() {
        return this.redirect_;
    }

    public boolean checkRedirect() {
        return this.redirect_ != null;
    }

    public void setRedirect(boolean redirect) {
        this.redirect_ = new Boolean(redirect);
    }

    public void setRedirect(Boolean redirect) {
        this.redirect_ = redirect;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<mapping");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.param_ != null) {
            buffer.append(" param=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getParam())));
            buffer.append("\"");
        }
        if (this.pattern_ != null) {
            buffer.append(" pattern=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPattern())));
            buffer.append("\"");
        }
        if (this.action_ != null) {
            buffer.append(" action=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.append("\"");
        }
        if (this.releaselock_ != null) {
            buffer.append(" releaselock=\"");
            buffer.append(URelaxer.getString(this.getReleaselock()));
            buffer.append("\"");
        }
        if (this.pagenum_ != null) {
            buffer.append(" pagenum=\"");
            buffer.append(URelaxer.getString(this.getPagenum()));
            buffer.append("\"");
        }
        if (this.redirect_ != null) {
            buffer.append(" redirect=\"");
            buffer.append(URelaxer.getString(this.getRedirect()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</mapping>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<mapping");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.param_ != null) {
            buffer.write(" param=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getParam())));
            buffer.write("\"");
        }
        if (this.pattern_ != null) {
            buffer.write(" pattern=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPattern())));
            buffer.write("\"");
        }
        if (this.action_ != null) {
            buffer.write(" action=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.write("\"");
        }
        if (this.releaselock_ != null) {
            buffer.write(" releaselock=\"");
            buffer.write(URelaxer.getString(this.getReleaselock()));
            buffer.write("\"");
        }
        if (this.pagenum_ != null) {
            buffer.write(" pagenum=\"");
            buffer.write(URelaxer.getString(this.getPagenum()));
            buffer.write("\"");
        }
        if (this.redirect_ != null) {
            buffer.write(" redirect=\"");
            buffer.write(URelaxer.getString(this.getRedirect()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</mapping>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<mapping");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.param_ != null) {
            buffer.print(" param=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getParam())));
            buffer.print("\"");
        }
        if (this.pattern_ != null) {
            buffer.print(" pattern=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPattern())));
            buffer.print("\"");
        }
        if (this.action_ != null) {
            buffer.print(" action=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getAction())));
            buffer.print("\"");
        }
        if (this.releaselock_ != null) {
            buffer.print(" releaselock=\"");
            buffer.print(URelaxer.getString(this.getReleaselock()));
            buffer.print("\"");
        }
        if (this.pagenum_ != null) {
            buffer.print(" pagenum=\"");
            buffer.print(URelaxer.getString(this.getPagenum()));
            buffer.print("\"");
        }
        if (this.redirect_ != null) {
            buffer.print(" redirect=\"");
            buffer.print(URelaxer.getString(this.getRedirect()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</mapping>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getParamAsString() {
        return URelaxer.getString(this.getParam());
    }

    public String getPatternAsString() {
        return URelaxer.getString(this.getPattern());
    }

    public String getActionAsString() {
        return URelaxer.getString(this.getAction());
    }

    public String getReleaselockAsString() {
        return URelaxer.getString(this.getReleaselock());
    }

    public String getPagenumAsString() {
        return URelaxer.getString(this.getPagenum());
    }

    public String getRedirectAsString() {
        return URelaxer.getString(this.getRedirect());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setParamByString(String string) {
        this.setParam(string);
    }

    public void setPatternByString(String string) {
        this.setPattern(string);
    }

    public void setActionByString(String string) {
        this.setAction(string);
    }

    public void setReleaselockByString(String string) {
        this.setReleaselock((boolean)new Boolean(string));
    }

    public void setPagenumByString(String string) {
        this.setPagenum(Integer.parseInt(string));
    }

    public void setRedirectByString(String string) {
        this.setRedirect((boolean)new Boolean(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "mapping")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Mapping.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Mapping.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

