/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IEnvironmentChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Param;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MessageQueue
implements Serializable,
Cloneable,
IRNode,
IEnvironmentChoice {
    public static final String TYPE_RABBITMQ = "RabbitMQ";
    public static final String TYPE_ACTIVEMQ = "ActiveMQ";
    private String type_;
    private String host_;
    private Integer port_;
    private String username_;
    private String password_;
    private String createQueues_;
    private Boolean enableJob_;
    private String listenJobQueues_;
    private Boolean primary_;
    private List param_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public MessageQueue() {
    }

    public MessageQueue(MessageQueue source) {
        this.setup(source);
    }

    public MessageQueue(RStack stack) {
        this.setup(stack);
    }

    public MessageQueue(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public MessageQueue(Element element) {
        this.setup(element);
    }

    public MessageQueue(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public MessageQueue(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public MessageQueue(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public MessageQueue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public MessageQueue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public MessageQueue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(MessageQueue source) {
        this.setType(source.getType());
        this.setHost(source.getHost());
        this.setPort(source.getPort());
        this.setUsername(source.getUsername());
        this.setPassword(source.getPassword());
        this.setCreateQueues(source.getCreateQueues());
        this.setEnableJob(source.getEnableJob());
        this.setListenJobQueues(source.getListenJobQueues());
        this.setPrimary(source.getPrimary());
        this.param_.clear();
        int size = source.param_.size();
        for (int i = 0; i < size; ++i) {
            this.addParam((Param)source.getParam(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.host_ = URelaxer.getAttributePropertyAsString(element, "host");
        this.port_ = URelaxer.getAttributePropertyAsIntObject(element, "port");
        this.username_ = URelaxer.getAttributePropertyAsString(element, "username");
        this.password_ = URelaxer.getAttributePropertyAsString(element, "password");
        this.createQueues_ = URelaxer.getAttributePropertyAsString(element, "createQueues");
        this.enableJob_ = URelaxer.getAttributePropertyAsBooleanObject(element, "enableJob");
        this.listenJobQueues_ = URelaxer.getAttributePropertyAsString(element, "listenJobQueues");
        this.primary_ = URelaxer.getAttributePropertyAsBooleanObject(element, "primary");
        this.param_.clear();
        while (Param.isMatch(stack)) {
            this.addParam(factory.createParam(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createMessageQueue(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("messageQueue");
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.host_ != null) {
            URelaxer.setAttributePropertyByString(element, "host", this.host_);
        }
        if (this.port_ != null) {
            URelaxer.setAttributePropertyByInt(element, "port", this.port_);
        }
        if (this.username_ != null) {
            URelaxer.setAttributePropertyByString(element, "username", this.username_);
        }
        if (this.password_ != null) {
            URelaxer.setAttributePropertyByString(element, "password", this.password_);
        }
        if (this.createQueues_ != null) {
            URelaxer.setAttributePropertyByString(element, "createQueues", this.createQueues_);
        }
        if (this.enableJob_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "enableJob", this.enableJob_);
        }
        if (this.listenJobQueues_ != null) {
            URelaxer.setAttributePropertyByString(element, "listenJobQueues", this.listenJobQueues_);
        }
        if (this.primary_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "primary", this.primary_);
        }
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_RABBITMQ;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getHost() {
        return this.host_;
    }

    public final void setHost(String host) {
        this.host_ = host;
    }

    public int getPort() {
        if (this.port_ == null) {
            return -1;
        }
        return this.port_;
    }

    public int getPort(int port) {
        if (this.port_ == null) {
            return port;
        }
        return this.port_;
    }

    public Integer getPortAsInteger() {
        return this.port_;
    }

    public boolean checkPort() {
        return this.port_ != null;
    }

    public void setPort(int port) {
        this.port_ = new Integer(port);
    }

    public void setPort(Integer port) {
        this.port_ = port;
    }

    public final String getUsername() {
        return this.username_;
    }

    public final void setUsername(String username) {
        this.username_ = username;
    }

    public final String getPassword() {
        return this.password_;
    }

    public final void setPassword(String password) {
        this.password_ = password;
    }

    public final String getCreateQueues() {
        return this.createQueues_;
    }

    public final void setCreateQueues(String createQueues) {
        this.createQueues_ = createQueues;
    }

    public boolean getEnableJob() {
        if (this.enableJob_ == null) {
            return false;
        }
        return this.enableJob_;
    }

    public boolean getEnableJob(boolean enableJob) {
        if (this.enableJob_ == null) {
            return enableJob;
        }
        return this.enableJob_;
    }

    public Boolean getEnableJobAsBoolean() {
        return this.enableJob_;
    }

    public boolean checkEnableJob() {
        return this.enableJob_ != null;
    }

    public void setEnableJob(boolean enableJob) {
        this.enableJob_ = new Boolean(enableJob);
    }

    public void setEnableJob(Boolean enableJob) {
        this.enableJob_ = enableJob;
    }

    public final String getListenJobQueues() {
        return this.listenJobQueues_;
    }

    public final void setListenJobQueues(String listenJobQueues) {
        this.listenJobQueues_ = listenJobQueues;
    }

    public boolean getPrimary() {
        if (this.primary_ == null) {
            return false;
        }
        return this.primary_;
    }

    public boolean getPrimary(boolean primary) {
        if (this.primary_ == null) {
            return primary;
        }
        return this.primary_;
    }

    public Boolean getPrimaryAsBoolean() {
        return this.primary_;
    }

    public boolean checkPrimary() {
        return this.primary_ != null;
    }

    public void setPrimary(boolean primary) {
        this.primary_ = new Boolean(primary);
    }

    public void setPrimary(Boolean primary) {
        this.primary_ = primary;
    }

    public final Param[] getParam() {
        Param[] array = new Param[this.param_.size()];
        return this.param_.toArray(array);
    }

    public final void setParam(Param[] param) {
        int i;
        this.param_.clear();
        if (param != null) {
            for (i = 0; i < param.length; ++i) {
                this.addParam(param[i]);
            }
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetParentRNode(this);
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setParam(Param param) {
        this.param_.clear();
        this.addParam(param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
        if (param != null) {
            param.rSetRContext(this.rGetRContext());
        }
    }

    public final void addParam(Param param) {
        this.param_.add(param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
        if (param != null) {
            param.rSetRContext(this.rGetRContext());
        }
    }

    public final void addParam(Param[] param) {
        int i;
        for (i = 0; i < param.length; ++i) {
            this.addParam(param[i]);
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetParentRNode(this);
        }
        for (i = 0; i < param.length; ++i) {
            param[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeParam() {
        return this.param_.size();
    }

    public final Param getParam(int index) {
        return (Param)this.param_.get(index);
    }

    public final void setParam(int index, Param param) {
        this.param_.set(index, param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
    }

    public final void addParam(int index, Param param) {
        this.param_.add(index, param);
        if (param != null) {
            param.rSetParentRNode(this);
        }
    }

    public final void removeParam(int index) {
        this.param_.remove(index);
    }

    public final void removeParam(Param param) {
        this.param_.remove(param);
    }

    public final void clearParam() {
        this.param_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<messageQueue");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.host_ != null) {
            buffer.append(" host=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHost())));
            buffer.append("\"");
        }
        if (this.port_ != null) {
            buffer.append(" port=\"");
            buffer.append(URelaxer.getString(this.getPort()));
            buffer.append("\"");
        }
        if (this.username_ != null) {
            buffer.append(" username=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUsername())));
            buffer.append("\"");
        }
        if (this.password_ != null) {
            buffer.append(" password=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPassword())));
            buffer.append("\"");
        }
        if (this.createQueues_ != null) {
            buffer.append(" createQueues=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateQueues())));
            buffer.append("\"");
        }
        if (this.enableJob_ != null) {
            buffer.append(" enableJob=\"");
            buffer.append(URelaxer.getString(this.getEnableJob()));
            buffer.append("\"");
        }
        if (this.listenJobQueues_ != null) {
            buffer.append(" listenJobQueues=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getListenJobQueues())));
            buffer.append("\"");
        }
        if (this.primary_ != null) {
            buffer.append(" primary=\"");
            buffer.append(URelaxer.getString(this.getPrimary()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</messageQueue>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<messageQueue");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.host_ != null) {
            buffer.write(" host=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHost())));
            buffer.write("\"");
        }
        if (this.port_ != null) {
            buffer.write(" port=\"");
            buffer.write(URelaxer.getString(this.getPort()));
            buffer.write("\"");
        }
        if (this.username_ != null) {
            buffer.write(" username=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUsername())));
            buffer.write("\"");
        }
        if (this.password_ != null) {
            buffer.write(" password=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPassword())));
            buffer.write("\"");
        }
        if (this.createQueues_ != null) {
            buffer.write(" createQueues=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateQueues())));
            buffer.write("\"");
        }
        if (this.enableJob_ != null) {
            buffer.write(" enableJob=\"");
            buffer.write(URelaxer.getString(this.getEnableJob()));
            buffer.write("\"");
        }
        if (this.listenJobQueues_ != null) {
            buffer.write(" listenJobQueues=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getListenJobQueues())));
            buffer.write("\"");
        }
        if (this.primary_ != null) {
            buffer.write(" primary=\"");
            buffer.write(URelaxer.getString(this.getPrimary()));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</messageQueue>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<messageQueue");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.host_ != null) {
            buffer.print(" host=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getHost())));
            buffer.print("\"");
        }
        if (this.port_ != null) {
            buffer.print(" port=\"");
            buffer.print(URelaxer.getString(this.getPort()));
            buffer.print("\"");
        }
        if (this.username_ != null) {
            buffer.print(" username=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getUsername())));
            buffer.print("\"");
        }
        if (this.password_ != null) {
            buffer.print(" password=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPassword())));
            buffer.print("\"");
        }
        if (this.createQueues_ != null) {
            buffer.print(" createQueues=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCreateQueues())));
            buffer.print("\"");
        }
        if (this.enableJob_ != null) {
            buffer.print(" enableJob=\"");
            buffer.print(URelaxer.getString(this.getEnableJob()));
            buffer.print("\"");
        }
        if (this.listenJobQueues_ != null) {
            buffer.print(" listenJobQueues=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getListenJobQueues())));
            buffer.print("\"");
        }
        if (this.primary_ != null) {
            buffer.print(" primary=\"");
            buffer.print(URelaxer.getString(this.getPrimary()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.param_.size();
        for (int i = 0; i < size; ++i) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</messageQueue>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getHostAsString() {
        return URelaxer.getString(this.getHost());
    }

    public String getPortAsString() {
        return URelaxer.getString(this.getPort());
    }

    public String getUsernameAsString() {
        return URelaxer.getString(this.getUsername());
    }

    public String getPasswordAsString() {
        return URelaxer.getString(this.getPassword());
    }

    public String getCreateQueuesAsString() {
        return URelaxer.getString(this.getCreateQueues());
    }

    public String getEnableJobAsString() {
        return URelaxer.getString(this.getEnableJob());
    }

    public String getListenJobQueuesAsString() {
        return URelaxer.getString(this.getListenJobQueues());
    }

    public String getPrimaryAsString() {
        return URelaxer.getString(this.getPrimary());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setHostByString(String string) {
        this.setHost(string);
    }

    public void setPortByString(String string) {
        this.setPort(Integer.parseInt(string));
    }

    public void setUsernameByString(String string) {
        this.setUsername(string);
    }

    public void setPasswordByString(String string) {
        this.setPassword(string);
    }

    public void setCreateQueuesByString(String string) {
        this.setCreateQueues(string);
    }

    public void setEnableJobByString(String string) {
        this.setEnableJob((boolean)new Boolean(string));
    }

    public void setListenJobQueuesByString(String string) {
        this.setListenJobQueues(string);
    }

    public void setPrimaryByString(String string) {
        this.setPrimary((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.param_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "messageQueue")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (Param.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return MessageQueue.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (MessageQueue.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

