/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model;

import java.io.File;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang.StringUtils;

public abstract class ModelGeneratorBase
extends JavaSourceGenerator {
    public static final String SUB_PACKAGE_NAME = "model";
    protected Model model;
    protected final String templateDir = "template/javasrc/model/";

    public ModelGeneratorBase(Project project, Model model) {
        super(project);
        this.model = model;
    }

    protected String createPackageName(String separator) {
        return SUB_PACKAGE_NAME + separator + this.model.getId();
    }

    public String getPackageNameAsJavaRule() {
        if (this.model != null && StringUtils.isNotBlank((String)this.model.getPackage())) {
            return this.model.getPackage();
        }
        return this.project.getPackage() + "." + this.getSubpackageNameAsJavaRule();
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public String getModelPackageName() {
        return this.model.getPackage();
    }

    @Override
    public String getSubpackageName() {
        return this.createPackageName(File.separator);
    }

    @Override
    public String getSubpackageNameAsJavaRule() {
        return this.createPackageName(".");
    }

    protected String getTemplateFilePath() {
        return "template/javasrc/model/" + this.getTemplateFile();
    }

    @Override
    public String getClassname() {
        return AppSchemaUtil.getClassname(this.model);
    }

    public String getElementName() {
        return this.model.getId();
    }

    protected abstract String getTemplateFile();
}

