/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model;

import jp.jasminesoft.jfc.gen.IGeneratorFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.model.AbstractModelGenerator;
import jp.jasminesoft.jfc.gen.model.list.ListModelGenerator;
import jp.jasminesoft.jfc.gen.model.presentation.PresentationListModelGenerator;
import jp.jasminesoft.jfc.gen.model.presentation.PresentationModelGenerator;
import jp.jasminesoft.jfc.gen.model.store.StoreModelGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelGeneratorFactory
implements IGeneratorFactory {
    protected static Logger logger = LogManager.getLogger((String)ModelGeneratorFactory.class.getName());

    public static AbstractModelGenerator create(Project project, Model model) {
        AbstractModelGenerator mgen = null;
        if (project == null || model == null) {
            return mgen;
        }
        if (!model.getUseRelax()) {
            return mgen;
        }
        if (!model.getNoUseRelaxer()) {
            return mgen;
        }
        if ("presentation".equals(model.getType())) {
            IRNode node = model.getIdrefAsIRNode();
            if (!(node instanceof Model)) {
                return mgen;
            }
            Model refmodel = (Model)node;
            if ("store".equals(refmodel.getType()) || "condition".equals(refmodel.getType())) {
                mgen = new PresentationModelGenerator(project, model, refmodel);
            } else if ("list".equals(refmodel.getType()) || "total".equals(refmodel.getType())) {
                Model smodel = (Model)refmodel.getIdrefAsIRNode();
                mgen = new PresentationListModelGenerator(project, model, smodel);
            } else {
                logger.error("unknown model type.");
            }
        } else if ("list".equals(model.getType()) || "total".equals(model.getType())) {
            mgen = new ListModelGenerator(project, model);
        } else if ("store".equals(model.getType()) || "condition".equals(model.getType())) {
            mgen = new StoreModelGenerator(project, model);
        } else if (!"reserved".equals(model.getType())) {
            logger.warn("no generate model. model/@type : " + model.getType());
        }
        return mgen;
    }
}

