/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.model.AbstractModelGenerator;
import jp.jasminesoft.jfc.gen.model.AttributeContent;
import jp.jasminesoft.jfc.gen.model.presentation.ModelitemContent_list;
import jp.jasminesoft.jfc.gen.model.presentation.ModelitemContent_presen;
import jp.jasminesoft.jfc.gen.model.presentation.modelitem.PresentationModelitemContainerGenerator;
import jp.jasminesoft.jfc.gen.model.presentation.modelitem.PresentationModelitemGenerator;
import jp.jasminesoft.jfc.gen.model.presentation.modelitem.PresentationModelitemGeneratorFactory;
import jp.jasminesoft.jfc.gen.model.presentation.modelitem.PresentationModelitemGenerator_total;
import jp.jasminesoft.jfc.gen.model.presentation.modelitem.PresentationModelitemGenerator_zipcode;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresentationModelGenerator
extends AbstractModelGenerator {
    protected Model smodel;
    protected Logger logger = LogManager.getLogger((String)PresentationModelGenerator.class.getName());
    public static final String ZIPCODE_SUFFIX = "_jshzipcode";

    public PresentationModelGenerator(Project project, Model model, Model smodel) {
        super(project, model);
        this.smodel = smodel;
        this.addSortableAttributeContent();
    }

    protected void addSortableAttributeContent() {
        if (this.isSortable() && !this.isContainer()) {
            AttributeContent attributeContent = new AttributeContent();
            attributeContent.setName("sortable");
            attributeContent.setDataType("string");
            this.addAttributeContent(attributeContent);
            attributeContent = new AttributeContent();
            attributeContent.setName("sort");
            attributeContent.setDataType("string");
            this.addAttributeContent(attributeContent);
            attributeContent = new AttributeContent();
            attributeContent.setName("order");
            attributeContent.setDataType("string");
            attributeContent.addChoiceValue("normal");
            attributeContent.addChoiceValue("reverse");
            this.addAttributeContent(attributeContent);
        }
    }

    protected void generateModelitem() {
        Map<String, Object> map = AppSchemaUtil.devideMapByContainerName(this.smodel);
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof Modelitem) {
                Modelitem pmitem;
                Modelitem smitem = (Modelitem)obj;
                if (!smitem.getExistCheck() && !this.isLpModel() || AppSchemaUtil.isGenerationModelitem(smitem.getName(), this.smodel) || (pmitem = AppSchemaUtil.getModelitem(smitem.getName(), this.model)) == null) continue;
                List<PresentationModelitemGenerator> list = PresentationModelitemGeneratorFactory.create(this.project, this.model, pmitem, smitem, this.smodel, this.isLpModel());
                if (list.size() == 0 && this.isLpModel()) {
                    this.addModelitemContent(new ModelitemContent_list(this.project, smitem).setNoAttribute(true));
                }
                for (PresentationModelitemGenerator gen : list) {
                    gen.process();
                    Modelitem tmp_smitem = smitem;
                    if (gen instanceof PresentationModelitemGenerator_zipcode) {
                        if (this.isLpModel()) {
                            this.addModelitemContent(new ModelitemContent_list(smitem).setNoAttribute(true));
                        }
                        try {
                            tmp_smitem = new Modelitem(smitem.makeDocument());
                        }
                        catch (ParserConfigurationException e) {
                            this.logger.warn(e.getMessage());
                            this.logger.debug((Object)e);
                            tmp_smitem = (Modelitem)smitem.clone();
                        }
                        tmp_smitem.setName(smitem.getName() + ZIPCODE_SUFFIX);
                        tmp_smitem.setMultiple(true);
                    } else if (gen instanceof PresentationModelitemGenerator_total && !JavaSourceGenerator.isBasicType(smitem.getType())) {
                        try {
                            tmp_smitem = new Modelitem(smitem.makeDocument());
                        }
                        catch (ParserConfigurationException e) {
                            this.logger.warn(e.getMessage());
                            this.logger.debug((Object)e);
                            tmp_smitem = (Modelitem)smitem.clone();
                        }
                        tmp_smitem.setMultiple(true);
                    }
                    Modelitem c_smitem = tmp_smitem;
                    if ("storeref".equals(smitem.getType()) && !tmp_smitem.getMultiple() && AppSchemaUtil.isMultiple(this.project, smitem)) {
                        try {
                            c_smitem = new Modelitem(smitem.makeDocument());
                        }
                        catch (ParserConfigurationException e) {
                            this.logger.warn(e.getMessage());
                            this.logger.debug((Object)e);
                            c_smitem = (Modelitem)smitem.clone();
                        }
                        c_smitem.setMultiple(true);
                    }
                    if (this.isLpModel()) {
                        this.addModelitemContent(new ModelitemContent_list(this.project, c_smitem));
                        continue;
                    }
                    this.addModelitemContent(new ModelitemContent_presen(this.project, c_smitem));
                }
                continue;
            }
            if (obj instanceof Set) {
                PresentationModelitemContainerGenerator pmcgen = new PresentationModelitemContainerGenerator(this.project, this.model, key, (Set)obj, this.smodel, this.isLpModel());
                pmcgen.process();
                Modelitem smitem = AppSchemaUtil.getModelitem(key, this.smodel);
                if (pmcgen.getModelitemContentList().size() <= 0) continue;
                this.addModelitemContent(new ModelitemContent_presen(smitem));
                continue;
            }
            this.logger.error("return unexpected Object. : " + obj);
        }
        if (this.isValidNolselection() && this.getModelitemContentList().size() > 0) {
            Modelitem noselection_mitem = new Modelitem();
            noselection_mitem.setName("noselection_jshparam");
            noselection_mitem.setMultiple(true);
            this.addModelitemContent(new ModelitemContent_presen(noselection_mitem).setNoAttribute(true));
        }
    }

    protected boolean isLpModel() {
        return false;
    }

    @Override
    public String process0() {
        Modelitem passwdNow = null;
        Modelitem passwd2 = null;
        int insertPoint = -1;
        if (this.smodel.getId().equals("juser") || "juser".equals(this.smodel.getMainmodelidref())) {
            IModelChoice[] imcs = this.smodel.getContent();
            for (int i = 0; i < imcs.length; ++i) {
                Modelitem mitem;
                IModelChoice imc = imcs[i];
                if (!(imc instanceof Modelitem) || !(mitem = (Modelitem)imc).getName().equals("passwd")) continue;
                insertPoint = i;
                break;
            }
            if (insertPoint > 0) {
                passwd2 = new Modelitem();
                passwd2.setName("passwd2");
                passwd2.setType("string");
                this.smodel.addContent(insertPoint - 1, passwd2);
                passwdNow = new Modelitem();
                passwdNow.setName("passwdNow");
                passwdNow.setType("string");
                this.smodel.addContent(insertPoint - 1, passwdNow);
            }
            AppSchemaUtil.setCacheProcess(false);
        }
        this.generateModelitem();
        String ret = null;
        if (this.isGenerateThisClass()) {
            ret = super.process0();
        }
        ArrayList<Modelitem> removeContentList = null;
        for (IModelChoice imc : this.model.getContent()) {
            Modelitem _mitem;
            String limitedSrcgen;
            if (!(imc instanceof Modelitem) || !StringUtils.isNotBlank((String)(limitedSrcgen = (_mitem = (Modelitem)imc).getSrcgen())) || !"model".equals(limitedSrcgen)) continue;
            if (removeContentList == null) {
                removeContentList = new ArrayList<Modelitem>();
            }
            removeContentList.add(_mitem);
        }
        if (removeContentList != null) {
            for (Modelitem rmitem : removeContentList) {
                this.model.removeContent(rmitem);
            }
        }
        if (this.smodel.getId().equals("juser") || "juser".equals(this.smodel.getMainmodelidref()) && insertPoint > 0) {
            this.smodel.removeContent(passwdNow);
            this.smodel.removeContent(passwd2);
            AppSchemaUtil.setCacheProcess(true);
        }
        return ret;
    }

    protected boolean isGenerateThisClass() {
        return true;
    }

    @Override
    protected boolean isValidNolselection() {
        return "condition".equals(this.smodel.getType());
    }

    @Override
    protected boolean isPathlist() {
        return true;
    }

    @Override
    protected String appendCodes() {
        String mid = this.smodel.getMainmodelidref();
        if (StringUtils.isBlank((String)mid)) {
            mid = this.smodel.getId();
        }
        if (!(!"juser".equals(mid) || AppSchemaUtil.getModelitem("jprincipalId", this.smodel) == null || this.isContainer() || this.getClassname().endsWith("Lp") || this.getClassname().endsWith("Ulp") || this.getClassname().endsWith("Cp") || this.getClassname().equals("Item"))) {
            String templateFilePath = "template/javasrc/model/juser_p/getJprincipalIdArray.vm";
            HashMap map = new HashMap();
            return VelocityUtils.mergeContent((String)templateFilePath, map);
        }
        return "";
    }
}

