/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model.store;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.appgen.model.store.CompositeKeyGenerator;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.RelaxSchemaTotalGeneratorUtil;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.jfc.gen.model.AbstractModelGenerator;
import jp.jasminesoft.jfc.gen.model.AbstractModelitemContent;
import jp.jasminesoft.jfc.gen.model.AttributeContent;
import jp.jasminesoft.jfc.gen.model.presentation.ModelitemContent_presen;
import jp.jasminesoft.jfc.gen.model.store.ModelitemContent_store;
import jp.jasminesoft.jfc.gen.model.store.modelitem.StoreModelitemCheckbox4CompositeKeyGenerator;
import jp.jasminesoft.jfc.gen.model.store.modelitem.StoreModelitemContainerGenerator;
import jp.jasminesoft.jfc.gen.model.total.modelitem.TotalModelitemGenerator_storeref;
import org.apache.commons.lang.StringUtils;

public class StoreModelGenerator
extends AbstractModelGenerator {
    protected Model smodel;

    public StoreModelGenerator(Project project, Model model) {
        super(project, model);
        this.smodel = model;
    }

    protected void generateModelitem() {
        Map<String, Object> map = AppSchemaUtil.devideMapByContainerName(this.model);
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof Modelitem) {
                Modelitem mitem = (Modelitem)obj;
                if (AppSchemaUtil.isGenerationModelitem(mitem.getName(), this.model)) continue;
                this.generateModelitem(mitem);
                continue;
            }
            if (obj instanceof Set) {
                this.generateModelitem(key, (Set)obj);
                continue;
            }
            this.logger.error("return unexpected Object. : " + obj);
        }
        if (this.isValidNolselection() && this.getModelitemContentList().size() > 0) {
            Modelitem noselection_mitem = new Modelitem();
            noselection_mitem.setName("noselection_jshparam");
            noselection_mitem.setMultiple(true);
            this.addModelitemContent(new ModelitemContent_presen(noselection_mitem).setNoAttribute(true));
        }
    }

    protected void generateModelitem(Modelitem smitem) {
        PrimaryKey[] r_pkeys;
        Model rmodel;
        Relation relation;
        if (!smitem.getUseRelax()) {
            return;
        }
        if (smitem.getGeneration()) {
            return;
        }
        Modelitem original_smitem = smitem;
        AbstractModelitemContent mitem_content = null;
        if (this.isListModel()) {
            if ((smitem = AppSchemaUtil.getModelitem(smitem.getName(), this.smodel)) == null) {
                return;
            }
            if ("total".equals(this.model.getType()) && this.isMajor(smitem)) {
                if (AppSchemaUtil.isMasterref(this.project, this.smodel.getId(), smitem)) {
                    mitem_content = new ModelitemContent_presen(this.project, smitem);
                    ArrayList<AttributeContent> attributes = new ArrayList<AttributeContent>();
                    AttributeContent attributeContent = new AttributeContent();
                    attributeContent.setName("id");
                    attributeContent.setDataType(AppSchemaUtil.getModelitemType(this.project, this.smodel.getId(), smitem, "roleid"));
                    attributes.add(attributeContent);
                    TotalModelitemGenerator_storeref tmigen = new TotalModelitemGenerator_storeref(this.project, this.model, original_smitem, attributes);
                    tmigen.process();
                } else if (AppSchemaUtil.isStoreref(this.project, this.smodel.getId(), smitem)) {
                    relation = AppSchemaUtil.getRelation(smitem);
                    rmodel = (Model)relation.getIdrefAsIRNode();
                    r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
                    if (r_pkeys != null) {
                        TotalModelitemGenerator_storeref tmigen;
                        ArrayList<AttributeContent> attributes;
                        if (r_pkeys.length == 1) {
                            mitem_content = new ModelitemContent_presen(this.project, smitem);
                            attributes = new ArrayList<AttributeContent>();
                            AttributeContent attributeContent = new AttributeContent();
                            attributeContent.setName("id");
                            attributeContent.setDataType(AppSchemaUtil.getModelitemType(this.project, this.smodel.getId(), smitem, "roleid"));
                            attributes.add(attributeContent);
                            tmigen = new TotalModelitemGenerator_storeref(this.project, this.model, original_smitem, attributes);
                            tmigen.process();
                        } else {
                            mitem_content = new ModelitemContent_presen(this.project, smitem);
                            attributes = new ArrayList();
                            int size = r_pkeys.length;
                            for (int i = 0; i < size; ++i) {
                                Modelitem c_smitem = null;
                                try {
                                    c_smitem = new Modelitem(smitem.makeDocument());
                                }
                                catch (ParserConfigurationException e) {
                                    this.logger.warn(e.getMessage());
                                    this.logger.debug((Object)e);
                                    c_smitem = (Modelitem)smitem.clone();
                                }
                                c_smitem.setName(c_smitem.getName() + "_" + r_pkeys[i].getName());
                                AttributeContent attributeContent = new AttributeContent();
                                attributeContent.setName(c_smitem.getName());
                                attributeContent.setDataType(r_pkeys[i].getType());
                                attributes.add(attributeContent);
                            }
                            tmigen = new TotalModelitemGenerator_storeref(this.project, this.model, original_smitem, attributes);
                            tmigen.process();
                        }
                    }
                } else {
                    smitem = JavaSourceGenerator.isBasicType(smitem.getType()) ? this.changeDataTypeForTotalView(smitem) : this.changeMultipleForTotalView(smitem);
                }
            }
        }
        if (mitem_content == null) {
            Model _rmodel;
            relation = AppSchemaUtil.getRelationTypeExceptRef(smitem);
            if (relation == null && !smitem.getTransient() && (relation = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.model, smitem)) != null && !(_rmodel = (Model)relation.getIdrefAsIRNode()).getType().equals("store")) {
                relation = null;
            }
            if (relation == null || "masterref".equals(smitem.getType())) {
                Model rmodel2;
                PrimaryKey[] r_pkeys2;
                Relation __rel_rmitem;
                boolean isOutputModelitem = false;
                relation = AppSchemaUtil.getRelationTypeIsRef(smitem);
                if (relation != null && (__rel_rmitem = AppSchemaUtil.getRelatedRelationInCaseofTypeRef(this.smodel, smitem)) != null && (r_pkeys2 = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel2 = (Model)__rel_rmitem.getIdrefAsIRNode(), this.project)) != null && r_pkeys2.length > 1) {
                    int size = r_pkeys2.length;
                    for (int i = 0; i < size; ++i) {
                        Modelitem c_smitem = null;
                        try {
                            c_smitem = new Modelitem(smitem.makeDocument());
                        }
                        catch (ParserConfigurationException e) {
                            this.logger.warn(e.getMessage());
                            this.logger.debug((Object)e);
                            c_smitem = (Modelitem)smitem.clone();
                        }
                        c_smitem.setName(c_smitem.getName() + "_" + r_pkeys2[i].getName());
                        mitem_content = new ModelitemContent_store(this.project, c_smitem, smitem, i, this.smodel);
                        this.addModelitemContent(mitem_content);
                        isOutputModelitem = true;
                    }
                }
                if (!isOutputModelitem) {
                    Modelitem c_smitem = smitem;
                    if (AppSchemaUtil.isMultiple(this.project, smitem)) {
                        try {
                            c_smitem = new Modelitem(smitem.makeDocument());
                        }
                        catch (ParserConfigurationException e) {
                            this.logger.warn(e.getMessage());
                            this.logger.debug((Object)e);
                            c_smitem = (Modelitem)smitem.clone();
                        }
                        c_smitem.setMultiple(true);
                    }
                    mitem_content = new ModelitemContent_store(this.project, c_smitem, this.smodel);
                    this.addModelitemContent(mitem_content);
                }
            } else if (relation != null && relation.getRoleid() != null && relation.getRolecontent() != null && relation.getRoleid().equals(relation.getRolecontent())) {
                mitem_content = new ModelitemContent_store(this.project, smitem, this.smodel);
                this.addModelitemContent(mitem_content);
            } else if (!smitem.getExistCheck()) {
                mitem_content = new ModelitemContent_store(this.project, smitem, this.smodel);
                mitem_content.setNoAttribute(false);
                this.addModelitemContent(mitem_content);
            } else {
                rmodel = (Model)relation.getIdrefAsIRNode();
                r_pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
                if (r_pkeys != null) {
                    if (r_pkeys.length == 1) {
                        mitem_content = new ModelitemContent_store(this.project, smitem, this.smodel);
                        this.addModelitemContent(mitem_content);
                    } else if ("check".equals(relation.getType())) {
                        StoreModelitemCheckbox4CompositeKeyGenerator smcgen = new StoreModelitemCheckbox4CompositeKeyGenerator(this.project, this.model, rmodel, smitem, r_pkeys);
                        smcgen.process();
                        mitem_content = new ModelitemContent_store(this.project, smitem, this.smodel);
                        mitem_content.setNoAttribute(false);
                        this.addModelitemContent(mitem_content);
                    } else {
                        int size = r_pkeys.length;
                        for (int i = 0; i < size; ++i) {
                            Modelitem c_smitem = null;
                            try {
                                c_smitem = new Modelitem(smitem.makeDocument());
                            }
                            catch (ParserConfigurationException e) {
                                this.logger.warn(e.getMessage());
                                this.logger.debug((Object)e);
                                c_smitem = (Modelitem)smitem.clone();
                            }
                            c_smitem.setName(c_smitem.getName() + "_" + r_pkeys[i].getName());
                            mitem_content = new ModelitemContent_store(this.project, c_smitem, smitem, i, this.smodel);
                            this.addModelitemContent(mitem_content);
                        }
                    }
                } else {
                    mitem_content = new ModelitemContent_store(this.project, smitem, this.smodel);
                    this.addModelitemContent(mitem_content);
                }
            }
        } else {
            this.addModelitemContent(mitem_content);
        }
    }

    protected void generateModelitem(String containerName, Set<Modelitem> itemSet) {
        StoreModelitemContainerGenerator smcgen = new StoreModelitemContainerGenerator(this.project, this.model, containerName, itemSet);
        smcgen.process();
        if (smcgen.getModelitemContentList().size() == 0) {
            return;
        }
        Modelitem smitem = AppSchemaUtil.getModelitem(containerName, this.smodel);
        this.addModelitemContent(new ModelitemContent_presen(smitem));
    }

    private Modelitem changeDataTypeForTotalView(Modelitem smitem) {
        if (smitem == null) {
            return smitem;
        }
        String new_type = null;
        if ("byte".equals(smitem.getType()) || "short".equals(smitem.getType()) || "int".equals(smitem.getType())) {
            new_type = "long";
        } else if ("float".equals(smitem.getType())) {
            new_type = "double";
        }
        if (StringUtils.isNotBlank((String)new_type)) {
            try {
                smitem = new Modelitem(smitem.makeDocument());
            }
            catch (ParserConfigurationException e) {
                this.logger.warn(e.getMessage());
                this.logger.debug((Object)e);
                smitem = (Modelitem)smitem.clone();
            }
            smitem.setType(new_type);
        }
        return smitem;
    }

    private Modelitem changeMultipleForTotalView(Modelitem smitem) {
        if (smitem == null) {
            return smitem;
        }
        try {
            smitem = new Modelitem(smitem.makeDocument());
        }
        catch (ParserConfigurationException e) {
            this.logger.warn(e.getMessage());
            this.logger.debug((Object)e);
            smitem = (Modelitem)smitem.clone();
        }
        smitem.setMultiple(true);
        return smitem;
    }

    private boolean isMajor(Modelitem smitem) {
        Item[] items;
        View view = RelaxSchemaTotalGeneratorUtil.getTotalView(this.project, this.model);
        if (view == null || smitem == null) {
            return false;
        }
        Item[] itemArray = items = view != null ? view.getItem() : null;
        if (items == null || items.length == 0) {
            return false;
        }
        for (Item item : items) {
            if (!"major".equals(item.getName()) || !smitem.getName().equals(item.getContent())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String process0() {
        this.generateModelitem();
        String ret = null;
        if (this.isGenerateThisClass()) {
            ret = super.process0();
        }
        ArrayList<Modelitem> removeContentList = null;
        for (IModelChoice imc : this.model.getContent()) {
            Modelitem _mitem;
            String limitedSrcgen;
            if (!(imc instanceof Modelitem) || !StringUtils.isNotBlank((String)(limitedSrcgen = (_mitem = (Modelitem)imc).getSrcgen())) || !"model".equals(limitedSrcgen)) continue;
            if (removeContentList == null) {
                removeContentList = new ArrayList<Modelitem>();
            }
            removeContentList.add(_mitem);
        }
        if (removeContentList != null) {
            for (Modelitem rmitem : removeContentList) {
                this.model.removeContent(rmitem);
            }
        }
        return ret;
    }

    protected boolean isGenerateThisClass() {
        return true;
    }

    @Override
    protected boolean isValidNolselection() {
        return "condition".equals(this.model.getType());
    }

    protected boolean isListModel() {
        return "list".equals(this.model.getType()) || "total".equals(this.model.getType());
    }

    @Override
    protected String appendCodes() {
        return this.generateCompositeKey();
    }

    protected String generateCompositeKey() {
        if (!"store".equals(this.model.getType())) {
            return "";
        }
        return new CompositeKeyGenerator(this.project, this.model).process0();
    }
}

