/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.sourcefilemanager;

import java.io.File;
import java.io.Serializable;

public class GeneratedData
implements Serializable {
    static final String SEPARATOR = ",";
    private State _state = State.NONE;
    private boolean _isChecked = false;
    private String _fileName = null;
    private long _date;
    private int _hashCode;

    public GeneratedData() {
    }

    public GeneratedData(State state) {
        this();
        this.setState(state);
    }

    public GeneratedData(State state, boolean isChecked) {
        this(state);
        this.setIsChecked(isChecked);
    }

    public GeneratedData(State state, boolean isChecked, String fileName) {
        this(state, isChecked);
        this.setFullFileName(fileName);
    }

    public GeneratedData(State state, boolean isChecked, String fileName, long date) {
        this(state, isChecked, fileName);
        this.setDate(date);
    }

    public GeneratedData(State state, boolean isChecked, String fileName, long date, int hashCode) {
        this(state, isChecked, fileName, date);
        this.setHashCode(hashCode);
    }

    public void setState(State state) {
        this._state = state;
    }

    public void setIsChecked(boolean isChecked) {
        this._isChecked = isChecked;
    }

    public void setFullFileName(String fileName) {
        this._fileName = fileName;
    }

    public void setDate(long date) {
        this._date = date;
    }

    public void setHashCode(int hashCode) {
        this._hashCode = hashCode;
    }

    public State getState() {
        return this._state;
    }

    public boolean isStateKeep() {
        return this.getState() == State.NONE;
    }

    public boolean isStateInsert() {
        return this.getState() == State.INSERT;
    }

    public boolean isStateUpdate() {
        return this.getState() == State.UPDATE;
    }

    public boolean isStateDelete() {
        return this.getState() == State.DELETE;
    }

    public static String convertStateString(State state) {
        return state.toString();
    }

    public static State convertStateInt(String state) {
        if (State.INSERT.toString().equals(state)) {
            return State.INSERT;
        }
        if (State.UPDATE.toString().equals(state)) {
            return State.UPDATE;
        }
        if (State.DELETE.toString().equals(state)) {
            return State.DELETE;
        }
        return State.NONE;
    }

    public boolean isChecked() {
        return this._isChecked;
    }

    public String getFullFileName() {
        if (this._fileName != null) {
            return this._fileName;
        }
        return "";
    }

    public String getPackageName() {
        int index = this.getFullFileName().lastIndexOf(File.separator);
        return this.getFullFileName().substring(0, index);
    }

    public String getFileName() {
        int index = this.getFullFileName().lastIndexOf(File.separator) + 1;
        return this.getFullFileName().substring(index);
    }

    public String getSimpleFileName() {
        int index = this.getFileName().lastIndexOf(".");
        return this.getFileName().substring(0, index);
    }

    public String getClassFileName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSimpleFileName());
        sb.append(".class");
        return sb.toString();
    }

    public String getClassFileNamePrefixInner() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSimpleFileName());
        sb.append("$");
        return sb.toString();
    }

    public boolean isJavaFile() {
        return this.getFullFileName().endsWith(".java");
    }

    public boolean isRngFile() {
        return this.getFullFileName().endsWith(".rng");
    }

    public boolean isRxmFile() {
        return this.getFullFileName().endsWith(".rxm");
    }

    public boolean isRelaxFile() {
        return this.isRngFile() || this.isRxmFile();
    }

    public boolean isHibernateMappingFile() {
        return this.getFullFileName().endsWith(".hbm.xml");
    }

    public long getDate() {
        return this._date;
    }

    public int getHashCode() {
        return this._hashCode;
    }

    public String getModelId() {
        String filename;
        String rest;
        int ptr;
        String InitPath = File.separator + "init" + File.separator;
        String ConfPath = File.separator + "conf" + File.separator;
        String WebPagePath = File.separator + "webpage" + File.separator;
        String modelId = null;
        String path = this.getFullFileName();
        if (path.startsWith(InitPath)) {
            String rest2 = path.substring(InitPath.length());
            modelId = rest2.substring(0, rest2.indexOf(File.separator));
        } else if (path.startsWith(ConfPath)) {
            String rest3 = path.substring(InitPath.length());
            int ptr2 = rest3.indexOf(File.separator);
            if (ptr2 > 0 && (rest3 = rest3.substring(ptr2 + 1)).endsWith(".xsl")) {
                modelId = rest3.substring(0, rest3.length() - ".xsl".length());
            }
        } else if (path.endsWith(".java") || path.endsWith(".java.gen")) {
            String rest4 = path.substring(0, path.lastIndexOf(File.separator));
            int ptr3 = rest4.lastIndexOf(File.separator);
            if (!(ptr3 <= 0 || (rest4 = rest4.substring(ptr3 + 1)).equals("hibernate") || rest4.equals("app") || rest4.equals("controller"))) {
                modelId = rest4.endsWith("_p") ? rest4.substring(0, rest4.length() - "_p".length()) : (rest4.endsWith("_lp") ? rest4.substring(0, rest4.length() - "_lp".length()) : (rest4.endsWith("_cp") ? rest4.substring(0, rest4.length() - "_cp".length()) : (rest4.endsWith("_c") ? rest4.substring(0, rest4.length() - "_c".length()) : (rest4.endsWith("_l") ? rest4.substring(0, rest4.length() - "_l".length()) : (rest4.endsWith("_ulp") ? rest4.substring(0, rest4.length() - "_ulp".length()) : rest4)))));
            }
        } else if (path.startsWith(WebPagePath) && (ptr = (rest = path.substring(WebPagePath.length())).lastIndexOf(File.separator)) > 0 && !"ehcache.xml".equals(filename = rest.substring(ptr + 1)) && !"hibernate.cfg.xml".equals(filename) && !"context.xml".equals(filename)) {
            String tmp;
            int ptr2;
            if (filename.endsWith(".hbm.xml")) {
                modelId = rest.substring(0, filename.length() - ".hbm.xml".length());
            } else if (filename.endsWith(".xml")) {
                String tmp2;
                int ptr22 = rest.lastIndexOf(File.separator);
                if (!(ptr22 <= 0 || (tmp2 = rest.substring(0, ptr22)).equals("WEB-INF") && rest.substring(("WEB-INF" + File.separator).length()).indexOf(File.separator) < 0 || !"jfc".equals(modelId = filename.substring(0, filename.length() - ".xml".length())) && !modelId.startsWith("__"))) {
                    modelId = null;
                }
            } else if ((rest.endsWith(".css") || rest.endsWith(".js") || rest.endsWith(".jsp")) && (ptr2 = (tmp = path.substring(WebPagePath.length())).indexOf(File.separator)) > 0 && ((modelId = tmp.substring(0, ptr2)).equals("parts") || modelId.equals("system"))) {
                modelId = null;
            }
        }
        return modelId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(GeneratedData.convertStateString(this.getState()));
        sb.append(SEPARATOR);
        sb.append(this.getFullFileName());
        sb.append(SEPARATOR);
        sb.append(this.getDate());
        sb.append(SEPARATOR);
        sb.append(this.getHashCode());
        return sb.toString();
    }

    public static enum State {
        NONE("keep"),
        INSERT("insert"),
        UPDATE("update"),
        DELETE("delete");

        private String str;

        private State(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

