/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.dojo;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WidgetProps<T extends WidgetProps<T>> {
    protected Logger logger = LogManager.getLogger((String)WidgetProps.class.getName());
    private Project project;
    private Model pmodel;
    private Displayitem ditem;
    private Modelitem mitem;
    private Modelitem pitem;
    String id = null;
    String name = null;
    String type = null;
    String dojoProps = null;
    String valueEl = null;
    String htmlClass = null;
    String style = null;
    String disabled = null;
    String readonly = null;
    String tabIndex = null;
    String required = null;
    String size = null;
    String byteSize = null;
    String maxlength = null;
    String autocomplete = null;
    String enterKeyAction = null;
    String cursorPosition = null;
    String range = null;
    String regExp = null;
    String label = null;
    String onClick = null;
    String onChange = null;
    String onKeydown = null;
    String onBlur = null;
    String faIconClass = null;
    String title = null;
    String placeholder = null;
    String with = null;
    String src = null;
    String numberFormat = null;
    String constraints = null;
    String utext = null;
    String inputError = null;

    public WidgetProps(Project project, Model pmodel, Displayitem ditem, Modelitem mitem, Modelitem pitem) {
        this.project = project;
        this.pmodel = pmodel;
        this.ditem = ditem;
        this.mitem = mitem;
        this.pitem = pitem;
        this.initProps();
    }

    public WidgetProps() {
    }

    public abstract T getThis();

    public Displayitem getDitem() {
        return this.ditem;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (StringUtils.isNotBlank((String)this.name)) {
            return this.name;
        }
        return this.id;
    }

    public String getValueEl() {
        return this.valueEl;
    }

    public String getType() {
        if (this.ditem != null) {
            return this.ditem.getType();
        }
        return this.type;
    }

    public String getHtmlClass() {
        return this.htmlClass;
    }

    public String getStyle() {
        if ("hidden".equals(this.getType()) || StringUtils.isBlank((String)this.style)) {
            return "";
        }
        String stylePlace = this.ditem.getStylePlace();
        if (!"centerfield".equals(stylePlace) && !"all".equals(stylePlace)) {
            return "";
        }
        return this.style;
    }

    public String getDojoProps() {
        return this.dojoProps;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public String getTabIndex() {
        return this.tabIndex;
    }

    public String getRequired() {
        return this.required;
    }

    public String getSize() {
        return this.size;
    }

    public String getByteSize() {
        return this.byteSize;
    }

    public String getMaxlength() {
        if (this.maxlength == null) {
            return "";
        }
        return this.maxlength.toString();
    }

    public String getAutocomplete() {
        return this.autocomplete;
    }

    public String getEnterKeyAction() {
        return this.enterKeyAction;
    }

    public String getCursorPosition() {
        if ("left".equals(this.cursorPosition)) {
            return "";
        }
        return this.cursorPosition;
    }

    public String getRange() {
        return this.range;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOnClick() {
        return this.onClick;
    }

    public String getOnChange() {
        return this.onChange;
    }

    public String getOnKeydown() {
        return this.onKeydown;
    }

    public String getOnBlur() {
        return this.onBlur;
    }

    public String getFaIconClass() {
        return this.faIconClass;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getWith() {
        return this.with;
    }

    public String getSrc() {
        return this.src;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public String getUtext() {
        return this.utext != null ? this.utext.toString() : "";
    }

    public String getInputError() {
        return this.inputError;
    }

    public void initProps() {
        this.setId();
        if (this.ditem != null) {
            this.setDisplayitem(this.ditem);
        }
    }

    public T setId(String id) {
        this.id = id;
        return this.getThis();
    }

    public T setName(String name) {
        this.name = name;
        return this.getThis();
    }

    public T setType(String type) {
        this.type = type;
        return this.getThis();
    }

    public T setValueEl(String valueEl) {
        this.valueEl = valueEl;
        return this.getThis();
    }

    public T setHtmlClass(String htmlClass) {
        this.htmlClass = htmlClass;
        return this.getThis();
    }

    public T setStyle(String style) {
        this.style = style;
        return this.getThis();
    }

    public T setDojoProps(String dojoProps) {
        this.dojoProps = dojoProps;
        return this.getThis();
    }

    public T setDisabled(String disabled) {
        this.disabled = disabled;
        return this.getThis();
    }

    public T setReadonly(String readonly) {
        this.readonly = readonly;
        return this.getThis();
    }

    public T setTabIndex(String tabIndex) {
        this.tabIndex = tabIndex;
        return this.getThis();
    }

    public T setTabIndex(int tabIndex) {
        if (tabIndex <= 0 && tabIndex != -1) {
            return this.getThis();
        }
        this.tabIndex = String.valueOf(tabIndex);
        return this.getThis();
    }

    public T setTabIndex(Displayitem ditem) {
        return this.setTabIndex(ditem.getTabindex());
    }

    public T setRequired(String required) {
        this.required = required;
        return this.getThis();
    }

    public T setSize(int size) {
        if (size <= 0) {
            return this.getThis();
        }
        this.size = String.valueOf(size);
        return this.getThis();
    }

    public T setSize(Displayitem ditem) {
        int size = 0;
        if (ditem != null) {
            size = ditem.getSize();
        }
        return this.setSize(size);
    }

    public T setByteSize(String byteSize) {
        this.byteSize = byteSize;
        return this.getThis();
    }

    public T setMaxlength(int maxlength) {
        if (maxlength <= 0) {
            return this.getThis();
        }
        this.maxlength = String.valueOf(maxlength);
        return this.getThis();
    }

    public T setMaxlength(Displayitem ditem) {
        if (ditem == null) {
            return this.getThis();
        }
        return this.setMaxlength(ditem.getMaxlength());
    }

    public T setAutocomplete(boolean autocomplete) {
        if (!autocomplete) {
            this.autocomplete = "off";
        }
        return this.getThis();
    }

    public T setAutocomplete(Displayitem ditem) {
        boolean autocomplete = false;
        if (ditem != null) {
            autocomplete = ditem.getAutocomplete();
        }
        return this.setAutocomplete(autocomplete);
    }

    public T setEnterKeyAction(String enterKeyAction) {
        this.enterKeyAction = enterKeyAction;
        return this.getThis();
    }

    public T setEnterKeyAction(Displayitem ditem) {
        this.enterKeyAction = ditem.getEnterKeyAction();
        return this.getThis();
    }

    public T setCursorPosition(Displayitem ditem) {
        String cursorPosition = ditem.getCursorPosition();
        if (!"left".equals(cursorPosition)) {
            this.cursorPosition = cursorPosition;
        }
        return this.getThis();
    }

    public T setRange(String range) {
        this.range = range;
        return this.getThis();
    }

    public T setRegExp(String regExp) {
        this.regExp = regExp;
        return this.getThis();
    }

    public T setLabel(String label) {
        this.label = label;
        return this.getThis();
    }

    public T setOnClick(String onClick) {
        this.onClick = onClick;
        return this.getThis();
    }

    public T setOnChange(String onChange) {
        this.onChange = onChange;
        return this.getThis();
    }

    public T setOnChange(Displayitem ditem) {
        return this.setOnChange(ditem.getOnChange());
    }

    public T setOnKeydown(String onKeydown) {
        this.onKeydown = onKeydown;
        return this.getThis();
    }

    public T setOnBlur(String onBlur) {
        this.onBlur = onBlur;
        return this.getThis();
    }

    public T setFaIconClass(String faIconClass) {
        this.faIconClass = faIconClass;
        return this.getThis();
    }

    public T setTitle(String title) {
        this.title = title;
        return this.getThis();
    }

    public T setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this.getThis();
    }

    public T setWith(String with) {
        this.with = with;
        return this.getThis();
    }

    public T setSrc(String src) {
        this.src = src;
        return this.getThis();
    }

    public T setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
        return this.getThis();
    }

    public T setNumberFormat(Displayitem ditem) {
        this.numberFormat = ditem.getNumberformat();
        return this.getThis();
    }

    public T setUtext(Boolean utext) {
        this.utext = utext.toString();
        return this.getThis();
    }

    public T setInputError(String inputError) {
        this.inputError = inputError;
        return this.getThis();
    }

    public T setDisplayitem(Displayitem ditem) {
        this.ditem = ditem;
        this.setSize(ditem);
        this.setEnterKeyAction(ditem);
        this.setCursorPosition(ditem);
        this.setOnChange(ditem);
        this.setMaxlength(ditem);
        this.setAutocomplete(ditem);
        this.setTabIndex(ditem);
        this.setNumberFormat(ditem);
        return this.getThis();
    }

    public Map<String, String> getProps() {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        this.setFields(this.getClass(), fields);
        for (Field f : fields) {
            if (Modifier.isPrivate(f.getModifiers()) || "logger".equals(f.getName())) continue;
            try {
                map.put(f.getName(), (String)f.get(this));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.warn("Widget property access error: " + e.getMessage());
            }
        }
        return map;
    }

    public void setFields(Class<?> clazz, List<Field> fields) {
        if (clazz == null) {
            return;
        }
        Field[] fieldArr = clazz.getDeclaredFields();
        if (fieldArr.length > 0) {
            fields.addAll(Arrays.asList(fieldArr));
        }
        this.setFields(clazz.getSuperclass(), fields);
    }

    public void setId() {
        String _name = this.ditem != null ? this.ditem.getName() : this.pitem.getName();
        this.id = AppSchemaUtil.createNameAttribute_th(this.project, _name, this.pmodel);
    }

    public boolean hasChild() {
        if (this.mitem == null) {
            return false;
        }
        return AppSchemaUtil.hasChildPart(this.mitem.getName());
    }
}

