/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.CSSLayout;
import jp.jasminesoft.jfc.gen.HTMLIndentProcessor;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaScriptManagerFactory;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspPanelContentBase;
import jp.jasminesoft.jfc.gen.PluginHtmlManager;
import jp.jasminesoft.jfc.gen.XslElementNameManager;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Constraint;
import jp.jasminesoft.jfc.gen.appschema.Control;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayimage;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaymodel;
import jp.jasminesoft.jfc.gen.appschema.Displaymodelgroup;
import jp.jasminesoft.jfc.gen.appschema.Displaytext;
import jp.jasminesoft.jfc.gen.appschema.IDisplayconditionChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplayitemgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelgroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.Panelgroup;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGeneratorDisplayitem_update;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGenerator_show;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator;
import jp.jasminesoft.util.FileTemplateManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ThBodyGenerator
extends ThGenerator {
    protected boolean csslayoutdebug = false;
    protected Displaymodel displaymodel;
    protected Model pmodel;
    protected String idref;
    protected Logger logger = LogManager.getLogger((String)ThBodyGenerator.class.getName());
    protected List<Displayitem> hiddenlist;
    protected XslElementNameManager xslnman;
    protected Map<String, String> attrNameMap;
    FileTemplateManager tplman = null;
    PluginHtmlManager pluginman = new PluginHtmlManager();
    boolean isOutputJSTL = false;
    protected int DEFAULT_CHECK_RADIO_COLUMN_SIZE = 4;
    private Set<String> processedNameSet = new HashSet<String>();
    private static final String STYLEATTRMARK = " style=\"";

    public ThBodyGenerator(Project project, Action action, Presentation presentation, Model pmodel, String idref, Displaymodel displaymodel, boolean isOutputJSTL) {
        super(project, action, presentation, null);
        this.displaymodel = displaymodel;
        this.pmodel = pmodel;
        this.idref = idref;
        this.isOutputJSTL = isOutputJSTL;
        this.rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
        if (action != null) {
            this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, action);
        } else if (idref != null) {
            this.jsman = JavaScriptManagerFactory.getInstance(project, presentation, idref);
        }
        this.xslnman = XslElementNameManager.getInstance();
        this.hiddenlist = new ArrayList<Displayitem>();
        this.attrNameMap = new LinkedHashMap<String, String>();
        this.attrNameMap.put("valueClass", "class");
        this.attrNameMap.put("labelClass", "class");
        this.attrNameMap = Collections.unmodifiableMap(this.attrNameMap);
    }

    public boolean isOutputHeaderPart() {
        return this.isOutputJSTL;
    }

    protected void setTemplateManager() {
        if (!this.isOutputJSTL) {
            return;
        }
        String templatefilename = this.getTemplatefilename();
        if (templatefilename == null) {
            return;
        }
        File tf = new File(templatefilename);
        if (tf.exists() && tf.isFile() && tf.canRead()) {
            String enc = JavaSourceGenerator.getWebEncoding(this.project);
            this.tplman = new FileTemplateManager(templatefilename, enc);
        }
    }

    protected String getTemplatefilename() {
        String[] templatefileBasedirs;
        String s;
        String string = s = this.displaymodel != null ? this.displaymodel.getTemplatefilename() : null;
        if (s == null || s.length() == 0) {
            s = this.getFilename();
            s = this.isOutputJSTL ? s + "_template.html" : s + ".html";
        } else if (!s.endsWith(".html")) {
            s = s + ".html";
        }
        Model smodel = AppSchemaUtil.getStoreModel(this.pmodel);
        String smodelid = smodel != null ? smodel.getId() : null;
        smodelid = smodelid == null ? "" : File.separator + smodelid;
        for (String basedir : templatefileBasedirs = this.rman.getValueStrArray("JspBodyGenerator.templatefileBasedirs")) {
            String filename = basedir + File.separator + smodelid + File.separator + s;
            File tf = new File(filename);
            if (!tf.exists() || !tf.isFile() || !tf.canRead()) continue;
            return filename;
        }
        return null;
    }

    @Override
    public boolean outputCheckLogonTag() {
        return false;
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        if (this.isOutputJSTL) {
            sb.append(this.gHeader1());
        }
        this.gBody(sb);
        this.gFinish(sb);
        HTMLIndentProcessor hpro = new HTMLIndentProcessor();
        return hpro.process(sb.toString(), HTMLIndentProcessor.Mode.Thymeleaf);
    }

    public String gAttrTag(String attrname) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(attrname);
        sb.append("=\"");
        return sb.toString();
    }

    public String gAttrTag(String attrname, int value) {
        return this.gAttrTag(attrname, Integer.toString(value));
    }

    public final String gAttrTag(String attrname, String value) {
        if ("nowrap".equals(attrname)) {
            try {
                throw new IllegalArgumentException("[CAUTION] nowrap is deprecated since R7.5.");
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(attrname);
        if (value == null) {
            value = "";
        }
        if ("style".equals(attrname) && StringUtils.isNotEmpty((String)value) && !value.endsWith(";")) {
            value = value + ";";
        }
        sb.append("=\"");
        sb.append(value);
        sb.append("\"");
        return sb.toString();
    }

    protected String comment(String comment) {
        return this.comment(comment, true);
    }

    protected String comment(String comment, boolean b) {
        if (!this.project.getDebug()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<!--/* ");
        if (b) {
            sb.append(this.getClass().getName() + "::");
        }
        sb.append(comment);
        sb.append(" */-->");
        return sb.toString();
    }

    @Override
    protected abstract String getActionType();

    protected String getFilenamePrefix() {
        return this.getActionType();
    }

    @Override
    public String getFilename() {
        String filename = ThBodyGenerator.getOutputFilename(this.getFilenamePrefix(), this.idref, this.displaymodel, this.project);
        if (filename.endsWith(".jsp")) {
            filename = filename.substring(0, filename.length() - ".jsp".length());
        } else if (filename.endsWith(".html")) {
            filename = filename.substring(0, filename.length() - ".html".length());
        }
        if (!this.isOutputJSTL) {
            filename = filename + "_template";
        }
        return filename;
    }

    @Override
    public String getFileSuffix() {
        return ".html";
    }

    protected void gTemplate(StringBuilder sb) {
    }

    protected void gBeforeTemplate(StringBuilder sb) {
    }

    protected void gAfterTemplate(StringBuilder sb) {
    }

    protected void gBeginTable(StringBuilder sb, Map<String, Object> attrMap) {
        if (this.tplman != null) {
            return;
        }
        String[] attrs = new String[]{"class", "width", "cellspacing", "cellpadding", "style"};
        String width = (String)attrMap.get("width");
        if (StringUtils.isNotBlank((String)width) && NumberUtils.isCreatable((String)width)) {
            String styleWidth = "width: " + width + "px;";
            String style = (String)attrMap.get("style");
            style = StringUtils.isBlank((String)style) ? styleWidth : style + "; " + styleWidth;
            attrMap.put("style", style);
        }
        sb.append(this.comment("gBeginTable"));
        sb.append("<table");
        if ("showList".equals(this.getActionType()) || "updateList".equals(this.getActionType())) {
            sb.append(" th:if=\"${!#arrays.isEmpty(").append(ThBodyGenerator.convertELId(this.getMatchTarget())).append(") and").append(" #arrays.length(").append(ThBodyGenerator.convertELId(this.getMatchTarget())).append(".item) gt 0}\"");
            if ("showList".equals(this.getActionType())) {
                sb.append(this.gShowConditionBatchProcessCheckboxColumn());
            }
        }
        this.gExpandAttrMap(attrMap, attrs, sb);
        sb.append(">");
    }

    protected void gBeginDiv(StringBuilder sb, Map<String, Object> attrMap, CSSLayout cssLayout, String comment) {
        if (this.tplman != null) {
            return;
        }
        String[] attrs = new String[]{"class", "width", "cellspacing", "cellpadding", "style"};
        sb.append(this.comment("gBeginDiv"));
        sb.append("<div th:class=\"|");
        sb.append("group");
        if (attrMap.containsKey("#valueClass")) {
            sb.append(" ${valueClass}");
        }
        sb.append("|\"");
        StringBuilder css_sb = new StringBuilder();
        this.gExpandAttrMap(attrMap, attrs, css_sb);
        if (this.csslayoutdebug && StringUtils.isNotBlank((String)comment)) {
            sb.append(" ").append(comment);
        }
        sb.append(">");
    }

    protected void gEndTable(StringBuilder sb) {
        if (this.tplman != null) {
            return;
        }
        if (this.tplman == null) {
            sb.append(this.comment("gEndTable"));
            sb.append("</table>");
        }
    }

    protected void gEndDiv(StringBuilder sb, String comment) {
        if (this.tplman != null) {
            return;
        }
        if (this.tplman == null) {
            sb.append(this.comment("gEndDiv"));
            sb.append("</div");
            if (this.csslayoutdebug && StringUtils.isNotBlank((String)comment)) {
                sb.append(" ").append(comment);
            }
            sb.append(">");
        }
    }

    protected void gTableTitle(StringBuilder sb) {
    }

    protected void gTableTitle0(String title, StringBuilder sb, int colnum) {
        this.gTableTitle0(title, sb, colnum, "tabletitle");
    }

    protected void gTableTitle0(String title, StringBuilder sb, int colnum, String rkeyname) {
        if (StringUtils.isBlank((String)title)) {
            return;
        }
        String deftitlekey = this.gTableTitle0_resource(title, rkeyname);
        if (sb != null) {
            sb.append(this.createRValueStatement(deftitlekey));
        }
    }

    protected String gTableTitle0_resource(String title, String rkeyname) {
        String deftitlekey = null;
        if (StringUtils.isBlank((String)rkeyname)) {
            rkeyname = "tabletitle";
        }
        if (this.getAction() != null) {
            rkeyname = this.getAction().getId() + "." + rkeyname;
        }
        deftitlekey = this.createResourceKey(rkeyname, title);
        JFCAppResourceGenerator.put(deftitlekey, title);
        return deftitlekey;
    }

    protected void gBeforeActionLink(StringBuilder sb) {
        sb.append(this.comment("gBeforeActionLink"));
    }

    protected void gAfterActionLink(StringBuilder sb) {
        sb.append(this.comment("gAfterActionLink"));
    }

    protected void gActionLink(StringBuilder sb) {
        this.gActionLink(sb, null);
    }

    protected void gActionLink(StringBuilder sb, FileTemplateManager tplman) {
        if (this.displaymodel == null) {
            Object[] o = new Object[]{this.getAction().getId(), this.idref};
            this.logger.error(this.rman.getValue("value.null.displaymodel.xsl", o));
            return;
        }
    }

    protected void gActionLink0(StringBuilder sb, Link link) {
        PrimaryKey[] pkeys;
        IRNode node;
        String label;
        String laction;
        if (this.tplman == null) {
            sb.append(this.comment("gActionLink0"));
        }
        if ((laction = link.getAction()) == null) {
            laction = "";
        }
        if ((label = link.getLabel()) == null || label.length() == 0) {
            label = "Button";
        }
        Model smodel = null;
        if (this.pmodel != null && (node = this.pmodel.getIdrefAsIRNode()) != null && node instanceof Model && "list".equals((smodel = (Model)node).getType()) && (node = smodel.getIdrefAsIRNode()) != null && node instanceof Model) {
            smodel = (Model)node;
        }
        LinkedHashSet<String> hiddenSet = new LinkedHashSet<String>();
        if (link.getHidden() != null) {
            StringTokenizer st = new StringTokenizer(link.getHidden(), ", ");
            while (st.hasMoreTokens()) {
                hiddenSet.add(st.nextToken());
            }
        }
        if ((pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project)) != null) {
            for (int i = 0; i < pkeys.length; ++i) {
                PrimaryKey pkey = pkeys[i];
                hiddenSet.add(pkey.getName());
            }
        }
        String forward = link.getForward();
        String confirm = link.getConfirm();
        String rkey_confirm = null;
        if (forward != null && forward.startsWith("delete") && (confirm == null || confirm.length() == 0)) {
            rkey_confirm = "__jfc_common.confirm";
        }
        if (rkey_confirm == null) {
            rkey_confirm = this.createResourceKey(laction, confirm);
            JFCAppResourceGenerator.put(rkey_confirm, confirm);
        }
        sb.append("<td");
        sb.append(this.gAttrTag("class", "navigation_field"));
        sb.append(this.gAttrTag("valign", "top"));
        sb.append(">");
        if (forward != null && forward.length() > 0) {
            String submitcnt = null;
            submitcnt = confirm != null && confirm.length() > 0 && !StringUtil.isFullOf((String)confirm, (char)' ') ? "return doConfirm(this, '" + this.createRValueStatement(rkey_confirm) + "');" : "buttonOff(); return true;";
            if (!(forward.endsWith(".html") || forward.endsWith(".htm") || forward.endsWith(".jsp"))) {
                forward = forward + ".do";
            }
            sb.append("<form");
            sb.append(this.gAttrTag("name", "Nav" + forward));
            sb.append(this.gAttrTag("action", forward));
            sb.append(this.gAttrTag("method", "post"));
            sb.append(this.gAttrTag("onSubmit", submitcnt));
            sb.append(" novalidate>");
            sb.append("<input");
            sb.append(this.gAttrTag("type", "hidden"));
            sb.append(this.gAttrTag("name", "SENDACTION"));
            sb.append("/>");
            sb.append("<input");
            sb.append(this.gAttrTag("type", "hidden"));
            sb.append(this.gAttrTag("name", "sessionId"));
            sb.append(this.gAttrTag("th:value", "${#jfc.md5Hash(#session.getId())}"));
            sb.append("/>");
            confirm = null;
        }
        for (Displayitem ditem : this.hiddenlist) {
            IModelChoice[] imc;
            String name = ditem.getName();
            Modelitem mitem = null;
            if (smodel != null && (imc = smodel.getContent()) != null) {
                int i;
                for (i = 0; !(i >= imc.length || imc[i] instanceof Modelitem && name.equals((mitem = (Modelitem)imc[i]).getName())); ++i) {
                }
                if (i >= imc.length) {
                    mitem = null;
                }
            }
            if (mitem == null) {
                Object[] o = new Object[]{this.getAction().getId(), name};
                this.logger.error(this.rman.getValue("value.null.hiddenlist", o));
            }
            sb.append("<input");
            sb.append(this.gAttrTag("type", "hidden"));
            sb.append(this.gAttrTag("name", name));
            sb.append(this.gAttrTag("th:value"));
            sb.append("${");
            sb.append(name);
            if (mitem != null && (mitem.getType().equals("masterref") || mitem.getType().equals("storeref"))) {
                sb.append("[0].id");
            }
            sb.append("}\"/>");
        }
        this.gActionLink0_inputfield(sb, laction, label, confirm, link);
        if (forward != null && forward.length() > 0) {
            sb.append("</form>");
        }
    }

    protected void gActionLink0_inputfield(StringBuilder sb, String name, String label, String confirm, Link link) {
        sb.append("<button");
        sb.append(this.gAttrTag("data-dojo-type", "wagby/Button"));
        sb.append(this.gAttrTag("type", "submit"));
        if (StringUtils.isNotBlank((String)link.getIconClass())) {
            sb.append(this.gAttrTag("faIconClass", link.getIconClass()));
        }
        if (name != null && name.length() > 0) {
            StringBuilder code = new StringBuilder();
            code.append("this.valueNode.form.SENDACTION.name='action_");
            code.append(name);
            code.append("';");
            if (confirm != null && confirm.length() > 0) {
                code.insert(0, "var ret = doConfirm(this, '" + confirm + "');if (ret) { ");
                code.append("this.valueNode.form.submit(); } else return false;");
            }
            sb.append(this.gAttrTag("name", "btn" + name));
            sb.append(this.gAttrTag("onClick", code.toString()));
        }
        sb.append(">");
        sb.append(label);
        sb.append("</button>");
    }

    protected String getMatchTarget() {
        return this.idref;
    }

    public String getInputForm() {
        String ret = this.getPresentation().getIdref();
        if (this.getAction().getWizard() && this.getPresentation().getFilename() != null) {
            ret = this.getPresentation().getFilename();
        }
        return ret + ".do";
    }

    protected void gAfterContent(StringBuilder sb) {
        sb.append(this.comment("gAfterContent"));
    }

    protected void gFinish(StringBuilder sb) {
        sb.append(this.comment("gFinish"));
    }

    protected void gHiddenlist(StringBuilder sb) {
        int size;
        StringBuilder _sb = new StringBuilder();
        HashSet<String> processedItemSet = new HashSet<String>();
        HashSet<String> targetItemNameSet = null;
        if (this.displaymodel != null) {
            List<Displayitem> _ditems = AppSchemaUtil.getDisplayitems(this.displaymodel);
            for (Displayitem _ditem : _ditems) {
                if (targetItemNameSet == null) {
                    targetItemNameSet = new HashSet<String>();
                }
                targetItemNameSet.add(_ditem.getName());
            }
        }
        Model _model = (Model)this.pmodel.getIdrefAsIRNode();
        if (!"show".equals(this.getActionType()) && this.getAction().getWizard()) {
            PrimaryKey[] _pkeys;
            Presentation[] _presentations = AppSchemaUtil.getPresentation(this.project, this.getAction());
            if (_model != null && _model.getType().equals("store") && (_pkeys = AppSchemaUtil.getPrimaryKey(_model)) != null) {
                block1: for (PrimaryKey _pkey : _pkeys) {
                    if (!_pkey.checkAutoid()) continue;
                    String _pkeyname = _pkey.getName();
                    for (Presentation _presentation : _presentations) {
                        Displayitem _ditem = AppSchemaUtil.getDisplayitem(_pkeyname, _presentation);
                        if (_ditem == null || this.hiddenlist.contains(_ditem)) continue;
                        this.hiddenlist.add(0, _ditem);
                        break block1;
                    }
                }
            }
        }
        if ((size = this.hiddenlist.size()) > 0) {
            String id = this.getMatchTarget();
            Model smodel = AppSchemaUtil.getStoreModel(this.pmodel);
            boolean isCondition = false;
            if (_model != null && "condition".equals(_model.getType())) {
                isCondition = true;
            }
            for (int i = 0; i < size; ++i) {
                String labelid;
                Displayitem ditem = this.hiddenlist.get(i);
                String name = ditem.getName();
                Modelitem pitem = AppSchemaUtil.getModelitem(name, this.pmodel);
                if (targetItemNameSet != null && !targetItemNameSet.contains(name)) continue;
                Modelitem sitem = AppSchemaUtil.getModelitem(name, smodel);
                if (sitem == null && _model != null && "condition".equals(_model.getType()) && "textsearchjshparam".equals(name)) {
                    sitem = new Modelitem();
                    sitem.setName("textsearchjshparam");
                    sitem.setType("string");
                }
                String sname = this.createSelectName(ditem, sitem);
                Modelitem _sitem = null;
                if (sname.matches(".*[12]+jshparam$")) {
                    String org_name = name.substring(0, name.length() - "+jshparam".length());
                    _sitem = AppSchemaUtil.getModelitem(org_name, smodel);
                } else {
                    _sitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), sitem);
                }
                if (_sitem == null) continue;
                String type = _sitem.getType();
                Modelitem citem = null;
                Relation citem_ref = null;
                if ("condition".equals(_model.getType())) {
                    citem = AppSchemaUtil.getModelitem(_sitem.getName(), _model);
                    citem_ref = AppSchemaUtil.getRelationTypeExceptRef(citem);
                }
                String pname = id;
                boolean containerFlag = AppSchemaUtil.hasChildPart(name);
                if (containerFlag) {
                    pname = AppSchemaUtil.getParentPart(name);
                }
                if (processedItemSet.contains(labelid = AppSchemaUtil.createNameAttribute_th(this.project, name, this.pmodel))) continue;
                processedItemSet.add(labelid);
                if ("hidden".equals(ditem.getType())) {
                    String ditem_label = null;
                    if (StringUtils.isNotBlank((String)ditem.getLabel())) {
                        ditem_label = ditem.getLabel();
                    }
                    if (StringUtils.isBlank(ditem_label)) {
                        ditem_label = ditem.getLabelname();
                    }
                    if (ditem_label == null && pitem != null) {
                        ditem_label = pitem.getLabel();
                    }
                    if (ditem_label != null && ditem_label.length() > 0) {
                        ditem_label = ThBodyGenerator.getLabelBodyPart(ditem_label);
                        String rkey = this.createResourceKey(ditem.getName(), ditem_label);
                        JFCAppResourceGenerator.put(rkey, ditem_label);
                    }
                }
                if ("masterref".equals(type) || "storeref".equals(type) || StringUtils.isNotBlank((String)_sitem.getDualinputmethod())) {
                    Relation relation = AppSchemaUtil.getRelationTypeExceptRef(_sitem);
                    if (relation != null) {
                        boolean isCombobox = false;
                        if (relation != null && "combo".equals(relation.getType()) || "combo".equals(_sitem.getDualinputmethod())) {
                            isCombobox = true;
                        }
                        boolean isCheckbox = false;
                        if (relation != null && "check".equals(relation.getType())) {
                            isCheckbox = true;
                        }
                        String _key = null;
                        _key = containerFlag && _model != null && "condition".equals(_model.getType()) ? this.gHiddenlistKey(id, sname) : this.gHiddenlistKey(pname, sname);
                        _sb.append("<th:block th:each=\"c : ${").append(_key).append("}\">").append("<input").append(this.gAttrTag("th:if", "${c.choose}"));
                        if (!isCondition) {
                            _sb.append(this.gAttrTag("data-dojo-type", "dijit/form/TextBox"));
                        }
                        _sb.append(this.gAttrTag("type", "hidden")).append(this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement(labelid))).append(this.gAttrTag("th:name", ThBodyGenerator.getThLiteralReplacement(labelid)));
                        StringBuilder valueEl = new StringBuilder();
                        valueEl.append("${!c.noId ? ").append(this.getIdItemNames("c", _sitem)).append(" : ''}");
                        _sb.append(this.gAttrTag("th:value", valueEl.toString())).append("/>").append("</th:block>");
                        if (!isCombobox && !isCheckbox) {
                            _sb.append("<input").append(" th:if=\"${!#jfc.ifItemSelected(").append(_key).append(")}\"");
                            if (!isCondition) {
                                _sb.append(this.gAttrTag("data-dojo-type", "dijit/form/TextBox"));
                            }
                            _sb.append(this.gAttrTag("type", "hidden"));
                            _sb.append(this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement(labelid)));
                            _sb.append(this.gAttrTag("th:name", ThBodyGenerator.getThLiteralReplacement(labelid)));
                            _sb.append(this.gAttrTag("value", ""));
                            _sb.append("/>");
                        }
                    }
                } else if (_sitem.getMultiple() && !_model.getType().equals("condition")) {
                    String mlabelid = ThBodyGenerator.getThLiteralReplacement(labelid + ThBodyGenerator.convertJavaVariableString("[") + "${cIterStat.count}" + ThBodyGenerator.convertJavaVariableString("]/@content"));
                    _sb.append("<th:block th:each=\"c, cIterStat : ${").append(this.gHiddenlistKey(pname, sname)).append("}\">");
                    _sb.append("<input");
                    if (!isCondition) {
                        _sb.append(this.gAttrTag("data-dojo-type", "dijit/form/TextBox"));
                    }
                    _sb.append(this.gAttrTag("type", "hidden"));
                    _sb.append(this.gAttrTag("th:id", mlabelid));
                    _sb.append(this.gAttrTag("th:name", mlabelid));
                    _sb.append(this.gAttrTag("th:value", "${c.content}"));
                    _sb.append("/>");
                    _sb.append("</th:block>");
                } else if ("rtextarea".equals(ditem.getType())) {
                    _sb.append("<input");
                    if (!isCondition) {
                        _sb.append(this.gAttrTag("data-dojo-type", "dijit/form/TextBox"));
                    }
                    _sb.append(this.gAttrTag("type", "hidden"));
                    _sb.append(this.gAttrTag("th:name", ThBodyGenerator.getThLiteralReplacement(labelid)));
                    _sb.append(this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement(labelid)));
                    _sb.append(this.gAttrTag("th:value", this.wrapValueEl(this.gHiddenlistValue(pname, sname, sitem))));
                    _sb.append("/>");
                } else if (citem_ref != null && citem_ref.getSelfsearch()) {
                    String _key = this.gHiddenlistKey(pname, sname);
                    _sb.append("<th:block th:each=\"c, cIterStat : ${").append(_key).append("}\">");
                    _sb.append("<input th:if=\"${c.choose}");
                    if (!isCondition) {
                        _sb.append(this.gAttrTag("data-dojo-type", "dijit/form/TextBox"));
                    }
                    _sb.append(this.gAttrTag("type", "hidden"));
                    _sb.append(this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement(labelid)));
                    _sb.append(this.gAttrTag("th:name", ThBodyGenerator.getThLiteralReplacement(labelid)));
                    _sb.append(this.gAttrTag("th:value", "${!c.noId ? c.id : ''}"));
                    _sb.append("/>");
                    _sb.append("</th:block>");
                } else {
                    _sb.append("<input").append(this.gDisplayitemControlCondition(smodel, ditem, pitem));
                    if (!isCondition) {
                        _sb.append(this.gAttrTag("data-dojo-type", "dijit/form/TextBox"));
                    }
                    _sb.append(this.gAttrTag("type", "hidden")).append(this.gAttrTag("th:name", ThBodyGenerator.getThLiteralReplacement(labelid))).append(this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement(labelid))).append(this.gAttrTag("th:value", this.wrapValueEl(this.gHiddenlistValue(pname, sname, sitem)))).append("/>");
                }
                this.gHiddenlist_update(sitem, labelid, pitem);
            }
        }
        if (_sb.length() > 0) {
            _sb.append("</div>");
            _sb.append("<!--/* ThBodyGenerator Hidden item process finished. */-->");
            _sb.insert(0, "<!--/* ThBodyGenerator Hidden item process started. */--><div id=\"jfc_hidden_item\">");
        } else {
            _sb.append("<div id=\"jfc_hidden_item\"></div>");
        }
        sb.append(_sb.toString());
    }

    protected String gDisplayitemControlCondition(Model smodel, Displayitem ditem, Modelitem pitem) {
        if (pitem == null) {
            return "";
        }
        Control control = AppSchemaUtil.getControlTypeIsHidden(pitem);
        if (control == null) {
            return "";
        }
        Modelitem sitem = AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), AppSchemaUtil.getModelitem(ditem.getName(), smodel));
        boolean isMultiple = sitem != null && sitem.getMultiple();
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(sitem);
        boolean isRelation = relation != null;
        boolean isDualinput = false;
        if (sitem != null && "combo".equals(sitem.getDualinputmethod())) {
            isDualinput = true;
        }
        String expr = null;
        if (isMultiple || isRelation || isDualinput) {
            expr = "!#arrays.isEmpty(" + ThBodyGenerator.convertELId(this.getMatchTarget()) + "." + ThBodyGenerator.convertELProperty(ditem.getName()) + ")";
        } else {
            expr = null;
            expr = !AppSchemaUtil.hasChildPart(ditem.getName()) ? ThBodyGenerator.convertELId(this.getMatchTarget()) + "." + ThBodyGenerator.convertELProperty(ditem.getName()) + " ne null" : ThBodyGenerator.convertELId(AppSchemaUtil.getParentPart(ditem.getName())) + "." + ThBodyGenerator.convertELProperty(AppSchemaUtil.getChildPart(ditem.getName())) + " ne null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" th:if=\"${").append(expr).append("}\"");
        return sb.toString();
    }

    protected String gHiddenlistKey(String pname, String sname) {
        return ThBodyGenerator.convertELId(pname) + "." + ThBodyGenerator.convertELProperty(sname);
    }

    protected String gHiddenlistValue(String pname, String sname, Modelitem sitem) {
        return this.gHiddenlistKey(pname, sname) + ".content";
    }

    protected void gHiddenlist_update(Modelitem mitem, String labelid) {
    }

    protected void gHiddenlist_update(Modelitem mitem, String labelid, Modelitem pitem) {
    }

    protected Map<String, Object> createAttrMap(Link link) {
        return this.createAttrMap(link, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Link link, Map<String, Object> map) {
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        if (link == null) {
            return cmap;
        }
        String classname = link.getValueClass();
        if (classname != null && classname.length() >= 0) {
            cmap.put("valueClass", classname);
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displaycondition displaycondition) {
        return this.createAttrMap(displaycondition, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displaycondition displaycondition, Map<String, Object> map) {
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        String s = displaycondition.getWidth();
        if (s != null && s.length() > 0) {
            cmap.put("width", s);
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displaymodel displaymodel) {
        return this.createAttrMap(displaymodel, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displaymodel displaymodel, Map<String, Object> map) {
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        String s = displaymodel.getWidth();
        if (s != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = displaymodel.getValueClass()) != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = displaymodel.getLabelClass()) != null && s.length() >= 0) {
            cmap.put("labelClass", s);
        }
        boolean b = displaymodel.getAutoalignment();
        cmap.put("autoalignment", b);
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displayitem ditem) {
        return this.createAttrMap(ditem, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displayitem ditem, Map<String, Object> map) {
        boolean b;
        int rowspan;
        int colspan;
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        String s = ditem.getValueClass();
        if (s != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = ditem.getLabelClass()) != null && s.length() >= 0) {
            cmap.put("labelClass", s);
        }
        if ((s = ditem.getWidth()) != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = ditem.getHeight()) != null && s.length() >= 0) {
            cmap.put("height", s);
        }
        if ((s = ditem.getAlign()) != null && s.length() >= 0) {
            cmap.put("align", s);
        }
        if ((s = ditem.getValign()) != null && s.length() >= 0) {
            cmap.put("valign", s);
        }
        if ((colspan = ditem.getColspan()) > 0) {
            cmap.put("colspan", Integer.toString(colspan));
        }
        if ((rowspan = ditem.getRowspan()) > 1) {
            cmap.put("rowspan", Integer.toString(rowspan));
        }
        if (b = ditem.getNowrap()) {
            cmap.put("nowrap", "nowrap");
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displaytext dtext) {
        return this.createAttrMap(dtext, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displaytext dtext, Map<String, Object> map) {
        boolean b;
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        String s = dtext.getValueClass();
        if (s != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = dtext.getWidth()) != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = dtext.getAlign()) != null && s.length() >= 0) {
            cmap.put("align", s);
        }
        if ((s = dtext.getValign()) != null && s.length() >= 0) {
            cmap.put("valign", s);
        }
        if (b = dtext.getNowrap()) {
            cmap.put("nowrap", "nowrap");
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displayimage dimage) {
        return this.createAttrMap(dimage, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displayimage dimage, Map<String, Object> map) {
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        String s = dimage.getContent();
        if (s != null && s.length() >= 0) {
            cmap.put("src", s);
        }
        if ((s = dimage.getWidth()) != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = dimage.getHeight()) != null && s.length() >= 0) {
            cmap.put("height", s);
        }
        if ((s = dimage.getHspace()) != null && s.length() >= 0) {
            cmap.put("hspace", s);
        }
        if ((s = dimage.getVspace()) != null && s.length() >= 0) {
            cmap.put("vspace", s);
        }
        if ((s = dimage.getAlt()) != null && s.length() >= 0) {
            cmap.put("alt", s);
        }
        return cmap;
    }

    protected Map<String, Object> createAttrMap(Displayitemgroup ditemg) {
        return this.createAttrMap(ditemg, new LinkedHashMap<String, Object>());
    }

    protected Map<String, Object> createAttrMap(Displayitemgroup ditemg, Map<String, Object> map) {
        boolean b;
        LinkedHashMap<String, Object> cmap = new LinkedHashMap<String, Object>(map);
        String s = ditemg.getWidth();
        if (s != null && s.length() >= 0) {
            cmap.put("width", s);
        }
        if ((s = ditemg.getValueClass()) != null && s.length() >= 0) {
            cmap.put("valueClass", s);
        }
        if ((s = ditemg.getLabelClass()) != null && s.length() >= 0) {
            cmap.put("labelClass", s);
        }
        if (b = ditemg.getNowrap()) {
            cmap.put("nowrap", "nowrap");
        }
        b = ditemg.getAutoalignment();
        cmap.put("autoalignment", b);
        return cmap;
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, StringBuilder sb) {
        this.gExpandAttrMap(attrMap, null, sb);
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, String[] attrs, StringBuilder sb) {
        this.gExpandAttrMap(null, attrMap, attrs, "iterStat", sb, true);
    }

    protected void gExpandAttrMap(Map<String, Object> attrMap, String[] attrs, StringBuilder sb, boolean forceIndentFlag) {
        this.gExpandAttrMap(null, attrMap, attrs, "iterStat", sb, forceIndentFlag);
    }

    protected void gExpandAttrMap(String elemname, Map<String, Object> attrMap, String[] attrs, String posname, StringBuilder sb, boolean forceIndentFlag) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                set.add(attrs[i]);
            }
        }
        LinkedHashMap<String, String> outputMap = new LinkedHashMap<String, String>();
        if (attrMap != null && attrMap.size() > 0) {
            for (String key : attrMap.keySet()) {
                String value;
                if (attrs != null && !set.contains(key) || (value = (String)attrMap.get(key)) == null || value.length() <= 0) continue;
                key = this.convertAttrKey(key);
                outputMap.put(key, value);
            }
        }
        if (outputMap.containsKey("nowrap")) {
            String style = (String)outputMap.get("style");
            if (style == null) {
                outputMap.put("style", "white-space: nowrap; word-wrap: normal;");
            } else {
                style = "white-space: nowrap; word-wrap: normal;" + style;
                outputMap.put("style", style);
            }
            outputMap.remove("nowrap");
        }
        for (String key : outputMap.keySet()) {
            this.gExpandAttrMap0(null, key, (String)outputMap.get(key), posname, sb);
        }
    }

    protected void gExpandAttrMap0(String elemname, String key, String value, String posname, StringBuilder sb) {
        this.gExpandAttrMap0(elemname, key, null, value, posname, sb);
    }

    protected void gExpandAttrMap0(String elemname, String key, String prevalue, String value, String posname, StringBuilder sb) {
        List<Object> cssClassList = null;
        if (!CSSLayout.isStyleWithCondition(value)) {
            cssClassList = Optional.ofNullable(StringUtils.split((String)value, (String)",")).map(Arrays::stream).orElse(Stream.empty()).map(s -> s.trim()).collect(Collectors.toList());
        } else {
            cssClassList = new ArrayList<String>();
            cssClassList.add(value);
        }
        if (cssClassList.size() == 1) {
            StringBuilder tagWithAttr = new StringBuilder();
            tagWithAttr.append(this.gAttrTag(key, (String)cssClassList.get(0)));
            if (elemname != null) {
                tagWithAttr.insert(0, "<" + elemname).append(">");
            }
            sb.append(tagWithAttr.toString());
        }
    }

    protected String convertAttrKey(String key) {
        if (this.attrNameMap.keySet().contains(key)) {
            return this.attrNameMap.get(key);
        }
        return key;
    }

    protected String createValueOfName(Displayitem ditem, Modelitem mitem) {
        return ThBodyGenerator.createValueOfName(ditem, mitem, "${cIterStat.count}");
    }

    public static String createValueOfName(Displayitem ditem, Modelitem mitem, String multiplemark) {
        String name0 = mitem == null ? ditem.getName() : mitem.getName();
        return ThBodyGenerator.createValueOfName(name0, multiplemark);
    }

    protected static String createValueOfName(String name0, String multiplemark) {
        String name = name0;
        int ptr = name0.indexOf("/");
        if (ptr >= 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(ThBodyGenerator.convertJavaVariableString(name0.substring(0, ptr)));
            buf.append(ThBodyGenerator.convertJavaVariableString("["));
            buf.append(multiplemark);
            buf.append(ThBodyGenerator.convertJavaVariableString("]/"));
            buf.append(ThBodyGenerator.convertJavaVariableString(name0.substring(ptr + 1)));
            name = buf.toString();
        } else {
            name = ThBodyGenerator.convertJavaVariableString(name0);
        }
        return name;
    }

    protected String createSelectName(Displayitem ditem, Modelitem sitem) {
        String name0 = sitem == null ? ditem.getName() : sitem.getName();
        int ptr = name0.indexOf("/");
        String name = ptr >= 0 ? name0.substring(ptr + 1) : name0;
        return name;
    }

    protected Displayitemgroup getFirstDisplayitemgroup() {
        Displayitemgroup ditemg = null;
        IDisplaymodelChoice[] idmc = this.displaymodel.getContent();
        for (int i = 0; i < idmc.length; ++i) {
            if (!(idmc[i] instanceof Displayitemgroup)) continue;
            ditemg = (Displayitemgroup)idmc[i];
            break;
        }
        return ditemg;
    }

    protected Displayitem getFirstDisplayitem() {
        Displayitem ditem = null;
        IDisplaymodelChoice[] idmc = this.displaymodel.getContent();
        for (int i = 0; i < idmc.length; ++i) {
            if (idmc[i] instanceof Displayitemgroup) {
                Displayitemgroup ditemg = (Displayitemgroup)idmc[i];
                ditem = this.getFirstDisplayitem(ditemg);
            }
            if (idmc[i] instanceof Displayitem) {
                ditem = (Displayitem)idmc[i];
            }
            if (ditem != null && !AppSchemaUtil.isHiddenDisplayitem(ditem)) break;
        }
        if (ditem == null) {
            Object[] o = new Object[]{this.getAction().getId(), this.idref, this.displaymodel.makeTextDocument()};
            this.logger.error(this.rman.getValue("value.null.displaymodel.firstdisplayitem", o));
        }
        return ditem;
    }

    protected Displayitem getFirstDisplayitem(Displayitemgroup ditemg) {
        IDisplayitemgroupChoice[] idmgcs;
        Displayitem ditem = null;
        for (IDisplayitemgroupChoice idmgc : idmgcs = ditemg.getContent()) {
            if (idmgc instanceof Displayitemgroup) {
                Displayitemgroup _ditemg = (Displayitemgroup)idmgc;
                ditem = this.getFirstDisplayitem(_ditemg);
            }
            if (idmgc instanceof Displayitem) {
                ditem = (Displayitem)idmgc;
            }
            if (ditem != null && !AppSchemaUtil.isHiddenDisplayitem(ditem)) break;
        }
        return ditem;
    }

    protected String getParentName() {
        Displayitem ditem = this.getFirstDisplayitem();
        return this.getParentName(ditem);
    }

    protected String getParentName(Displayitem ditem) {
        String parentname = "";
        if (ditem != null) {
            String _name = ditem.getName();
            int idx = _name.indexOf("/");
            parentname = idx > 0 ? _name.substring(0, _name.indexOf("/")) : _name;
        }
        return parentname;
    }

    public String getParentName(Displayitem[] ditems) {
        if (ditems == null || ditems.length == 0) {
            return null;
        }
        String parentname = null;
        for (Displayitem ditem : ditems) {
            if (StringUtils.isBlank((String)ditem.getName())) continue;
            parentname = this.getParentName(ditem);
            break;
        }
        return parentname;
    }

    protected Object getParentNode(Displayitem ditem) {
        if (this.getPresentation() == null) {
            return null;
        }
        Layout layout = this.getPresentation().getLayout();
        if (layout == null) {
            return null;
        }
        Panel[] panels = layout.getPanel();
        if (panels == null || panels.length == 0) {
            return null;
        }
        Panel panel = null;
        Object ret = null;
        for (int i = 0; i < panels.length && ((panel = panels[i]) == null || (ret = this.getParentNode0(panel, ditem)) == null); ++i) {
        }
        return ret;
    }

    protected Object getParentNode0(Panel panel, Displayitem ditem) {
        Object ret = null;
        IPanelChoice[] ipc = panel.getContent();
        if (ipc == null || ipc.length == 0) {
            return ret;
        }
        block0: for (int j = 0; j < ipc.length; ++j) {
            Displaymodel dm;
            if (ipc[j] instanceof Panel) {
                Panel panel2 = (Panel)ipc[j];
                ret = this.getParentNode0(panel2, ditem);
                if (ret == null) continue;
                break;
            }
            if (ipc[j] instanceof Displaycondition) {
                Displaycondition dc = (Displaycondition)ipc[j];
                ret = this.getParentNode0(dc, ditem);
                continue;
            }
            if (ipc[j] instanceof Displaymodelgroup) {
                Displaymodelgroup dmg = (Displaymodelgroup)ipc[j];
                IDisplaymodelgroupChoice[] idmgc = dmg.getContent();
                if (idmgc == null || idmgc.length == 0) continue;
                for (int k = 0; k < idmgc.length; ++k) {
                    if (idmgc[k] instanceof Displaymodel) {
                        Displaymodel dm2 = (Displaymodel)idmgc[k];
                        ret = this.getParentNode0(dm2, ditem);
                        if (ret == null) continue;
                        break block0;
                    }
                    if (!(idmgc[k] instanceof Panelgroup)) continue;
                    Panelgroup panelgroup = (Panelgroup)idmgc[k];
                    for (Panel _panel : panelgroup.getPanel()) {
                        ret = this.getParentNode0(_panel, ditem);
                        if (ret != null) break block0;
                    }
                }
                continue;
            }
            if (ipc[j] instanceof Displaymodel && (ret = this.getParentNode0(dm = (Displaymodel)ipc[j], ditem)) != null) break;
        }
        return ret;
    }

    protected Object getParentNode0(Displaycondition dc, Displayitem ditem) {
        Object ret = null;
        IDisplayconditionChoice[] idc = dc.getContent();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem di;
            if (idc[i] instanceof Displayitemgroup) {
                Displayitemgroup dig = (Displayitemgroup)idc[i];
                ret = this.getParentNode1(dig, ditem);
                if (ret == null) continue;
                break;
            }
            if (!(idc[i] instanceof Displayitem) || !(di = (Displayitem)idc[i]).getName().equals(ditem.getName())) continue;
            ret = dc;
            break;
        }
        return ret;
    }

    protected Object getParentNode0(Displaymodel dm, Displayitem ditem) {
        Object ret = null;
        IDisplaymodelChoice[] idc = dm.getContent();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem di;
            if (idc[i] instanceof Displayitemgroup) {
                Displayitemgroup dig = (Displayitemgroup)idc[i];
                ret = this.getParentNode1(dig, ditem);
                if (ret == null) continue;
                break;
            }
            if (!(idc[i] instanceof Displayitem) || !(di = (Displayitem)idc[i]).getName().equals(ditem.getName())) continue;
            ret = dm;
            break;
        }
        return ret;
    }

    protected Object getParentNode1(Displayitemgroup dig, Displayitem ditem) {
        Object ret = null;
        IDisplayitemgroupChoice[] idc = dig.getContent();
        for (int i = 0; i < idc.length; ++i) {
            Displayitem di;
            if (idc[i] instanceof Displayitemgroup) {
                Displayitemgroup dig2 = (Displayitemgroup)idc[i];
                ret = this.getParentNode1(dig2, ditem);
                if (ret == null) continue;
                break;
            }
            if (!(idc[i] instanceof Displayitem) || !(di = (Displayitem)idc[i]).getName().equals(ditem.getName())) continue;
            ret = dig;
            break;
        }
        return ret;
    }

    public String getContainerLabel(Displayitemgroup ditemg, Model pmodel) {
        String pname = null;
        String label = null;
        IDisplayitemgroupChoice[] iditemgcs = ditemg.getContent();
        if (iditemgcs != null && iditemgcs.length > 0) {
            Modelitem pitem;
            for (IDisplayitemgroupChoice iditemgc : iditemgcs) {
                Displayitem ditem;
                if (iditemgc instanceof Displayitem && !AppSchemaUtil.isHiddenDisplayitem(ditem = (Displayitem)iditemgc) && (pname = this.getParentName(ditem)) != null && pname.length() > 0) break;
            }
            if (pname != null && (pitem = AppSchemaUtil.getModelitem(pname, pmodel)) != null) {
                label = pitem.getLabel();
            }
        }
        if (label == null) {
            Displayitemgroup ditemg0;
            IDisplayitemgroupChoice iditemgc;
            IDisplayitemgroupChoice[] iDisplayitemgroupChoiceArray = iditemgcs;
            int n = iDisplayitemgroupChoiceArray.length;
            for (int i = 0; !(i >= n || (iditemgc = iDisplayitemgroupChoiceArray[i]) instanceof Displayitemgroup && (label = this.getContainerLabel(ditemg0 = (Displayitemgroup)iditemgc, pmodel)) != null && label.length() > 0); ++i) {
            }
        }
        if (label == null) {
            label = "";
        }
        return label;
    }

    protected void gBody(StringBuilder sb) {
        sb.append(this.comment("gBody"));
        this.gTemplate(sb);
    }

    protected String getDataType(Modelitem item) {
        String mname;
        String _type;
        IRNode node;
        String type = "number";
        if (item == null) {
            return type;
        }
        Model smodel = null;
        if (this.pmodel != null && (node = this.pmodel.getIdrefAsIRNode()) != null && node instanceof Model) {
            smodel = (Model)node;
        }
        if (!JavaSourceGenerator.isBasicType(_type = AppSchemaUtil.getModelitemType(this.project, mname = smodel != null ? smodel.getId() : "", item))) {
            type = "text";
        }
        return type;
    }

    protected String createActionId() {
        return JspPanelContentBase.createActionId(this.getAction(), this.idref);
    }

    protected static String createNameAttributeValue(String id, String name) {
        String vname = ThBodyGenerator.convertJavaVariableString(id + "/") + name;
        return vname;
    }

    protected static String createNameAttributeValue_anorm(String labelid) {
        return labelid + ThBodyGenerator.convertJavaVariableString("/@anorm");
    }

    public static String createNameAttributeValue_id(String id, String name) {
        String vname = ThBodyGenerator.convertJavaVariableString(id + "/") + name + ThBodyGenerator.convertJavaVariableString("[1]/@id");
        return vname;
    }

    protected static String createNameAttributeValue_content(String id, String name) {
        String vname = "_" + ThBodyGenerator.convertJavaVariableString(id + "/") + name + ThBodyGenerator.convertJavaVariableString("[1]/@id") + "_content";
        return vname;
    }

    protected static String createNameAttributeValue_content(String labelid) {
        return "_" + labelid + "_content";
    }

    public final String createRValueStatement(String rkey) {
        StringBuilder sb = new StringBuilder();
        sb.append("<fmt:message key=\"");
        sb.append(rkey);
        sb.append("\"/>");
        return sb.toString();
    }

    public void insertWagbyBlockTag(String name, StringBuilder sb) {
        this.insertWagbyBlockTag(name, sb, false);
    }

    public void insertWagbyBlockTag(String name, StringBuilder sb, boolean multiPattern) {
        if (!this.isOutputJSTL) {
            String pre = null;
            String post = null;
            String tmp = sb.toString();
            if (tmp.startsWith("<div ") || tmp.startsWith("<div>")) {
                pre = tmp.substring(0, tmp.indexOf(">") + 1);
                post = "</div>";
            }
            if (!multiPattern && this.processedNameSet.contains(name) && pre == null) {
                sb.delete(0, sb.length());
                return;
            }
            sb.delete(0, sb.length());
            if (pre != null) {
                sb.append(pre);
            }
            sb.append("$block{" + name + "}");
            if (post != null) {
                sb.append(post);
            }
            this.processedNameSet.add(name);
        }
    }

    public void insertWagbyCommentInTemplate(StringBuilder sb) {
    }

    protected String getRelationType(Displayitem ditem, Relation rel) {
        String reltype;
        if (ditem != null && (reltype = ditem.getRelationtype()) != null && reltype.length() > 0 && !"use_modelitem_setting".equals(reltype)) {
            return reltype;
        }
        return rel.getType();
    }

    protected boolean useHeaderAppendButton() {
        return false;
    }

    protected void addCancelOfConstraintElement(Modelitem mitem, String labelid, Modelitem pitem, Displayitem ditem) {
        IModelitemChoice[] imic;
        IModelitemChoice[] iModelitemChoiceArray = imic = mitem != null ? mitem.getContent() : null;
        if (imic == null || this.jsman == null) {
            return;
        }
        for (int i = 0; i < imic.length; ++i) {
            Constraint constraint;
            if (!(imic[i] instanceof Constraint) || !(constraint = (Constraint)imic[i]).getKeep()) continue;
            if (AppSchemaUtil.isCheckRelation(mitem, ditem)) {
                this.jsman.addCancelOfConstraintElement(ThBodyGeneratorDisplayitem_update.getCheckboxREName(this.project, mitem, this.pmodel, ditem), pitem);
                continue;
            }
            this.jsman.addCancelOfConstraintElement(labelid, pitem);
        }
    }

    protected void gEnterKeyAction(Displayitem ditem, StringBuilder sb) {
        String code = this.getEnterKeyAction(ditem);
        if (code != null) {
            sb.append(" onKeyDown=\"");
            sb.append(code);
            sb.append("\"");
        }
    }

    protected String getEnterKeyAction(Displayitem ditem) {
        String type;
        String string = type = ditem != null ? ditem.getEnterKeyAction() : null;
        if (type == null || type.length() == 0) {
            return null;
        }
        StringBuilder code = new StringBuilder();
        if ("changetab".equals(type)) {
            code.append("enterKeyHandler.focusNextElement(this, event);");
        } else if ("ignore".equals(type)) {
            code.append("if (event.keyCode == 0x0d) event.preventDefault();");
        } else {
            String action = "condition".equals(this.getActionType()) ? "Search_Condition" : "Send";
            code.append("if (event.keyCode == 0x0d) { doSubmitForm(event.target.form, 'action_").append(action).append("'); }");
        }
        return code.toString();
    }

    protected String getWagbyDownloadUrl(Modelitem sitem, String id, String relax_name, String mitemFooter) {
        StringBuilder url = new StringBuilder();
        url.append("wagbyDownload.do?path=");
        if (StringUtils.isNotBlank((String)mitemFooter)) {
            url.append(this.getWagbyDownloadPath(sitem, id, relax_name)).append(mitemFooter).append("&fname=").append(this.getWagbyDownloadPath(sitem, id, relax_name));
        } else {
            url.append(this.getWagbyDownloadPath(sitem, id, relax_name));
        }
        url.append("&fdate=");
        return url.toString();
    }

    protected String getWagbyDownloadPath(Modelitem sitem, String id, String relax_name) {
        StringBuilder sb1 = new StringBuilder();
        String target = this.getWagbyDownloadPathMatchTarget(sitem);
        if ("showList".equals(this.getActionType()) || "updateList".equals(this.getActionType())) {
            sb1.append(ThBodyGenerator.convertJavaVariableString(target + "/item[")).append("__${iterStat.count}__").append(ThBodyGenerator.convertJavaVariableString("]/"));
            if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                sb1.append(AppSchemaUtil.getParentPart(sitem.getName())).append(ThBodyGenerator.convertJavaVariableString("[")).append("__${cIterStat.count}__").append(ThBodyGenerator.convertJavaVariableString("]/")).append(relax_name);
            } else if (sitem.getMultiple()) {
                sb1.append(relax_name).append(ThBodyGenerator.convertJavaVariableString("[")).append("__${cIterStat.count}__").append(ThBodyGenerator.convertJavaVariableString("]"));
            } else {
                sb1.append(relax_name);
            }
        } else {
            sb1.append(ThBodyGenerator.convertJavaVariableString(target + "/"));
            if (AppSchemaUtil.hasChildPart(sitem.getName())) {
                sb1.append(AppSchemaUtil.getParentPart(sitem.getName())).append(ThBodyGenerator.convertJavaVariableString("[")).append("__${iterStat.count}__").append(ThBodyGenerator.convertJavaVariableString("]/" + relax_name));
            } else if (sitem.getMultiple()) {
                sb1.append(ThBodyGenerator.convertJavaVariableString(sitem.getName())).append(ThBodyGenerator.convertJavaVariableString("[")).append("__${cIterStat.count}__").append(ThBodyGenerator.convertJavaVariableString("]"));
            } else {
                sb1.append(ThBodyGenerator.convertJavaVariableString(relax_name));
            }
        }
        return sb1.toString();
    }

    protected String getWagbyDownloadPathMatchTarget(Modelitem sitem) {
        return this.getMatchTarget();
    }

    protected void setTabVisibility(String tabContainerId, String tabId, Displayitemgroup displayitemgroup) {
        if (StringUtils.isBlank((String)displayitemgroup.getTabvisible())) {
            return;
        }
        this.jsman.setTabVisibility(tabContainerId, tabId, displayitemgroup);
    }

    public static String getLabelBodyPart(String label) {
        int ptr;
        if (StringUtils.isBlank((String)label)) {
            return "";
        }
        if ((label = label.trim()).endsWith("]") && (ptr = label.lastIndexOf("[")) > 0) {
            String[] tokens;
            StringBuilder buf = new StringBuilder();
            String cnt = label.substring(ptr + 1, label.length() - 1).trim();
            for (String token : tokens = cnt.split(";")) {
                int ptr2 = token.indexOf("=");
                if (ptr2 > 0) {
                    String token2 = token.substring(0, ptr2).trim();
                    if (token2.equals("@label") || token2.equals("@rowspan") || token2.equals("@colspan") || token2.equals("@list") || token2.equals("@listColspan") || token2.equals("@listRowspan")) continue;
                    buf.append(token);
                    continue;
                }
                buf.append(token);
            }
            cnt = buf.toString();
            label = StringUtils.isEmpty((String)cnt) ? label.substring(0, ptr) : label.substring(0, ptr) + "[" + cnt + "]";
        }
        return label;
    }

    protected String extractNumber(String s) {
        char _c;
        if (s == null) {
            return null;
        }
        s = s.trim();
        StringBuilder _buf = new StringBuilder();
        for (int k = 0; k < s.length() && Character.isDigit(_c = s.charAt(k)); ++k) {
            try {
                _buf.append(Integer.parseInt(String.valueOf(_c)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _buf.toString();
    }

    protected static String removeStyleAttribute(StringBuilder sb) {
        String s = null;
        if (sb.toString().lastIndexOf(STYLEATTRMARK) >= 0) {
            String rest;
            int begin = sb.lastIndexOf(STYLEATTRMARK);
            int nextQuot = sb.substring(begin + STYLEATTRMARK.length()).indexOf("\"");
            int end = begin + STYLEATTRMARK.length() + nextQuot + 1;
            s = sb.substring(begin + STYLEATTRMARK.length(), end - 1);
            String string = rest = sb.length() > end ? sb.substring(end) : "";
            if (rest.indexOf("><") >= 0) {
                return null;
            }
            sb.delete(begin, end);
        }
        return s != null ? s.trim() : null;
    }

    public static String getFieldClass(CSSLayout cssLayout, Displayitem ditem) {
        return ThBodyGenerator.getFieldClass(cssLayout, ditem, null, true, null);
    }

    public static String getFieldClass(CSSLayout cssLayout, Displayitem ditem, Model pmodel) {
        return ThBodyGenerator.getFieldClass(cssLayout, ditem, null, true, pmodel);
    }

    public static String getFieldClass(CSSLayout cssLayout, Displayitem ditem, String csscontent) {
        return ThBodyGenerator.getFieldClass(cssLayout, ditem, csscontent, true, null);
    }

    public static String getFieldClass(CSSLayout cssLayout, Displayitem ditem, boolean isCareChildPart) {
        return ThBodyGenerator.getFieldClass(cssLayout, ditem, null, isCareChildPart, null);
    }

    public static String getFieldClass(CSSLayout cssLayout, Displayitem ditem, boolean isCareChildPart, Model pmodel) {
        return ThBodyGenerator.getFieldClass(cssLayout, ditem, null, isCareChildPart, pmodel);
    }

    public static String getFieldClass(CSSLayout cssLayout, Displayitem ditem, String csscontent, boolean isCareChildPart, Model pmodel) {
        String actionIdref;
        String classname = cssLayout.getFieldClassName(pmodel, ditem);
        StringBuilder ret = new StringBuilder(classname);
        if ("column".equals(ditem.getLabelalign())) {
            if (isCareChildPart && AppSchemaUtil.hasChildPart(ditem.getName())) {
                ret.append(" center");
            } else if (pmodel == null || !StringUtils.endsWith((String)pmodel.getId(), (String)"_lp")) {
                ret.append(" cfield");
            }
        } else {
            IRNode node = ditem.rGetParentRNode();
            Displaymodel dmodel = null;
            if (node instanceof Displaymodel) {
                dmodel = (Displaymodel)node;
            }
            if (!(dmodel != null && StringUtils.endsWith((String)dmodel.getIdref(), (String)"_lp") || (isCareChildPart && pmodel != null && !StringUtils.endsWith((String)pmodel.getId(), (String)"_cp") && AppSchemaUtil.hasChildPart(ditem.getName()) || pmodel != null && (StringUtils.endsWith((String)pmodel.getId(), (String)"_lp") || pmodel.getUpdatelist()) || StringUtils.endsWith((String)ditem.getName(), (String)"1jshparam") || StringUtils.endsWith((String)ditem.getName(), (String)"2jshparam")) && !ThBodyGenerator.isContainerLineupVertically(ditem))) {
                ret.append(" cfield");
            }
        }
        String _valueClass = ditem.getValueClass();
        if (StringUtils.isNotBlank((String)_valueClass)) {
            ret.append(" ").append(_valueClass);
        }
        Model smodel = AppSchemaUtil.getStoreModel(pmodel);
        String prefixModelId = null;
        String id = smodel != null ? smodel.getId() : null;
        String string = actionIdref = cssLayout.getAction() != null ? cssLayout.getAction().getIdref() : null;
        if (id != null && !id.equals(actionIdref)) {
            prefixModelId = id;
            if (csscontent == null) {
                csscontent = "style=\"display:block;width:98%;\"";
            }
        } else if (cssLayout.getAction() != null && cssLayout.getAction().getUpdatelist() && csscontent == null) {
            csscontent = "style=\"display:block;width:98%;\"";
        }
        if (StringUtils.isBlank((String)csscontent)) {
            csscontent = ThBodyGenerator.getCssContentForContainerRefitem(smodel, ditem);
        }
        cssLayout.addContentCore(ditem, classname, csscontent, null, prefixModelId);
        return ret.toString();
    }

    private static String getCssContentForContainerRefitem(Model smodel, Displayitem ditem) {
        if (ditem == null || !AppSchemaUtil.hasChildPart(ditem.getName())) {
            return null;
        }
        Modelitem mitem = AppSchemaUtil.getModelitem(ditem.getName(), smodel);
        if (mitem == null) {
            return null;
        }
        String type = AppSchemaUtil.getRelationType(AppSchemaUtil.getRelation(mitem), ModelUtils.getProject(smodel));
        if (!("radio".equals(type) || "check".equals(type) || "search".equals(type))) {
            return null;
        }
        return "style=\"display:flex;white-space:nowrap;\"";
    }

    public static boolean isContainerLineupVertically(Displayitem ditem) {
        if (!AppSchemaUtil.hasChildPart(ditem.getName())) {
            return false;
        }
        Displayitemgroup ditemg = null;
        IRNode parentNode = ditem.rGetParentRNode();
        if (parentNode instanceof Displaymodel) {
            ditemg = Arrays.stream(((Displaymodel)parentNode).getContent()).filter(d -> d instanceof Displayitemgroup).findFirst().orElse(null);
        } else {
            if (!(parentNode instanceof Displayitemgroup)) {
                return false;
            }
            ditemg = (Displayitemgroup)parentNode;
        }
        if (ditemg == null) {
            return false;
        }
        return "0".equals(ditemg.getSeparate());
    }

    protected String getDisplaymodelSize(Displaymodel displaymodel) {
        String width_;
        StringBuilder style = new StringBuilder();
        String height_ = displaymodel.getHeight();
        if (StringUtils.isNotBlank((String)height_)) {
            style.append("height: ").append(height_).append(";");
        }
        if (StringUtils.isNotBlank((String)(width_ = displaymodel.getWidth()))) {
            style.append("width: ").append(width_).append(";");
        }
        return style.toString();
    }

    protected String getDivClass(CSSLayout cssLayout, Displayitem ditem, Model pmodel) {
        IRNode node;
        if (!"condition".equals(this.getActionType()) && AppSchemaUtil.hasChildPart(ditem.getName())) {
            return "";
        }
        if (!StringUtils.isBlank((String)ditem.getPrestring()) || !StringUtils.isBlank((String)ditem.getPoststring())) {
            return "cfield";
        }
        StringBuilder classname = new StringBuilder(ThBodyGenerator.getFieldClass(cssLayout, ditem, pmodel));
        if ("condition".equals(this.getActionType()) && (node = ditem.rGetParentRNode()) != null && node instanceof Displayitemgroup) {
            return classname.toString();
        }
        if (!StringUtils.contains((String)classname.toString(), (String)"cfield")) {
            classname.append(" cfield");
        }
        return classname.toString();
    }

    public static String getDivStyle(Model pmodel, Displayitem ditem, String actionType) {
        String stylePlace = ditem.getStylePlace();
        if (StringUtils.isEmpty((String)stylePlace) || "centerfield".equals(stylePlace)) {
            return "";
        }
        return ThBodyGenerator_show.createStyle(pmodel, ditem, actionType);
    }

    protected static String getRequiredValue(boolean isRequired, boolean isMultipleFlag) {
        if (!isRequired) {
            return "";
        }
        if (isMultipleFlag) {
            return "${cIterStat.first ? true : _}";
        }
        return "true";
    }

    protected String getCheckYNimage(String name, ThBodyGenerator_show.ImageContainer imageContainer) {
        StringBuilder sb = new StringBuilder();
        sb.append("<img th:src=\"${").append(name).append(".choose ?").append(" '").append(imageContainer.getYesImage()).append("' :").append(" '").append(imageContainer.getNoImage()).append("'}\"").append(this.gAttrTag("style", "vertical-align: middle; padding-right: 2px;")).append(">");
        return sb.toString();
    }

    protected String gValueOf_calendarinput(String mtype, Displayitem ditem, Modelitem mitem, Modelitem pitem, String id, String name, String labelid, boolean isReadOnlyFlag, boolean isMultipleFlag, Control control, ThBodyGeneratorDisplayitem_update thgen_ditem, CSSLayout cssLayout) {
        StringBuilder sb = new StringBuilder();
        Modelitem sitem = AppSchemaUtil.getModelitem(name, AppSchemaUtil.getStoreModel(this.pmodel));
        String sname = this.createSelectName(ditem, sitem);
        boolean isControlTypeReadOnly = thgen_ditem.gAppendControl_before_half(false, id, sname, pitem, control, false, sb);
        String valueEl = this.gValueEl(id, name, mitem, isMultipleFlag, pitem, ditem);
        if (!isReadOnlyFlag) {
            sb.append(thgen_ditem.gValueOf_calendarinput(mtype, ditem, mitem, pitem, id, name, labelid, valueEl, isReadOnlyFlag, isMultipleFlag, control, labelid));
            if ("normal".equals(ditem.getSelectinputRangetype())) {
                sb.append(this.gNoselectionCheckbox(ditem, this.pmodel));
            }
            if (isControlTypeReadOnly) {
                sb.append("</th:block>");
                thgen_ditem.gAppendControl_before_half(false, id, sname, pitem, control, false, sb, false, true);
                sb.append(this.getReadonlyValueTag(labelid, valueEl)).append("</th:block>");
            }
        } else {
            String dateSubformat;
            String string = dateSubformat = ditem != null ? ditem.getSubformat() : null;
            if (StringUtils.isNotBlank((String)dateSubformat)) {
                sb.append("<span data-dojo-type=\"wagby/ReferenceLinkage\"").append(" th:id=\"").append(ThGenerator.getThLiteralReplacement(labelid)).append("\"").append(this.gThValue(valueEl)).append(" data-dojo-props=\"dateSubformat: '").append(dateSubformat).append("'\"").append("></span>");
            } else {
                sb.append(this.getReadonlyValueTag(labelid, valueEl));
            }
        }
        if ("updateList".equals(this.getActionType())) {
            this.setIgnoreIndentMark(sb);
            return sb.toString();
        }
        StringBuilder fieldContainer = new StringBuilder();
        fieldContainer.append("<div");
        if (!isMultipleFlag) {
            String divStyle;
            fieldContainer.append(this.getFieldContainerId(labelid));
            String divclass = this.getDivClass(cssLayout, ditem, this.pmodel);
            if (StringUtils.isNotBlank((String)divclass)) {
                fieldContainer.append(this.gAttrTag("class", divclass));
            }
            if (!"condition".equals(this.getActionType()) && StringUtils.isNotBlank((String)(divStyle = ThBodyGenerator.getDivStyle(this.pmodel, ditem, this.getActionType())))) {
                fieldContainer.append(this.gAttrTag("th:style", ThBodyGenerator.getThLiteralReplacement(divStyle)));
            }
        } else {
            fieldContainer.append(this.gAttrTag("class", "repeatItemContainer"));
        }
        fieldContainer.append(this.gThTitle(id, ditem, this.getActionType()));
        fieldContainer.append(">").append(sb.toString()).append("</div>");
        return fieldContainer.toString();
    }

    protected void setIgnoreIndentMark(StringBuilder sb) {
        sb.insert(0, "<!--BEGIN_IGNORE_INDENT-->").append("<!--END_IGNORE_INDENT-->");
    }

    protected String gValueOf_input_date(Displayitem ditem, Modelitem mitem, Modelitem pitem, String id, String name, String labelid, boolean isReadOnlyFlag, boolean isMultipleFlag, Control control, ThBodyGeneratorDisplayitem_update thgen_ditem) {
        return thgen_ditem.gValueOf_input_date(ditem, mitem, pitem, id, name, labelid, isReadOnlyFlag, isMultipleFlag, control);
    }

    protected String gValueOf_selectinput_date(Displayitem ditem, Modelitem mitem, Modelitem pitem, String id, String name, String labelid, boolean isReadOnlyFlag, boolean isMultipleFlag, Control control, ThBodyGeneratorDisplayitem_update thgen_ditem) {
        StringBuilder sb = new StringBuilder();
        thgen_ditem.gValueOf_selectinput_date(sb, ditem, mitem, pitem, id, name, labelid, isReadOnlyFlag, isMultipleFlag, control);
        return sb.toString();
    }

    protected String gValueOf_selectinput_time(Displayitem ditem, Modelitem mitem, Modelitem pitem, String id, String name, String labelid, boolean isReadOnlyFlag, boolean isMultipleFlag, Control control, ThBodyGeneratorDisplayitem_update thgen_ditem, CSSLayout cssLayout) {
        String divStyle;
        StringBuilder sb = new StringBuilder();
        String valueEl = this.gValueEl(id, name, mitem, isMultipleFlag, pitem, ditem);
        if (isReadOnlyFlag) {
            sb.append(this.getReadonlyValueTag(labelid, valueEl));
        } else {
            Modelitem sitem = AppSchemaUtil.getModelitem(name, AppSchemaUtil.getStoreModel(this.pmodel));
            String sname = this.createSelectName(ditem, sitem);
            boolean isControlTypeReadOnly = thgen_ditem.gAppendControl_before_half(false, id, sname, pitem, control, false, sb);
            StringBuilder timeValueEl = new StringBuilder();
            timeValueEl.append("|T").append(valueEl).append("|");
            sb.append(thgen_ditem.gValueOf_selectinput_time(ditem, mitem, pitem, id, name, labelid, timeValueEl.toString(), isReadOnlyFlag, isMultipleFlag, control));
            if ("normal".equals(ditem.getSelectinputRangetype())) {
                sb.append(this.gNoselectionCheckbox(ditem, this.pmodel));
            }
            if (isControlTypeReadOnly) {
                sb.append("</th:block>");
                thgen_ditem.gAppendControl_before_half(false, id, sname, pitem, control, false, sb, false, true);
                sb.append(this.getReadonlyValueTag(labelid, valueEl)).append("</th:block>");
            }
        }
        if ("updateList".equals(this.getActionType())) {
            return sb.toString();
        }
        StringBuilder fieldContainer = new StringBuilder();
        fieldContainer.append("<div").append(this.getFieldContainerId(labelid));
        String divclass = this.getDivClass(cssLayout, ditem, this.pmodel);
        if (StringUtils.isNotBlank((String)divclass)) {
            fieldContainer.append(this.gAttrTag("class", divclass));
        }
        if (!"condition".equals(this.getActionType()) && StringUtils.isNotBlank((String)(divStyle = ThBodyGenerator.getDivStyle(this.pmodel, ditem, this.getActionType())))) {
            fieldContainer.append(this.gAttrTag("th:style", ThBodyGenerator.getThLiteralReplacement(divStyle)));
        }
        fieldContainer.append(this.gThTitle(id, ditem, this.getActionType()));
        fieldContainer.append(">").append(sb.toString()).append("</div>");
        return fieldContainer.toString();
    }

    protected String getThReadonlyCSSClass(String sid, String pmodelId, String pitemName, String labelClass) {
        StringBuilder thClass = new StringBuilder();
        thClass.append("${#jfc.getControlType2(#request, '").append(sid).append("'").append(", '").append(pmodelId).append("'").append(", '").append(pitemName).append("'").append(") eq 'Readonly' ? '").append(labelClass).append("_readonly' : '").append(labelClass).append("'}");
        return thClass.toString();
    }

    protected String getFieldContainerId(String labelid) {
        return this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement("field_" + StringUtils.substringBeforeLast((String)labelid, (String)"_005b")));
    }

    protected String getRangeConditionNoselection(Displayitem ditem, Model pmodel, Displaycondition displaycondition) {
        if (!StringUtils.endsWith((String)ditem.getName(), (String)"2jshparam")) {
            return "";
        }
        String target_name = StringUtils.substringBefore((String)ditem.getName(), (String)"2jshparam") + "1jshparam";
        return this.gNoselectionCheckbox(AppSchemaUtil.getDisplayitem(target_name, displaycondition), pmodel);
    }

    protected String gNoselectionCheckbox(Displayitem ditem, Model pmodel) {
        Modelitem smitem;
        StringBuilder sb = new StringBuilder();
        Model cmodel = (Model)pmodel.getIdrefAsIRNode();
        if (cmodel == null || !"condition".equals(cmodel.getType())) {
            return sb.toString();
        }
        String target_name = JavaSourceGenerator.normalizeModelitemName(ditem.getName());
        Modelitem cmitem = AppSchemaUtil.getModelitem(target_name, cmodel);
        String noselection_label = AppSchemaUtil.getNoselection(cmitem, cmodel, this.project);
        if (StringUtils.isEmpty((String)noselection_label)) {
            return sb.toString();
        }
        Model smodel = AppSchemaUtil.getStoreModel(cmodel);
        if (smodel != null && (smitem = AppSchemaUtil.getModelitem(ditem.getName(), smodel)) != null && smitem.getMultiple()) {
            return sb.toString();
        }
        if ("masterref".equals(cmitem.getType())) {
            return sb.toString();
        }
        Model refmodel = null;
        if ("storeref".equals(cmitem.getType())) {
            Relation relation = AppSchemaUtil.getRelationTypeExceptRef(cmitem);
            if (relation == null || !"search".equals(relation.getType())) {
                return sb.toString();
            }
            refmodel = (Model)relation.getIdrefAsIRNode();
        }
        String rkey = this.createResourceKey("check.noselection", noselection_label);
        JFCAppResourceGenerator.put(rkey, noselection_label);
        String child_name = AppSchemaUtil.getChildPart(ditem.getName());
        String labelid = AppSchemaUtil.createNameAttribute_th(this.project, "noselection_jshparam", pmodel) + ThBodyGenerator.convertJavaVariableString("[") + child_name + ThBodyGenerator.convertJavaVariableString("]");
        labelid = ThBodyGenerator.getThLiteralReplacement(labelid);
        String noselectionKey = ThBodyGenerator.convertELId(pmodel.getId()) + "." + ThBodyGenerator.convertELProperty("noselection_jshparam");
        StringBuilder pkeys = new StringBuilder();
        PrimaryKey[] r_pkeys = AppSchemaUtil.getPrimaryKey(refmodel);
        if (r_pkeys != null && r_pkeys.length > 1) {
            pkeys.append(child_name).append("_").append(r_pkeys[0].getName());
        } else {
            pkeys.append(child_name);
        }
        sb.append("<div class=\"noselectionCheckContainer\">").append(CR).append("<input data-dojo-type=\"dijit/form/CheckBox\" type=\"checkbox\"").append(" th:id=\"").append(labelid).append("\"").append(" th:name=\"").append(labelid).append("\"").append(" th:value=\"").append(child_name).append("\"").append(" th:checked=\"${#arrays.contains(").append(noselectionKey).append(", '").append((CharSequence)pkeys).append("')}\"/>").append(CR).append("<label th:for=\"").append(labelid).append("\" class=\"checkRadioLabel\"").append(" th:text=\"").append(this.wrapMessageEl(rkey)).append("\"></label>").append(CR).append("</div>").append(CR);
        return sb.toString();
    }

    public String getReadonlyValueTag(String labelid, String valueEl) {
        return this.getReadonlyValueTag(labelid, valueEl, null);
    }

    public String getReadonlyValueTag(String labelid, String valueEl, String thIf) {
        StringBuilder sb = new StringBuilder();
        sb.append("<span");
        if (StringUtils.isNotBlank((String)thIf)) {
            sb.append(this.gAttrTag("th:if", thIf));
        }
        sb.append(this.gAttrTag("th:id", ThBodyGenerator.getThLiteralReplacement("content_" + labelid))).append(this.gAttrTag("th:name", ThBodyGenerator.getThLiteralReplacement(labelid))).append(this.gThText(valueEl)).append("></span>");
        return sb.toString();
    }

    protected boolean isDisplayRoleidNumber(Model refmodel, Modelitem sitem) {
        if (refmodel == null) {
            return false;
        }
        String _type = AppSchemaUtil.getModelitemType(this.project, refmodel.getId(), sitem, "roleid");
        return JavaSourceGenerator.isBasicType(_type);
    }

    protected String getDisplayRoleidDojoType(Model refmodel, Modelitem sitem) {
        if (this.isDisplayRoleidNumber(refmodel, sitem)) {
            return this.gAttrTag("data-dojo-type", "dijit/form/NumberTextBox");
        }
        return this.gAttrTag("data-dojo-type", "wagby/TextBox");
    }

    protected String getIdItemNames(String itemValueEl, Modelitem sitem) {
        String idName = itemValueEl + ".id";
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(sitem);
        if (relation == null) {
            return idName;
        }
        Model rmodel = (Model)relation.getIdrefAsIRNode();
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(rmodel, this.project);
        if (pkeys == null || pkeys.length == 0) {
            return idName;
        }
        ArrayList<String> idItemNames = new ArrayList<String>();
        idItemNames.add(idName);
        for (int i = 1; i < pkeys.length; ++i) {
            PrimaryKey pkey = pkeys[i];
            String name = pkey.getName();
            String refName = pkey.getRefname();
            name = StringUtils.isBlank((String)refName) ? itemValueEl + "." + ThBodyGenerator.convertELProperty(name) + "Jshpkey" : itemValueEl + "." + ThBodyGenerator.convertELProperty(refName + "_" + name) + "Jshpkey";
            idItemNames.add(name);
        }
        if (idItemNames.size() == 1) {
            return (String)idItemNames.get(0);
        }
        String separator = ", '" + PrimaryKeyUtils.PKEY_SEPARATOR() + "', ";
        return "#strings.concat(" + String.join((CharSequence)separator, idItemNames) + ")";
    }

    protected String gShowConditionBatchProcessCheckboxColumn() {
        return "";
    }

    public static String[] getSelectinputItemName(String name, String selectinput) {
        ArrayList<String> selectinputNames = new ArrayList<String>();
        if (StringUtils.contains((String)selectinput, (String)"Y")) {
            selectinputNames.add(name + "_year");
        }
        if (StringUtils.contains((String)selectinput, (String)"YM")) {
            selectinputNames.add(name + "_month");
        }
        if (StringUtils.contains((String)selectinput, (String)"YMD")) {
            selectinputNames.add(name + "_day");
        }
        if (StringUtils.contains((String)selectinput, (String)"H")) {
            selectinputNames.add(name + "_hour");
        }
        if (StringUtils.contains((String)selectinput, (String)"HM")) {
            selectinputNames.add(name + "_minute");
        }
        if (StringUtils.contains((String)selectinput, (String)"HMS")) {
            selectinputNames.add(name + "_second");
        }
        return selectinputNames.toArray(new String[0]);
    }

    protected String gLabelIdIf(String label_id) {
        StringBuilder condition = new StringBuilder();
        if (label_id.indexOf("${iterStat.count}") > 0) {
            String[] splittedId = label_id.split("\\$\\{iterStat.count\\}");
            condition.append("idElement.startsWith('").append(splittedId[0]).append("')").append(" && idElement.endsWith('").append(splittedId[1]).append("')");
        } else {
            condition.append("idElement == '").append(label_id).append("'");
        }
        condition.insert(0, "if (").append(") {");
        return condition.toString();
    }
}

