/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.ISourceVariable;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditiongroup;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Dataitem;
import jp.jasminesoft.jfc.gen.appschema.Datalist;
import jp.jasminesoft.jfc.gen.appschema.IConditiongroupChoice;
import jp.jasminesoft.jfc.gen.appschema.IConditionlistChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.ResourceManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThComponent_link_implicit
implements ISourceVariable {
    protected Logger logger = LogManager.getLogger((String)ThComponent_link_implicit.class.getName());
    protected ResourceManager rman = ResourceManagerFactory.getInstance((String)"jp.jasminesoft.jfc.gen.appschema");
    private Project project;
    private Link link;
    private String idref;
    private Action linkedAction;
    int condition_count = 1;
    String mapVariableName = null;
    boolean ignoreOperator = true;

    public ThComponent_link_implicit(Link link, String idref, Project project) {
        this.link = link;
        this.idref = idref;
        this.project = project;
    }

    public String process() {
        return this.process("");
    }

    public String process(String basetab) {
        String forward = this.link.getForward();
        if (StringUtils.isBlank((CharSequence)forward) || forward.endsWith(".html") || forward.endsWith(".htm") || forward.endsWith(".jsp")) {
            return null;
        }
        Presentation presentation = AppSchemaUtil.getPresentationFromForward(this.project, forward);
        Action action = null;
        if (presentation != null) {
            IRNode node = presentation.getIdrefAsIRNode();
            if (node == null || !(node instanceof Action)) {
                return null;
            }
            action = (Action)node;
        } else {
            action = AppSchemaUtil.getAction(this.project, forward);
        }
        if (!this.checkIdref(action)) {
            return "";
        }
        this.linkedAction = action;
        Conditionlist conditionlist = AppSchemaUtil.getConditionlist(action);
        Conditionlist remade_clist = AppSchemaUtil.remakeConditionlistImplicitOnly(conditionlist);
        if (remade_clist == null) {
            return null;
        }
        String checkCode = this.gImplicitCheckCode_conditionlist(remade_clist, basetab);
        if (checkCode != null && checkCode.length() == 0) {
            return null;
        }
        return checkCode;
    }

    protected String gImplicitCheckCode_conditionlist(Conditionlist conditionlist, String basetab) {
        IConditionlistChoice[] icc = conditionlist.getContent();
        if (icc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < icc.length; ++i) {
            if (icc[i] instanceof Conditiongroup) {
                Conditiongroup _conditiongroup = (Conditiongroup)icc[i];
                this.addOperator(sb, _conditiongroup.getOperator());
                sb.append(this.gImplicitCheckCode_conditiongroup(_conditiongroup, basetab));
                continue;
            }
            if (!(icc[i] instanceof Condition)) continue;
            Condition condition = (Condition)icc[i];
            this.addOperator(sb, condition.getOperator());
            String code = this.gImplicitCheckCode_condition(condition, basetab);
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(code);
                continue;
            }
            this.logger.warn((Object)condition);
            sb.append("true");
        }
        sb.insert(0, basetab + "<th:block th:if=\"${");
        sb.append("}\">");
        return sb.toString();
    }

    protected String gImplicitCheckCode_conditiongroup(Conditiongroup conditiongroup, String basetab) {
        IConditiongroupChoice[] icc = conditiongroup.getContent();
        if (icc == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < icc.length; ++i) {
            if (icc[i] instanceof Conditiongroup) {
                Conditiongroup _conditiongroup = (Conditiongroup)icc[i];
                this.addOperator(sb, _conditiongroup.getOperator());
                sb.append(this.gImplicitCheckCode_conditiongroup(_conditiongroup, basetab));
                continue;
            }
            if (!(icc[i] instanceof Condition)) continue;
            Condition condition = (Condition)icc[i];
            this.addOperator(sb, condition.getOperator());
            String code = this.gImplicitCheckCode_condition(condition, basetab);
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sb.append(code);
                continue;
            }
            this.logger.warn((Object)condition);
            sb.append("true");
        }
        return sb.toString();
    }

    private void addOperator(StringBuilder sb, String operator) {
        if (sb.length() == 0) {
            return;
        }
        sb.append(this.convertJavaOperator(operator));
    }

    protected String gImplicitCheckCode_condition(Condition condition, String basetab) {
        StringBuilder sb = new StringBuilder();
        String type = condition.getType();
        if ("username".equals(type)) {
            sb.append(this.gImplicitCheckCode_username(condition, basetab));
        } else if ("jgroupid".equals(type)) {
            sb.append(this.gImplicitCheckCode_jgroupid(condition, basetab));
        }
        return sb.toString();
    }

    protected String gImplicitCheckCode_username(Condition condition, String basetab) {
        return this.gImplicitCheckCode_username(condition, basetab, false);
    }

    protected String gImplicitCheckCode_username(Condition condition, String basetab, boolean checkJgroupid) {
        IRNode node = this.linkedAction.getIdrefAsIRNode();
        if (!(node instanceof Model)) {
            return "";
        }
        boolean isStoreref = false;
        boolean isCheckbox = false;
        Model smodel = (Model)node;
        Modelitem mitem = AppSchemaUtil.getModelitem(condition.getName(), smodel);
        if (mitem == null) {
            return "";
        }
        if ("masterref".equals(mitem.getType()) || "storeref".equals(mitem.getType())) {
            isStoreref = true;
        }
        String type = AppSchemaUtil.getModelitemType(this.project, smodel.getId(), mitem, "roleid");
        if (!checkJgroupid && !"string".equals(type) || checkJgroupid && !"int".equals(type) && !"int[]".equals(type)) {
            Object[] o = new Object[]{this.linkedAction.getId(), condition.getName(), smodel.getId(), type};
            if (checkJgroupid) {
                this.logger.error(this.rman.getValue("jsp.illegal.link.action.implicit.jgroupid", o));
            } else {
                this.logger.error(this.rman.getValue("jsp.illegal.link.action.implicit.username", o));
            }
            return "";
        }
        if (AppSchemaUtil.isCheckRelation(AppSchemaUtil.getRelatedModelitemInCaseofTypeRef(this.project, smodel.getId(), mitem))) {
            isCheckbox = true;
        }
        boolean innerContainer = false;
        String name = condition.getName();
        int index = name.indexOf("/");
        if (index > 0 || isCheckbox) {
            if (index > 0) {
                innerContainer = true;
            }
            if (innerContainer && isCheckbox) {
                this.logger.error("No support, checkbox");
                this.logger.error((Object)condition);
            }
            if (innerContainer) {
                name = name.substring(index + 1);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (checkJgroupid) {
            sb.append("#jfc.checkJgroupid(");
        } else {
            if (!innerContainer && !isCheckbox && isStoreref) {
                sb.append(this.gCheckCodeUserArrayEmpty(this.idref, condition.getName())).append(" or ");
            }
            sb.append("#jfc.checkUsername(");
        }
        sb.append("#request");
        if (condition.getExceptPermname() != null) {
            sb.append(", '").append(condition.getExceptPermname()).append("'");
            if (condition.getExceptPermaction() != null) {
                sb.append(", '").append(condition.getExceptPermaction()).append("'");
            }
        }
        if (checkJgroupid && "group".equals(mitem.getGroupDataType())) {
            sb.append(", true");
        }
        if (innerContainer || isCheckbox) {
            if (checkJgroupid) {
                sb.append(", ").append(this.idref).append(".jgroupidjshparam");
            }
        } else {
            sb.append(", ").append(this.idref).append(".").append(SourceGenerator.convertELProperty(condition.getName()));
            if (checkJgroupid) {
                sb.append(".jgroupidjshparam");
            } else if (isStoreref) {
                sb.append("[0].id");
            } else {
                sb.append(".content");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected String gCheckCodeUserArrayEmpty(String idref, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("#arrays.isEmpty(").append(idref).append(".").append(name).append(")");
        return sb.toString();
    }

    protected String gImplicitCheckCode_jgroupid(Condition condition, String basetab) {
        return this.gImplicitCheckCode_username(condition, basetab, true);
    }

    protected String convertJavaOperator(String operator) {
        if ("or".equalsIgnoreCase(operator)) {
            return " or ";
        }
        return " and ";
    }

    protected boolean checkIdref(Action action) {
        if (action == null) {
            return false;
        }
        if ("update".equals(action.getType())) {
            return this.checkIdref_updateAction(action);
        }
        if ("delete".equals(action.getType())) {
            return this.checkIdref_deleteAction(action);
        }
        return false;
    }

    protected boolean checkIdref_updateAction(Action action) {
        Datalist datalist = AppSchemaUtil.getDatalist(action);
        if (datalist == null) {
            return false;
        }
        Dataitem[] dataitem_array = datalist.getDataitem();
        for (int i = 0; i < dataitem_array.length; ++i) {
            if (!"presentation".equals(dataitem_array[i].getType()) || !this.idref.equals(dataitem_array[i].getIdref())) continue;
            return true;
        }
        return false;
    }

    protected boolean checkIdref_deleteAction(Action action) {
        Model pmodel = AppSchemaUtil.getModel(this.project, this.idref);
        if (pmodel == null || !(pmodel.getIdrefAsIRNode() instanceof Model)) {
            return false;
        }
        Model smodel = (Model)pmodel.getIdrefAsIRNode();
        return smodel.getId().equals(action.getIdref());
    }
}

