/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaygraph;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.Item;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator;
import jp.jasminesoft.jfc.gen.ui.th.ThPanelContentBase;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThPanelContent_displaygraph
extends ThPanelContentBase {
    protected Logger logger = LogManager.getLogger((String)ThPanelContent_displaygraph.class.getName());
    private Displaygraph displaygraph;
    Item[] majors = null;
    Item[] dimensions = null;
    public static final String[] pattern = new String[]{"column", "clusteredColumn", "stackedColumn", "bar", "clusteredBar", "stackedBar", "pie", "piev", "line", "mline", "stackedLine", "scatter", "area", "stackedArea"};
    public static final String[] patternFor2dim = new String[]{"3Dbar"};
    private static final Map<String, String> GraphThemes = new HashMap<String, String>();
    private String DefaultThemeModule = "dojox.charting.themes.PlotKit.orange";
    private int graphid;

    public ThPanelContent_displaygraph(IPanelChoice ipc, ThGenerator jspgen, int graphid) {
        super(jspgen);
        View view;
        Map<String, Item[]> map;
        String s;
        this.displaygraph = (Displaygraph)ipc;
        this.graphid = graphid;
        String color = this.displaygraph.getColor();
        if (color != null && !StringUtils.isBlank((String)color) && GraphThemes.containsKey(s = "dojox.charting.themes.PlotKit." + color)) {
            this.DefaultThemeModule = s;
        }
        if ((map = this.getViewItems(view = AppSchemaUtil.getView(jspgen.getAction()))) != null) {
            this.majors = map.get("major");
            this.dimensions = map.get("dimension");
        }
    }

    protected Map<String, Item[]> getViewItems(View view) {
        if (view == null) {
            return null;
        }
        Item[] items = view.getItem();
        if (items == null) {
            return null;
        }
        ArrayList<Item> mlist = new ArrayList<Item>();
        ArrayList<Item> dlist = new ArrayList<Item>();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if ("major".equals(item.getName())) {
                mlist.add(item);
                continue;
            }
            if (!"dimension".equals(item.getName())) continue;
            dlist.add(item);
        }
        HashMap<String, Item[]> map = new HashMap<String, Item[]>();
        map.put("major", mlist.toArray(new Item[0]));
        map.put("dimension", dlist.toArray(new Item[0]));
        return map;
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        Action action = this.thgen.getAction();
        if (action == null) {
            return sb.toString();
        }
        if (this.majors == null || this.majors.length < 1) {
            return sb.toString();
        }
        if (this.dimensions == null || this.dimensions.length < 1 || this.dimensions.length > 2) {
            return sb.toString();
        }
        sb.append("<a name=\"").append(this.displaygraph.getIdref()).append("_graph\"></a>").append(CR);
        if (this.displaygraph.getIdref() != null && this.displaygraph.getIdref().length() > 0) {
            sb.append("<th:block th:if=\"${!#arrays.isEmpty(").append(this.displaygraph.getIdref()).append(".item)}\">").append(CR);
        }
        sb.append("<div class=\"chart_wrapper\" id=\"").append(this.displaygraph.getIdref()).append("_chart_wrapper\"").append(this.gGraphTypes()).append(">").append(CR).append("  ").append("<div id=\"").append(this.displaygraph.getIdref()).append("_chart_view\">").append(CR).append("    ").append("<table>").append(CR).append("      ").append("<tr><td class=\"graph_title\"").append(" th:text=\"${").append(this.displaygraph.getIdref()).append("_title}\"></td></tr>").append(CR).append("      ").append("<tr><td id=\"").append(this.displaygraph.getIdref()).append("_chart_container\" align=\"left\">").append("</td></tr>").append(CR).append("    ").append("</table>").append(CR).append("    ").append("<div id=\"").append(this.displaygraph.getIdref()).append("_chart_legend\"></div>").append(CR).append("  ").append("</div>").append(CR);
        String graphtype = this.displaygraph.getType();
        if (!Arrays.asList(pattern).contains(graphtype)) {
            graphtype = "clusterdColumn";
        }
        this.gGraphController(sb, pattern, graphtype);
        sb.append(CR);
        this.gGraphsFor1dim(sb, graphtype);
        sb.append("</div>").append(CR);
        if (this.displaygraph.getIdref() != null && this.displaygraph.getIdref().length() > 0) {
            sb.append("</th:block>").append(CR);
        }
        return sb.toString();
    }

    private String gGraphTypes() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.displaygraph.getIdref()).append("_type=").append("${#strings.isEmpty(param.").append(this.displaygraph.getIdref()).append("_type) ? '");
        if (StringUtils.isBlank((String)this.displaygraph.getType())) {
            sb.append("clusterdColumn");
        } else {
            sb.append(this.displaygraph.getType());
        }
        sb.append("' : param.").append(this.displaygraph.getIdref()).append("_type}");
        String graph_title = this.displaygraph.getTitle();
        String rkey = JFCAppResourceGenerator.checkUniqueRKey("__jfc_displaygraph." + this.displaygraph.getIdref() + "_title.1", graph_title);
        JFCAppResourceGenerator.put(rkey, graph_title);
        sb.append(", ").append(this.displaygraph.getIdref()).append("_title=").append("#{").append(rkey).append("}");
        if (this.displaygraph.getHtitle() != null) {
            sb.append(", ").append(this.displaygraph.getIdref()).append("_htitle=").append("'").append(this.displaygraph.getHtitle()).append("'");
        }
        if (this.displaygraph.getVtitle() != null) {
            sb.append(", ").append(this.displaygraph.getIdref()).append("_vtitle=").append("'").append(this.displaygraph.getVtitle()).append("'");
        }
        sb.append(", ").append(this.displaygraph.getIdref()).append("_width=").append(this.displaygraph.getWidth()).append(", ").append(this.displaygraph.getIdref()).append("_height=").append(this.displaygraph.getHeight());
        if (this.displaygraph.getPieFontSize() != null) {
            sb.append(", ").append(this.displaygraph.getIdref()).append("_pie_font_size=").append(this.displaygraph.getPieFontSize()).append(", ").append(this.displaygraph.getIdref()).append("_pie_label_length=").append(this.displaygraph.getPieLabelLength());
        }
        if (this.displaygraph.getGraphFontSize() != null) {
            sb.append(", ").append(this.displaygraph.getIdref()).append("_graph_font_size=");
            sb.append(this.displaygraph.getGraphFontSize());
        }
        sb.insert(0, " th:with=\"");
        sb.append("\"");
        return sb.toString();
    }

    protected void gGraphController(StringBuilder sb, String[] pattern, String graphtype) {
        sb.append("  ").append("<form id=\"").append(this.displaygraph.getIdref()).append("_graphSettingForm\" data-dojo-type=\"dijit/form/Form\" style=\"width: 50%; margin-top: 10px;\" novalidate>").append(CR).append("    ").append("<input type=\"hidden\" name=\"sessionId\" th:value=\"${#jfc.md5Hash(#session.getId())}\">").append(CR).append("    ").append("<div>").append(CR).append("    ").append("<div class=\"itemContainer\">").append(CR).append("    ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.graph}\"></div>").append(CR).append("    ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("    ").append("<select id=\"").append(this.displaygraph.getIdref()).append("_type\" data-dojo-type=\"wagby/Select\">").append(CR);
        for (String patname : pattern) {
            sb.append("      ").append("<option value=\"").append(patname).append("\"");
            if (patname.equals(graphtype)) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(" th:text=\"#{__jfc_common.graph.pattern.").append(patname).append("}\"></option>").append(CR);
        }
        sb.append("    ").append("</select>").append(CR).append("    ").append("</div>").append(CR).append("    ").append("</div>").append(CR).append("    ").append("<div class=\"itemContainer\">").append(CR).append("    ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.switchDimensionMeasure}\"></div>").append(CR).append("    ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("    ").append("<input type=\"checkbox\" id=\"").append(this.displaygraph.getIdref()).append("_reverseDimension\" class=\"plain\" data-dojo-type=\"dijit/form/CheckBox\" />").append(CR).append("    ").append("</div>").append(CR).append("    ").append("</div>").append(CR).append("    ").append("<div class=\"itemContainer\">").append(CR).append("    ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.sortDimension}\"></div>").append(CR).append("    ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("    ").append("<input type=\"checkbox\" id=\"").append(this.displaygraph.getIdref()).append("_sortDimension\" class=\"plain\" data-dojo-type=\"dijit/form/CheckBox\" />").append(CR).append("    ").append("</div>").append(CR).append("    ").append("</div>").append(CR).append("    ").append("<div class=\"itemContainer\">").append(CR).append("    ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.graphDetail}\"></div>").append(CR).append("    ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("    ").append("<span id=\"").append(this.displaygraph.getIdref()).append("_graphDetail_parent\"></span>").append(CR).append("    ").append("<button id=\"").append(this.displaygraph.getIdref()).append("_graphDetailButton\" class=\"plain\" data-dojo-type=\"dijit/form/ToggleButton\" th:label=\"#{__jfc_common.graph.label.graphDetailButton}\"></button>").append(CR).append("    ").append("</div>").append(CR).append("    ").append("</div>").append(CR).append("    ").append("</div>").append(CR).append(this.gDetailSettings()).append("    ").append("<button data-dojo-id=\"showChartButton\" id=\"").append(this.displaygraph.getIdref()).append("_showChartButton\" class=\"plain\" data-dojo-type=\"dijit/form/ToggleButton\"");
        String labelMessageKey = "__jfc_common.graph.label.showChartButton.checked";
        String checked = "true";
        if (!this.displaygraph.getShow()) {
            labelMessageKey = "__jfc_common.graph.label.showChartButton.unchecked";
            checked = "false";
        }
        sb.append(" th:label=\"#{").append(labelMessageKey).append("}\"").append(" checked=\"").append(checked).append("\">").append("    ").append("</button>").append(CR).append("    ").append("<button id=\"").append(this.displaygraph.getIdref()).append("_deleteSettingButton\" class=\"plain\" data-dojo-type=\"dijit/form/ToggleButton\" th:label=\"#{__jfc_common.graph.label.deleteSettingButton}\"></button>").append(CR).append("    ").append("<button id=\"").append(this.displaygraph.getIdref()).append("_sendAllSettingButton\"").append(" th:if=\"${#jfc.ifLogon(#request, '").append("permclassname").append("=jp.jasminesoft.jfc.JFCAppPermission").append(", ").append("permname").append("=jfcgraphsetting").append(", ").append("permactions").append("=admin')}\"").append(" class=\"plain\" data-dojo-type=\"dijit/form/ToggleButton\" th:label=\"#{__jfc_common.graph.label.sendAllSettingButton}\"></button>").append(CR).append("  ").append("</form>").append(CR);
    }

    private String gDetailSettings() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append("<div data-dojo-type=\"wagby/TitlePane\" id=\"").append(this.displaygraph.getIdref()).append("_detail_setting\"").append(" th:attr=\"data-dojo-props=|title: '#{__jfc_common.graph.label.detailSettingTitle}', open: false|\"").append(CR).append("      ").append("<div>").append(CR).append("        ").append("<div class=\"itemContainer\">").append(CR).append("          ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.theme}\"></div>").append(CR).append("          ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("            ").append("<select id=\"").append(this.displaygraph.getIdref()).append("_theme\" data-dojo-type=\"dijit/form/Select\" style=\"width: 5em;\">").append(CR);
        for (Map.Entry<String, String> e : GraphThemes.entrySet()) {
            sb.append("              ").append("<option value=\"").append(e.getKey()).append("\"");
            if (this.DefaultThemeModule.equals(e.getKey())) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(" th:text=\"#{").append(e.getValue()).append("}\"></option>").append(CR);
        }
        sb.append("            ").append("</select>").append(CR).append("          ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("<div class=\"itemContainer\">").append(CR).append("          ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.width}\"></div>").append(CR).append("          ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("            ").append("<input type=\"text\" id=\"").append(this.displaygraph.getIdref()).append("_chart_width\" class=\"plain\" th:value=\"${").append(this.displaygraph.getIdref()).append("_width}\" maxLength=\"4\" size=\"4\" data-dojo-type=\"dijit/form/NumberSpinner\" constraints=\"{max:9999,min:100,pattern:'#####0'}\"/>").append("          ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("<div class=\"itemContainer\">").append(CR).append("          ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.height}\"></div>").append(CR).append("          ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("            ").append("<input type=\"text\" id=\"").append(this.displaygraph.getIdref()).append("_chart_height\" class=\"plain\" th:value=\"${").append(this.displaygraph.getIdref()).append("_height}\" maxLength=\"4\" size=\"4\" data-dojo-type=\"dijit/form/NumberSpinner\" constraints=\"{max:9999,min:100,pattern:'#####0'}\"/>").append("          ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("<div id=\"jshgraph_config_onlypie\">").append(CR).append("        ").append("<div class=\"itemContainer\">").append(CR).append("          ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.PieFontSize}\"></div>").append(CR).append("          ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("            ").append("<input type=\"text\" id=\"").append(this.displaygraph.getIdref()).append("_pie_font_size\" class=\"plain\" th:value=\"${").append(this.displaygraph.getIdref()).append("_pie_font_size}\" maxLength=\"2\" size=\"2\" data-dojo-type=\"dijit/form/NumberSpinner\" constraints=\"{max:99,min:1}\" required=\"false\" />").append("          ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("<div class=\"itemContainer\">").append(CR).append("          ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.PieLabelLength}\"></div>").append(CR).append("          ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("            ").append("<input type=\"text\" id=\"").append(this.displaygraph.getIdref()).append("_pie_label_length\" class=\"plain\" th:value=\"${").append(this.displaygraph.getIdref()).append("_pie_label_length}\" maxLength=\"3\" size=\"3\" data-dojo-type=\"dijit/form/NumberSpinner\" constraints=\"{max:999,min:1}\"/>").append("          ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("<div id=\"jshgraph_config_withoutpie\">").append(CR).append("        ").append("<div class=\"itemContainer\">").append(CR).append("          ").append("<div class=\"clabel\" style=\"width: 50%;\" th:text=\"#{__jfc_common.graph.label.GraphFontSize}\"></div>").append(CR).append("          ").append("<div class=\"cfield\" style=\"width: 50%;\">").append(CR).append("            ").append("<input type=\"text\" id=\"").append(this.displaygraph.getIdref()).append("_graph_font_size\" class=\"plain\" th:value=\"${").append(this.displaygraph.getIdref()).append("_graph_font_size}\" maxLength=\"2\" size=\"2\" data-dojo-type=\"dijit/form/NumberSpinner\" constraints=\"{max:99,min:1}\" required=\"false\" />").append("        ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("        ").append("</div>").append(CR).append("      ").append("</div>").append(CR).append("    ").append("</div>").append(CR);
        return sb.toString();
    }

    protected void gGraphsFor1dim(StringBuilder sb, String graphtype) {
        this.gGraphInitValue(sb);
        sb.append("  ").append("/*]]>*/").append(CR).append("  ").append("</script>").append(CR);
    }

    protected void gGraphsFor2dim(StringBuilder sb) {
        this.gCreate3DBarGraph(sb);
    }

    protected void gCreateGraphAnchor(String url, StringBuilder sb, String[] pattern) {
        for (int i = 0; i < pattern.length; ++i) {
            sb.append("<c:choose>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<c:when test=\"${param.type == '");
            sb.append(pattern[i]);
            sb.append("'}\">");
            sb.append(CR);
            sb.append("    ");
            sb.append("<fmt:message key=\"__jfc_common.graph.pattern." + pattern[i] + "\"/>");
            sb.append(CR);
            sb.append("  ");
            sb.append("</c:when>");
            sb.append(CR);
            sb.append("  ");
            sb.append("<c:otherwise>");
            sb.append(CR);
            sb.append("    ");
            sb.append("<a href=\"");
            sb.append(url);
            sb.append("?type=");
            sb.append(pattern[i]);
            sb.append("#graph\">");
            sb.append("<fmt:message key=\"__jfc_common.graph.pattern." + pattern[i] + "\"/>");
            sb.append("</a>");
            sb.append(CR);
            sb.append("  ");
            sb.append("</c:otherwise>");
            sb.append(CR);
            sb.append("</c:choose>");
            sb.append(CR);
            if (i >= pattern.length - 1) continue;
            sb.append("<fmt:message key=\"__jfc_common.graph.pattern.separator\"/>");
            sb.append(CR);
        }
    }

    public String gGraphResource() {
        String s;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" th:src=\"|system/jshgraph.js?${application.__jfc_releaseTimestamp}|\" charset=\"UTF-8\"></script>").append(CR).append("<script type=\"text/javascript\" th:inline=\"javascript\">").append(CR).append("/*<![CDATA[*/").append(CR).append("  ").append("var messageResource = {").append(CR).append("    ").append("graphLabelErrorMessage: [[#{__jfc_common.graph.label.error}]],").append(CR).append("    ").append("illegalFontSizeMessage: [[#{__jfc_common.graph.label.IllegalFontSizeMessage}]],").append(CR).append("    ").append("illegalLabelLengthMessage: [[#{__jfc_common.graph.label.IllegalLabelLengthMessage}]],").append(CR).append("    ").append("showChartButtonCheckedLabel: [[#{__jfc_common.graph.label.showChartButton.checked}]],").append(CR).append("    ").append("showChartButtonUnCheckedLabel: [[#{__jfc_common.graph.label.showChartButton.unchecked}]],").append(CR).append("    ").append("plotDialogTitleLabel:  [[#{__jfc_common.graph.label.plotDialogTitle}]],").append(CR).append("    ").append("plotDialogDisplayMeasureSeries1Label: [[#{__jfc_common.graph.label.plotDialogDisplayMeasureSeries1}]],").append(CR).append("    ").append("plotDialogDisplayMeasureSeries2Label: [[#{__jfc_common.graph.label.plotDialogDisplayMeasureSeries2}]],").append(CR).append("    ").append("plotDialogDisplayMeasureNoneLabel:  [[#{__jfc_common.graph.label.plotDialogDisplayMeasureNone}]],").append(CR).append("    ").append("plotDialogOkLabel: [[#{__jfc_common.graph.label.ok}]],").append(CR).append("    ").append("plotDialogCancelLabel: [[#{__jfc_common.graph.label.cancel}]],").append(CR).append("    ").append("plotDialogResetLabel: [[#{__jfc_common.graph.label.reset}]],").append(CR).append("    ").append("deleteSettingConfirmLabel: [[#{__jfc_common.graph.label.deleteSettingConfirm}]],").append(CR).append("    ").append("sendAllSettingOverLabel: [[#{__jfc_common.graph.label.sendAllSettingOverLabel}]],").append(CR).append("    ").append("sendAllSettingSaveLabel: [[#{__jfc_common.graph.label.sendAllSettingSaveLabel}]]").append(CR).append("  ").append("};").append(CR).append(CR);
        String[] sa = new String[]{"column", "clusteredColumn", "stackedColumn", "bar", "clusteredBar", "stackedBar", "pie", "piev", "line", "mline", "stackedLine", "scatter", "area", "stackedArea"};
        sb.append("  ").append("var TypeDisplayedValue = {").append(CR);
        for (i = 0; i < sa.length; ++i) {
            s = sa[i];
            sb.append("    ").append(s).append(": [[#{__jfc_common.graph.pattern.").append(s).append("}]]");
            if (i < sa.length - 1) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("  ").append("};").append(CR);
        sb.append("  ").append("graphTypeOptions = [").append(CR);
        for (i = 0; i < sa.length; ++i) {
            s = sa[i];
            sb.append("    ").append("{ value:\"").append(s).append("\", label: [[#{__jfc_common.graph.pattern.").append(s).append("}]] }");
            if (i < sa.length - 1) {
                sb.append(",");
            }
            sb.append(CR);
        }
        sb.append("  ").append("];").append(CR).append("/*]]>*/").append(CR).append("</script>").append(CR);
        return sb.toString();
    }

    protected void gGraphInitValue(StringBuilder sb) {
        Map<String, Item[]> map = this.getViewItems(AppSchemaUtil.getView(this.thgen.getAction(), this.displaygraph.getIdref()));
        Object[] measure = map.get("major");
        Object[] dimension = map.get("dimension");
        if (ArrayUtils.isEmpty((Object[])measure) || ArrayUtils.isEmpty((Object[])dimension)) {
            return;
        }
        sb.append("  ").append("<script type=\"text/javascript\" th:inline=\"javascript\"").append(this.gGraphTypes()).append(">").append(CR).append("/*<![CDATA[*/").append(CR).append("    ").append("require([\"dojo/ready\"], function(ready) {").append(CR).append("    ").append("ready(function(){").append(CR).append("      ").append("var ").append(this.displaygraph.getIdref()).append("_initialValue = {").append(CR).append("        ").append("screenid: [[${__jfc_screen_id");
        if (this.graphid >= 2) {
            sb.append("_").append(this.graphid);
        }
        sb.append("}]],").append(CR).append("        ").append("userid: [[${#session.getAttribute('__jfc_user').username}]],").append(CR).append("        ").append("type: [[${").append(this.displaygraph.getIdref()).append("_type}]],").append(CR).append("        ").append("width: [[${").append(this.displaygraph.getIdref()).append("_width}]],").append(CR).append("        ").append("height: [[${").append(this.displaygraph.getIdref()).append("_height}]],").append(CR).append("        ").append("theme: \"").append(this.DefaultThemeModule).append("\",").append(CR).append("        ").append("themename: [[#{").append(GraphThemes.get(this.DefaultThemeModule)).append("}]],").append(CR);
        String pieFontSizeKey = this.displaygraph.getIdref() + "_pie_font_size";
        String graphFontSizeKey = this.displaygraph.getIdref() + "_graph_font_size";
        sb.append("        ").append("pieFontSize: [[${").append(pieFontSizeKey).append(" gt 0 ? ").append(pieFontSizeKey).append(" : 10}]],").append(CR).append("        ").append("pieLabelLength: [[${").append(this.displaygraph.getIdref()).append("_pie_label_length}]],").append(CR).append("        ").append("graphFontSize: [[${").append(graphFontSizeKey).append(" gt 0 ? ").append(graphFontSizeKey).append(" : 10}]],").append(CR).append("        ").append("datas:dojo.fromJson(decodeHtml([[${").append(this.displaygraph.getIdref()).append("_json}]])),").append(CR).append("        ").append("dimensionItemName: \"").append(SourceGenerator.convertELProperty(((Item)dimension[0]).getContent())).append("\",").append(CR).append("        ").append("measureItemNames: [\"").append(SourceGenerator.convertELProperty(((Item)measure[0]).getContent())).append("\"");
        for (int i = 1; i < measure.length; ++i) {
            sb.append(", \"").append(SourceGenerator.convertELProperty(((Item)measure[i]).getContent())).append("\"");
        }
        sb.append("],").append(CR).append("        ").append("chartNamePrefix: \"").append(this.displaygraph.getIdref()).append("_\"").append(CR).append("      ").append("};").append(CR).append(CR);
        this.g2DGraphInit(sb);
        sb.append("    ").append("});").append(CR).append("    ").append("});").append(CR);
    }

    protected void g2DGraphInit(StringBuilder sb) {
        sb.append("      ").append("var ").append(this.displaygraph.getIdref()).append("_jshGraph = new JshGraph(").append(this.displaygraph.getIdref()).append("_initialValue, TypeDisplayedValue, messageResource);").append(CR);
        sb.append("      ").append(this.displaygraph.getIdref()).append("_jshGraph.getSettingJson();").append(CR);
    }

    protected void gCountMajor(StringBuilder sb) {
        sb.append("        ");
        sb.append("var maj_count = 0;");
        sb.append(CR);
        for (int i = 0; i < this.majors.length; ++i) {
            sb.append("        ");
            sb.append("if (datas.item[0]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + " instanceof Array) {");
            sb.append(CR);
            sb.append("          ");
            sb.append("maj_count += datas.item[0]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + ".length;");
            sb.append(CR);
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append("          ");
            sb.append("maj_count++;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
    }

    protected void gSetXLabels(StringBuilder sb) {
        sb.append("        ");
        sb.append("var xlabels = new Array(maj_count);");
        sb.append(CR);
        sb.append("        ");
        sb.append("var l = 0;");
        sb.append(CR);
        for (int i = 0; i < this.majors.length; ++i) {
            sb.append("        ");
            sb.append("if (datas.item[0]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + " instanceof Array) {");
            sb.append(CR);
            sb.append("          ");
            sb.append("for (j=0; j<datas.item[0]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + ".length; j++) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("xlabels[l] = {value:l+1, text:datas.item[0]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + "[j].label};");
            sb.append(CR);
            sb.append("            ");
            sb.append("l++;");
            sb.append(CR);
            sb.append("          ");
            sb.append("}");
            sb.append(CR);
            sb.append("        ");
            sb.append("} else {");
            sb.append(CR);
            sb.append("          ");
            sb.append("xlabels[l] = {value:l+1, text:datas.item[0]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + ".label};");
            sb.append(CR);
            sb.append("          ");
            sb.append("l++;");
            sb.append(CR);
            sb.append("        ");
            sb.append("}");
            sb.append(CR);
        }
    }

    protected void gSetMultiSeries(StringBuilder sb) {
        sb.append("        ");
        sb.append("var sname = new Array(datas.item.length);");
        sb.append(CR);
        sb.append("        ");
        sb.append("var sdatas = new Array(datas.item.length);");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (i=0; i<datas.item.length; i++) {");
        sb.append(CR);
        sb.append("          ");
        sb.append("sdatas[i] = new Array(maj_count);");
        sb.append(CR);
        sb.append("          ");
        sb.append("var k = 0;");
        sb.append(CR);
        sb.append("          ");
        sb.append("if (datas.item[i]." + StringUtil.convertELProperty((String)this.dimensions[0].getContent()) + "[0].id != undefined) {");
        sb.append(CR);
        sb.append("            ");
        sb.append("sname[i] = datas.item[i]." + StringUtil.convertELProperty((String)this.dimensions[0].getContent()) + "[0].label;");
        sb.append(CR);
        sb.append("          ");
        sb.append("} else {");
        sb.append(CR);
        sb.append("            ");
        sb.append("sname[i] = datas.item[i]." + StringUtil.convertELProperty((String)this.dimensions[0].getContent()) + "[0].content;");
        sb.append(CR);
        sb.append("          ");
        sb.append("}");
        sb.append(CR);
        for (int i = 0; i < this.majors.length; ++i) {
            sb.append("          ");
            sb.append("if (datas.item[i]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + " instanceof Array) {");
            sb.append(CR);
            sb.append("            ");
            sb.append("for (j=0; j<datas.item[i]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + ".length; j++) {");
            sb.append(CR);
            sb.append("              ");
            sb.append("sdatas[i][k] = Number(datas.item[i]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + "[j].content);");
            sb.append(CR);
            sb.append("              ");
            sb.append("k++;");
            sb.append(CR);
            sb.append("            ");
            sb.append("}");
            sb.append(CR);
            sb.append("          ");
            sb.append("} else {");
            sb.append(CR);
            sb.append("            ");
            sb.append("sdatas[i][k] = Number(datas.item[i]." + StringUtil.convertELProperty((String)this.majors[i].getContent()) + ".content);");
            sb.append(CR);
            sb.append("            ");
            sb.append("k++;");
            sb.append(CR);
            sb.append("          ");
            sb.append("}");
            sb.append(CR);
        }
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (i=0; i<datas.item.length; i++) {");
        sb.append(CR);
        sb.append("          ");
        sb.append("chart.addSeries(sname[i], sdatas[i]);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
    }

    protected void gSetXaxis(StringBuilder sb, String params) {
        sb.append("        ");
        sb.append("var xaxis = " + params + ";");
        sb.append(CR);
        sb.append("        ");
        sb.append("add_graph_defaultplot(xaxis);");
        sb.append(CR);
        sb.append("        ");
        sb.append("chart.addAxis(\"x\", xaxis);");
        sb.append(CR);
    }

    protected void gSetYaxis(StringBuilder sb, String params) {
        sb.append("        ");
        sb.append("var yaxis = " + params + ";");
        sb.append(CR);
        sb.append("        ");
        sb.append("add_graph_defaultplot(yaxis);");
        sb.append(CR);
        sb.append("        ");
        sb.append("chart.addAxis(\"y\", yaxis);");
        sb.append(CR);
    }

    protected void gSetDefaultplot(StringBuilder sb, String params) {
        sb.append("        ");
        sb.append("var defaultplot = " + params + ";");
        sb.append(CR);
        sb.append("        ");
        sb.append("add_graph_defaultplot(defaultplot);");
        sb.append(CR);
        sb.append("        ");
        sb.append("chart.addPlot(\"default\", defaultplot);");
        sb.append(CR);
    }

    protected void gCreateColumnGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"Columns\", gap: 5}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateClusteredColumnGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"ClusteredColumns\", gap: 5}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateStackedColumnGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"StackedColumns\", gap: 5}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateBarGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetDefaultplot(sb, "{type: \"Bars\", gap: 5}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", vMajorLines: true, hMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateClusteredBarGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetDefaultplot(sb, "{type: \"ClusteredBars\", gap: 5}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", vMajorLines: true, hMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateStackedBarGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetDefaultplot(sb, "{type: \"StackedBars\", gap: 5}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", vMajorLines: true, hMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreatePieGraph(StringBuilder sb, boolean is_sum_horizontal) {
        sb.append("        ");
        sb.append("var sname;");
        sb.append(CR);
        if (is_sum_horizontal) {
            this.gCreatePieGraph_makesdatasSumHorizontal(sb, "        ");
        } else {
            this.gCreatePieGraph_makesdatasSumVertical(sb, "        ");
        }
        sb.append("        ");
        sb.append("chart.addPlot(\"default\", get_pie_defaultplot());");
        sb.append(CR);
        sb.append("        ");
        sb.append("chart.addSeries(sname, sdatas);");
        sb.append(CR);
    }

    private void gCreatePieGraph_makesdatasSumHorizontal(StringBuilder sb, String tab) {
        String varmajor = StringUtil.convertELProperty((String)this.majors[0].getContent());
        String vardim = StringUtil.convertELProperty((String)this.dimensions[0].getContent());
        sb.append(tab);
        sb.append("var sumarray = new Array(datas.item.length);");
        sb.append(CR);
        sb.append(tab);
        sb.append("if (datas.item[0]." + varmajor + " instanceof Array) {");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sname = datas.item[0]." + varmajor + "[0].label;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("for (i=0; i<sumarray.length; i++) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("sumarray[i] = 0;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("for (j=0; j<datas.item[0]." + varmajor + ".length; j++) {");
        sb.append(CR);
        sb.append(tab + "      ");
        sb.append("sumarray[i] += parseInt(datas.item[i]." + varmajor + "[j].content);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sname = datas.item[0]." + varmajor + ".label;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("for (i=0; i<sumarray.length; i++) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("sumarray[i] = parseInt(datas.item[i]." + varmajor + ".content);");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("var sdatas = new Array(datas.item.length);");
        sb.append(CR);
        sb.append(tab);
        sb.append("for (i=0; i<sdatas.length; i++) {");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("var txt;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("if (datas.item[i]." + vardim + "[0].id != undefined) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("txt = datas.item[i]." + vardim + "[0].label;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("txt = datas.item[i]." + vardim + "[0].content;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("if (txt.length > PieLabelLength) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("txt = txt.substring(0, PieLabelLength)+\"...\";");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sdatas[i] = {y:Number(sumarray[i])");
        sb.append(", text:txt};");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
    }

    private void gCreatePieGraph_makesdatasSumVertical(StringBuilder sb, String tab) {
        String varmajor = StringUtil.convertELProperty((String)this.majors[0].getContent());
        sb.append(tab);
        sb.append("var sdatas;");
        sb.append(CR);
        sb.append(tab);
        sb.append("if (datas.item[0]." + StringUtil.convertELProperty((String)this.majors[0].getContent()) + " instanceof Array) {");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sname = datas.item[0]." + StringUtil.convertELProperty((String)this.majors[0].getContent()) + "[0].label;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("var sumarray = new Array(datas.item[0]." + varmajor + ".length);");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("for (i=0; i<sumarray.length; i++) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("sumarray[i] = 0;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("for (j=0; j<datas.item.length; j++) {");
        sb.append(CR);
        sb.append(tab + "      ");
        sb.append("sumarray[i] += parseInt(datas.item[j]." + varmajor + "[i].content);");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sdatas = new Array(datas.item[0]." + varmajor + ".length);");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("for (i=0; i<sdatas.length; i++) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("var txt;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (datas.item[0]." + varmajor + "[i].id != undefined) {");
        sb.append(CR);
        sb.append(tab + "      ");
        sb.append("txt = datas.item[0]." + varmajor + "[i].label;");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "      ");
        sb.append("txt = sumarray[i].toString();");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("if (txt.length > PieLabelLength) {");
        sb.append(CR);
        sb.append(tab + "      ");
        sb.append("txt = txt.substring(0, PieLabelLength)+\"...\";");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("sdatas[i] = {y:Number(sumarray[i])");
        sb.append(", text:txt};");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab);
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sname = datas.item[0]." + varmajor + ".label;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("var sum = 0;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("for (i=0; i<datas.item.length; i++) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("sum += parseInt(datas.item[i]." + varmajor + ".content);");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sdatas = new Array(1);");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("var txt;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("if (datas.item[0]." + varmajor + ".id != undefined) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("txt = datas.item[0]." + varmajor + ".label;");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("} else {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("txt = sum.toString();");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("if (txt.length > PieLabelLength) {");
        sb.append(CR);
        sb.append(tab + "    ");
        sb.append("txt = txt.substring(0, PieLabelLength)+\"...\";");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("}");
        sb.append(CR);
        sb.append(tab + "  ");
        sb.append("sdatas[0] = {y:Number(sum)");
        sb.append(", text:txt};");
        sb.append(CR);
        sb.append(tab);
        sb.append("}");
        sb.append(CR);
    }

    protected void gCreateLineGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"Lines\"}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateMlineGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"Markers\"}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateStackedLineGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"StackedLines\"}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateScatterGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"Scatter\"}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateAreaGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"Areas\"}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreateStackedAreaGraph(StringBuilder sb) {
        this.gCountMajor(sb);
        sb.append(CR);
        this.gSetXLabels(sb);
        sb.append(CR);
        this.gSetXaxis(sb, "{fixLower:\"minor\", fixUpper:\"minor\", labels:xlabels, minorTicks:false}");
        this.gSetYaxis(sb, "{vertical:true, fixLower:\"major\", fixUpper:\"major\", includeZero:true, natural:true}");
        this.gSetDefaultplot(sb, "{type: \"StackedAreas\"}");
        sb.append("        ");
        sb.append("chart.addPlot(\"back_grid\", {type: \"Grid\", hMajorLines: true, vMajorLines: false});");
        sb.append(CR);
        sb.append(CR);
        this.gSetMultiSeries(sb);
        sb.append(CR);
    }

    protected void gCreate3DBarGraph(StringBuilder sb) {
        this.gCommon3DGraphFirst(sb);
        this.gSetCommon3DGraph(sb);
        sb.append(CR);
        sb.append("        ");
        sb.append("var plots = new Array[1]");
        sb.append(CR);
        sb.append("        ");
        sb.append("var sdatas = new Array[1][4]");
        sb.append(CR);
        sb.append("        ");
        sb.append("plots[0] = new dojox.charting.plot3d.Bars(${width}, ${height}, {gap: 10});");
        sb.append(CR);
        sb.append("        ");
        sb.append("for (i=0; i<0; i++) {");
        sb.append(CR);
        sb.append("          ");
        sb.append("for (j=0; j<4; j++) {");
        sb.append(CR);
        sb.append("        ");
        sb.append("sdatas[i][j] = 100;");
        sb.append(CR);
        sb.append("          ");
        sb.append("}");
        sb.append("          ");
        sb.append("chart.addPlot(plot[i]);");
        sb.append(CR);
        sb.append("        ");
        sb.append("}");
        sb.append(CR);
        this.gCommon3DGraphLast(sb);
    }

    protected void gCommon3DGraphFirst(StringBuilder sb) {
        sb.append("    ");
        sb.append("<script type=\"text/javascript\">");
        sb.append(CR);
        sb.append("      ");
        sb.append("dojo.require(\"dojox.charting.Chart3D\");");
        sb.append(CR);
        sb.append("      ");
        sb.append(CR);
        sb.append("      ");
        sb.append("var datas = JSON.parse(decodeHtml('<c:out value=\"${");
        sb.append(this.displaygraph.getIdref());
        sb.append("_json}\"/>'));");
        sb.append(CR);
        sb.append("      ");
        sb.append("makeObjects = function(){");
        sb.append(CR);
        sb.append("        ");
        sb.append("var m = dojox.gfx3d.matrix;");
        sb.append(CR);
    }

    protected void gSetCommon3DGraph(StringBuilder sb) {
        sb.append("        ");
        sb.append("var chart = new dojox.charting.Chart3D(\"chart\",");
        sb.append(CR);
        sb.append("          ");
        sb.append("{");
        sb.append(CR);
        sb.append("            ");
        sb.append("lights:[{direction:{x:5, y:5, z:-5}, color:\"white\"}],");
        sb.append(CR);
        sb.append("            ");
        sb.append("ambient:{color:\"white\", intensity:2},");
        sb.append(CR);
        sb.append("            ");
        sb.append("specular:\"white\"");
        sb.append(CR);
        sb.append("          ");
        sb.append("},");
        sb.append(CR);
        sb.append("          ");
        sb.append("[m.cameraRotateXg(10), m.cameraRotateYg(-10), m.scale(0.8), m.cameraTranslate(-50, -50, -120)]");
        sb.append(CR);
        sb.append("        ");
        sb.append(");");
        sb.append(CR);
    }

    protected void gCommon3DGraphLast(StringBuilder sb) {
        sb.append("        ");
        sb.append("chart.generate().render();");
        sb.append(CR);
        sb.append("      ");
        sb.append("};");
        sb.append(CR);
        sb.append("      ");
        sb.append("dojo.addOnLoad(makeObjects);");
        sb.append(CR);
        sb.append("</script>");
        sb.append(CR);
    }

    static {
        GraphThemes.put("dojox.charting.themes.PlotKit.orange", "__jfc_common.graph.theme.name.pk_orange");
        GraphThemes.put("dojox.charting.themes.PlotKit.cyan", "__jfc_common.graph.theme.name.pk_cyan");
        GraphThemes.put("dojox.charting.themes.PlotKit.red", "__jfc_common.graph.theme.name.pk_red");
        GraphThemes.put("dojox.charting.themes.PlotKit.green", "__jfc_common.graph.theme.name.pk_green");
        GraphThemes.put("dojox.charting.themes.PlotKit.blue", "__jfc_common.graph.theme.name.pk_blue");
        GraphThemes.put("dojox.charting.themes.PlotKit.purple", "__jfc_common.graph.theme.name.pk_purple");
    }
}

