/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.GoogleMapScriptManager;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaychart;
import jp.jasminesoft.jfc.gen.appschema.Displaymap;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.util.ResourceManager;
import org.apache.commons.lang.StringUtils;

public abstract class ThSourceGenerator
extends JspSourceGenerator {
    protected boolean isRedirectJspFlag;
    protected static ResourceManager x2aj_rman = ResourceManager.getInstance((String)"x2aj");

    public ThSourceGenerator(Project project, Action action, Presentation presentation) {
        super(project, action, presentation);
    }

    @Override
    public String getEncoding() {
        return JavaSourceGenerator.getWebEncoding(this.project);
    }

    @Override
    public abstract String getFilename();

    @Override
    public String getFileSuffix() {
        return ".html";
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    protected abstract String getActionType();

    @Override
    public Presentation getPresentation() {
        return this.presentation;
    }

    @Override
    public String getActionIdref() {
        return this.getAction().getIdref();
    }

    @Override
    public boolean isTiles() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        String styleSheetRef;
        this.init();
        String filename = this.getFilename();
        this.isRedirectJspFlag = filename.startsWith("redirect");
        filename = this.getTemplatesPath() + File.separator + this.addModelidToFilename(this.getAction(), filename);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            String dirbase0 = this.project.getBasedir() + File.separator + this.getPackageName() + File.separator;
            String dirbase1 = "webpage" + File.separator;
            String checkLine = "<script type=\"text/javascript\" src=";
            br = new BufferedReader(new StringReader(this.process0()));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("<script type=\"text/javascript\" src=")) {
                    File _file1;
                    String _rest = line.substring("<script type=\"text/javascript\" src=".length() + 1);
                    String terminalSymbol = _rest.contains("?") ? "?" : "\"";
                    String _fid = _rest.substring(0, _rest.indexOf(terminalSymbol));
                    File _file0 = new File(dirbase0 + _fid);
                    if (!(StringUtils.endsWith((String)_fid, (String)"dojo.js") || StringUtils.startsWith((String)_fid, (String)"system/") || _file0.exists() || (_file1 = new File(dirbase1 + _fid)).exists())) {
                        int _ptr = _fid.indexOf("/");
                        if (this.getAction() == null || _ptr <= 0) continue;
                        String mid = _fid.substring(0, _ptr);
                        if (!this.getAction().getIdref().equals(mid)) continue;
                    }
                }
                sb.append(line);
                sb.append(CR);
            }
        }
        catch (IOException dirbase0) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException dirbase0) {}
            }
        }
        String content = sb.toString();
        if (!this.isTiles() || this.isRedirectJspFlag) {
            this.createSource(this.getGeneratorClassName() + content, filename, this.getPackageName(), false);
        } else {
            String tcontent;
            String tfilename;
            String line = null;
            StringBuilder javascript_code = new StringBuilder();
            StringBuilder bean_code = new StringBuilder();
            javascript_code.append(this.gTilesJspInit());
            bean_code.append(this.gTilesJspInit());
            boolean isJavaScriptCreateFlag = false;
            boolean isBeanDefCreateFlag = false;
            HashMap<String, StringBuilder> tmap = new HashMap<String, StringBuilder>();
            String tid2 = null;
            StringTokenizer st = new StringTokenizer(content, CR);
            while (st.hasMoreTokens()) {
                line = st.nextToken();
                if (line.startsWith("<script") && line.endsWith("</script>")) {
                    isJavaScriptCreateFlag = true;
                    javascript_code.append(line.replaceFirst("\\.js\"", "\\.js\\?\\${application.__jfc_buildTimestamp}\"")).append(CR);
                } else if (line.startsWith("<bean:define")) {
                    isBeanDefCreateFlag = true;
                    bean_code.append(line + CR);
                } else {
                    if (line.startsWith("<!-- begin")) {
                        String s = line.substring("<!-- begin ".length());
                        tid2 = s.substring(0, s.length() - " -->".length());
                        continue;
                    }
                    if (line.startsWith("<!-- end")) {
                        tid2 = null;
                        continue;
                    }
                }
                if (tid2 == null) continue;
                StringBuilder sb0 = (StringBuilder)tmap.get(tid2);
                if (sb0 == null) {
                    sb0 = new StringBuilder();
                    sb0.append(this.gTilesJspInit());
                    tmap.put(tid2, sb0);
                }
                sb0.append(line + CR);
            }
            for (String tid2 : tmap.keySet()) {
                StringBuilder sb0 = (StringBuilder)tmap.get(tid2);
                String tfilename2 = filename + "_" + tid2;
                String tcontent2 = sb0.toString();
                this.createSource(this.getGeneratorClassName() + tcontent2, tfilename2, this.getPackageName(), false);
            }
            if (isJavaScriptCreateFlag) {
                tfilename = filename + "_javascript";
                tcontent = javascript_code.toString();
                Displaymap displaymap = AppSchemaUtil.findDisplaymap(this.getPresentation());
                if (displaymap != null && "google".equals(displaymap.getType())) {
                    StringBuilder __sb = new StringBuilder(tcontent);
                    GoogleMapScriptManager gmsm = GoogleMapScriptManager.getInstance(this.project);
                    if (gmsm != null) {
                        __sb.append(gmsm.getReadyScript());
                        __sb.append(gmsm.getScript(this.getPresentation()));
                        tcontent = __sb.toString();
                    }
                }
                if (this.getAction() != null && AppSchemaUtil.isJgroupnodeOrgChartDefined(AppSchemaUtil.getModel(this.project, this.getAction().getIdref()), this.getAction())) {
                    tcontent = tcontent + "<script type=\"text/javascript\">\r\nlet datasource = <c:choose><c:when test=\"${__jfc_groupChart != null}\"><c:out value=\"${__jfc_groupChart}\" escapeXml=\"false\"/></c:when><c:otherwise>null</c:otherwise></c:choose>;\r\n</script>\r\n";
                }
                this.createSource(this.getGeneratorClassName() + tcontent, tfilename, this.getPackageName(), false);
            }
            if (isBeanDefCreateFlag) {
                tfilename = filename + "_beandef";
                tcontent = bean_code.toString();
                this.createSource(this.getGeneratorClassName() + tcontent, tfilename, this.getPackageName(), false);
            }
        }
        if ((this.isTiles() && !this.isRedirectJspFlag || this.getAction() == null || this.getAction().getId().startsWith("searchList")) && StringUtils.isNotBlank((String)(styleSheetRef = this.gStyleSheetRef()))) {
            StringBuilder stylesheetCode = new StringBuilder();
            stylesheetCode.append(this.getGeneratorClassName()).append(this.gTilesJspInit()).append(styleSheetRef);
            StringBuilder tfilename = new StringBuilder();
            tfilename.append(filename).append("_").append("stylesheet");
            this.createSource(stylesheetCode.toString(), tfilename.toString(), this.getPackageName(), false);
        }
    }

    @Override
    protected String gTilesJspInit() {
        StringBuilder sb = new StringBuilder();
        sb.append("<%@ page pageEncoding=\"");
        sb.append(this.getEncoding());
        sb.append("\"");
        String[] importlist = this.getImportList();
        if (importlist != null && importlist.length > 0) {
            sb.append(CR);
            sb.append("    import=\"");
            for (int i = 0; i < importlist.length; ++i) {
                sb.append(importlist[i]);
                if (i + 1 >= importlist.length) continue;
                sb.append(",");
            }
            sb.append("\"");
        }
        sb.append(" %>").append(CR);
        sb.append("<fmt:setBundle basename=\"jfcapp\"/>").append(CR);
        return sb.toString();
    }

    @Override
    public void init() {
    }

    @Override
    public abstract String process0();

    @Override
    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && o instanceof ThSourceGenerator) {
            ThSourceGenerator jsg = (ThSourceGenerator)o;
            if (this.getFilename().equals(jsg.getFilename()) && this.getFileSuffix().equals(jsg.getFileSuffix())) {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    protected String[] getImportList() {
        Model _model;
        ArrayList<String> importList = new ArrayList<String>();
        if (AppSchemaUtil.isMobile(this.getPresentation())) {
            importList.add("jp.jasminesoft.jfc.controller.BaseController");
        }
        if (this.getAction() != null && (_model = AppSchemaUtil.getModel(this.project, this.getAction().getIdref())) != null && _model.getWorkflow()) {
            importList.add("jp.jasminesoft.workflow.WorkEvent");
        }
        return importList.toArray(new String[0]);
    }

    @Override
    public String gRequestFormBegin(String name, String actionref, String code, String basetab) {
        return this.gRequestFormBegin(name, actionref, code, null, basetab);
    }

    @Override
    protected String gRequestFormEnd(String basetab) {
        return "";
    }

    @Override
    protected String gComment(String comment) {
        if (!this.project.getDebug()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<%-- ").append(this.getClass().getName()).append("::").append(comment).append(" --%>").append(CR);
        return sb.toString();
    }

    @Override
    protected String getGeneratorClassName() {
        if (System.getProperty("jfc.output.genclassname") != null) {
            return "<%-- genclassname:" + this.getClass().getName() + " --%>" + CR;
        }
        return "";
    }

    public String getTemplatesPath() {
        return "WEB-INF" + File.separator + "classes" + File.separator + "templates";
    }

    @Override
    protected String gDisplaychart(Displaychart displaychart) {
        StringBuilder sb = new StringBuilder();
        Action action = this.getAction();
        if (action == null) {
            return "";
        }
        String title = displaychart.getTitle();
        String rkey = null;
        if (title != null) {
            rkey = JFCAppResourceGenerator.createModelResourceKey(action.getIdref(), "chart." + displaychart.getId() + ".title", title);
            JFCAppResourceGenerator.put(rkey, title);
        }
        sb.append("<div style=\"margin: 0 10px;\">").append(CR).append("<h4 style=\"margin: 0; text-align: center;\"");
        if (StringUtils.isNotBlank(rkey)) {
            sb.append(" th:text=\"#{").append(rkey).append("}\"");
        }
        sb.append("></h4>").append(CR);
        sb.append("<canvas id=\"").append(action.getId()).append("_").append(displaychart.getId()).append("_chart").append("\"").append(" height=\"").append(displaychart.getHeight()).append("\"").append(" width=\"").append(displaychart.getWidth()).append("\"/>").append(CR).append("</div>").append(CR);
        return sb.toString();
    }
}

