/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.core.support.velocity.VelocityUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.test.support.testmodel.model.ConditionTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.ListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.StoreTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.UpdateListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.SuiteClassInfo;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestScenarioMacro;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestScenarioMacroParser;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenerateTestCode
extends SourceGenerator {
    private static Logger LOGGER = LogManager.getLogger(GenerateTestCode.class);
    public static final String TYPE_UPDATELIST = "updatelist";
    private static final String[] MODEL_TYPES = new String[]{"store", "condition", "list", "updatelist"};
    public static final String GEN_BASE_DIR = "test";
    private static final String PATH_TMODEL_STORE = "jp/jasminesoft/jfc/test/support/testmodel/template/TModel_store.vm";
    private static final String PATH_TMODEL_CONDITION = "jp/jasminesoft/jfc/test/support/testmodel/template/TModel_Cp.vm";
    private static final String PATH_TMODEL_LIST = "jp/jasminesoft/jfc/test/support/testmodel/template/TModel_Lp.vm";
    private static final String PATH_TMODEL_UPDATE_LIST = "jp/jasminesoft/jfc/test/support/testmodel/template/TModel_Ulp.vm";
    private static final String PATH_TEST_SCENARIO = "jp/jasminesoft/jfc/test/support/testmodel/scenario/template/TestScenario.vm";
    private static final String PATH_TEST_SUITE = "jp/jasminesoft/jfc/test/support/testmodel/scenario/template/AllTests.vm";
    private static final String FILE_EXT_TEST_SCENARIO = "tsm";
    public static final String PATH_SCENARIO_MACRO_DIR = ".." + File.separator + ".." + File.separator + "customize" + File.separator + "test" + File.separator + "tsm";
    public static final Charset TSM_FILE_CHARSET = StandardCharsets.UTF_8;
    public static final Pattern PTN_TEST_ENV_TAG = Pattern.compile(":[a-zA-Z0-9_.\\-]+:.+");
    private File[] tsmFiles;
    private final String packageSeparator = ".";
    private Set<String> tsmJavaFileSet;

    public GenerateTestCode(Project project) {
        super(project);
        File tsmdir = new File(PATH_SCENARIO_MACRO_DIR);
        if (tsmdir.exists() && tsmdir.isDirectory()) {
            this.tsmFiles = tsmdir.listFiles((FilenameFilter)FileFilterUtils.suffixFileFilter((String)FILE_EXT_TEST_SCENARIO));
        }
        this.tsmJavaFileSet = new HashSet<String>();
    }

    @Override
    public String getFileSuffix() {
        return ".java";
    }

    @Override
    public void process() {
        if (this.tsmFiles == null || this.tsmFiles.length == 0) {
            return;
        }
        Map<String, Map<String, TModel>> testModelMap = this.initTestModelMapMap();
        if (testModelMap == null) {
            return;
        }
        for (String modelType : MODEL_TYPES) {
            for (TModel model : testModelMap.get(modelType).values()) {
                String id = model.getId();
                try {
                    String content = this.toJavaCode(model);
                    if (content == null) continue;
                    String filename = model.getClassName();
                    super.createSource(content, filename, this.getTestSubpackageRelPath(id), false);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.generateTestScneario(testModelMap);
    }

    public void generateTestScneario(Map<String, Map<String, TModel>> testModelMap) {
        SuiteClassInfo suiteInfo = new SuiteClassInfo(PATH_SCENARIO_MACRO_DIR);
        suiteInfo.setPackage(this.getTestRootPackage());
        TestScenarioMacroParser tsmParser = new TestScenarioMacroParser(testModelMap);
        tsmParser.setOutputStatus(suiteInfo.isOutputStatus());
        for (File tsmFile : this.tsmFiles) {
            try {
                System.out.print("loading " + tsmFile.getName() + "... ");
                TestScenarioMacro tsmData = tsmParser.parse(tsmFile.toPath());
                tsmData.setBasePackage(this.getTestScnearioSubpackage(null));
                String javaCode = this.toTestScenarioJavaCode(tsmData);
                String relOutputPath = this.getTestSubpackageRelScnearioPath(tsmData.getEnvironment().getSubPackage());
                super.createSource(javaCode, tsmData.getClassName(), relOutputPath, false);
                suiteInfo.addTestClass(tsmData.getPackage() + "." + tsmData.getClassName() + ".class");
                this.tsmJavaFileSet.add(relOutputPath + File.separator + tsmData.getClassName() + ".java");
                System.out.println("done.");
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate Test Scenario Source Code: " + e.getMessage());
            }
        }
        try {
            String suiteJavaCode = this.toTestSuiteJavaCode(suiteInfo);
            super.createSource(suiteJavaCode, "AllTests", this.getTestRootPackageRelPath(), false);
            this.tsmJavaFileSet.add(this.getTestRootPackageRelPath() + File.separator + "AllTests.java");
        }
        catch (IOException e) {
            LOGGER.error("Failed to generate Test Suite Source Code: " + e.getMessage());
        }
    }

    public Set<String> getCreatedTsmJavaFilenames() {
        return Collections.unmodifiableSet(this.tsmJavaFileSet);
    }

    private Map<String, Map<String, TModel>> initTestModelMapMap() {
        HashMap<String, Map<String, TModel>> typeMap = new HashMap<String, Map<String, TModel>>();
        typeMap.put("store", new HashMap());
        typeMap.put("condition", new HashMap());
        typeMap.put("list", new HashMap());
        typeMap.put(TYPE_UPDATELIST, new HashMap());
        Model[] presentationModels = AppSchemaUtil.getModelsByType(this.project, "presentation");
        if (presentationModels == null) {
            LOGGER.error("Failed to generate WTF class. Try to full build first.");
            return null;
        }
        for (Model pModel : presentationModels) {
            Model refModel = (Model)pModel.getIdrefAsIRNode();
            if (refModel == null) continue;
            if ("store".equals(refModel.getType())) {
                StoreTModel storeModel = new StoreTModel(refModel, pModel);
                ((Map)typeMap.get("store")).put(storeModel.getJapaneseClassName(), storeModel);
                continue;
            }
            if ("condition".equals(refModel.getType())) {
                ConditionTModel condModel = new ConditionTModel(refModel, pModel);
                ((Map)typeMap.get("condition")).put(condModel.getJapaneseClassName(), condModel);
                continue;
            }
            if ("list".equals(refModel.getType()) && pModel.getUpdatelist()) {
                UpdateListTModel ulpModel = new UpdateListTModel(refModel, pModel);
                ((Map)typeMap.get(TYPE_UPDATELIST)).put(ulpModel.getJapaneseClassName(), ulpModel);
                continue;
            }
            if (!"list".equals(refModel.getType())) continue;
            ListTModel listModel = new ListTModel(refModel, pModel);
            ((Map)typeMap.get("list")).put(listModel.getJapaneseClassName(), listModel);
        }
        return typeMap;
    }

    private String toJavaCode(TModel tModel) throws IOException {
        String template = null;
        HashMap<String, TModel> context = new HashMap<String, TModel>();
        if (tModel instanceof StoreTModel) {
            template = this.loadTemplate(PATH_TMODEL_STORE);
            context.put("model", (StoreTModel)tModel);
        } else if (tModel instanceof ConditionTModel) {
            template = this.loadTemplate(PATH_TMODEL_CONDITION);
            context.put("model", (ConditionTModel)tModel);
        } else if (tModel instanceof ListTModel) {
            template = this.loadTemplate(PATH_TMODEL_LIST);
            context.put("model", (ListTModel)tModel);
        } else {
            template = this.loadTemplate(PATH_TMODEL_UPDATE_LIST);
            context.put("model", (UpdateListTModel)tModel);
        }
        return VelocityUtils.evaluate((String)template, context);
    }

    private String toTestScenarioJavaCode(TestScenarioMacro tsmData) throws IOException {
        HashMap<String, TestScenarioMacro> context = new HashMap<String, TestScenarioMacro>();
        context.put("testScenario", tsmData);
        String template = this.loadTemplate(PATH_TEST_SCENARIO);
        return VelocityUtils.evaluate((String)template, context);
    }

    private String toTestSuiteJavaCode(SuiteClassInfo suiteClassInfo) throws IOException {
        HashMap<String, SuiteClassInfo> context = new HashMap<String, SuiteClassInfo>();
        context.put("suiteInfo", suiteClassInfo);
        String template = this.loadTemplate(PATH_TEST_SUITE);
        return VelocityUtils.evaluate((String)template, context);
    }

    /*
     * Exception decompiling
     */
    private String loadTemplate(String templateLoc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getTestRootPackageRelPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(GEN_BASE_DIR).append(File.separator);
        sb.append(JavaSourceGenerator.convPackage2FilePath(this.project.getPackage()));
        sb.append(File.separator).append("tests");
        return sb.toString();
    }

    private String getTestSubpackageRelPath(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTestRootPackageRelPath());
        sb.append(File.separator).append("models");
        if (id != null && id.trim().length() > 0) {
            sb.append(File.separator).append(id.trim());
        }
        return sb.toString();
    }

    private String getTestSubpackageRelScnearioPath(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTestRootPackageRelPath());
        sb.append(File.separator);
        if (id != null && id.trim().length() > 0) {
            sb.append(id.trim());
        }
        return sb.toString();
    }

    private String getTestRootPackage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.project.getPackage());
        sb.append(".").append("tests");
        return sb.toString();
    }

    private String getTestScnearioSubpackage(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTestRootPackage());
        if (id != null && id.trim().length() > 0) {
            sb.append(".").append(id.trim());
        }
        return sb.toString();
    }
}

